/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.adminui;

import com.buuz135.adminui.AdminUIIndexRegistry;
import com.buuz135.adminui.gui.AdminStickGui;
import com.buuz135.adminui.gui.BackupGui;
import com.buuz135.adminui.gui.BanGui;
import com.buuz135.adminui.gui.MuteGui;
import com.buuz135.adminui.gui.PlayerGui;
import com.buuz135.adminui.gui.StatsGui;
import com.buuz135.adminui.gui.WarpGui;
import com.buuz135.adminui.gui.WhitelistGui;
import com.buuz135.adminui.interaction.AdminStickInteraction;
import com.buuz135.adminui.util.AdminStickCustomConfig;
import com.buuz135.adminui.util.BackupConfiguration;
import com.buuz135.adminui.util.MuteTracker;
import com.buuz135.adminui.util.PlayerTracker;
import com.buuz135.adminui.util.ReflectionUtil;
import com.hypixel.hytale.assetstore.event.LoadedAssetsEvent;
import com.hypixel.hytale.assetstore.map.DefaultAssetMap;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.Options;
import com.hypixel.hytale.server.core.asset.type.model.config.ModelAsset;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.entity.UUIDComponent;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.player.PlayerChatEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerConnectEvent;
import com.hypixel.hytale.server.core.modules.accesscontrol.AccessControlModule;
import com.hypixel.hytale.server.core.modules.accesscontrol.provider.HytaleBanProvider;
import com.hypixel.hytale.server.core.modules.accesscontrol.provider.HytaleWhitelistProvider;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.Interaction;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.Universe;
import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionSet;

public class AdminUI
extends JavaPlugin {
    public static Map<String, ModelAsset> MODELS = new HashMap<String, ModelAsset>();
    private static AdminUI INSTANCE;
    private HytaleWhitelistProvider whitelistProvider;
    private HytaleBanProvider banProvider;
    private PlayerTracker playerTracker;
    private AdminStickCustomConfig adminStickCustomConfig;
    private MuteTracker muteTracker;
    private BackupConfiguration backupConfiguration;

    public static AdminUI getInstance() {
        return INSTANCE;
    }

    public AdminUI(@Nonnull JavaPluginInit init) {
        super(init);
        INSTANCE = this;
        this.playerTracker = new PlayerTracker();
        this.adminStickCustomConfig = new AdminStickCustomConfig();
        this.muteTracker = new MuteTracker();
        this.backupConfiguration = new BackupConfiguration();
    }

    protected void setup() {
        super.setup();
        File folder = new File("AdminUI");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.playerTracker.syncLoad();
        this.getEventRegistry().registerGlobal(PlayerConnectEvent.class, event -> {
            Player player = (Player)event.getHolder().getComponent(Player.getComponentType());
            UUID uuid = ((UUIDComponent)event.getHolder().getComponent(UUIDComponent.getComponentType())).getUuid();
            this.playerTracker.addPlayer(player.getDisplayName(), uuid);
        });
        this.adminStickCustomConfig.syncLoad();
        this.muteTracker.syncLoad();
        this.backupConfiguration.syncLoad();
        AdminUIIndexRegistry.getInstance().register(new AdminUIIndexRegistry.Entry("whitelist", "Whitelists", WhitelistGui::new, true, "wl", "whitelists"));
        AdminUIIndexRegistry.getInstance().register(new AdminUIIndexRegistry.Entry("mute", "Mutes", MuteGui::new, true, "m", "mute"));
        AdminUIIndexRegistry.getInstance().register(new AdminUIIndexRegistry.Entry("ban", "Bans", BanGui::new, true, "b", "bans"));
        AdminUIIndexRegistry.getInstance().register(new AdminUIIndexRegistry.Entry("player", "Players", PlayerGui::new, true, "p", "players"));
        AdminUIIndexRegistry.getInstance().register(new AdminUIIndexRegistry.Entry("warps", "Warps", WarpGui::new, true, "w", "warps"));
        AdminUIIndexRegistry.getInstance().register(new AdminUIIndexRegistry.Entry("admin-stick", "Admin Stick", AdminStickGui::new, true, new String[0]));
        AdminUIIndexRegistry.getInstance().register(new AdminUIIndexRegistry.Entry("backup", "Server Backups", BackupGui::new, true, "bk", "backup"));
        AdminUIIndexRegistry.getInstance().register(new AdminUIIndexRegistry.Entry("server", "Server Stats", StatsGui::new, true, "st", "stats"));
        this.whitelistProvider = ReflectionUtil.getPublic(HytaleWhitelistProvider.class, AccessControlModule.get(), "whitelistProvider");
        this.banProvider = ReflectionUtil.getPublic(HytaleBanProvider.class, AccessControlModule.get(), "banProvider");
        if (this.whitelistProvider == null || this.banProvider == null) {
            throw new RuntimeException("Could not find Hytale Access Control Module");
        }
        this.getEventRegistry().register(LoadedAssetsEvent.class, ModelAsset.class, AdminUI::onModelAssetLoad);
        this.getCommandRegistry().registerCommand((AbstractCommand)AdminUIIndexRegistry.getInstance().getCommand());
        this.getCodecRegistry(Interaction.CODEC).register("Buuz135_AdminUI_AdminStickInteraction", AdminStickInteraction.class, AdminStickInteraction.CODEC);
        this.getEventRegistry().registerGlobal(PlayerChatEvent.class, event -> {
            if (this.muteTracker.isMuted(event.getSender().getUuid())) {
                event.setCancelled(true);
                event.getSender().sendMessage(Message.join((Message[])new Message[]{Message.raw((String)"You are muted and cannot chat!").color(Color.RED).bold(true), Message.raw((String)(" Reason: " + this.muteTracker.getPlayer(event.getSender().getUuid()).reason()))}));
            }
        });
        if (!Options.getOptionSet().has(Options.BACKUP)) {
            if (this.backupConfiguration.isEnabled()) {
                OptionSet optionSet = Options.getOptionSet();
                Map map = ReflectionUtil.getPublic(Map.class, optionSet, "optionsToArguments");
                map.put((AbstractOptionSpec)Options.BACKUP_MAX_COUNT, List.of("" + this.backupConfiguration.getRetentionAmount()));
                map.put((AbstractOptionSpec)Options.BACKUP_DIRECTORY, List.of(this.backupConfiguration.getFolder()));
                int frequencyMinutes = Math.max(this.backupConfiguration.getBackupFrequency(), 1);
                this.getLogger().at(Level.INFO).log("Scheduled backup to run every %d minute(s)", frequencyMinutes);
                HytaleServer.SCHEDULED_EXECUTOR.scheduleWithFixedDelay(() -> {
                    try {
                        this.getLogger().at(Level.INFO).log("Backing up universe...");
                        Universe.get().runBackup().thenAccept(aVoid -> this.getLogger().at(Level.INFO).log("Completed scheduled backup."));
                    }
                    catch (Exception e) {
                        ((HytaleLogger.Api)this.getLogger().at(Level.SEVERE).withCause((Throwable)e)).log("Error backing up universe");
                    }
                }, frequencyMinutes, frequencyMinutes, TimeUnit.MINUTES);
            }
        } else {
            this.getLogger().at(Level.INFO).log("Ignoring scheduled backups as it was enabled with the backup option arguments");
        }
    }

    private static void onModelAssetLoad(LoadedAssetsEvent<String, ModelAsset, DefaultAssetMap<String, ModelAsset>> event) {
        MODELS = ((DefaultAssetMap)event.getAssetMap()).getAssetMap();
    }

    protected void shutdown() {
        super.shutdown();
        this.playerTracker.syncSave();
        this.adminStickCustomConfig.syncSave();
        this.muteTracker.syncSave();
    }

    public HytaleBanProvider getBanProvider() {
        return this.banProvider;
    }

    public HytaleWhitelistProvider getWhitelistProvider() {
        return this.whitelistProvider;
    }

    public PlayerTracker getPlayerTracker() {
        return this.playerTracker;
    }

    public AdminStickCustomConfig getAdminStickCustomConfig() {
        return this.adminStickCustomConfig;
    }

    public MuteTracker getMuteTracker() {
        return this.muteTracker;
    }

    public BackupConfiguration getBackupConfiguration() {
        return this.backupConfiguration;
    }
}

