/*
 * Decompiled with CFR 0.152.
 */
package net.mahmutkocas.container;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.AddReason;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.event.EventPriority;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.StateData;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.inventory.container.SimpleItemContainer;
import com.hypixel.hytale.server.core.modules.entity.item.ItemComponent;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.hypixel.hytale.server.core.universe.world.meta.BlockState;
import com.hypixel.hytale.server.core.universe.world.meta.state.ItemContainerState;
import com.hypixel.hytale.server.core.universe.world.worldmap.WorldMapManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class UpgradeableItemContainerState
extends ItemContainerState {
    public static final Codec<UpgradeableItemContainerState> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(UpgradeableItemContainerState.class, UpgradeableItemContainerState::new, (BuilderCodec)BlockState.BASE_CODEC).append(new KeyedCodec("Custom", (Codec)Codec.BOOLEAN), (state, o) -> {
        state.custom = o;
    }, state -> state.custom).add()).append(new KeyedCodec("AllowViewing", (Codec)Codec.BOOLEAN), (state, o) -> {
        state.allowViewing = o;
    }, state -> state.allowViewing).add()).append(new KeyedCodec("Droplist", (Codec)Codec.STRING), (state, o) -> {
        state.droplist = o;
    }, state -> state.droplist).add()).append(new KeyedCodec("Marker", (Codec)WorldMapManager.MarkerReference.CODEC), (state, o) -> {
        state.marker = o;
    }, state -> state.marker).add()).append(new KeyedCodec("ItemContainer", (Codec)SimpleItemContainer.CODEC), (state, o) -> {
        state.itemContainer = o;
    }, state -> state.itemContainer).add()).append(new KeyedCodec("Capacity", (Codec)Codec.SHORT), (state, o) -> {
        state.capacity = o;
    }, state -> state.capacity).add()).build();
    short capacity;

    public boolean initialize(@Nonnull BlockType blockType) {
        StateData stateData = blockType.getState();
        if (stateData instanceof ItemContainerState.ItemContainerStateData) {
            ItemContainerState.ItemContainerStateData itemContainerStateData = (ItemContainerState.ItemContainerStateData)stateData;
            this.capacity = itemContainerStateData.getCapacity();
        }
        ObjectArrayList remainder = new ObjectArrayList();
        this.itemContainer = (SimpleItemContainer)ItemContainer.ensureContainerCapacity((ItemContainer)this.itemContainer, (short)this.capacity, SimpleItemContainer::new, (List)remainder);
        this.itemContainer.registerChangeEvent(EventPriority.LAST, arg_0 -> ((UpgradeableItemContainerState)this).onItemChange(arg_0));
        if (!remainder.isEmpty()) {
            WorldChunk chunk = this.getChunk();
            World world = chunk.getWorld();
            Store store = world.getEntityStore().getStore();
            ((HytaleLogger.Api)HytaleLogger.getLogger().at(Level.WARNING).withCause(new Throwable())).log("Dropping %d excess items from item container: %s at world: %s, chunk: %s, block: %s", (Object)remainder.size(), (Object)blockType.getId(), (Object)chunk.getWorld().getName(), (Object)chunk, (Object)this.getPosition());
            Vector3i blockPosition = this.getBlockPosition();
            Holder[] itemEntityHolders = ItemComponent.generateItemDrops((ComponentAccessor)store, (List)remainder, (Vector3d)blockPosition.toVector3d(), (Vector3f)Vector3f.ZERO);
            store.addEntities(itemEntityHolders, AddReason.SPAWN);
        }
        return true;
    }
}

