/*
 * Decompiled with CFR 0.152.
 */
package org.sureizu.plugin.hud;

import com.hypixel.hytale.assetstore.AssetPack;
import com.hypixel.hytale.assetstore.map.BlockTypeAssetMap;
import com.hypixel.hytale.common.plugin.PluginManifest;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.asset.AssetModule;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.asset.type.item.config.Item;
import com.hypixel.hytale.server.core.asset.type.item.config.ItemCategory;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.component.DisplayNameComponent;
import com.hypixel.hytale.server.core.modules.entity.component.HiddenFromAdventurePlayers;
import com.hypixel.hytale.server.core.modules.entity.tracker.NetworkId;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.TargetUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.sureizu.plugin.hud.LookHud;

public final class LookHudUpdater {
    private static final Object ORIGIN_LOCK = new Object();
    private static volatile Map<String, String> BLOCK_ID_TO_ORIGIN;

    private LookHudUpdater() {
    }

    @Nonnull
    private static String resolveBlockOwnerFull(@Nonnull String blockKey, String itemId) {
        int colon;
        String idForOrigin;
        String string = idForOrigin = itemId != null && !itemId.isEmpty() ? itemId : blockKey;
        if (idForOrigin != null && (colon = idForOrigin.indexOf(58)) > 0) {
            String ns = idForOrigin.substring(0, colon);
            if (ns.equalsIgnoreCase("core")) {
                return "Hytale:Hytale";
            }
            return ns;
        }
        String fromPack = LookHudUpdater.getOriginFromPackMap(blockKey);
        if (fromPack != null && !fromPack.isEmpty()) {
            return fromPack;
        }
        return "";
    }

    private static boolean isVanillaOwner(String ownerFull) {
        return ownerFull != null && ownerFull.equalsIgnoreCase("Hytale:Hytale");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOriginFromPackMap(@Nonnull String blockKey) {
        Map<String, String> map = BLOCK_ID_TO_ORIGIN;
        if (map == null) {
            Object object = ORIGIN_LOCK;
            synchronized (object) {
                map = BLOCK_ID_TO_ORIGIN;
                if (map == null) {
                    BLOCK_ID_TO_ORIGIN = map = LookHudUpdater.buildBlockOriginMap();
                }
            }
        }
        return map.get(blockKey.toLowerCase(Locale.ROOT));
    }

    @Nonnull
    private static Map<String, String> buildBlockOriginMap() {
        HashMap<String, String> out = new HashMap<String, String>();
        try {
            BlockTypeAssetMap assetMap = BlockType.getAssetMap();
            for (AssetPack pack : AssetModule.get().getAssetPacks()) {
                Set keys;
                if (pack == null || (keys = assetMap.getKeysForPack(pack.getName())) == null) continue;
                Object origin = null;
                try {
                    PluginManifest manifest = pack.getManifest();
                    if (manifest != null) {
                        String group = manifest.getGroup();
                        String name = manifest.getName();
                        if (group != null && !group.isEmpty() && name != null && !name.isEmpty()) {
                            origin = group + ":" + name;
                        } else if (name != null && !name.isEmpty()) {
                            origin = name;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (origin == null || ((String)origin).isEmpty()) {
                    origin = pack.getName();
                }
                for (Object keyObj : keys) {
                    if (keyObj == null) continue;
                    String key = String.valueOf(keyObj);
                    out.putIfAbsent(key.toLowerCase(Locale.ROOT), (String)origin);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return out;
    }

    public static void update(@Nonnull Ref<EntityStore> ref, @Nonnull LookHud hud, double blockMaxDistance, double entityMaxDistance) {
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        UICommandBuilder builder = new UICommandBuilder();
        if (!hud.isEntityHudEnabled()) {
            hud.setEntityVisible(false);
            hud.setEntityName(Message.raw((String)""));
            hud.setEntityId(Message.raw((String)""));
            hud.setEntityStatus(Message.raw((String)""));
            builder.set("#BlocchioLookEntityHud.Visible", false);
            builder.set("#BlocchioEntityNameLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioEntityIdLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioEntityStatusLabel.TextSpans", Message.raw((String)""));
        } else {
            Ref targetEntity = null;
            try {
                float radius = 8.0f;
                try {
                    radius = (float)Math.max(0.0, entityMaxDistance);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                targetEntity = TargetUtil.getTargetEntity(ref, (float)radius, (ComponentAccessor)store);
            }
            catch (Throwable radius) {
                // empty catch block
            }
            if (targetEntity != null && targetEntity.equals(ref)) {
                targetEntity = null;
            }
            if (targetEntity != null && targetEntity.isValid()) {
                try {
                    HiddenFromAdventurePlayers hidden = (HiddenFromAdventurePlayers)store.getComponent(targetEntity, HiddenFromAdventurePlayers.getComponentType());
                    if (hidden != null) {
                        targetEntity = null;
                    }
                }
                catch (Throwable hidden) {
                    // empty catch block
                }
            }
            if (targetEntity != null && targetEntity.isValid()) {
                Message entityName = Message.raw((String)"Entity");
                try {
                    DisplayNameComponent displayName = (DisplayNameComponent)store.getComponent(targetEntity, DisplayNameComponent.getComponentType());
                    if (displayName != null && displayName.getDisplayName() != null) {
                        entityName = displayName.getDisplayName();
                    }
                }
                catch (Throwable displayName) {
                    // empty catch block
                }
                Object entityId = "";
                try {
                    NetworkId networkId = (NetworkId)store.getComponent(targetEntity, NetworkId.getComponentType());
                    if (networkId != null) {
                        entityId = "#" + networkId.getId();
                    }
                }
                catch (Throwable networkId) {
                    // empty catch block
                }
                String status = "Entity";
                try {
                    Player player = (Player)store.getComponent(targetEntity, Player.getComponentType());
                    if (player != null) {
                        status = "Player";
                    }
                }
                catch (Throwable player) {
                    // empty catch block
                }
                hud.setEntityVisible(true);
                hud.setEntityName(entityName);
                hud.setEntityId(Message.raw((String)entityId));
                hud.setEntityStatus(Message.raw((String)status));
                builder.set("#BlocchioLookEntityHud.Visible", true);
                builder.set("#BlocchioEntityNameLabel.TextSpans", entityName);
                builder.set("#BlocchioEntityIdLabel.Visible", hud.isShowEntityId());
                builder.set("#BlocchioEntityIdLabel.TextSpans", hud.isShowEntityId() ? Message.raw((String)entityId) : Message.raw((String)""));
                builder.set("#BlocchioEntityStatusLabel.Visible", hud.isShowEntityStatus());
                builder.set("#BlocchioEntityStatusLabel.TextSpans", hud.isShowEntityStatus() ? Message.raw((String)status) : Message.raw((String)""));
            } else {
                hud.setEntityVisible(false);
                hud.setEntityName(Message.raw((String)""));
                hud.setEntityId(Message.raw((String)""));
                hud.setEntityStatus(Message.raw((String)""));
                builder.set("#BlocchioLookEntityHud.Visible", false);
                builder.set("#BlocchioEntityNameLabel.TextSpans", Message.raw((String)""));
                builder.set("#BlocchioEntityIdLabel.Visible", hud.isShowEntityId());
                builder.set("#BlocchioEntityIdLabel.TextSpans", Message.raw((String)""));
                builder.set("#BlocchioEntityStatusLabel.Visible", hud.isShowEntityStatus());
                builder.set("#BlocchioEntityStatusLabel.TextSpans", Message.raw((String)""));
            }
        }
        if (!hud.isBlockHudEnabled()) {
            hud.setName(Message.raw((String)""));
            hud.setBlockVisible(false);
            hud.setItemIconVisible(false);
            hud.setItemId("");
            hud.setBlockId(Message.raw((String)""));
            hud.setMetaVisible(false);
            hud.setBlockState(Message.raw((String)""));
            hud.setBlockOrigin(Message.raw((String)""));
            hud.setBlockCategory(Message.raw((String)""));
            hud.setModTagVisible(false);
            hud.setModTagText(Message.raw((String)""));
            builder.set("#BlocchioLookBlockHud.Visible", false);
            builder.set("#BlocchioItemIcon.Visible", false);
            builder.set("#BlocchioMetaCol.Visible", false);
            builder.set("#BlocchioStateLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioOriginLabel.Visible", hud.isShowBlockOrigin());
            builder.set("#BlocchioOriginLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioCategoryLabel.Visible", hud.isShowBlockCategory());
            builder.set("#BlocchioCategoryLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioModTagRow.Visible", false);
            builder.set("#BlocchioModFullLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioIdLabel.Visible", hud.isShowBlockId());
            builder.set("#BlocchioIdLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioNameLabel.TextSpans", Message.raw((String)""));
            hud.update(false, builder);
            return;
        }
        Vector3i target = TargetUtil.getTargetBlock(ref, (double)blockMaxDistance, (ComponentAccessor)store);
        if (target == null) {
            hud.setName(Message.raw((String)""));
            hud.setBlockVisible(false);
            hud.setItemIconVisible(false);
            hud.setBlockId(Message.raw((String)""));
            hud.setMetaVisible(false);
            hud.setBlockState(Message.raw((String)""));
            hud.setBlockOrigin(Message.raw((String)""));
            hud.setBlockCategory(Message.raw((String)""));
            hud.setModTagVisible(false);
            hud.setModTagText(Message.raw((String)""));
            builder.set("#BlocchioLookBlockHud.Visible", false);
            builder.set("#BlocchioItemIcon.Visible", false);
            builder.set("#BlocchioIdLabel.Visible", hud.isShowBlockId());
            builder.set("#BlocchioIdLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioMetaCol.Visible", false);
            builder.set("#BlocchioStateLabel.Visible", false);
            builder.set("#BlocchioStateLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioOriginLabel.Visible", hud.isShowBlockOrigin());
            builder.set("#BlocchioOriginLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioCategoryLabel.Visible", hud.isShowBlockCategory());
            builder.set("#BlocchioCategoryLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioModTagRow.Visible", false);
            builder.set("#BlocchioModFullLabel.TextSpans", Message.raw((String)""));
            builder.set("#BlocchioNameLabel.TextSpans", Message.raw((String)""));
        } else {
            String categoryId;
            Message name;
            String itemId;
            String blockKey;
            block44: {
                int blockId = world.getNonTickingChunk(ChunkUtil.indexChunkFromBlock((int)target.x, (int)target.z)).getBlock(target.x, target.y, target.z);
                BlockType blockType = (BlockType)BlockType.getAssetMap().getAsset(blockId);
                blockKey = blockType != null ? blockType.getId() : "<null>";
                Item item = blockType != null ? blockType.getItem() : null;
                itemId = item != null ? item.getId() : null;
                name = item != null ? Message.translation((String)item.getTranslationKey()) : Message.raw((String)blockKey);
                hud.setName(name);
                hud.setBlockVisible(true);
                builder.set("#BlocchioLookBlockHud.Visible", true);
                if (itemId != null && !itemId.isEmpty()) {
                    hud.setItemId(itemId);
                    hud.setItemIconVisible(true);
                    builder.set("#BlocchioItemIcon.Visible", true);
                    builder.set("#BlocchioItemIcon.ItemId", itemId);
                } else {
                    hud.setItemIconVisible(false);
                    builder.set("#BlocchioItemIcon.Visible", false);
                }
                Object shortBlockKey = blockKey;
                if (shortBlockKey != null && ((String)shortBlockKey).length() > 32) {
                    shortBlockKey = ((String)shortBlockKey).substring(0, 29) + "...";
                }
                Message idMsg = Message.raw((String)shortBlockKey);
                hud.setBlockId(idMsg);
                builder.set("#BlocchioIdLabel.Visible", hud.isShowBlockId());
                builder.set("#BlocchioIdLabel.TextSpans", hud.isShowBlockId() ? idMsg : Message.raw((String)""));
                categoryId = null;
                try {
                    String[] categories;
                    String[] stringArray = categories = item != null ? item.getCategories() : null;
                    if (categories == null) break block44;
                    for (String c : categories) {
                        if (c == null || c.isEmpty()) continue;
                        categoryId = c;
                        break;
                    }
                }
                catch (Throwable categories) {
                    // empty catch block
                }
            }
            if (categoryId != null && !categoryId.isEmpty()) {
                Message categoryMsg;
                String categoryName = categoryId;
                try {
                    ItemCategory category = (ItemCategory)ItemCategory.getAssetMap().getAsset((Object)categoryId);
                    if (category != null && category.getName() != null && !category.getName().isEmpty()) {
                        categoryName = category.getName();
                    }
                }
                catch (Throwable category) {
                    // empty catch block
                }
                if (categoryName.contains(".")) {
                    String shortCategory = categoryName;
                    int lastDot = shortCategory.lastIndexOf(46);
                    if (lastDot >= 0 && lastDot + 1 < shortCategory.length()) {
                        shortCategory = shortCategory.substring(lastDot + 1);
                    }
                    categoryMsg = Message.raw((String)shortCategory);
                } else {
                    categoryMsg = Message.raw((String)categoryName);
                }
                hud.setMetaVisible(true);
                hud.setBlockCategory(categoryMsg);
                builder.set("#BlocchioMetaCol.Visible", true);
                builder.set("#BlocchioStateLabel.Visible", false);
                builder.set("#BlocchioStateLabel.TextSpans", Message.raw((String)""));
                builder.set("#BlocchioCategoryLabel.Visible", hud.isShowBlockCategory());
                builder.set("#BlocchioCategoryLabel.TextSpans", hud.isShowBlockCategory() ? categoryMsg : Message.raw((String)""));
            } else {
                hud.setMetaVisible(false);
                hud.setBlockState(Message.raw((String)""));
                hud.setBlockCategory(Message.raw((String)""));
                builder.set("#BlocchioMetaCol.Visible", false);
                builder.set("#BlocchioStateLabel.Visible", false);
                builder.set("#BlocchioStateLabel.TextSpans", Message.raw((String)""));
                builder.set("#BlocchioCategoryLabel.Visible", hud.isShowBlockCategory());
                builder.set("#BlocchioCategoryLabel.TextSpans", Message.raw((String)""));
            }
            String ownerFull = LookHudUpdater.resolveBlockOwnerFull(blockKey, itemId);
            boolean vanilla = LookHudUpdater.isVanillaOwner(ownerFull);
            Message originMsg = Message.raw((String)(vanilla ? "vanilla" : "modded"));
            hud.setBlockOrigin(originMsg);
            builder.set("#BlocchioOriginLabel.Visible", hud.isShowBlockOrigin());
            builder.set("#BlocchioOriginLabel.TextSpans", hud.isShowBlockOrigin() ? originMsg : Message.raw((String)""));
            if (hud.isShowModTag() && !vanilla && ownerFull != null && !ownerFull.isEmpty()) {
                String modDisplay = ownerFull;
                try {
                    int colon = modDisplay.indexOf(58);
                    if (colon >= 0 && colon + 1 < modDisplay.length()) {
                        modDisplay = modDisplay.substring(colon + 1);
                    }
                }
                catch (Throwable colon) {
                    // empty catch block
                }
                Message modMsg = Message.raw((String)("MOD: " + modDisplay));
                hud.setModTagVisible(true);
                hud.setModTagText(modMsg);
                builder.set("#BlocchioModTagRow.Visible", true);
                builder.set("#BlocchioModFullLabel.TextSpans", modMsg);
            } else {
                hud.setModTagVisible(false);
                hud.setModTagText(Message.raw((String)""));
                builder.set("#BlocchioModTagRow.Visible", false);
                builder.set("#BlocchioModFullLabel.TextSpans", Message.raw((String)""));
            }
            builder.set("#BlocchioNameLabel.TextSpans", name);
        }
        hud.update(false, builder);
    }
}

