/*
 * Decompiled with CFR 0.152.
 */
package org.sureizu.plugin.hud;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.hud.CustomUIHud;
import com.hypixel.hytale.server.core.plugin.PluginManager;
import com.hypixel.hytale.server.core.ui.Anchor;
import com.hypixel.hytale.server.core.ui.Value;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sureizu.plugin.hud.LookHud;
import org.sureizu.plugin.hud.LookHudUpdater;

public final class LookHudService {
    private static final HytaleLogger LOGGER = HytaleLogger.forEnclosingClass();
    private static final String HUD_IDENTIFIER = "Blocchio";
    public static final double DEFAULT_BLOCK_RANGE = 5.0;
    public static final double DEFAULT_ENTITY_RANGE = 8.0;
    private static final int MIN_BLOCK_RANGE = 3;
    private static final int MAX_BLOCK_RANGE = 20;
    private static final int MIN_ENTITY_RANGE = 3;
    private static final int MAX_ENTITY_RANGE = 20;
    private static final long UPDATE_PERIOD_MS = 200L;
    private static final String SETTINGS_FILE = "player-settings.properties";
    private final ConcurrentHashMap<UUID, ScheduledFuture<?>> tasks = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, LookHud> huds = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Boolean> warnedMissingMultiHud = new ConcurrentHashMap();
    private final Path dataDirectory;
    private final Path settingsPath;
    private final Object settingsLock = new Object();
    private final ConcurrentHashMap<UUID, PlayerHudSettings> settings = new ConcurrentHashMap();

    public LookHudService(@Nonnull Path dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.settingsPath = dataDirectory.resolve(SETTINGS_FILE);
        this.loadSettings();
    }

    private static int clampBlockRange(int range) {
        if (range < 3) {
            return 3;
        }
        if (range > 20) {
            return 20;
        }
        return range;
    }

    private static int clampEntityRange(int range) {
        if (range < 3) {
            return 3;
        }
        if (range > 20) {
            return 20;
        }
        return range;
    }

    @Nonnull
    private PlayerHudSettings getOrCreateSettings(@Nonnull UUID uuid) {
        return this.settings.computeIfAbsent(uuid, u -> new PlayerHudSettings(true, "default", SizePreset.MEDIUM));
    }

    @Nonnull
    private static String normalizePosition(@Nullable String position) {
        String p;
        if (position == null) {
            return "default";
        }
        switch (p = position.trim().toLowerCase()) {
            case "default": 
            case "top_left": 
            case "top_right": 
            case "bottom_left": {
                return p;
            }
        }
        return "default";
    }

    @Nonnull
    private static SizePreset normalizeSize(@Nullable String size) {
        String s;
        if (size == null) {
            return SizePreset.MEDIUM;
        }
        switch (s = size.trim().toLowerCase()) {
            case "small": {
                return SizePreset.SMALL;
            }
            case "large": {
                return SizePreset.LARGE;
            }
        }
        return SizePreset.MEDIUM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        Object object = this.settingsLock;
        synchronized (object) {
            try {
                if (!Files.exists(this.dataDirectory, new LinkOption[0])) {
                    Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
                }
                if (!Files.exists(this.settingsPath, new LinkOption[0])) {
                    return;
                }
                Properties props = new Properties();
                try (InputStream in = Files.newInputStream(this.settingsPath, new OpenOption[0]);){
                    props.load(in);
                }
                for (String key : props.stringPropertyNames()) {
                    UUID uuid;
                    int dot = key.indexOf(46);
                    if (dot <= 0 || dot + 1 >= key.length()) continue;
                    String uuidStr = key.substring(0, dot);
                    String field = key.substring(dot + 1);
                    try {
                        uuid = UUID.fromString(uuidStr);
                    }
                    catch (IllegalArgumentException ignored) {
                        continue;
                    }
                    PlayerHudSettings s = this.getOrCreateSettings(uuid);
                    String value = props.getProperty(key, "");
                    if (field.equalsIgnoreCase("enabled")) {
                        s.enabled = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("position")) {
                        s.position = LookHudService.normalizePosition(value);
                        continue;
                    }
                    if (field.equalsIgnoreCase("size")) {
                        s.size = LookHudService.normalizeSize(value);
                        continue;
                    }
                    if (field.equalsIgnoreCase("block_range")) {
                        try {
                            s.blockRange = LookHudService.clampBlockRange(Integer.parseInt(value.trim()));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (field.equalsIgnoreCase("entity_range")) {
                        try {
                            s.entityRange = LookHudService.clampEntityRange(Integer.parseInt(value.trim()));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (field.equalsIgnoreCase("block_hud_enabled")) {
                        s.blockHudEnabled = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("entity_hud_enabled")) {
                        s.entityHudEnabled = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("show_block_id")) {
                        s.showBlockId = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("show_entity_id")) {
                        s.showEntityId = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("show_block_origin")) {
                        s.showBlockOrigin = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("show_block_category")) {
                        s.showBlockCategory = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("show_entity_status")) {
                        s.showEntityStatus = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("name_color")) {
                        s.nameColor = value;
                        continue;
                    }
                    if (field.equalsIgnoreCase("id_color")) {
                        s.idColor = value;
                        continue;
                    }
                    if (field.equalsIgnoreCase("origin_color")) {
                        s.originColor = value;
                        continue;
                    }
                    if (field.equalsIgnoreCase("category_color")) {
                        s.categoryColor = value;
                        continue;
                    }
                    if (field.equalsIgnoreCase("mod_tag_enabled")) {
                        s.modTagEnabled = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("mod_tag_color")) {
                        s.modTagColor = value;
                        continue;
                    }
                    if (field.equalsIgnoreCase("mod_tag_bold")) {
                        s.modTagBold = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("mod_tag_italic")) {
                        s.modTagItalic = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("entity_name_color")) {
                        s.entityNameColor = value;
                        continue;
                    }
                    if (field.equalsIgnoreCase("entity_id_color")) {
                        s.entityIdColor = value;
                        continue;
                    }
                    if (field.equalsIgnoreCase("entity_status_color")) {
                        s.entityStatusColor = value;
                        continue;
                    }
                    if (field.equalsIgnoreCase("entity_name_bold")) {
                        s.entityNameBold = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("entity_name_italic")) {
                        s.entityNameItalic = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("entity_id_bold")) {
                        s.entityIdBold = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("entity_id_italic")) {
                        s.entityIdItalic = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("name_bold")) {
                        s.nameBold = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("name_italic")) {
                        s.nameItalic = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (field.equalsIgnoreCase("id_bold")) {
                        s.idBold = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                        continue;
                    }
                    if (!field.equalsIgnoreCase("id_italic")) continue;
                    s.idItalic = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("yes");
                }
            }
            catch (Throwable t) {
                ((HytaleLogger.Api)LOGGER.at(Level.WARNING).withCause(t)).log("Failed to load Blocchio player settings");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSettings() {
        Object object = this.settingsLock;
        synchronized (object) {
            try {
                if (!Files.exists(this.dataDirectory, new LinkOption[0])) {
                    Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
                }
                Properties props = new Properties();
                for (Map.Entry<UUID, PlayerHudSettings> entry : this.settings.entrySet()) {
                    UUID uuid = entry.getKey();
                    PlayerHudSettings s = entry.getValue();
                    if (uuid == null || s == null) continue;
                    props.setProperty(uuid.toString() + ".enabled", String.valueOf(s.enabled));
                    props.setProperty(uuid.toString() + ".position", LookHudService.normalizePosition(s.position));
                    props.setProperty(uuid.toString() + ".size", s.size != null ? s.size.name().toLowerCase() : SizePreset.MEDIUM.name().toLowerCase());
                    props.setProperty(uuid.toString() + ".block_range", String.valueOf(LookHudService.clampBlockRange(s.blockRange)));
                    props.setProperty(uuid.toString() + ".entity_range", String.valueOf(LookHudService.clampEntityRange(s.entityRange)));
                    props.setProperty(uuid.toString() + ".block_hud_enabled", String.valueOf(s.blockHudEnabled));
                    props.setProperty(uuid.toString() + ".entity_hud_enabled", String.valueOf(s.entityHudEnabled));
                    props.setProperty(uuid.toString() + ".show_block_id", String.valueOf(s.showBlockId));
                    props.setProperty(uuid.toString() + ".show_entity_id", String.valueOf(s.showEntityId));
                    props.setProperty(uuid.toString() + ".show_block_origin", String.valueOf(s.showBlockOrigin));
                    props.setProperty(uuid.toString() + ".show_block_category", String.valueOf(s.showBlockCategory));
                    props.setProperty(uuid.toString() + ".show_entity_status", String.valueOf(s.showEntityStatus));
                    props.setProperty(uuid.toString() + ".name_color", s.nameColor != null ? s.nameColor : "#f8fafc");
                    props.setProperty(uuid.toString() + ".id_color", s.idColor != null ? s.idColor : "#4de3fa");
                    props.setProperty(uuid.toString() + ".origin_color", s.originColor != null ? s.originColor : "#94a3b8");
                    props.setProperty(uuid.toString() + ".category_color", s.categoryColor != null ? s.categoryColor : "#94a3b8");
                    props.setProperty(uuid.toString() + ".mod_tag_enabled", String.valueOf(s.modTagEnabled));
                    props.setProperty(uuid.toString() + ".mod_tag_color", s.modTagColor != null ? s.modTagColor : "#fbbf24");
                    props.setProperty(uuid.toString() + ".mod_tag_bold", String.valueOf(s.modTagBold));
                    props.setProperty(uuid.toString() + ".mod_tag_italic", String.valueOf(s.modTagItalic));
                    props.setProperty(uuid.toString() + ".entity_name_color", s.entityNameColor != null ? s.entityNameColor : "#f8fafc");
                    props.setProperty(uuid.toString() + ".entity_id_color", s.entityIdColor != null ? s.entityIdColor : "#4de3fa");
                    props.setProperty(uuid.toString() + ".entity_status_color", s.entityStatusColor != null ? s.entityStatusColor : "#e8e9eb");
                    props.setProperty(uuid.toString() + ".entity_name_bold", String.valueOf(s.entityNameBold));
                    props.setProperty(uuid.toString() + ".entity_name_italic", String.valueOf(s.entityNameItalic));
                    props.setProperty(uuid.toString() + ".entity_id_bold", String.valueOf(s.entityIdBold));
                    props.setProperty(uuid.toString() + ".entity_id_italic", String.valueOf(s.entityIdItalic));
                    props.setProperty(uuid.toString() + ".name_bold", String.valueOf(s.nameBold));
                    props.setProperty(uuid.toString() + ".name_italic", String.valueOf(s.nameItalic));
                    props.setProperty(uuid.toString() + ".id_bold", String.valueOf(s.idBold));
                    props.setProperty(uuid.toString() + ".id_italic", String.valueOf(s.idItalic));
                }
                try (OutputStream out = Files.newOutputStream(this.settingsPath, new OpenOption[0]);){
                    props.store(out, "Blocchio per-player HUD settings");
                }
            }
            catch (Throwable t) {
                ((HytaleLogger.Api)LOGGER.at(Level.WARNING).withCause(t)).log("Failed to save Blocchio player settings");
            }
        }
    }

    public void enable(@Nonnull PlayerRef playerRef) {
        UUID uuid = playerRef.getUuid();
        ScheduledFuture<?> oldTask = this.tasks.remove(uuid);
        if (oldTask != null) {
            oldTask.cancel(false);
        }
        this.huds.remove(uuid);
        this.warnedMissingMultiHud.remove(uuid);
        PlayerHudSettings s = this.getOrCreateSettings(uuid);
        if (!s.enabled) {
            return;
        }
        LookHud hud = new LookHud(playerRef);
        this.huds.put(uuid, hud);
        hud.setScale(s.size != null ? s.size.scale : SizePreset.MEDIUM.scale);
        this.updatePosition(playerRef, LookHudService.normalizePosition(s.position));
        hud.setNameColor(s.nameColor);
        hud.setIdColor(s.idColor);
        hud.setOriginColor(s.originColor);
        hud.setNameBold(s.nameBold);
        hud.setNameItalic(s.nameItalic);
        hud.setIdBold(s.idBold);
        hud.setIdItalic(s.idItalic);
        hud.setBlockHudEnabled(s.blockHudEnabled);
        hud.setEntityHudEnabled(s.entityHudEnabled);
        hud.setShowBlockId(s.showBlockId);
        hud.setShowEntityId(s.showEntityId);
        hud.setShowBlockOrigin(s.showBlockOrigin);
        hud.setShowBlockCategory(s.showBlockCategory);
        hud.setShowEntityStatus(s.showEntityStatus);
        hud.setCategoryColor(s.categoryColor);
        hud.setShowModTag(s.modTagEnabled);
        hud.setModTagColor(s.modTagColor);
        hud.setModTagBold(s.modTagBold);
        hud.setModTagItalic(s.modTagItalic);
        hud.setEntityNameColor(s.entityNameColor);
        hud.setEntityIdColor(s.entityIdColor);
        hud.setEntityStatusColor(s.entityStatusColor);
        hud.setEntityNameBold(s.entityNameBold);
        hud.setEntityNameItalic(s.entityNameItalic);
        hud.setEntityIdBold(s.entityIdBold);
        hud.setEntityIdItalic(s.entityIdItalic);
        ScheduledFuture<?> task = HytaleServer.SCHEDULED_EXECUTOR.scheduleWithFixedDelay(() -> {
            Ref ref = playerRef.getReference();
            if (ref == null || !ref.isValid()) {
                return;
            }
            Store store = ref.getStore();
            World world = ((EntityStore)store.getExternalData()).getWorld();
            world.execute(() -> {
                if (!ref.isValid()) {
                    return;
                }
                if (!hud.isAttached()) {
                    Player player = (Player)store.getComponent(ref, Player.getComponentType());
                    if (player == null) {
                        return;
                    }
                    if (MultiHudCompat.isAvailable()) {
                        if (MultiHudCompat.setCustomHud(player, playerRef, HUD_IDENTIFIER, hud)) {
                            hud.setAttached(true);
                            return;
                        }
                    } else {
                        Boolean alreadyWarned = this.warnedMissingMultiHud.putIfAbsent(uuid, Boolean.TRUE);
                        if (alreadyWarned == null) {
                            Message root = Message.raw((String)"");
                            Message prefix = Message.raw((String)"[Blocchio] ").bold(true).color("#A78BFA");
                            Message body = Message.raw((String)"MultipleHUD not found, HUD may not work correctly with other mods adding custom UI");
                            player.sendMessage(root.insert(prefix).insert(body));
                            LOGGER.at(Level.WARNING).log("MultipleHUD not found, Blocchio may not work correctly with other mods adding custom UI");
                        }
                    }
                    player.getHudManager().setCustomHud(playerRef, (CustomUIHud)hud);
                    hud.setAttached(true);
                }
                PlayerHudSettings ps = this.getOrCreateSettings(uuid);
                int blockRange = LookHudService.clampBlockRange(ps.blockRange);
                int entityRange = LookHudService.clampEntityRange(ps.entityRange);
                LookHudUpdater.update((Ref<EntityStore>)ref, hud, blockRange, entityRange);
            });
        }, 3L, 200L, TimeUnit.MILLISECONDS);
        this.tasks.put(uuid, task);
    }

    public void disable(@Nonnull PlayerRef playerRef) {
        UUID uuid = playerRef.getUuid();
        ScheduledFuture<?> task = this.tasks.remove(uuid);
        if (task != null) {
            task.cancel(false);
        }
        this.huds.remove(uuid);
        this.warnedMissingMultiHud.remove(uuid);
        Ref ref = playerRef.getReference();
        if (ref == null || !ref.isValid()) {
            return;
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        world.execute(() -> {
            if (!ref.isValid()) {
                return;
            }
            Player player = (Player)store.getComponent(ref, Player.getComponentType());
            if (player != null) {
                if (MultiHudCompat.isAvailable() && MultiHudCompat.hideCustomHud(player, playerRef, HUD_IDENTIFIER)) {
                    return;
                }
                player.getHudManager().setCustomHud(playerRef, null);
            }
        });
    }

    public void updatePosition(@Nonnull PlayerRef playerRef, @Nonnull String positionName) {
        Ref ref;
        String normalizedPos = LookHudService.normalizePosition(positionName);
        PlayerHudSettings playerSettings = this.getOrCreateSettings(playerRef.getUuid());
        playerSettings.position = normalizedPos;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setPositionName(normalizedPos);
        float scale = hud.getScale();
        if (scale <= 0.0f) {
            scale = 1.0f;
        }
        Anchor anchor = new Anchor();
        int width = Math.max(1, Math.round(320.0f * scale));
        int height = Math.max(1, Math.round(150.0f * scale));
        anchor.setWidth(Value.of((Object)width));
        anchor.setHeight(Value.of((Object)height));
        switch (normalizedPos) {
            case "top_left": {
                anchor.setLeft(Value.of((Object)10));
                anchor.setTop(Value.of((Object)10));
                break;
            }
            case "top_right": {
                anchor.setRight(Value.of((Object)10));
                anchor.setTop(Value.of((Object)10));
                break;
            }
            case "bottom_left": {
                anchor.setLeft(Value.of((Object)10));
                anchor.setBottom(Value.of((Object)10));
                break;
            }
            default: {
                anchor.setHeight(Value.of((Object)height));
                anchor.setLeft(Value.of((Object)8));
                anchor.setTop(Value.of((Object)185));
            }
        }
        hud.setRootAnchor(anchor);
        if (hud.isAttached() && (ref = playerRef.getReference()) != null && ref.isValid()) {
            Store store = ref.getStore();
            World world = ((EntityStore)store.getExternalData()).getWorld();
            world.execute(() -> {
                Player player = (Player)store.getComponent(ref, Player.getComponentType());
                if (player != null) {
                    UICommandBuilder builder = new UICommandBuilder();
                    builder.setObject("#ProbeHud.Anchor", (Object)anchor);
                    hud.update(false, builder);
                }
            });
        }
    }

    public void updateScale(@Nonnull PlayerRef playerRef, float scale) {
        this.updateSizePreset(playerRef, SizePreset.MEDIUM);
    }

    @Nonnull
    public StyleSnapshot getStyleSnapshot(@Nonnull PlayerRef playerRef) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        return new StyleSnapshot(LookHudService.normalizePosition(s.position), s.size != null ? s.size.name().toLowerCase() : SizePreset.MEDIUM.name().toLowerCase(), LookHudService.clampBlockRange(s.blockRange), LookHudService.clampEntityRange(s.entityRange), s.blockHudEnabled, s.entityHudEnabled, s.showBlockId, s.showEntityId, s.showBlockOrigin, s.showBlockCategory, s.showEntityStatus, s.nameColor != null ? s.nameColor : "#f8fafc", s.idColor != null ? s.idColor : "#4de3fa", s.originColor != null ? s.originColor : "#94a3b8", s.categoryColor != null ? s.categoryColor : "#94a3b8", s.modTagEnabled, s.modTagColor != null ? s.modTagColor : "#fbbf24", s.modTagBold, s.modTagItalic, s.entityNameColor != null ? s.entityNameColor : "#f8fafc", s.entityIdColor != null ? s.entityIdColor : "#4de3fa", s.entityStatusColor != null ? s.entityStatusColor : "#e8e9eb", s.entityNameBold, s.entityNameItalic, s.entityIdBold, s.entityIdItalic, s.nameBold, s.nameItalic, s.idBold, s.idItalic);
    }

    public void updateEntityRange(@Nonnull PlayerRef playerRef, int entityRange) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.entityRange = LookHudService.clampEntityRange(entityRange);
        this.saveSettings();
    }

    public void updateShowBlockOrigin(@Nonnull PlayerRef playerRef, boolean show) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.showBlockOrigin = show;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setShowBlockOrigin(show);
        UICommandBuilder builder = new UICommandBuilder();
        builder.set("#BlocchioOriginLabel.Visible", show);
        if (!show) {
            builder.set("#BlocchioOriginLabel.TextSpans", Message.raw((String)""));
        }
        hud.update(false, builder);
    }

    public void updateShowBlockCategory(@Nonnull PlayerRef playerRef, boolean show) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.showBlockCategory = show;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setShowBlockCategory(show);
        UICommandBuilder builder = new UICommandBuilder();
        builder.set("#BlocchioCategoryLabel.Visible", show);
        if (!show) {
            builder.set("#BlocchioCategoryLabel.TextSpans", Message.raw((String)""));
        }
        hud.update(false, builder);
    }

    public void updateShowEntityStatus(@Nonnull PlayerRef playerRef, boolean show) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.showEntityStatus = show;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setShowEntityStatus(show);
        UICommandBuilder builder = new UICommandBuilder();
        builder.set("#BlocchioEntityStatusLabel.Visible", show);
        if (!show) {
            builder.set("#BlocchioEntityStatusLabel.TextSpans", Message.raw((String)""));
        }
        hud.update(false, builder);
    }

    public void updateShowBlockId(@Nonnull PlayerRef playerRef, boolean show) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.showBlockId = show;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setShowBlockId(show);
        UICommandBuilder builder = new UICommandBuilder();
        builder.set("#BlocchioIdLabel.Visible", show);
        if (!show) {
            builder.set("#BlocchioIdLabel.TextSpans", Message.raw((String)""));
        }
        hud.update(false, builder);
    }

    public void updateShowEntityId(@Nonnull PlayerRef playerRef, boolean show) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.showEntityId = show;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setShowEntityId(show);
        UICommandBuilder builder = new UICommandBuilder();
        builder.set("#BlocchioEntityIdLabel.Visible", show);
        if (!show) {
            builder.set("#BlocchioEntityIdLabel.TextSpans", Message.raw((String)""));
        }
        hud.update(false, builder);
    }

    public void updateBlockRange(@Nonnull PlayerRef playerRef, int blockRange) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.blockRange = LookHudService.clampBlockRange(blockRange);
        this.saveSettings();
    }

    public void updateBlockHudEnabled(@Nonnull PlayerRef playerRef, boolean enabled) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.blockHudEnabled = enabled;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setBlockHudEnabled(enabled);
    }

    public void updateEntityHudEnabled(@Nonnull PlayerRef playerRef, boolean enabled) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.entityHudEnabled = enabled;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setEntityHudEnabled(enabled);
    }

    public void updateBlockExtraStyle(@Nonnull PlayerRef playerRef, @Nonnull String categoryColor) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.categoryColor = categoryColor;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setCategoryColor(categoryColor);
        if (!hud.isAttached()) {
            return;
        }
        Ref ref = playerRef.getReference();
        if (ref == null || !ref.isValid()) {
            return;
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        world.execute(() -> {
            Player player = (Player)store.getComponent(ref, Player.getComponentType());
            if (player != null) {
                UICommandBuilder builder = new UICommandBuilder();
                builder.set("#BlocchioCategoryLabel.Style.TextColor", categoryColor);
                hud.update(false, builder);
            }
        });
    }

    public void updateModTagStyle(@Nonnull PlayerRef playerRef, boolean enabled, @Nonnull String color, boolean bold, boolean italic) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.modTagEnabled = enabled;
        s.modTagColor = color;
        s.modTagBold = bold;
        s.modTagItalic = italic;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setShowModTag(enabled);
        hud.setModTagColor(color);
        hud.setModTagBold(bold);
        hud.setModTagItalic(italic);
        if (!hud.isAttached()) {
            return;
        }
        Ref ref = playerRef.getReference();
        if (ref == null || !ref.isValid()) {
            return;
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        world.execute(() -> {
            Player player = (Player)store.getComponent(ref, Player.getComponentType());
            if (player != null) {
                UICommandBuilder builder = new UICommandBuilder();
                builder.set("#BlocchioModTagRow.Visible", enabled);
                builder.set("#BlocchioModFullLabel.Style.TextColor", color);
                builder.set("#BlocchioModFullLabel.Style.RenderBold", bold);
                builder.set("#BlocchioModFullLabel.Style.RenderItalics", italic);
                hud.update(false, builder);
            }
        });
    }

    public void updateEntityTextStyle(@Nonnull PlayerRef playerRef, @Nonnull String nameColor, @Nonnull String idColor, @Nonnull String statusColor, boolean nameBold, boolean nameItalic, boolean idBold, boolean idItalic) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.entityNameColor = nameColor;
        s.entityIdColor = idColor;
        s.entityStatusColor = statusColor;
        s.entityNameBold = nameBold;
        s.entityNameItalic = nameItalic;
        s.entityIdBold = idBold;
        s.entityIdItalic = idItalic;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setEntityNameColor(nameColor);
        hud.setEntityIdColor(idColor);
        hud.setEntityStatusColor(statusColor);
        hud.setEntityNameBold(nameBold);
        hud.setEntityNameItalic(nameItalic);
        hud.setEntityIdBold(idBold);
        hud.setEntityIdItalic(idItalic);
    }

    public void updateTextStyle(@Nonnull PlayerRef playerRef, @Nonnull String nameColor, @Nonnull String idColor, @Nonnull String originColor, boolean nameBold, boolean nameItalic, boolean idBold, boolean idItalic) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        s.nameColor = nameColor;
        s.idColor = idColor;
        s.originColor = originColor;
        s.nameBold = nameBold;
        s.nameItalic = nameItalic;
        s.idBold = idBold;
        s.idItalic = idItalic;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setNameColor(nameColor);
        hud.setIdColor(idColor);
        hud.setOriginColor(originColor);
        hud.setNameBold(nameBold);
        hud.setNameItalic(nameItalic);
        hud.setIdBold(idBold);
        hud.setIdItalic(idItalic);
        if (!hud.isAttached()) {
            return;
        }
        Ref ref = playerRef.getReference();
        if (ref == null || !ref.isValid()) {
            return;
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        world.execute(() -> {
            Player player = (Player)store.getComponent(ref, Player.getComponentType());
            if (player != null) {
                UICommandBuilder builder = new UICommandBuilder();
                builder.set("#BlocchioNameLabel.Style.TextColor", nameColor);
                builder.set("#BlocchioNameLabel.Style.RenderBold", nameBold);
                builder.set("#BlocchioNameLabel.Style.RenderItalics", nameItalic);
                builder.set("#BlocchioIdLabel.Style.TextColor", idColor);
                builder.set("#BlocchioIdLabel.Style.RenderBold", idBold);
                builder.set("#BlocchioIdLabel.Style.RenderItalics", idItalic);
                builder.set("#BlocchioOriginLabel.Style.TextColor", originColor);
                hud.update(false, builder);
            }
        });
    }

    public void resetToDefaults(@Nonnull PlayerRef playerRef) {
        UUID uuid = playerRef.getUuid();
        PlayerHudSettings s = this.getOrCreateSettings(uuid);
        s.position = "default";
        s.size = SizePreset.MEDIUM;
        s.blockRange = 5;
        s.entityRange = 8;
        s.nameColor = "#f8fafc";
        s.idColor = "#4de3fa";
        s.originColor = "#94a3b8";
        s.blockHudEnabled = true;
        s.entityHudEnabled = true;
        s.showBlockId = true;
        s.showEntityId = true;
        s.showBlockOrigin = true;
        s.showBlockCategory = true;
        s.showEntityStatus = true;
        s.categoryColor = "#94a3b8";
        s.modTagEnabled = true;
        s.modTagColor = "#fbbf24";
        s.modTagBold = true;
        s.modTagItalic = false;
        s.entityNameColor = "#f8fafc";
        s.entityIdColor = "#4de3fa";
        s.entityStatusColor = "#e8e9eb";
        s.entityNameBold = true;
        s.entityNameItalic = false;
        s.entityIdBold = true;
        s.entityIdItalic = false;
        s.nameBold = true;
        s.nameItalic = false;
        s.idBold = true;
        s.idItalic = false;
        this.saveSettings();
        this.updateSizePreset(playerRef, SizePreset.MEDIUM);
        this.updatePosition(playerRef, "default");
        this.updateTextStyle(playerRef, s.nameColor, s.idColor, s.originColor, s.nameBold, s.nameItalic, s.idBold, s.idItalic);
        this.updateBlockRange(playerRef, s.blockRange);
        this.updateEntityRange(playerRef, s.entityRange);
        this.updateBlockHudEnabled(playerRef, true);
        this.updateEntityHudEnabled(playerRef, true);
        this.updateShowBlockId(playerRef, true);
        this.updateShowEntityId(playerRef, true);
        this.updateShowBlockOrigin(playerRef, true);
        this.updateShowBlockCategory(playerRef, true);
        this.updateShowEntityStatus(playerRef, true);
        this.updateBlockExtraStyle(playerRef, s.categoryColor);
        this.updateModTagStyle(playerRef, true, s.modTagColor, s.modTagBold, s.modTagItalic);
        this.updateEntityTextStyle(playerRef, s.entityNameColor, s.entityIdColor, s.entityStatusColor, s.entityNameBold, s.entityNameItalic, s.entityIdBold, s.entityIdItalic);
    }

    public void updateSizePreset(@Nonnull PlayerRef playerRef, @Nonnull String presetName) {
        SizePreset preset = LookHudService.normalizeSize(presetName);
        this.updateSizePreset(playerRef, preset);
    }

    private void updateSizePreset(@Nonnull PlayerRef playerRef, @Nonnull SizePreset preset) {
        PlayerHudSettings playerSettings = this.getOrCreateSettings(playerRef.getUuid());
        playerSettings.size = preset;
        this.saveSettings();
        LookHud hud = this.huds.get(playerRef.getUuid());
        if (hud == null) {
            return;
        }
        hud.setScale(preset.scale);
        this.updatePosition(playerRef, hud.getPositionName());
        if (!hud.isAttached()) {
            return;
        }
        Ref ref = playerRef.getReference();
        if (ref == null || !ref.isValid()) {
            return;
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        world.execute(() -> {
            Player player = (Player)store.getComponent(ref, Player.getComponentType());
            if (player == null) {
                return;
            }
            float sc = hud.getScale();
            UICommandBuilder builder = new UICommandBuilder();
            builder.setObject("#BlocchioLookBlockHud.Anchor", (Object)LookHudService.anchorHeight(LookHudService.scaleInt(82, sc)));
            builder.setObject("#BlocchioPanel.Anchor", (Object)LookHudService.anchorLtrh(0, 0, 0, LookHudService.scaleInt(64, sc)));
            builder.setObject("#BlocchioLeftCol.Anchor", (Object)LookHudService.anchorWh(LookHudService.scaleInt(60, sc), LookHudService.scaleInt(60, sc)));
            builder.setObject("#BlocchioItemIcon.Anchor", (Object)LookHudService.anchorLtwH(LookHudService.scaleInt(14, sc), LookHudService.scaleInt(14, sc), LookHudService.scaleInt(32, sc), LookHudService.scaleInt(32, sc)));
            builder.setObject("#BlocchioModTagRow.Anchor", (Object)LookHudService.anchorLtrh(LookHudService.scaleInt(68, sc), 0, 0, LookHudService.scaleInt(18, sc)));
            builder.setObject("#BlocchioLookEntityHud.Anchor", (Object)LookHudService.anchorHeight(LookHudService.scaleInt(64, sc)));
            builder.setObject("#BlocchioEntityLeftCol.Anchor", (Object)LookHudService.anchorWh(LookHudService.scaleInt(60, sc), LookHudService.scaleInt(60, sc)));
            builder.setObject("#BlocchioEntityIcon.Anchor", (Object)LookHudService.anchorLtwH(LookHudService.scaleInt(14, sc), LookHudService.scaleInt(14, sc), LookHudService.scaleInt(32, sc), LookHudService.scaleInt(32, sc)));
            builder.set("#BlocchioNameLabel.Style.FontSize", LookHudService.scaleFont(16, sc));
            builder.set("#BlocchioIdLabel.Style.FontSize", LookHudService.scaleFont(12, sc));
            builder.set("#BlocchioStateLabel.Style.FontSize", LookHudService.scaleFont(12, sc));
            builder.set("#BlocchioOriginLabel.Style.FontSize", LookHudService.scaleFont(10, sc));
            builder.set("#BlocchioModFullLabel.Style.FontSize", LookHudService.scaleFont(10, sc));
            builder.set("#BlocchioEntityNameLabel.Style.FontSize", LookHudService.scaleFont(16, sc));
            builder.set("#BlocchioEntityIdLabel.Style.FontSize", LookHudService.scaleFont(12, sc));
            builder.set("#BlocchioEntityStatusLabel.Style.FontSize", LookHudService.scaleFont(12, sc));
            hud.update(false, builder);
        });
    }

    private static int scaleInt(int base, float scale) {
        return Math.max(1, Math.round((float)base * scale));
    }

    private static int scaleFont(int base, float scale) {
        return Math.max(8, Math.round((float)base * scale));
    }

    public boolean isEnabled(@Nonnull PlayerRef playerRef) {
        return this.getOrCreateSettings((UUID)playerRef.getUuid()).enabled;
    }

    public void setEnabled(@Nonnull PlayerRef playerRef, boolean enabled) {
        PlayerHudSettings s = this.getOrCreateSettings(playerRef.getUuid());
        boolean changed = s.enabled != enabled;
        s.enabled = enabled;
        this.saveSettings();
        if (!changed) {
            return;
        }
        if (enabled) {
            this.enable(playerRef);
        } else {
            this.disable(playerRef);
        }
    }

    public boolean toggleEnabled(@Nonnull PlayerRef playerRef) {
        boolean next = !this.isEnabled(playerRef);
        this.setEnabled(playerRef, next);
        return next;
    }

    private static Anchor anchorHeight(int height) {
        Anchor a = new Anchor();
        a.setHeight(Value.of((Object)height));
        return a;
    }

    private static Anchor anchorWh(int width, int height) {
        Anchor a = new Anchor();
        a.setWidth(Value.of((Object)width));
        a.setHeight(Value.of((Object)height));
        return a;
    }

    private static Anchor anchorLtrh(int left, int top, int right, int height) {
        Anchor a = new Anchor();
        a.setLeft(Value.of((Object)left));
        a.setTop(Value.of((Object)top));
        a.setRight(Value.of((Object)right));
        a.setHeight(Value.of((Object)height));
        return a;
    }

    private static Anchor anchorLtwH(int left, int top, int width, int height) {
        Anchor a = new Anchor();
        a.setLeft(Value.of((Object)left));
        a.setTop(Value.of((Object)top));
        a.setWidth(Value.of((Object)width));
        a.setHeight(Value.of((Object)height));
        return a;
    }

    private static final class PlayerHudSettings {
        private volatile boolean enabled;
        private volatile String position;
        private volatile SizePreset size;
        private volatile int blockRange;
        private volatile int entityRange;
        private volatile boolean blockHudEnabled;
        private volatile boolean entityHudEnabled;
        private volatile boolean showBlockId;
        private volatile boolean showEntityId;
        private volatile boolean showBlockOrigin;
        private volatile boolean showBlockCategory;
        private volatile boolean showEntityStatus;
        private volatile String nameColor;
        private volatile String idColor;
        private volatile String originColor;
        private volatile String categoryColor;
        private volatile boolean modTagEnabled;
        private volatile String modTagColor;
        private volatile boolean modTagBold;
        private volatile boolean modTagItalic;
        private volatile String entityNameColor;
        private volatile String entityIdColor;
        private volatile String entityStatusColor;
        private volatile boolean entityNameBold;
        private volatile boolean entityNameItalic;
        private volatile boolean entityIdBold;
        private volatile boolean entityIdItalic;
        private volatile boolean nameBold;
        private volatile boolean nameItalic;
        private volatile boolean idBold;
        private volatile boolean idItalic;

        private PlayerHudSettings(boolean enabled, String position, SizePreset size) {
            this.enabled = enabled;
            this.position = position;
            this.size = size;
            this.blockRange = 5;
            this.entityRange = 8;
            this.blockHudEnabled = true;
            this.entityHudEnabled = true;
            this.showBlockId = true;
            this.showEntityId = true;
            this.showBlockOrigin = true;
            this.showBlockCategory = true;
            this.showEntityStatus = true;
            this.nameColor = "#f8fafc";
            this.idColor = "#4de3fa";
            this.originColor = "#94a3b8";
            this.categoryColor = "#94a3b8";
            this.modTagEnabled = true;
            this.modTagColor = "#fbbf24";
            this.modTagBold = true;
            this.modTagItalic = false;
            this.entityNameColor = "#f8fafc";
            this.entityIdColor = "#4de3fa";
            this.entityStatusColor = "#e8e9eb";
            this.entityNameBold = true;
            this.entityNameItalic = false;
            this.entityIdBold = true;
            this.entityIdItalic = false;
            this.nameBold = true;
            this.nameItalic = false;
            this.idBold = true;
            this.idItalic = false;
        }
    }

    private static enum SizePreset {
        SMALL(0.9f),
        MEDIUM(1.0f),
        LARGE(1.2f);

        private final float scale;

        private SizePreset(float scale) {
            this.scale = scale;
        }
    }

    public record StyleSnapshot(@Nonnull String position, @Nonnull String size, int blockRange, int entityRange, boolean blockHudEnabled, boolean entityHudEnabled, boolean showBlockId, boolean showEntityId, boolean showBlockOrigin, boolean showBlockCategory, boolean showEntityStatus, @Nonnull String nameColor, @Nonnull String idColor, @Nonnull String originColor, @Nonnull String categoryColor, boolean modTagEnabled, @Nonnull String modTagColor, boolean modTagBold, boolean modTagItalic, @Nonnull String entityNameColor, @Nonnull String entityIdColor, @Nonnull String entityStatusColor, boolean entityNameBold, boolean entityNameItalic, boolean entityIdBold, boolean entityIdItalic, boolean nameBold, boolean nameItalic, boolean idBold, boolean idItalic) {
    }

    private static final class MultiHudCompat {
        private static final Object LOCK = new Object();
        private static volatile boolean checked;
        private static volatile boolean available;
        private static volatile Method getInstanceMethod;
        private static volatile Method setCustomHudMethod;
        private static volatile Method hideCustomHudMethod;

        private MultiHudCompat() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean isAvailable() {
            if (!checked) {
                Object object = LOCK;
                synchronized (object) {
                    if (!checked) {
                        MultiHudCompat.init();
                        checked = true;
                    }
                }
            }
            return available;
        }

        private static void init() {
            try {
                Class<?> clazz = MultiHudCompat.loadMultiHudClass();
                if (clazz == null) {
                    throw new ClassNotFoundException("com.buuz135.mhud.MultipleHUD");
                }
                getInstanceMethod = clazz.getMethod("getInstance", new Class[0]);
                setCustomHudMethod = clazz.getMethod("setCustomHud", Player.class, PlayerRef.class, String.class, CustomUIHud.class);
                hideCustomHudMethod = clazz.getMethod("hideCustomHud", Player.class, PlayerRef.class, String.class);
                available = true;
            }
            catch (Throwable ignored) {
                available = false;
                getInstanceMethod = null;
                setCustomHudMethod = null;
                hideCustomHudMethod = null;
            }
        }

        private static Class<?> loadMultiHudClass() {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    return Class.forName("com.buuz135.mhud.MultipleHUD", true, cl);
                }
            }
            catch (Throwable cl) {
                // empty catch block
            }
            try {
                PluginManager pm = PluginManager.get();
                if (pm != null && pm.getBridgeClassLoader() != null) {
                    return pm.getBridgeClassLoader().loadClass("com.buuz135.mhud.MultipleHUD");
                }
            }
            catch (Throwable pm) {
                // empty catch block
            }
            try {
                return Class.forName("com.buuz135.mhud.MultipleHUD");
            }
            catch (Throwable ignored) {
                return null;
            }
        }

        static boolean setCustomHud(@Nonnull Player player, @Nonnull PlayerRef playerRef, @Nonnull String hudId, @Nonnull LookHud hud) {
            try {
                if (!MultiHudCompat.isAvailable() || getInstanceMethod == null || setCustomHudMethod == null) {
                    return false;
                }
                Object instance = getInstanceMethod.invoke(null, new Object[0]);
                if (instance == null) {
                    return false;
                }
                setCustomHudMethod.invoke(instance, new Object[]{player, playerRef, hudId, hud});
                return true;
            }
            catch (Throwable ignored) {
                return false;
            }
        }

        static boolean hideCustomHud(@Nonnull Player player, @Nonnull PlayerRef playerRef, @Nonnull String hudId) {
            try {
                if (!MultiHudCompat.isAvailable() || getInstanceMethod == null || hideCustomHudMethod == null) {
                    return false;
                }
                Object instance = getInstanceMethod.invoke(null, new Object[0]);
                if (instance == null) {
                    return false;
                }
                hideCustomHudMethod.invoke(instance, player, playerRef, hudId);
                return true;
            }
            catch (Throwable ignored) {
                return false;
            }
        }
    }
}

