/*
 * Decompiled with CFR 0.152.
 */
package org.sureizu.plugin.hud;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.player.hud.CustomUIHud;
import com.hypixel.hytale.server.core.ui.Anchor;
import com.hypixel.hytale.server.core.ui.Value;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import javax.annotation.Nonnull;
import org.sureizu.plugin.hud.UiResources;

public final class LookHud
extends CustomUIHud {
    public static final String UI_APPEND_PATH = "Pages/LookBlockHud.ui";
    public static final String UI_DOC = UiResources.loadUtf8OrFallback(LookHud.class, "/Common/UI/Custom/Pages/LookBlockHud.ui");
    private volatile boolean attached;
    private volatile boolean blockVisible;
    private volatile boolean entityVisible;
    private volatile boolean blockHudEnabled = true;
    private volatile boolean entityHudEnabled = true;
    private volatile boolean itemIconVisible;
    private volatile String itemId = "";
    private volatile Message blockName = Message.raw((String)"");
    private volatile Message blockId = Message.raw((String)"");
    private volatile boolean metaVisible;
    private volatile Message blockState = Message.raw((String)"");
    private volatile Message blockOrigin = Message.raw((String)"");
    private volatile Message blockCategory = Message.raw((String)"");
    private volatile boolean modTagVisible;
    private volatile Message modTagText = Message.raw((String)"");
    private volatile Message entityName = Message.raw((String)"");
    private volatile Message entityId = Message.raw((String)"");
    private volatile Message entityStatus = Message.raw((String)"");
    private volatile String nameColor = "#f8fafc";
    private volatile String idColor = "#4de3fa";
    private volatile String originColor = "#94a3b8";
    private volatile String categoryColor = "#94a3b8";
    private volatile String modTagColor = "#fbbf24";
    private volatile String entityNameColor = "#f8fafc";
    private volatile String entityIdColor = "#4de3fa";
    private volatile String entityStatusColor = "#e8e9eb";
    private volatile boolean nameBold = true;
    private volatile boolean nameItalic = false;
    private volatile boolean idBold = true;
    private volatile boolean idItalic = false;
    private volatile boolean modTagBold = true;
    private volatile boolean modTagItalic = false;
    private volatile boolean showBlockName = true;
    private volatile boolean showBlockId = true;
    private volatile boolean showBlockOrigin = true;
    private volatile boolean showBlockCategory = true;
    private volatile boolean showModTag = true;
    private volatile boolean showEntityName = true;
    private volatile boolean showEntityId = true;
    private volatile boolean showEntityStatus = true;
    private volatile boolean entityNameBold = true;
    private volatile boolean entityNameItalic = false;
    private volatile boolean entityIdBold = true;
    private volatile boolean entityIdItalic = false;
    private volatile Anchor rootAnchor;
    private volatile float scale = 1.0f;
    private volatile String positionName = "default";

    public LookHud(@Nonnull PlayerRef playerRef) {
        super(playerRef);
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean attached) {
        this.attached = attached;
    }

    public void setName(@Nonnull Message name) {
        this.blockName = name;
    }

    public void setItemId(@Nonnull String itemId) {
        this.itemId = itemId;
    }

    public void setBlockVisible(boolean visible) {
        this.blockVisible = visible;
    }

    public void setEntityVisible(boolean visible) {
        this.entityVisible = visible;
    }

    public void setBlockHudEnabled(boolean enabled) {
        this.blockHudEnabled = enabled;
    }

    public boolean isBlockHudEnabled() {
        return this.blockHudEnabled;
    }

    public void setEntityHudEnabled(boolean enabled) {
        this.entityHudEnabled = enabled;
    }

    public boolean isEntityHudEnabled() {
        return this.entityHudEnabled;
    }

    public void setItemIconVisible(boolean visible) {
        this.itemIconVisible = visible;
    }

    public void setBlockId(@Nonnull Message id) {
        this.blockId = id;
    }

    public void setMetaVisible(boolean visible) {
        this.metaVisible = visible;
    }

    public void setBlockState(@Nonnull Message state) {
        this.blockState = state;
    }

    public void setBlockOrigin(@Nonnull Message origin) {
        this.blockOrigin = origin;
    }

    public void setBlockCategory(@Nonnull Message category) {
        this.blockCategory = category;
    }

    public void setModTagVisible(boolean visible) {
        this.modTagVisible = visible;
    }

    public void setModTagText(@Nonnull Message text) {
        this.modTagText = text;
    }

    public void setModTagColor(@Nonnull String color) {
        this.modTagColor = color;
    }

    public void setEntityName(@Nonnull Message name) {
        this.entityName = name;
    }

    public void setEntityId(@Nonnull Message id) {
        this.entityId = id;
    }

    public void setEntityStatus(@Nonnull Message status) {
        this.entityStatus = status;
    }

    public void setEntityNameColor(@Nonnull String color) {
        this.entityNameColor = color;
    }

    public void setEntityIdColor(@Nonnull String color) {
        this.entityIdColor = color;
    }

    public void setEntityStatusColor(@Nonnull String color) {
        this.entityStatusColor = color;
    }

    public void setEntityNameBold(boolean bold) {
        this.entityNameBold = bold;
    }

    public void setEntityNameItalic(boolean italic) {
        this.entityNameItalic = italic;
    }

    public void setEntityIdBold(boolean bold) {
        this.entityIdBold = bold;
    }

    public void setEntityIdItalic(boolean italic) {
        this.entityIdItalic = italic;
    }

    public void setNameColor(@Nonnull String color) {
        this.nameColor = color;
    }

    public void setIdColor(@Nonnull String color) {
        this.idColor = color;
    }

    public void setOriginColor(@Nonnull String color) {
        this.originColor = color;
    }

    public void setCategoryColor(@Nonnull String color) {
        this.categoryColor = color;
    }

    public void setModTagBold(boolean bold) {
        this.modTagBold = bold;
    }

    public void setModTagItalic(boolean italic) {
        this.modTagItalic = italic;
    }

    public void setShowBlockName(boolean show) {
        this.showBlockName = show;
    }

    public void setShowBlockId(boolean show) {
        this.showBlockId = show;
    }

    public boolean isShowBlockId() {
        return this.showBlockId;
    }

    public void setShowBlockOrigin(boolean show) {
        this.showBlockOrigin = show;
    }

    public boolean isShowBlockOrigin() {
        return this.showBlockOrigin;
    }

    public void setShowBlockCategory(boolean show) {
        this.showBlockCategory = show;
    }

    public boolean isShowBlockCategory() {
        return this.showBlockCategory;
    }

    public void setShowModTag(boolean show) {
        this.showModTag = show;
    }

    public boolean isShowModTag() {
        return this.showModTag;
    }

    public void setShowEntityName(boolean show) {
        this.showEntityName = show;
    }

    public void setShowEntityId(boolean show) {
        this.showEntityId = show;
    }

    public boolean isShowEntityId() {
        return this.showEntityId;
    }

    public void setShowEntityStatus(boolean show) {
        this.showEntityStatus = show;
    }

    public boolean isShowEntityStatus() {
        return this.showEntityStatus;
    }

    public void setNameBold(boolean bold) {
        this.nameBold = bold;
    }

    public void setNameItalic(boolean italic) {
        this.nameItalic = italic;
    }

    public void setIdBold(boolean bold) {
        this.idBold = bold;
    }

    public void setIdItalic(boolean italic) {
        this.idItalic = italic;
    }

    public void setRootAnchor(Anchor anchor) {
        this.rootAnchor = anchor;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    @Nonnull
    public String getPositionName() {
        return this.positionName;
    }

    public void setPositionName(@Nonnull String positionName) {
        this.positionName = positionName;
    }

    private static int scaleInt(int base, float scale) {
        return Math.max(1, Math.round((float)base * scale));
    }

    private static int scaleFont(int base, float scale) {
        return Math.max(8, Math.round((float)base * scale));
    }

    protected void build(@Nonnull UICommandBuilder commandBuilder) {
        commandBuilder.append(UI_APPEND_PATH);
        if (this.rootAnchor != null) {
            commandBuilder.setObject("#ProbeHud.Anchor", (Object)this.rootAnchor);
        }
        float s = this.scale;
        commandBuilder.setObject("#BlocchioLookBlockHud.Anchor", (Object)LookHud.anchorHeight(LookHud.scaleInt(82, s)));
        commandBuilder.setObject("#BlocchioPanel.Anchor", (Object)LookHud.anchorLtrh(0, 0, 0, LookHud.scaleInt(64, s)));
        commandBuilder.setObject("#BlocchioLeftCol.Anchor", (Object)LookHud.anchorWh(LookHud.scaleInt(60, s), LookHud.scaleInt(60, s)));
        commandBuilder.setObject("#BlocchioItemIcon.Anchor", (Object)LookHud.anchorLtwH(LookHud.scaleInt(14, s), LookHud.scaleInt(14, s), LookHud.scaleInt(32, s), LookHud.scaleInt(32, s)));
        commandBuilder.setObject("#BlocchioModTagRow.Anchor", (Object)LookHud.anchorLtrh(LookHud.scaleInt(68, s), 0, 0, LookHud.scaleInt(18, s)));
        commandBuilder.setObject("#BlocchioLookEntityHud.Anchor", (Object)LookHud.anchorHeight(LookHud.scaleInt(64, s)));
        commandBuilder.setObject("#BlocchioEntityLeftCol.Anchor", (Object)LookHud.anchorWh(LookHud.scaleInt(60, s), LookHud.scaleInt(60, s)));
        commandBuilder.setObject("#BlocchioEntityIcon.Anchor", (Object)LookHud.anchorLtwH(LookHud.scaleInt(14, s), LookHud.scaleInt(14, s), LookHud.scaleInt(32, s), LookHud.scaleInt(32, s)));
        commandBuilder.set("#BlocchioNameLabel.Style.FontSize", LookHud.scaleFont(16, s));
        commandBuilder.set("#BlocchioIdLabel.Style.FontSize", LookHud.scaleFont(12, s));
        commandBuilder.set("#BlocchioStateLabel.Style.FontSize", LookHud.scaleFont(12, s));
        commandBuilder.set("#BlocchioOriginLabel.Style.FontSize", LookHud.scaleFont(10, s));
        commandBuilder.set("#BlocchioModFullLabel.Style.FontSize", LookHud.scaleFont(10, s));
        commandBuilder.set("#BlocchioEntityNameLabel.Style.FontSize", LookHud.scaleFont(16, s));
        commandBuilder.set("#BlocchioEntityIdLabel.Style.FontSize", LookHud.scaleFont(12, s));
        commandBuilder.set("#BlocchioEntityStatusLabel.Style.FontSize", LookHud.scaleFont(12, s));
        commandBuilder.set("#BlocchioNameLabel.Style.TextColor", this.nameColor);
        commandBuilder.set("#BlocchioNameLabel.Style.RenderBold", this.nameBold);
        commandBuilder.set("#BlocchioNameLabel.Style.RenderItalics", this.nameItalic);
        commandBuilder.set("#BlocchioNameLabel.Visible", this.showBlockName);
        commandBuilder.set("#BlocchioIdLabel.Style.TextColor", this.idColor);
        commandBuilder.set("#BlocchioIdLabel.Style.RenderBold", this.idBold);
        commandBuilder.set("#BlocchioIdLabel.Style.RenderItalics", this.idItalic);
        commandBuilder.set("#BlocchioIdLabel.Visible", this.showBlockId);
        commandBuilder.set("#BlocchioOriginLabel.Style.TextColor", this.originColor);
        commandBuilder.set("#BlocchioOriginLabel.Visible", this.showBlockOrigin);
        commandBuilder.set("#BlocchioCategoryLabel.Style.TextColor", this.categoryColor);
        commandBuilder.set("#BlocchioCategoryLabel.Visible", this.showBlockCategory);
        commandBuilder.set("#BlocchioModFullLabel.Style.TextColor", this.modTagColor);
        commandBuilder.set("#BlocchioModFullLabel.Style.RenderBold", this.modTagBold);
        commandBuilder.set("#BlocchioModFullLabel.Style.RenderItalics", this.modTagItalic);
        commandBuilder.set("#BlocchioEntityNameLabel.Style.TextColor", this.entityNameColor);
        commandBuilder.set("#BlocchioEntityNameLabel.Style.RenderBold", this.entityNameBold);
        commandBuilder.set("#BlocchioEntityNameLabel.Style.RenderItalics", this.entityNameItalic);
        commandBuilder.set("#BlocchioEntityNameLabel.Visible", this.showEntityName);
        commandBuilder.set("#BlocchioEntityIdLabel.Style.TextColor", this.entityIdColor);
        commandBuilder.set("#BlocchioEntityIdLabel.Style.RenderBold", this.entityIdBold);
        commandBuilder.set("#BlocchioEntityIdLabel.Style.RenderItalics", this.entityIdItalic);
        commandBuilder.set("#BlocchioEntityIdLabel.Visible", this.showEntityId);
        commandBuilder.set("#BlocchioEntityStatusLabel.Style.TextColor", this.entityStatusColor);
        commandBuilder.set("#BlocchioEntityStatusLabel.Visible", this.showEntityStatus);
        commandBuilder.set("#BlocchioLookBlockHud.Visible", this.blockVisible && this.blockHudEnabled);
        commandBuilder.set("#BlocchioLookEntityHud.Visible", this.entityVisible && this.entityHudEnabled);
        commandBuilder.set("#BlocchioItemIcon.Visible", this.itemIconVisible);
        if (this.itemId != null && !this.itemId.isEmpty()) {
            commandBuilder.set("#BlocchioItemIcon.ItemId", this.itemId);
        }
        commandBuilder.set("#BlocchioNameLabel.TextSpans", this.blockName);
        commandBuilder.set("#BlocchioIdLabel.TextSpans", this.blockId);
        commandBuilder.set("#BlocchioMetaCol.Visible", this.metaVisible);
        commandBuilder.set("#BlocchioStateLabel.TextSpans", this.blockState);
        commandBuilder.set("#BlocchioOriginLabel.TextSpans", this.blockOrigin);
        commandBuilder.set("#BlocchioModTagRow.Visible", this.modTagVisible);
        commandBuilder.set("#BlocchioModFullLabel.TextSpans", this.modTagText);
        commandBuilder.set("#BlocchioEntityNameLabel.TextSpans", this.entityName);
        commandBuilder.set("#BlocchioEntityIdLabel.TextSpans", this.entityId);
        commandBuilder.set("#BlocchioEntityStatusLabel.TextSpans", this.entityStatus);
    }

    private static Anchor anchorHeight(int height) {
        Anchor a = new Anchor();
        a.setHeight(Value.of((Object)height));
        return a;
    }

    private static Anchor anchorWh(int width, int height) {
        Anchor a = new Anchor();
        a.setWidth(Value.of((Object)width));
        a.setHeight(Value.of((Object)height));
        return a;
    }

    private static Anchor anchorLtrh(int left, int top, int right, int height) {
        Anchor a = new Anchor();
        a.setLeft(Value.of((Object)left));
        a.setTop(Value.of((Object)top));
        a.setRight(Value.of((Object)right));
        a.setHeight(Value.of((Object)height));
        return a;
    }

    private static Anchor anchorLtwH(int left, int top, int width, int height) {
        Anchor a = new Anchor();
        a.setLeft(Value.of((Object)left));
        a.setTop(Value.of((Object)top));
        a.setWidth(Value.of((Object)width));
        a.setHeight(Value.of((Object)height));
        return a;
    }
}

