/*
 * Decompiled with CFR 0.152.
 */
package org.sureizu.plugin.gui;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.ui.Anchor;
import com.hypixel.hytale.server.core.ui.DropdownEntryInfo;
import com.hypixel.hytale.server.core.ui.LocalizableString;
import com.hypixel.hytale.server.core.ui.Value;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.sureizu.plugin.hud.LookHudService;

public class BlocchioConfigGui
extends InteractiveCustomUIPage<EditorData> {
    private final LookHudService service;
    private String position;
    private String size;
    private int blockRange;
    private int entityRange;
    private String nameColor;
    private String idColor;
    private String originColor;
    private boolean blockHudEnabled;
    private boolean entityHudEnabled;
    private boolean showBlockId;
    private boolean showEntityId;
    private boolean showBlockOrigin;
    private boolean showBlockCategory;
    private boolean showEntityStatus;
    private String categoryColor;
    private boolean modTagEnabled;
    private String modTagColor;
    private boolean modTagBold;
    private boolean modTagItalic;
    private String entityNameColor;
    private String entityIdColor;
    private String entityStatusColor;
    private boolean entityNameBold;
    private boolean entityNameItalic;
    private boolean entityIdBold;
    private boolean entityIdItalic;
    private boolean nameBold;
    private boolean nameItalic;
    private boolean idBold;
    private boolean idItalic;
    private boolean nameSectionOpen = true;
    private boolean idSectionOpen = true;
    private boolean originSectionOpen = true;
    private boolean categorySectionOpen = true;
    private boolean modTagSectionOpen = true;
    private boolean entityNameSectionOpen = true;
    private boolean entityIdSectionOpen = true;
    private boolean entityStatusSectionOpen = true;

    @Nonnull
    private static EventData livePreviewCheckboxEventData() {
        return new EventData().append("Action", "LivePreview").append("@BlockHudEnabled", "#BlockHudEnabledCheckBox.Value").append("@EntityHudEnabled", "#EntityHudEnabledCheckBox.Value").append("@ShowBlockId", "#ShowBlockIdCheckBox.Value").append("@ShowEntityId", "#ShowEntityIdCheckBox.Value").append("@ShowBlockOrigin", "#ShowBlockOriginCheckBox.Value").append("@ShowBlockCategory", "#ShowBlockCategoryCheckBox.Value").append("@ShowEntityStatus", "#ShowEntityStatusCheckBox.Value").append("@ModTagEnabled", "#ModTagEnabledCheckBox.Value").append("@ModTagBold", "#ModTagBoldRowCheckBox.Value").append("@ModTagItalic", "#ModTagItalicRowCheckBox.Value").append("@EntityNameBold", "#EntityNameBoldRowCheckBox.Value").append("@EntityNameItalic", "#EntityNameItalicRowCheckBox.Value").append("@EntityIdBold", "#EntityIdBoldRowCheckBox.Value").append("@EntityIdItalic", "#EntityIdItalicRowCheckBox.Value").append("@NameBold", "#NameBoldRowCheckBox.Value").append("@NameItalic", "#NameItalicRowCheckBox.Value").append("@IdBold", "#IdBoldRowCheckBox.Value").append("@IdItalic", "#IdItalicRowCheckBox.Value");
    }

    public BlocchioConfigGui(@Nonnull PlayerRef playerRef, @Nonnull LookHudService service) {
        super(playerRef, CustomPageLifetime.CanDismiss, EditorData.CODEC);
        this.service = service;
        LookHudService.StyleSnapshot snapshot = service.getStyleSnapshot(playerRef);
        this.position = snapshot.position();
        this.size = snapshot.size();
        this.blockRange = snapshot.blockRange();
        this.entityRange = snapshot.entityRange();
        this.blockHudEnabled = snapshot.blockHudEnabled();
        this.entityHudEnabled = snapshot.entityHudEnabled();
        this.showBlockId = snapshot.showBlockId();
        this.showEntityId = snapshot.showEntityId();
        this.showBlockOrigin = snapshot.showBlockOrigin();
        this.showBlockCategory = snapshot.showBlockCategory();
        this.showEntityStatus = snapshot.showEntityStatus();
        this.nameColor = snapshot.nameColor();
        this.idColor = snapshot.idColor();
        this.originColor = snapshot.originColor();
        this.categoryColor = snapshot.categoryColor();
        this.modTagEnabled = snapshot.modTagEnabled();
        this.modTagColor = snapshot.modTagColor();
        this.modTagBold = snapshot.modTagBold();
        this.modTagItalic = snapshot.modTagItalic();
        this.entityNameColor = snapshot.entityNameColor();
        this.entityIdColor = snapshot.entityIdColor();
        this.entityStatusColor = snapshot.entityStatusColor();
        this.entityNameBold = snapshot.entityNameBold();
        this.entityNameItalic = snapshot.entityNameItalic();
        this.entityIdBold = snapshot.entityIdBold();
        this.entityIdItalic = snapshot.entityIdItalic();
        this.nameBold = snapshot.nameBold();
        this.nameItalic = snapshot.nameItalic();
        this.idBold = snapshot.idBold();
        this.idItalic = snapshot.idItalic();
    }

    private void applyPreview(@Nonnull UICommandBuilder cmd) {
        float sc = BlocchioConfigGui.scaleForSize(this.size);
        cmd.setObject("#BlocchioLookBlockHud.Anchor", (Object)BlocchioConfigGui.anchorHeight(BlocchioConfigGui.scaleInt(82, sc)));
        cmd.setObject("#BlocchioPanel.Anchor", (Object)BlocchioConfigGui.anchorLtrh(0, 0, 0, BlocchioConfigGui.scaleInt(64, sc)));
        cmd.setObject("#BlocchioLeftCol.Anchor", (Object)BlocchioConfigGui.anchorWh(BlocchioConfigGui.scaleInt(60, sc), BlocchioConfigGui.scaleInt(60, sc)));
        cmd.setObject("#BlocchioItemIcon.Anchor", (Object)BlocchioConfigGui.anchorLtwH(BlocchioConfigGui.scaleInt(14, sc), BlocchioConfigGui.scaleInt(14, sc), BlocchioConfigGui.scaleInt(32, sc), BlocchioConfigGui.scaleInt(32, sc)));
        cmd.setObject("#BlocchioModTagRow.Anchor", (Object)BlocchioConfigGui.anchorLtrh(BlocchioConfigGui.scaleInt(68, sc), 0, 0, BlocchioConfigGui.scaleInt(18, sc)));
        cmd.setObject("#BlocchioLookEntityHud.Anchor", (Object)BlocchioConfigGui.anchorHeight(BlocchioConfigGui.scaleInt(64, sc)));
        cmd.setObject("#BlocchioEntityLeftCol.Anchor", (Object)BlocchioConfigGui.anchorWh(BlocchioConfigGui.scaleInt(60, sc), BlocchioConfigGui.scaleInt(60, sc)));
        cmd.setObject("#BlocchioEntityIcon.Anchor", (Object)BlocchioConfigGui.anchorLtwH(BlocchioConfigGui.scaleInt(14, sc), BlocchioConfigGui.scaleInt(14, sc), BlocchioConfigGui.scaleInt(32, sc), BlocchioConfigGui.scaleInt(32, sc)));
        cmd.set("#BlocchioNameLabel.Style.FontSize", BlocchioConfigGui.scaleFont(16, sc));
        cmd.set("#BlocchioIdLabel.Style.FontSize", BlocchioConfigGui.scaleFont(12, sc));
        cmd.set("#BlocchioStateLabel.Style.FontSize", BlocchioConfigGui.scaleFont(12, sc));
        cmd.set("#BlocchioOriginLabel.Style.FontSize", BlocchioConfigGui.scaleFont(10, sc));
        cmd.set("#BlocchioModFullLabel.Style.FontSize", BlocchioConfigGui.scaleFont(10, sc));
        cmd.set("#BlocchioEntityNameLabel.Style.FontSize", BlocchioConfigGui.scaleFont(16, sc));
        cmd.set("#BlocchioEntityIdLabel.Style.FontSize", BlocchioConfigGui.scaleFont(12, sc));
        cmd.set("#BlocchioEntityStatusLabel.Style.FontSize", BlocchioConfigGui.scaleFont(12, sc));
        cmd.set("#BlocchioLookBlockHud.Visible", this.blockHudEnabled);
        cmd.set("#BlocchioLookEntityHud.Visible", this.entityHudEnabled);
        cmd.set("#BlocchioItemIcon.Visible", true);
        cmd.set("#BlocchioNameLabel.Text", "Debug cat");
        cmd.set("#BlocchioIdLabel.Text", "debug_cat");
        cmd.set("#BlocchioIdLabel.Visible", this.showBlockId);
        cmd.set("#BlocchioMetaCol.Visible", true);
        cmd.set("#BlocchioStateLabel.Visible", false);
        cmd.set("#BlocchioStateLabel.Text", "");
        cmd.set("#BlocchioOriginLabel.Text", "modded");
        cmd.set("#BlocchioCategoryLabel.Text", "CAT");
        cmd.set("#BlocchioOriginLabel.Visible", this.showBlockOrigin);
        cmd.set("#BlocchioCategoryLabel.Visible", this.showBlockCategory);
        cmd.set("#BlocchioModTagRow.Visible", this.modTagEnabled);
        cmd.set("#BlocchioModFullLabel.Text", "MOD: fancy cat NYA");
        cmd.set("#BlocchioEntityNameLabel.Text", "I'm an entity :D");
        cmd.set("#BlocchioEntityIdLabel.Text", "#2031");
        cmd.set("#BlocchioEntityIdLabel.Visible", this.showEntityId);
        cmd.set("#BlocchioEntityStatusLabel.Text", "Entity");
        cmd.set("#BlocchioEntityStatusLabel.Visible", this.showEntityStatus);
        cmd.set("#BlocchioNameLabel.Style.TextColor", this.nameColor);
        cmd.set("#BlocchioNameLabel.Style.RenderBold", this.nameBold);
        cmd.set("#BlocchioNameLabel.Style.RenderItalics", this.nameItalic);
        cmd.set("#BlocchioIdLabel.Style.TextColor", this.idColor);
        cmd.set("#BlocchioIdLabel.Style.RenderBold", this.idBold);
        cmd.set("#BlocchioIdLabel.Style.RenderItalics", this.idItalic);
        cmd.set("#BlocchioOriginLabel.Style.TextColor", this.originColor);
        cmd.set("#BlocchioCategoryLabel.Style.TextColor", this.categoryColor);
        cmd.set("#BlocchioModFullLabel.Style.TextColor", this.modTagColor);
        cmd.set("#BlocchioModFullLabel.Style.RenderBold", this.modTagBold);
        cmd.set("#BlocchioModFullLabel.Style.RenderItalics", this.modTagItalic);
        cmd.set("#BlocchioEntityNameLabel.Style.TextColor", this.entityNameColor);
        cmd.set("#BlocchioEntityNameLabel.Style.RenderBold", this.entityNameBold);
        cmd.set("#BlocchioEntityNameLabel.Style.RenderItalics", this.entityNameItalic);
        cmd.set("#BlocchioEntityIdLabel.Style.TextColor", this.entityIdColor);
        cmd.set("#BlocchioEntityIdLabel.Style.RenderBold", this.entityIdBold);
        cmd.set("#BlocchioEntityIdLabel.Style.RenderItalics", this.entityIdItalic);
        cmd.set("#BlocchioEntityStatusLabel.Style.TextColor", this.entityStatusColor);
    }

    private void applySectionVisibility(@Nonnull UICommandBuilder cmd) {
        cmd.set("#NameSectionContent.Visible", this.nameSectionOpen);
        cmd.set("#IdSectionContent.Visible", this.idSectionOpen);
        cmd.set("#OriginSectionContent.Visible", this.originSectionOpen);
        cmd.set("#CategorySectionContent.Visible", this.categorySectionOpen);
        cmd.set("#ModTagSectionContent.Visible", this.modTagSectionOpen);
        cmd.set("#EntityNameSectionContent.Visible", this.entityNameSectionOpen);
        cmd.set("#EntityIdSectionContent.Visible", this.entityIdSectionOpen);
        cmd.set("#EntityStatusSectionContent.Visible", this.entityStatusSectionOpen);
        cmd.set("#NameArrowUp.Visible", this.nameSectionOpen);
        cmd.set("#NameArrowDown.Visible", !this.nameSectionOpen);
        cmd.set("#IdArrowUp.Visible", this.idSectionOpen);
        cmd.set("#IdArrowDown.Visible", !this.idSectionOpen);
        cmd.set("#OriginArrowUp.Visible", this.originSectionOpen);
        cmd.set("#OriginArrowDown.Visible", !this.originSectionOpen);
        cmd.set("#CategoryArrowUp.Visible", this.categorySectionOpen);
        cmd.set("#CategoryArrowDown.Visible", !this.categorySectionOpen);
        cmd.set("#ModTagArrowUp.Visible", this.modTagSectionOpen);
        cmd.set("#ModTagArrowDown.Visible", !this.modTagSectionOpen);
        cmd.set("#EntityNameArrowUp.Visible", this.entityNameSectionOpen);
        cmd.set("#EntityNameArrowDown.Visible", !this.entityNameSectionOpen);
        cmd.set("#EntityIdArrowUp.Visible", this.entityIdSectionOpen);
        cmd.set("#EntityIdArrowDown.Visible", !this.entityIdSectionOpen);
        cmd.set("#EntityStatusArrowUp.Visible", this.entityStatusSectionOpen);
        cmd.set("#EntityStatusArrowDown.Visible", !this.entityStatusSectionOpen);
    }

    private void applyPositionDropdown(@Nonnull UICommandBuilder cmd) {
        ObjectArrayList entries = new ObjectArrayList();
        entries.add((Object)new DropdownEntryInfo(LocalizableString.fromString((String)"Default"), "default"));
        entries.add((Object)new DropdownEntryInfo(LocalizableString.fromString((String)"Top Left"), "top_left"));
        entries.add((Object)new DropdownEntryInfo(LocalizableString.fromString((String)"Top Right"), "top_right"));
        entries.add((Object)new DropdownEntryInfo(LocalizableString.fromString((String)"Bottom Left"), "bottom_left"));
        cmd.set("#PosDropdown.Entries", (List)entries);
        cmd.set("#PosDropdown.Value", this.position);
    }

    private void applySizeDropdown(@Nonnull UICommandBuilder cmd) {
        ObjectArrayList entries = new ObjectArrayList();
        entries.add((Object)new DropdownEntryInfo(LocalizableString.fromString((String)"Small"), "small"));
        entries.add((Object)new DropdownEntryInfo(LocalizableString.fromString((String)"Medium"), "medium"));
        entries.add((Object)new DropdownEntryInfo(LocalizableString.fromString((String)"Large"), "large"));
        cmd.set("#SizeDropdown.Entries", (List)entries);
        cmd.set("#SizeDropdown.Value", this.size);
    }

    private static float scaleForSize(@Nonnull String size) {
        String s;
        switch (s = size.trim().toLowerCase()) {
            case "small": {
                return 0.9f;
            }
            case "large": {
                return 1.2f;
            }
        }
        return 1.0f;
    }

    private static int scaleInt(int base, float scale) {
        return Math.max(1, Math.round((float)base * scale));
    }

    private static int scaleFont(int base, float scale) {
        return Math.max(8, Math.round((float)base * scale));
    }

    private static Anchor anchorHeight(int height) {
        Anchor a = new Anchor();
        a.setHeight(Value.of((Object)height));
        return a;
    }

    private static Anchor anchorWh(int width, int height) {
        Anchor a = new Anchor();
        a.setWidth(Value.of((Object)width));
        a.setHeight(Value.of((Object)height));
        return a;
    }

    private static Anchor anchorLtrh(int left, int top, int right, int height) {
        Anchor a = new Anchor();
        a.setLeft(Value.of((Object)left));
        a.setTop(Value.of((Object)top));
        a.setRight(Value.of((Object)right));
        a.setHeight(Value.of((Object)height));
        return a;
    }

    private static Anchor anchorLtwH(int left, int top, int width, int height) {
        Anchor a = new Anchor();
        a.setLeft(Value.of((Object)left));
        a.setTop(Value.of((Object)top));
        a.setWidth(Value.of((Object)width));
        a.setHeight(Value.of((Object)height));
        return a;
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder cmd, @Nonnull UIEventBuilder events, @Nonnull Store<EntityStore> store) {
        cmd.append("Pages/Blocchio_Config.ui");
        cmd.set("#BlockRangeSlider.Value", this.blockRange);
        cmd.set("#EntityRangeSlider.Value", this.entityRange);
        cmd.set("#NameColorPicker.Color", this.nameColor);
        cmd.set("#IdColorPicker.Color", this.idColor);
        cmd.set("#OriginColorPicker.Color", this.originColor);
        cmd.set("#BlockHudEnabledCheckBox.Value", this.blockHudEnabled);
        cmd.set("#EntityHudEnabledCheckBox.Value", this.entityHudEnabled);
        cmd.set("#ShowBlockIdCheckBox.Value", this.showBlockId);
        cmd.set("#ShowEntityIdCheckBox.Value", this.showEntityId);
        cmd.set("#ShowBlockOriginCheckBox.Value", this.showBlockOrigin);
        cmd.set("#ShowBlockCategoryCheckBox.Value", this.showBlockCategory);
        cmd.set("#ShowEntityStatusCheckBox.Value", this.showEntityStatus);
        cmd.set("#CategoryColorPicker.Color", this.categoryColor);
        cmd.set("#ModTagEnabledCheckBox.Value", this.modTagEnabled);
        cmd.set("#ModTagColorPicker.Color", this.modTagColor);
        cmd.set("#ModTagBoldRowCheckBox.Value", this.modTagBold);
        cmd.set("#ModTagItalicRowCheckBox.Value", this.modTagItalic);
        cmd.set("#EntityNameColorPicker.Color", this.entityNameColor);
        cmd.set("#EntityNameBoldRowCheckBox.Value", this.entityNameBold);
        cmd.set("#EntityNameItalicRowCheckBox.Value", this.entityNameItalic);
        cmd.set("#EntityIdColorPicker.Color", this.entityIdColor);
        cmd.set("#EntityIdBoldRowCheckBox.Value", this.entityIdBold);
        cmd.set("#EntityIdItalicRowCheckBox.Value", this.entityIdItalic);
        cmd.set("#EntityStatusColorPicker.Color", this.entityStatusColor);
        cmd.set("#NameBoldRowCheckBox.Value", this.nameBold);
        cmd.set("#NameItalicRowCheckBox.Value", this.nameItalic);
        cmd.set("#IdBoldRowCheckBox.Value", this.idBold);
        cmd.set("#IdItalicRowCheckBox.Value", this.idItalic);
        this.applyPositionDropdown(cmd);
        this.applySizeDropdown(cmd);
        this.applyPreview(cmd);
        this.applySectionVisibility(cmd);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#CloseButton", EventData.of((String)"Action", (String)"Close"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#NameSectionToggle", EventData.of((String)"Action", (String)"ToggleName"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#IdSectionToggle", EventData.of((String)"Action", (String)"ToggleId"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#OriginSectionToggle", EventData.of((String)"Action", (String)"ToggleOrigin"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#CategorySectionToggle", EventData.of((String)"Action", (String)"ToggleCategory"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#ModTagSectionToggle", EventData.of((String)"Action", (String)"ToggleModTag"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#EntityNameSectionToggle", EventData.of((String)"Action", (String)"ToggleEntityName"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#EntityIdSectionToggle", EventData.of((String)"Action", (String)"ToggleEntityId"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#EntityStatusSectionToggle", EventData.of((String)"Action", (String)"ToggleEntityStatus"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#ApplyButton", new EventData().append("Action", "Apply").append("@Position", "#PosDropdown.Value").append("@Size", "#SizeDropdown.Value").append("@BlockRange", "#BlockRangeSlider.Value").append("@EntityRange", "#EntityRangeSlider.Value").append("@BlockHudEnabled", "#BlockHudEnabledCheckBox.Value").append("@EntityHudEnabled", "#EntityHudEnabledCheckBox.Value").append("@ShowBlockId", "#ShowBlockIdCheckBox.Value").append("@ShowEntityId", "#ShowEntityIdCheckBox.Value").append("@ShowBlockOrigin", "#ShowBlockOriginCheckBox.Value").append("@ShowBlockCategory", "#ShowBlockCategoryCheckBox.Value").append("@ShowEntityStatus", "#ShowEntityStatusCheckBox.Value").append("@NameColor", "#NameColorPicker.Color").append("@IdColor", "#IdColorPicker.Color").append("@OriginColor", "#OriginColorPicker.Color").append("@CategoryColor", "#CategoryColorPicker.Color").append("@ModTagEnabled", "#ModTagEnabledCheckBox.Value").append("@ModTagColor", "#ModTagColorPicker.Color").append("@ModTagBold", "#ModTagBoldRowCheckBox.Value").append("@ModTagItalic", "#ModTagItalicRowCheckBox.Value").append("@EntityNameColor", "#EntityNameColorPicker.Color").append("@EntityIdColor", "#EntityIdColorPicker.Color").append("@EntityStatusColor", "#EntityStatusColorPicker.Color").append("@EntityNameBold", "#EntityNameBoldRowCheckBox.Value").append("@EntityNameItalic", "#EntityNameItalicRowCheckBox.Value").append("@EntityIdBold", "#EntityIdBoldRowCheckBox.Value").append("@EntityIdItalic", "#EntityIdItalicRowCheckBox.Value").append("@NameBold", "#NameBoldRowCheckBox.Value").append("@NameItalic", "#NameItalicRowCheckBox.Value").append("@IdBold", "#IdBoldRowCheckBox.Value").append("@IdItalic", "#IdItalicRowCheckBox.Value"), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#BlockHudEnabledCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#EntityHudEnabledCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ShowBlockIdCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ShowEntityIdCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ShowBlockOriginCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ShowBlockCategoryCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ShowEntityStatusCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ModTagEnabledCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ModTagBoldRowCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ModTagItalicRowCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#EntityNameBoldRowCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#EntityNameItalicRowCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#EntityIdBoldRowCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#EntityIdItalicRowCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#NameBoldRowCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#NameItalicRowCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#IdBoldRowCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#IdItalicRowCheckBox", BlocchioConfigGui.livePreviewCheckboxEventData(), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#PosDropdown", new EventData().append("Action", "LivePreview").append("@Position", "#PosDropdown.Value"), false);
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#SizeDropdown", new EventData().append("Action", "LivePreview").append("@Size", "#SizeDropdown.Value"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#ResetButton", EventData.of((String)"Action", (String)"Reset"), false);
    }

    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull EditorData data) {
        super.handleDataEvent(ref, store, (Object)data);
        boolean changedStyle = false;
        if (data.nameColor != null) {
            this.nameColor = data.nameColor;
            changedStyle = true;
        }
        if (data.idColor != null) {
            this.idColor = data.idColor;
            changedStyle = true;
        }
        if (data.originColor != null) {
            this.originColor = data.originColor;
            changedStyle = true;
        }
        if (data.nameBold != null) {
            this.nameBold = data.nameBold;
            changedStyle = true;
        }
        if (data.nameItalic != null) {
            this.nameItalic = data.nameItalic;
            changedStyle = true;
        }
        if (data.idBold != null) {
            this.idBold = data.idBold;
            changedStyle = true;
        }
        if (data.idItalic != null) {
            this.idItalic = data.idItalic;
            changedStyle = true;
        }
        if (data.action != null) {
            if (data.action.equals("Close")) {
                this.close();
                return;
            }
            if (data.action.equals("ToggleName")) {
                this.nameSectionOpen = !this.nameSectionOpen;
                UICommandBuilder cmd = new UICommandBuilder();
                this.applySectionVisibility(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
            if (data.action.equals("ToggleId")) {
                this.idSectionOpen = !this.idSectionOpen;
                UICommandBuilder cmd = new UICommandBuilder();
                this.applySectionVisibility(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
            if (data.action.equals("ToggleOrigin")) {
                this.originSectionOpen = !this.originSectionOpen;
                UICommandBuilder cmd = new UICommandBuilder();
                this.applySectionVisibility(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
            if (data.action.equals("ToggleCategory")) {
                this.categorySectionOpen = !this.categorySectionOpen;
                UICommandBuilder cmd = new UICommandBuilder();
                this.applySectionVisibility(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
            if (data.action.equals("ToggleModTag")) {
                this.modTagSectionOpen = !this.modTagSectionOpen;
                UICommandBuilder cmd = new UICommandBuilder();
                this.applySectionVisibility(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
            if (data.action.equals("ToggleEntityName")) {
                this.entityNameSectionOpen = !this.entityNameSectionOpen;
                UICommandBuilder cmd = new UICommandBuilder();
                this.applySectionVisibility(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
            if (data.action.equals("ToggleEntityId")) {
                this.entityIdSectionOpen = !this.entityIdSectionOpen;
                UICommandBuilder cmd = new UICommandBuilder();
                this.applySectionVisibility(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
            if (data.action.equals("ToggleEntityStatus")) {
                this.entityStatusSectionOpen = !this.entityStatusSectionOpen;
                UICommandBuilder cmd = new UICommandBuilder();
                this.applySectionVisibility(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
            if (data.action.equals("Reset")) {
                this.service.resetToDefaults(this.playerRef);
                LookHudService.StyleSnapshot snapshot = this.service.getStyleSnapshot(this.playerRef);
                this.position = snapshot.position();
                this.size = snapshot.size();
                this.blockRange = snapshot.blockRange();
                this.entityRange = snapshot.entityRange();
                this.blockHudEnabled = snapshot.blockHudEnabled();
                this.entityHudEnabled = snapshot.entityHudEnabled();
                this.showBlockId = snapshot.showBlockId();
                this.showEntityId = snapshot.showEntityId();
                this.showBlockOrigin = snapshot.showBlockOrigin();
                this.showBlockCategory = snapshot.showBlockCategory();
                this.showEntityStatus = snapshot.showEntityStatus();
                this.nameColor = snapshot.nameColor();
                this.idColor = snapshot.idColor();
                this.originColor = snapshot.originColor();
                this.categoryColor = snapshot.categoryColor();
                this.modTagEnabled = snapshot.modTagEnabled();
                this.modTagColor = snapshot.modTagColor();
                this.modTagBold = snapshot.modTagBold();
                this.modTagItalic = snapshot.modTagItalic();
                this.entityNameColor = snapshot.entityNameColor();
                this.entityIdColor = snapshot.entityIdColor();
                this.entityStatusColor = snapshot.entityStatusColor();
                this.entityNameBold = snapshot.entityNameBold();
                this.entityNameItalic = snapshot.entityNameItalic();
                this.entityIdBold = snapshot.entityIdBold();
                this.entityIdItalic = snapshot.entityIdItalic();
                this.nameBold = snapshot.nameBold();
                this.nameItalic = snapshot.nameItalic();
                this.idBold = snapshot.idBold();
                this.idItalic = snapshot.idItalic();
                this.nameSectionOpen = true;
                this.idSectionOpen = true;
                this.originSectionOpen = true;
                this.categorySectionOpen = true;
                this.modTagSectionOpen = true;
                this.entityNameSectionOpen = true;
                this.entityIdSectionOpen = true;
                this.entityStatusSectionOpen = true;
                UICommandBuilder cmd = new UICommandBuilder();
                cmd.set("#BlockRangeSlider.Value", this.blockRange);
                cmd.set("#EntityRangeSlider.Value", this.entityRange);
                cmd.set("#NameColorPicker.Color", this.nameColor);
                cmd.set("#IdColorPicker.Color", this.idColor);
                cmd.set("#OriginColorPicker.Color", this.originColor);
                cmd.set("#BlockHudEnabledCheckBox.Value", this.blockHudEnabled);
                cmd.set("#EntityHudEnabledCheckBox.Value", this.entityHudEnabled);
                cmd.set("#ShowBlockIdCheckBox.Value", this.showBlockId);
                cmd.set("#ShowEntityIdCheckBox.Value", this.showEntityId);
                cmd.set("#ShowBlockOriginCheckBox.Value", this.showBlockOrigin);
                cmd.set("#ShowBlockCategoryCheckBox.Value", this.showBlockCategory);
                cmd.set("#ShowEntityStatusCheckBox.Value", this.showEntityStatus);
                cmd.set("#CategoryColorPicker.Color", this.categoryColor);
                cmd.set("#ModTagEnabledCheckBox.Value", this.modTagEnabled);
                cmd.set("#ModTagColorPicker.Color", this.modTagColor);
                cmd.set("#ModTagBoldRowCheckBox.Value", this.modTagBold);
                cmd.set("#ModTagItalicRowCheckBox.Value", this.modTagItalic);
                cmd.set("#EntityNameColorPicker.Color", this.entityNameColor);
                cmd.set("#EntityNameBoldRowCheckBox.Value", this.entityNameBold);
                cmd.set("#EntityNameItalicRowCheckBox.Value", this.entityNameItalic);
                cmd.set("#EntityIdColorPicker.Color", this.entityIdColor);
                cmd.set("#EntityIdBoldRowCheckBox.Value", this.entityIdBold);
                cmd.set("#EntityIdItalicRowCheckBox.Value", this.entityIdItalic);
                cmd.set("#EntityStatusColorPicker.Color", this.entityStatusColor);
                cmd.set("#NameBoldRowCheckBox.Value", this.nameBold);
                cmd.set("#NameItalicRowCheckBox.Value", this.nameItalic);
                cmd.set("#IdBoldRowCheckBox.Value", this.idBold);
                cmd.set("#IdItalicRowCheckBox.Value", this.idItalic);
                this.applyPositionDropdown(cmd);
                this.applySizeDropdown(cmd);
                this.applyPreview(cmd);
                this.applySectionVisibility(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
            if (data.action.equals("Apply")) {
                if (data.position != null) {
                    this.position = data.position;
                }
                if (data.size != null) {
                    this.size = data.size;
                }
                if (data.blockRange != null) {
                    this.blockRange = data.blockRange;
                }
                if (data.entityRange != null) {
                    this.entityRange = data.entityRange;
                }
                if (data.blockHudEnabled != null) {
                    this.blockHudEnabled = data.blockHudEnabled;
                }
                if (data.entityHudEnabled != null) {
                    this.entityHudEnabled = data.entityHudEnabled;
                }
                if (data.showBlockId != null) {
                    this.showBlockId = data.showBlockId;
                }
                if (data.showEntityId != null) {
                    this.showEntityId = data.showEntityId;
                }
                if (data.showBlockOrigin != null) {
                    this.showBlockOrigin = data.showBlockOrigin;
                }
                if (data.showBlockCategory != null) {
                    this.showBlockCategory = data.showBlockCategory;
                }
                if (data.showEntityStatus != null) {
                    this.showEntityStatus = data.showEntityStatus;
                }
                if (data.nameColor != null) {
                    this.nameColor = data.nameColor;
                }
                if (data.idColor != null) {
                    this.idColor = data.idColor;
                }
                if (data.originColor != null) {
                    this.originColor = data.originColor;
                }
                if (data.categoryColor != null) {
                    this.categoryColor = data.categoryColor;
                }
                if (data.modTagEnabled != null) {
                    this.modTagEnabled = data.modTagEnabled;
                }
                if (data.modTagColor != null) {
                    this.modTagColor = data.modTagColor;
                }
                if (data.modTagBold != null) {
                    this.modTagBold = data.modTagBold;
                }
                if (data.modTagItalic != null) {
                    this.modTagItalic = data.modTagItalic;
                }
                if (data.entityNameColor != null) {
                    this.entityNameColor = data.entityNameColor;
                }
                if (data.entityIdColor != null) {
                    this.entityIdColor = data.entityIdColor;
                }
                if (data.entityStatusColor != null) {
                    this.entityStatusColor = data.entityStatusColor;
                }
                if (data.entityNameBold != null) {
                    this.entityNameBold = data.entityNameBold;
                }
                if (data.entityNameItalic != null) {
                    this.entityNameItalic = data.entityNameItalic;
                }
                if (data.entityIdBold != null) {
                    this.entityIdBold = data.entityIdBold;
                }
                if (data.entityIdItalic != null) {
                    this.entityIdItalic = data.entityIdItalic;
                }
                if (data.nameBold != null) {
                    this.nameBold = data.nameBold;
                }
                if (data.nameItalic != null) {
                    this.nameItalic = data.nameItalic;
                }
                if (data.idBold != null) {
                    this.idBold = data.idBold;
                }
                if (data.idItalic != null) {
                    this.idItalic = data.idItalic;
                }
                this.service.updatePosition(this.playerRef, this.position);
                this.service.updateSizePreset(this.playerRef, this.size);
                this.service.updateBlockRange(this.playerRef, this.blockRange);
                this.service.updateEntityRange(this.playerRef, this.entityRange);
                this.service.updateBlockHudEnabled(this.playerRef, this.blockHudEnabled);
                this.service.updateEntityHudEnabled(this.playerRef, this.entityHudEnabled);
                this.service.updateShowBlockId(this.playerRef, this.showBlockId);
                this.service.updateShowEntityId(this.playerRef, this.showEntityId);
                this.service.updateShowBlockOrigin(this.playerRef, this.showBlockOrigin);
                this.service.updateShowBlockCategory(this.playerRef, this.showBlockCategory);
                this.service.updateShowEntityStatus(this.playerRef, this.showEntityStatus);
                this.service.updateTextStyle(this.playerRef, this.nameColor, this.idColor, this.originColor, this.nameBold, this.nameItalic, this.idBold, this.idItalic);
                this.service.updateBlockExtraStyle(this.playerRef, this.categoryColor);
                this.service.updateModTagStyle(this.playerRef, this.modTagEnabled, this.modTagColor, this.modTagBold, this.modTagItalic);
                this.service.updateEntityTextStyle(this.playerRef, this.entityNameColor, this.entityIdColor, this.entityStatusColor, this.entityNameBold, this.entityNameItalic, this.entityIdBold, this.entityIdItalic);
                UICommandBuilder cmd = new UICommandBuilder();
                this.applyPositionDropdown(cmd);
                this.applySizeDropdown(cmd);
                this.applyPreview(cmd);
                this.applySectionVisibility(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
            if (data.action.equals("LivePreview")) {
                if (data.position != null) {
                    this.position = data.position;
                }
                if (data.size != null) {
                    this.size = data.size;
                }
                if (data.blockHudEnabled != null) {
                    this.blockHudEnabled = data.blockHudEnabled;
                }
                if (data.entityHudEnabled != null) {
                    this.entityHudEnabled = data.entityHudEnabled;
                }
                if (data.showBlockId != null) {
                    this.showBlockId = data.showBlockId;
                }
                if (data.showEntityId != null) {
                    this.showEntityId = data.showEntityId;
                }
                if (data.showBlockOrigin != null) {
                    this.showBlockOrigin = data.showBlockOrigin;
                }
                if (data.showBlockCategory != null) {
                    this.showBlockCategory = data.showBlockCategory;
                }
                if (data.showEntityStatus != null) {
                    this.showEntityStatus = data.showEntityStatus;
                }
                if (data.modTagEnabled != null) {
                    this.modTagEnabled = data.modTagEnabled;
                }
                if (data.modTagBold != null) {
                    this.modTagBold = data.modTagBold;
                }
                if (data.modTagItalic != null) {
                    this.modTagItalic = data.modTagItalic;
                }
                if (data.entityNameBold != null) {
                    this.entityNameBold = data.entityNameBold;
                }
                if (data.entityNameItalic != null) {
                    this.entityNameItalic = data.entityNameItalic;
                }
                if (data.entityIdBold != null) {
                    this.entityIdBold = data.entityIdBold;
                }
                if (data.entityIdItalic != null) {
                    this.entityIdItalic = data.entityIdItalic;
                }
                if (data.nameBold != null) {
                    this.nameBold = data.nameBold;
                }
                if (data.nameItalic != null) {
                    this.nameItalic = data.nameItalic;
                }
                if (data.idBold != null) {
                    this.idBold = data.idBold;
                }
                if (data.idItalic != null) {
                    this.idItalic = data.idItalic;
                }
                UICommandBuilder cmd = new UICommandBuilder();
                this.applyPreview(cmd);
                this.sendUpdate(cmd, null, false);
                return;
            }
        }
    }

    public static class EditorData {
        public static final BuilderCodec<EditorData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(EditorData.class, EditorData::new).addField(new KeyedCodec("Action", (Codec)Codec.STRING), (d, s) -> {
            d.action = s;
        }, d -> d.action)).addField(new KeyedCodec("@Position", (Codec)Codec.STRING), (d, s) -> {
            d.position = s;
        }, d -> d.position)).addField(new KeyedCodec("@Size", (Codec)Codec.STRING), (d, s) -> {
            d.size = s;
        }, d -> d.size)).addField(new KeyedCodec("@BlockRange", (Codec)Codec.INTEGER), (d, v) -> {
            d.blockRange = v;
        }, d -> d.blockRange)).addField(new KeyedCodec("@EntityRange", (Codec)Codec.INTEGER), (d, v) -> {
            d.entityRange = v;
        }, d -> d.entityRange)).addField(new KeyedCodec("@BlockHudEnabled", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.blockHudEnabled = b;
        }, d -> d.blockHudEnabled)).addField(new KeyedCodec("@EntityHudEnabled", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.entityHudEnabled = b;
        }, d -> d.entityHudEnabled)).addField(new KeyedCodec("@ShowBlockId", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.showBlockId = b;
        }, d -> d.showBlockId)).addField(new KeyedCodec("@ShowEntityId", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.showEntityId = b;
        }, d -> d.showEntityId)).addField(new KeyedCodec("@ShowBlockOrigin", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.showBlockOrigin = b;
        }, d -> d.showBlockOrigin)).addField(new KeyedCodec("@ShowBlockCategory", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.showBlockCategory = b;
        }, d -> d.showBlockCategory)).addField(new KeyedCodec("@ShowEntityStatus", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.showEntityStatus = b;
        }, d -> d.showEntityStatus)).addField(new KeyedCodec("@NameColor", (Codec)Codec.STRING), (d, s) -> {
            d.nameColor = s;
        }, d -> d.nameColor)).addField(new KeyedCodec("@IdColor", (Codec)Codec.STRING), (d, s) -> {
            d.idColor = s;
        }, d -> d.idColor)).addField(new KeyedCodec("@OriginColor", (Codec)Codec.STRING), (d, s) -> {
            d.originColor = s;
        }, d -> d.originColor)).addField(new KeyedCodec("@CategoryColor", (Codec)Codec.STRING), (d, s) -> {
            d.categoryColor = s;
        }, d -> d.categoryColor)).addField(new KeyedCodec("@ModTagEnabled", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.modTagEnabled = b;
        }, d -> d.modTagEnabled)).addField(new KeyedCodec("@ModTagColor", (Codec)Codec.STRING), (d, s) -> {
            d.modTagColor = s;
        }, d -> d.modTagColor)).addField(new KeyedCodec("@ModTagBold", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.modTagBold = b;
        }, d -> d.modTagBold)).addField(new KeyedCodec("@ModTagItalic", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.modTagItalic = b;
        }, d -> d.modTagItalic)).addField(new KeyedCodec("@EntityNameColor", (Codec)Codec.STRING), (d, s) -> {
            d.entityNameColor = s;
        }, d -> d.entityNameColor)).addField(new KeyedCodec("@EntityIdColor", (Codec)Codec.STRING), (d, s) -> {
            d.entityIdColor = s;
        }, d -> d.entityIdColor)).addField(new KeyedCodec("@EntityStatusColor", (Codec)Codec.STRING), (d, s) -> {
            d.entityStatusColor = s;
        }, d -> d.entityStatusColor)).addField(new KeyedCodec("@EntityNameBold", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.entityNameBold = b;
        }, d -> d.entityNameBold)).addField(new KeyedCodec("@EntityNameItalic", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.entityNameItalic = b;
        }, d -> d.entityNameItalic)).addField(new KeyedCodec("@EntityIdBold", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.entityIdBold = b;
        }, d -> d.entityIdBold)).addField(new KeyedCodec("@EntityIdItalic", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.entityIdItalic = b;
        }, d -> d.entityIdItalic)).addField(new KeyedCodec("@NameBold", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.nameBold = b;
        }, d -> d.nameBold)).addField(new KeyedCodec("@NameItalic", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.nameItalic = b;
        }, d -> d.nameItalic)).addField(new KeyedCodec("@IdBold", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.idBold = b;
        }, d -> d.idBold)).addField(new KeyedCodec("@IdItalic", (Codec)Codec.BOOLEAN), (d, b) -> {
            d.idItalic = b;
        }, d -> d.idItalic)).build();
        public String action;
        public String position;
        public String size;
        public Integer blockRange;
        public Integer entityRange;
        public Boolean blockHudEnabled;
        public Boolean entityHudEnabled;
        public Boolean showBlockId;
        public Boolean showEntityId;
        public Boolean showBlockOrigin;
        public Boolean showBlockCategory;
        public Boolean showEntityStatus;
        public String nameColor;
        public String idColor;
        public String originColor;
        public String categoryColor;
        public Boolean modTagEnabled;
        public String modTagColor;
        public Boolean modTagBold;
        public Boolean modTagItalic;
        public String entityNameColor;
        public String entityIdColor;
        public String entityStatusColor;
        public Boolean entityNameBold;
        public Boolean entityNameItalic;
        public Boolean entityIdBold;
        public Boolean entityIdItalic;
        public Boolean nameBold;
        public Boolean nameItalic;
        public Boolean idBold;
        public Boolean idItalic;
    }
}

