/*
 * Decompiled with CFR 0.152.
 */
package org.sureizu.plugin.command;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.command.system.basecommands.CommandBase;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.sureizu.plugin.gui.BlocchioConfigGui;
import org.sureizu.plugin.hud.LookHudService;

public class BlocchioCommand
extends CommandBase {
    private final LookHudService service;
    private final boolean commandsRequirePermission;

    protected boolean canGeneratePermission() {
        return this.commandsRequirePermission;
    }

    public String getPermission() {
        return this.commandsRequirePermission ? super.getPermission() : null;
    }

    private static Message prefixed(@Nonnull Message body) {
        Message root = Message.raw((String)"");
        Message prefix = Message.raw((String)"[Blocchio] ").bold(true).color("#A78BFA");
        return root.insert(prefix).insert(body);
    }

    public BlocchioCommand(LookHudService service, boolean commandsRequirePermission) {
        super("blocchio", "Manage Blocchio HUD settings");
        this.service = service;
        this.commandsRequirePermission = commandsRequirePermission;
        this.setAllowsExtraArguments(true);
        this.addAliases(new String[]{"bloc", "bl"});
        this.addSubCommand((AbstractCommand)new OnCommand(this));
        this.addSubCommand((AbstractCommand)new OffCommand(this));
        this.addSubCommand((AbstractCommand)new ConfigCommand(this));
        this.addSubCommand((AbstractCommand)new ToggleCommand(this));
        this.addSubCommand((AbstractCommand)new PosCommand(this));
        this.addSubCommand((AbstractCommand)new SizeCommand(this));
    }

    protected void executeSync(@Nonnull CommandContext ctx) {
        String input = ctx.getInputString();
        if (input != null) {
            String lower;
            String sub;
            String[] parts;
            String normalized = input.trim();
            if (normalized.startsWith("/")) {
                normalized = normalized.substring(1);
            }
            if (!((parts = normalized.split("\\s+")).length <= 1 || (sub = parts[1].trim()).isEmpty() || (lower = sub.toLowerCase()).equals("help") || lower.equals("--help") || lower.equals("-h") || lower.equals("?"))) {
                Message unknown = Message.raw((String)"").insert(Message.raw((String)"Unknown subcommand: ").color("#fbbf24")).insert(Message.raw((String)sub).bold(true).color("#4de3fa")).insert(Message.raw((String)"\n").color("#e2e8f0"));
                ctx.sendMessage(BlocchioCommand.prefixed(unknown));
            }
        }
        Message body = Message.raw((String)"").insert(Message.raw((String)"Commands:\n").bold(true).color("#e2e8f0")).insert(Message.raw((String)"/blocchio on").color("#4de3fa")).insert(Message.raw((String)" - enable HUD\n").color("#e2e8f0")).insert(Message.raw((String)"/blocchio off").color("#4de3fa")).insert(Message.raw((String)" - disable HUD\n").color("#e2e8f0")).insert(Message.raw((String)"/blocchio config").color("#4de3fa")).insert(Message.raw((String)" - open config UI\n").color("#e2e8f0")).insert(Message.raw((String)"/blocchio pos <position>").color("#4de3fa")).insert(Message.raw((String)" - set position\n").color("#e2e8f0")).insert(Message.raw((String)"/blocchio size <small|medium|large>").color("#4de3fa")).insert(Message.raw((String)" - set size\n").color("#e2e8f0")).insert(Message.raw((String)"/blocchio toggle <on|off|toggle>").color("#94a3b8")).insert(Message.raw((String)" - advanced\n").color("#e2e8f0")).insert(Message.raw((String)"Aliases: ").color("#e2e8f0")).insert(Message.raw((String)"/bloc, /bl").bold(true).color("#4de3fa"));
        ctx.sendMessage(BlocchioCommand.prefixed(body));
    }

    private class OnCommand
    extends PublicCommandBase {
        final /* synthetic */ BlocchioCommand this$0;

        private OnCommand(BlocchioCommand blocchioCommand) {
            BlocchioCommand blocchioCommand2 = blocchioCommand;
            Objects.requireNonNull(blocchioCommand2);
            this.this$0 = blocchioCommand2;
            super(blocchioCommand.commandsRequirePermission, "on", "Enable Blocchio HUD");
        }

        protected void executeSync(@Nonnull CommandContext ctx) {
            CommandSender commandSender = ctx.sender();
            if (!(commandSender instanceof Player)) {
                ctx.sendMessage(BlocchioCommand.prefixed(Message.raw((String)"This command can only be executed by a player.").color("#e2e8f0")));
                return;
            }
            Player sender = (Player)commandSender;
            this.this$0.service.setEnabled(sender.getPlayerRef(), true);
            Message body = Message.raw((String)"").insert(Message.raw((String)"HUD is now ").color("#e2e8f0")).insert(Message.raw((String)"ON").bold(true).color("#22c55e"));
            ctx.sendMessage(BlocchioCommand.prefixed(body));
        }
    }

    private class OffCommand
    extends PublicCommandBase {
        final /* synthetic */ BlocchioCommand this$0;

        private OffCommand(BlocchioCommand blocchioCommand) {
            BlocchioCommand blocchioCommand2 = blocchioCommand;
            Objects.requireNonNull(blocchioCommand2);
            this.this$0 = blocchioCommand2;
            super(blocchioCommand.commandsRequirePermission, "off", "Disable Blocchio HUD");
        }

        protected void executeSync(@Nonnull CommandContext ctx) {
            CommandSender commandSender = ctx.sender();
            if (!(commandSender instanceof Player)) {
                ctx.sendMessage(BlocchioCommand.prefixed(Message.raw((String)"This command can only be executed by a player.").color("#e2e8f0")));
                return;
            }
            Player sender = (Player)commandSender;
            this.this$0.service.setEnabled(sender.getPlayerRef(), false);
            Message body = Message.raw((String)"").insert(Message.raw((String)"HUD is now ").color("#e2e8f0")).insert(Message.raw((String)"OFF").bold(true).color("#f87171"));
            ctx.sendMessage(BlocchioCommand.prefixed(body));
        }
    }

    private class ConfigCommand
    extends PublicPlayerCommand {
        final /* synthetic */ BlocchioCommand this$0;

        private ConfigCommand(BlocchioCommand blocchioCommand) {
            BlocchioCommand blocchioCommand2 = blocchioCommand;
            Objects.requireNonNull(blocchioCommand2);
            this.this$0 = blocchioCommand2;
            super(blocchioCommand.commandsRequirePermission, "config", "Open Blocchio configuration UI");
        }

        protected void execute(@Nonnull CommandContext context, @Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull PlayerRef playerRef, @Nonnull World world) {
            Player player = (Player)store.getComponent(ref, Player.getComponentType());
            if (player == null) {
                return;
            }
            player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new BlocchioConfigGui(playerRef, this.this$0.service));
        }
    }

    private class ToggleCommand
    extends PublicCommandBase {
        private final RequiredArg<String> modeArg;
        private static final String TOGGLE_HELP = "on, off, toggle";
        private static final String TOGGLE_EXAMPLE = "/blocchio toggle off";
        final /* synthetic */ BlocchioCommand this$0;

        private ToggleCommand(BlocchioCommand blocchioCommand) {
            BlocchioCommand blocchioCommand2 = blocchioCommand;
            Objects.requireNonNull(blocchioCommand2);
            this.this$0 = blocchioCommand2;
            super(blocchioCommand.commandsRequirePermission, "toggle", "Enable/disable Blocchio HUD");
            this.modeArg = this.withRequiredArg("mode", "HUD toggle. Options: on, off, toggle. Example: /blocchio toggle off", (ArgumentType)ArgTypes.STRING);
            this.addUsageVariant((AbstractCommand)new ToggleUsageVariant(this));
        }

        protected void executeSync(@Nonnull CommandContext ctx) {
            boolean enabled;
            String normalized;
            CommandSender commandSender = ctx.sender();
            if (!(commandSender instanceof Player)) {
                ctx.sendMessage(BlocchioCommand.prefixed(Message.raw((String)"This command can only be executed by a player.").color("#e2e8f0")));
                return;
            }
            Player sender = (Player)commandSender;
            String mode = (String)this.modeArg.get(ctx);
            switch (normalized = mode == null ? "" : mode.trim().toLowerCase()) {
                case "on": {
                    this.this$0.service.setEnabled(sender.getPlayerRef(), true);
                    enabled = true;
                    break;
                }
                case "off": {
                    this.this$0.service.setEnabled(sender.getPlayerRef(), false);
                    enabled = false;
                    break;
                }
                case "toggle": {
                    enabled = this.this$0.service.toggleEnabled(sender.getPlayerRef());
                    break;
                }
                default: {
                    Message body = Message.raw((String)"").insert(Message.raw((String)"Invalid toggle option. Use: ").color("#fbbf24")).insert(Message.raw((String)TOGGLE_HELP).bold(true).color("#4de3fa"));
                    ctx.sendMessage(BlocchioCommand.prefixed(body));
                    return;
                }
            }
            Message body = Message.raw((String)"").insert(Message.raw((String)"HUD is now ").color("#e2e8f0")).insert(Message.raw((String)(enabled ? "ON" : "OFF")).bold(true).color(enabled ? "#22c55e" : "#f87171"));
            ctx.sendMessage(BlocchioCommand.prefixed(body));
        }

        private class ToggleUsageVariant
        extends PublicCommandBase {
            private ToggleUsageVariant(ToggleCommand toggleCommand) {
                Objects.requireNonNull(toggleCommand);
                super(toggleCommand.this$0.commandsRequirePermission, "Show usage for /blocchio toggle");
            }

            protected void executeSync(@Nonnull CommandContext ctx) {
                Message body = Message.raw((String)"").insert(Message.raw((String)"Usage: ").color("#e2e8f0")).insert(Message.raw((String)ToggleCommand.TOGGLE_EXAMPLE).bold(true).color("#4de3fa")).insert("\n").insert(Message.raw((String)"Options: ").color("#e2e8f0")).insert(Message.raw((String)ToggleCommand.TOGGLE_HELP).bold(true).color("#4de3fa"));
                ctx.sendMessage(BlocchioCommand.prefixed(body));
            }
        }
    }

    private class PosCommand
    extends PublicCommandBase {
        private final RequiredArg<String> positionArg;
        private static final String POS_HELP = "default, top_left, top_right, bottom_left";
        private static final String POS_EXAMPLE = "/blocchio pos top_right";
        final /* synthetic */ BlocchioCommand this$0;

        private PosCommand(BlocchioCommand blocchioCommand) {
            BlocchioCommand blocchioCommand2 = blocchioCommand;
            Objects.requireNonNull(blocchioCommand2);
            this.this$0 = blocchioCommand2;
            super(blocchioCommand.commandsRequirePermission, "pos", "Change HUD position");
            this.positionArg = this.withRequiredArg("position", "HUD position. Options: default, top_left, top_right, bottom_left. Example: /blocchio pos top_right", (ArgumentType)ArgTypes.STRING);
            this.addUsageVariant((AbstractCommand)new PosUsageVariant(this));
        }

        protected void executeSync(@Nonnull CommandContext ctx) {
            String normalized;
            CommandSender commandSender = ctx.sender();
            if (!(commandSender instanceof Player)) {
                ctx.sendMessage(BlocchioCommand.prefixed(Message.raw((String)"This command can only be executed by a player.").color("#e2e8f0")));
                return;
            }
            Player sender = (Player)commandSender;
            String pos = (String)this.positionArg.get(ctx);
            switch (normalized = pos == null ? "" : pos.trim().toLowerCase()) {
                case "default": 
                case "top_left": 
                case "top_right": 
                case "bottom_left": {
                    break;
                }
                default: {
                    Message body = Message.raw((String)"").insert(Message.raw((String)"Invalid position. Use: ").color("#fbbf24")).insert(Message.raw((String)POS_HELP).bold(true).color("#4de3fa"));
                    ctx.sendMessage(BlocchioCommand.prefixed(body));
                    return;
                }
            }
            this.this$0.service.updatePosition(sender.getPlayerRef(), pos);
            Message body = Message.raw((String)"").insert(Message.raw((String)"Position updated to: ").color("#e2e8f0")).insert(Message.raw((String)normalized).bold(true).color("#4de3fa"));
            ctx.sendMessage(BlocchioCommand.prefixed(body));
        }

        private class PosUsageVariant
        extends PublicCommandBase {
            private PosUsageVariant(PosCommand posCommand) {
                Objects.requireNonNull(posCommand);
                super(posCommand.this$0.commandsRequirePermission, "Show usage for /blocchio pos");
            }

            protected void executeSync(@Nonnull CommandContext ctx) {
                Message body = Message.raw((String)"").insert(Message.raw((String)"Usage: ").color("#e2e8f0")).insert(Message.raw((String)PosCommand.POS_EXAMPLE).bold(true).color("#4de3fa")).insert("\n").insert(Message.raw((String)"Options: ").color("#e2e8f0")).insert(Message.raw((String)PosCommand.POS_HELP).bold(true).color("#4de3fa"));
                ctx.sendMessage(BlocchioCommand.prefixed(body));
            }
        }
    }

    private class SizeCommand
    extends PublicCommandBase {
        private final RequiredArg<String> sizeArg;
        private static final String SIZE_HELP = "small, medium, large";
        private static final String SIZE_EXAMPLE = "/blocchio size medium";
        final /* synthetic */ BlocchioCommand this$0;

        private SizeCommand(BlocchioCommand blocchioCommand) {
            BlocchioCommand blocchioCommand2 = blocchioCommand;
            Objects.requireNonNull(blocchioCommand2);
            this.this$0 = blocchioCommand2;
            super(blocchioCommand.commandsRequirePermission, "size", "Change HUD size preset");
            this.sizeArg = this.withRequiredArg("preset", "HUD size preset. Options: small, medium, large. Example: /blocchio size large", (ArgumentType)ArgTypes.STRING);
            this.addUsageVariant((AbstractCommand)new SizeUsageVariant(this));
        }

        protected void executeSync(@Nonnull CommandContext ctx) {
            String normalized;
            CommandSender commandSender = ctx.sender();
            if (!(commandSender instanceof Player)) {
                ctx.sendMessage(BlocchioCommand.prefixed(Message.raw((String)"This command can only be executed by a player.").color("#e2e8f0")));
                return;
            }
            Player sender = (Player)commandSender;
            String preset = (String)this.sizeArg.get(ctx);
            switch (normalized = preset == null ? "" : preset.trim().toLowerCase()) {
                case "small": 
                case "medium": 
                case "large": {
                    break;
                }
                default: {
                    Message body = Message.raw((String)"").insert(Message.raw((String)"Invalid size. Use: ").color("#fbbf24")).insert(Message.raw((String)SIZE_HELP).bold(true).color("#4de3fa"));
                    ctx.sendMessage(BlocchioCommand.prefixed(body));
                    return;
                }
            }
            this.this$0.service.updateSizePreset(sender.getPlayerRef(), normalized);
            Message body = Message.raw((String)"").insert(Message.raw((String)"Size updated to: ").color("#e2e8f0")).insert(Message.raw((String)normalized).bold(true).color("#4de3fa"));
            ctx.sendMessage(BlocchioCommand.prefixed(body));
        }

        private class SizeUsageVariant
        extends PublicCommandBase {
            private SizeUsageVariant(SizeCommand sizeCommand) {
                Objects.requireNonNull(sizeCommand);
                super(sizeCommand.this$0.commandsRequirePermission, "Show usage for /blocchio size");
            }

            protected void executeSync(@Nonnull CommandContext ctx) {
                Message body = Message.raw((String)"").insert(Message.raw((String)"Usage: ").color("#e2e8f0")).insert(Message.raw((String)SizeCommand.SIZE_EXAMPLE).bold(true).color("#4de3fa")).insert("\n").insert(Message.raw((String)"Options: ").color("#e2e8f0")).insert(Message.raw((String)SizeCommand.SIZE_HELP).bold(true).color("#4de3fa"));
                ctx.sendMessage(BlocchioCommand.prefixed(body));
            }
        }
    }

    private static abstract class PublicPlayerCommand
    extends AbstractPlayerCommand {
        private final boolean commandsRequirePermission;

        protected PublicPlayerCommand(boolean commandsRequirePermission, @Nonnull String name, @Nonnull String description) {
            super(name, description);
            this.commandsRequirePermission = commandsRequirePermission;
        }

        protected PublicPlayerCommand(@Nonnull String name, @Nonnull String description) {
            super(name, description);
            this.commandsRequirePermission = false;
        }

        protected boolean canGeneratePermission() {
            return this.commandsRequirePermission;
        }

        public String getPermission() {
            return this.commandsRequirePermission ? super.getPermission() : null;
        }
    }

    private static abstract class PublicCommandBase
    extends CommandBase {
        private final boolean commandsRequirePermission;

        protected PublicCommandBase(boolean commandsRequirePermission, @Nonnull String name, @Nonnull String description) {
            super(name, description);
            this.commandsRequirePermission = commandsRequirePermission;
        }

        protected PublicCommandBase(boolean commandsRequirePermission, @Nonnull String description) {
            super(description);
            this.commandsRequirePermission = commandsRequirePermission;
        }

        protected PublicCommandBase(@Nonnull String name, @Nonnull String description) {
            super(name, description);
            this.commandsRequirePermission = false;
        }

        protected PublicCommandBase(@Nonnull String description) {
            super(description);
            this.commandsRequirePermission = false;
        }

        protected boolean canGeneratePermission() {
            return this.commandsRequirePermission;
        }

        public String getPermission() {
            return this.commandsRequirePermission ? super.getPermission() : null;
        }
    }
}

