/*
 * Decompiled with CFR 0.152.
 */
package org.sureizu.plugin;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.event.events.player.PlayerConnectEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerDisconnectEvent;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.sureizu.plugin.command.BlocchioCommand;
import org.sureizu.plugin.hud.LookHudService;

public class Blocchio
extends JavaPlugin {
    private static final HytaleLogger LOGGER = HytaleLogger.forEnclosingClass();
    private static final boolean AUTO_ENABLE_LOOK_HUD = true;
    private static final String CONFIG_FILE = "config.properties";
    private final LookHudService lookHudService = new LookHudService(this.getDataDirectory());
    private volatile boolean commandsRequirePermission;

    public Blocchio(@Nonnull JavaPluginInit init) {
        super(init);
    }

    private void loadConfig() {
        try {
            String v;
            Path dir = this.getDataDirectory();
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            Path configPath = dir.resolve(CONFIG_FILE);
            Properties props = new Properties();
            if (Files.exists(configPath, new LinkOption[0])) {
                try (InputStream in = Files.newInputStream(configPath, new OpenOption[0]);){
                    props.load(in);
                }
            }
            this.commandsRequirePermission = (v = props.getProperty("commands.require_permission", "false").trim()).equalsIgnoreCase("true") || v.equalsIgnoreCase("1") || v.equalsIgnoreCase("yes");
            props.setProperty("commands.require_permission", String.valueOf(this.commandsRequirePermission));
            try (OutputStream out = Files.newOutputStream(configPath, new OpenOption[0]);){
                props.store(out, "Blocchio plugin configuration");
            }
        }
        catch (Throwable t) {
            ((HytaleLogger.Api)LOGGER.at(Level.WARNING).withCause(t)).log("Failed to load Blocchio config");
            this.commandsRequirePermission = false;
        }
    }

    protected void setup() {
        ((HytaleLogger.Api)LOGGER.atInfo()).log("Setting up plugin " + this.getName());
        this.loadConfig();
        this.getCommandRegistry().registerCommand((AbstractCommand)new BlocchioCommand(this.lookHudService, this.commandsRequirePermission));
        this.getEventRegistry().register(PlayerConnectEvent.class, event -> this.enableLookHud(event.getPlayerRef()));
        this.getEventRegistry().register(PlayerDisconnectEvent.class, event -> this.disableLookHud(event.getPlayerRef()));
        HytaleServer.SCHEDULED_EXECUTOR.schedule(() -> {
            Universe universe = Universe.get();
            if (universe == null) {
                return;
            }
            for (PlayerRef ref : universe.getPlayers()) {
                if (ref == null) continue;
                this.enableLookHud(ref);
            }
        }, 3L, TimeUnit.SECONDS);
    }

    private void enableLookHud(@Nonnull PlayerRef playerRef) {
        this.lookHudService.enable(playerRef);
    }

    private void disableLookHud(@Nonnull PlayerRef playerRef) {
        this.lookHudService.disable(playerRef);
    }
}

