/*
 * Decompiled with CFR 0.152.
 */
package com.inkblindcat.multitools.event;

import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.EntityEventSystem;
import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.protocol.BlockPosition;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.ecs.UseBlockEvent;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.hypixel.hytale.server.core.universe.world.meta.BlockState;
import com.hypixel.hytale.server.core.universe.world.meta.state.ItemContainerState;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.TargetUtil;
import com.inkblindcat.multitools.util.MultitoolMigrationUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContainerMigrationSystem
extends EntityEventSystem<EntityStore, UseBlockEvent.Pre> {
    public ContainerMigrationSystem() {
        super(UseBlockEvent.Pre.class);
    }

    public void handle(int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer, @Nonnull UseBlockEvent.Pre pre) {
        Vector3i targetBlockPos;
        WorldChunk chunk;
        Ref ref = archetypeChunk.getReferenceTo(index);
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        TransformComponent transform = (TransformComponent)archetypeChunk.getComponent(index, TransformComponent.getComponentType());
        if (transform != null && (chunk = transform.getChunk()) != null && (targetBlockPos = TargetUtil.getTargetBlock((Ref)archetypeChunk.getReferenceTo(index), (double)5.0, commandBuffer)) != null) {
            BlockPosition pos = player.getWorld().getBaseBlock(new BlockPosition(targetBlockPos.x, targetBlockPos.y, targetBlockPos.z));
            BlockState state = chunk.getState(pos.x, pos.y, pos.z);
            if (state instanceof ItemContainerState) {
                ItemContainerState containerState = (ItemContainerState)state;
                MultitoolMigrationUtil.migrateContainer(containerState.getItemContainer(), "Tool_Multitool_", "Tool_Hatchet_Pickaxe_Multitool_");
            }
        }
    }

    @Nullable
    public Query<EntityStore> getQuery() {
        return PlayerRef.getComponentType();
    }
}

