/*
 * Decompiled with CFR 0.152.
 */
package com.rootapp.quicksleep.i18n;

import com.rootapp.quicksleep.QuickSleepPlugin;
import com.rootapp.quicksleep.shadow.snakeyaml.Yaml;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\nH\u0002J2\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u000b2\b\b\u0002\u0010\u0019\u001a\u00020\nH\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002J?\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2*\u0010\u001d\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u001f0\u001e\"\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u001f\u00a2\u0006\u0002\u0010 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010%\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/rootapp/quicksleep/i18n/LanguageManager;", "", "plugin", "Lcom/rootapp/quicksleep/QuickSleepPlugin;", "<init>", "(Lcom/rootapp/quicksleep/QuickSleepPlugin;)V", "yaml", "Lcom/rootapp/quicksleep/shadow/snakeyaml/Yaml;", "loadedLanguages", "", "", "", "availableLanguages", "", "setupLangFolder", "", "copyResourceToFile", "resourcePath", "targetFile", "Ljava/io/File;", "scanAvailableLanguages", "loadLanguage", "langCode", "flattenYaml", "map", "prefix", "getLangFolder", "get", "key", "replacements", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "getAvailableLanguages", "", "isLanguageAvailable", "", "reload", "SleepVote-Hytale"})
@SourceDebugExtension(value={"SMAP\nLanguageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageManager.kt\ncom/rootapp/quicksleep/i18n/LanguageManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,202:1\n1863#2,2:203\n1863#2,2:208\n3829#3:205\n4344#3,2:206\n*S KotlinDebug\n*F\n+ 1 LanguageManager.kt\ncom/rootapp/quicksleep/i18n/LanguageManager\n*L\n52#1:203,2\n82#1:208,2\n82#1:205\n82#1:206,2\n*E\n"})
public final class LanguageManager {
    @NotNull
    private final QuickSleepPlugin plugin;
    @NotNull
    private final Yaml yaml;
    @NotNull
    private final Map<String, Map<String, String>> loadedLanguages;
    @NotNull
    private final Set<String> availableLanguages;

    public LanguageManager(@NotNull QuickSleepPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.yaml = new Yaml();
        this.loadedLanguages = new LinkedHashMap();
        this.availableLanguages = new LinkedHashSet();
        this.setupLangFolder();
        this.scanAvailableLanguages();
        this.loadLanguage(this.plugin.getPluginConfig().getLanguage());
    }

    private final void setupLangFolder() {
        File langFolder = this.getLangFolder();
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        String[] stringArray = new String[]{"en", "es", "zh", "hi", "ar", "pt", "ru", "ja", "de", "fr", "ko", "it", "tr", "vi", "pl", "nl", "th", "id", "uk", "sv", "cs", "el", "da"};
        Iterable $this$forEach$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String lang = (String)element$iv;
            boolean bl = false;
            File langFile = new File(langFolder, lang + ".yml");
            if (langFile.exists()) continue;
            this.copyResourceToFile("lang/" + lang + ".yml", langFile);
        }
    }

    private final void copyResourceToFile(String resourcePath, File targetFile) {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
            if (inputStream != null) {
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                Reader reader = new InputStreamReader(inputStream2, charset);
                int n = 8192;
                FilesKt.writeText$default(targetFile, TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), null, 2, null);
                this.plugin.getLogger().at(Level.INFO).log("Created default language file: %s", (Object)targetFile.getName());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().at(Level.WARNING).log("Failed to copy default language file %s: %s", (Object)resourcePath, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void scanAvailableLanguages() {
        this.availableLanguages.clear();
        File langFolder = this.getLangFolder();
        File[] fileArray = langFolder.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!Intrinsics.areEqual(FilesKt.getExtension((File)it), "yml")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(file);
                this.availableLanguages.add(FilesKt.getNameWithoutExtension(file));
            }
        }
        this.plugin.getLogger().at(Level.INFO).log("Available languages: %s", (Object)CollectionsKt.joinToString$default(this.availableLanguages, ", ", null, null, 0, null, null, 62, null));
    }

    private final void loadLanguage(String langCode) {
        if (this.loadedLanguages.containsKey(langCode)) {
            return;
        }
        File langFile = new File(this.getLangFolder(), langCode + ".yml");
        if (langFile.exists()) {
            try {
                Map map = (Map)this.yaml.load(FilesKt.readText$default(langFile, null, 1, null));
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                Map yamlContent = map;
                Map flatMap2 = LanguageManager.flattenYaml$default(this, yamlContent, null, 2, null);
                this.loadedLanguages.put(langCode, flatMap2);
                this.plugin.getLogger().at(Level.INFO).log("Loaded language file: %s (%d keys)", (Object)langCode, flatMap2.size());
            }
            catch (Exception e) {
                this.plugin.getLogger().at(Level.WARNING).log("Failed to load language file %s: %s", (Object)langCode, (Object)e.getMessage());
            }
        } else {
            this.plugin.getLogger().at(Level.WARNING).log("Language file not found: %s.yml", (Object)langCode);
        }
        if (!Intrinsics.areEqual(langCode, "en") && !this.loadedLanguages.containsKey("en")) {
            this.loadLanguage("en");
        }
    }

    private final Map<String, String> flattenYaml(Map<String, ? extends Object> map, String prefix) {
        Map result = new LinkedHashMap();
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String fullKey = ((CharSequence)prefix).length() == 0 ? key : prefix + "." + key;
            Object object = value;
            if (object instanceof String) {
                result.put(fullKey, value);
                continue;
            }
            if (object instanceof Map) {
                Object object2 = value;
                Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                result.putAll(this.flattenYaml((Map)object2, fullKey));
                continue;
            }
            result.put(fullKey, value.toString());
        }
        return result;
    }

    static /* synthetic */ Map flattenYaml$default(LanguageManager languageManager, Map map, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return languageManager.flattenYaml(map, string);
    }

    private final File getLangFolder() {
        return new File("mods/QuickSleep/lang");
    }

    @NotNull
    public final String get(@NotNull String key, Pair<String, ? extends Object> ... replacements) {
        Object template;
        Object object;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(replacements, "replacements");
        String currentLang = this.plugin.getPluginConfig().getLanguage();
        if (!this.loadedLanguages.containsKey(currentLang)) {
            this.loadLanguage(currentLang);
        }
        if ((object = this.loadedLanguages.get(currentLang)) == null || (object = object.get(key)) == null) {
            Map<String, String> map = this.loadedLanguages.get("en");
            object = map != null ? map.get(key) : null;
            if (object == null) {
                object = key;
            }
        }
        Object result = template = object;
        for (Pair<String, ? extends Object> pair : replacements) {
            String placeholder = pair.component1();
            Object value = pair.component2();
            result = StringsKt.replace$default((String)result, "%" + placeholder + "%", value.toString(), false, 4, null);
        }
        return result;
    }

    @NotNull
    public final Set<String> getAvailableLanguages() {
        return CollectionsKt.toSet((Iterable)this.availableLanguages);
    }

    public final boolean isLanguageAvailable(@NotNull String langCode) {
        Intrinsics.checkNotNullParameter(langCode, "langCode");
        return this.availableLanguages.contains(langCode);
    }

    public final void reload() {
        this.loadedLanguages.clear();
        this.scanAvailableLanguages();
        this.loadLanguage(this.plugin.getPluginConfig().getLanguage());
    }
}

