/*
 * Decompiled with CFR 0.152.
 */
package com.rootapp.quicksleep.config;

import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.rootapp.quicksleep.shadow.gson.Gson;
import com.rootapp.quicksleep.shadow.gson.GsonBuilder;
import java.io.File;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\b\u0018\u0000 -2\u00020\u0001:\u0001-BM\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\t\u0010&\u001a\u00020\fH\u00c6\u0003J\t\u0010'\u001a\u00020\fH\u00c6\u0003JO\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\fH\u00d6\u0001J\t\u0010,\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006."}, d2={"Lcom/rootapp/quicksleep/config/PluginConfig;", "", "sleepPercentage", "", "skipDelayMs", "", "broadcastMessages", "", "excludeSpectators", "language", "", "nightStartHour", "", "nightStartMinute", "<init>", "(DJZZLjava/lang/String;II)V", "getSleepPercentage", "()D", "getSkipDelayMs", "()J", "getBroadcastMessages", "()Z", "getExcludeSpectators", "getLanguage", "()Ljava/lang/String;", "getNightStartHour", "()I", "getNightStartMinute", "save", "", "plugin", "Lcom/hypixel/hytale/server/core/plugin/JavaPlugin;", "getClampedSleepPercentage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "Companion", "SleepVote-Hytale"})
public final class PluginConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double sleepPercentage;
    private final long skipDelayMs;
    private final boolean broadcastMessages;
    private final boolean excludeSpectators;
    @NotNull
    private final String language;
    private final int nightStartHour;
    private final int nightStartMinute;
    @NotNull
    private static final Gson gson;

    public PluginConfig(double sleepPercentage, long skipDelayMs, boolean broadcastMessages, boolean excludeSpectators, @NotNull String language, int nightStartHour, int nightStartMinute) {
        Intrinsics.checkNotNullParameter(language, "language");
        this.sleepPercentage = sleepPercentage;
        this.skipDelayMs = skipDelayMs;
        this.broadcastMessages = broadcastMessages;
        this.excludeSpectators = excludeSpectators;
        this.language = language;
        this.nightStartHour = nightStartHour;
        this.nightStartMinute = nightStartMinute;
    }

    public /* synthetic */ PluginConfig(double d, long l, boolean bl, boolean bl2, String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            d = 0.5;
        }
        if ((n3 & 2) != 0) {
            l = 500L;
        }
        if ((n3 & 4) != 0) {
            bl = true;
        }
        if ((n3 & 8) != 0) {
            bl2 = true;
        }
        if ((n3 & 0x10) != 0) {
            string = "en";
        }
        if ((n3 & 0x20) != 0) {
            n = 19;
        }
        if ((n3 & 0x40) != 0) {
            n2 = 30;
        }
        this(d, l, bl, bl2, string, n, n2);
    }

    public final double getSleepPercentage() {
        return this.sleepPercentage;
    }

    public final long getSkipDelayMs() {
        return this.skipDelayMs;
    }

    public final boolean getBroadcastMessages() {
        return this.broadcastMessages;
    }

    public final boolean getExcludeSpectators() {
        return this.excludeSpectators;
    }

    @NotNull
    public final String getLanguage() {
        return this.language;
    }

    public final int getNightStartHour() {
        return this.nightStartHour;
    }

    public final int getNightStartMinute() {
        return this.nightStartMinute;
    }

    public final void save(@NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        File configFile = PluginConfig.Companion.getConfigFile(plugin);
        String string = gson.toJson(this);
        Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
        FilesKt.writeText$default(configFile, string, null, 2, null);
    }

    public final double getClampedSleepPercentage() {
        return RangesKt.coerceIn(this.sleepPercentage, 0.0, 1.0);
    }

    public final double component1() {
        return this.sleepPercentage;
    }

    public final long component2() {
        return this.skipDelayMs;
    }

    public final boolean component3() {
        return this.broadcastMessages;
    }

    public final boolean component4() {
        return this.excludeSpectators;
    }

    @NotNull
    public final String component5() {
        return this.language;
    }

    public final int component6() {
        return this.nightStartHour;
    }

    public final int component7() {
        return this.nightStartMinute;
    }

    @NotNull
    public final PluginConfig copy(double sleepPercentage, long skipDelayMs, boolean broadcastMessages, boolean excludeSpectators, @NotNull String language, int nightStartHour, int nightStartMinute) {
        Intrinsics.checkNotNullParameter(language, "language");
        return new PluginConfig(sleepPercentage, skipDelayMs, broadcastMessages, excludeSpectators, language, nightStartHour, nightStartMinute);
    }

    public static /* synthetic */ PluginConfig copy$default(PluginConfig pluginConfig, double d, long l, boolean bl, boolean bl2, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            d = pluginConfig.sleepPercentage;
        }
        if ((n3 & 2) != 0) {
            l = pluginConfig.skipDelayMs;
        }
        if ((n3 & 4) != 0) {
            bl = pluginConfig.broadcastMessages;
        }
        if ((n3 & 8) != 0) {
            bl2 = pluginConfig.excludeSpectators;
        }
        if ((n3 & 0x10) != 0) {
            string = pluginConfig.language;
        }
        if ((n3 & 0x20) != 0) {
            n = pluginConfig.nightStartHour;
        }
        if ((n3 & 0x40) != 0) {
            n2 = pluginConfig.nightStartMinute;
        }
        return pluginConfig.copy(d, l, bl, bl2, string, n, n2);
    }

    @NotNull
    public String toString() {
        return "PluginConfig(sleepPercentage=" + this.sleepPercentage + ", skipDelayMs=" + this.skipDelayMs + ", broadcastMessages=" + this.broadcastMessages + ", excludeSpectators=" + this.excludeSpectators + ", language=" + this.language + ", nightStartHour=" + this.nightStartHour + ", nightStartMinute=" + this.nightStartMinute + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.sleepPercentage);
        result = result * 31 + Long.hashCode(this.skipDelayMs);
        result = result * 31 + Boolean.hashCode(this.broadcastMessages);
        result = result * 31 + Boolean.hashCode(this.excludeSpectators);
        result = result * 31 + this.language.hashCode();
        result = result * 31 + Integer.hashCode(this.nightStartHour);
        result = result * 31 + Integer.hashCode(this.nightStartMinute);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluginConfig)) {
            return false;
        }
        PluginConfig pluginConfig = (PluginConfig)other;
        if (Double.compare(this.sleepPercentage, pluginConfig.sleepPercentage) != 0) {
            return false;
        }
        if (this.skipDelayMs != pluginConfig.skipDelayMs) {
            return false;
        }
        if (this.broadcastMessages != pluginConfig.broadcastMessages) {
            return false;
        }
        if (this.excludeSpectators != pluginConfig.excludeSpectators) {
            return false;
        }
        if (!Intrinsics.areEqual(this.language, pluginConfig.language)) {
            return false;
        }
        if (this.nightStartHour != pluginConfig.nightStartHour) {
            return false;
        }
        return this.nightStartMinute == pluginConfig.nightStartMinute;
    }

    public PluginConfig() {
        this(0.0, 0L, false, false, null, 0, 0, 127, null);
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        PluginConfig.gson = gson;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/rootapp/quicksleep/config/PluginConfig$Companion;", "", "<init>", "()V", "gson", "Lcom/rootapp/quicksleep/shadow/gson/Gson;", "load", "Lcom/rootapp/quicksleep/config/PluginConfig;", "plugin", "Lcom/hypixel/hytale/server/core/plugin/JavaPlugin;", "getConfigFile", "Ljava/io/File;", "SleepVote-Hytale"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PluginConfig load(@NotNull JavaPlugin plugin) {
            PluginConfig pluginConfig;
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            File configFile = this.getConfigFile(plugin);
            if (configFile.exists()) {
                PluginConfig pluginConfig2;
                try {
                    pluginConfig2 = gson.fromJson(FilesKt.readText$default(configFile, null, 1, null), PluginConfig.class);
                }
                catch (Exception e) {
                    plugin.getLogger().at(Level.WARNING).log("Failed to load config, using defaults: %s", (Object)e.getMessage());
                    pluginConfig2 = new PluginConfig(0.0, 0L, false, false, null, 0, 0, 127, null);
                }
                pluginConfig = pluginConfig2;
            } else {
                void var3_4;
                PluginConfig defaultConfig = new PluginConfig(0.0, 0L, false, false, null, 0, 0, 127, null);
                defaultConfig.save(plugin);
                pluginConfig = var3_4;
            }
            return pluginConfig;
        }

        private final File getConfigFile(JavaPlugin plugin) {
            File dataFolder = new File("mods/QuickSleep");
            if (!dataFolder.exists()) {
                dataFolder.mkdirs();
            }
            return new File(dataFolder, "config.json");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

