/*
 * Decompiled with CFR 0.152.
 */
package com.rootapp.quicksleep.commands;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.CommandBase;
import com.rootapp.quicksleep.QuickSleepPlugin;
import com.rootapp.quicksleep.config.PluginConfig;
import com.rootapp.quicksleep.i18n.LanguageManager;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\n\u000b\f\r\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/rootapp/quicksleep/commands/QuickSleepCommand;", "Lcom/hypixel/hytale/server/core/command/system/basecommands/CommandBase;", "plugin", "Lcom/rootapp/quicksleep/QuickSleepPlugin;", "<init>", "(Lcom/rootapp/quicksleep/QuickSleepPlugin;)V", "executeSync", "", "context", "Lcom/hypixel/hytale/server/core/command/system/CommandContext;", "PercentageCommand", "DelayCommand", "LanguageCommand", "LanguagesCommand", "ReloadCommand", "SleepVote-Hytale"})
public final class QuickSleepCommand
extends CommandBase {
    @NotNull
    private final QuickSleepPlugin plugin;

    public QuickSleepCommand(@NotNull QuickSleepPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        super("quicksleep", "QuickSleep configuration commands");
        this.plugin = plugin;
        this.addSubCommand((AbstractCommand)new PercentageCommand(this.plugin));
        this.addSubCommand((AbstractCommand)new DelayCommand(this.plugin));
        this.addSubCommand((AbstractCommand)new LanguageCommand(this.plugin));
        this.addSubCommand((AbstractCommand)new LanguagesCommand(this.plugin));
        this.addSubCommand((AbstractCommand)new ReloadCommand(this.plugin));
    }

    protected void executeSync(@NotNull CommandContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        PluginConfig config = this.plugin.getPluginConfig();
        LanguageManager lang = this.plugin.getLanguageManager();
        context.sendMessage(Message.raw((String)lang.get("command.settings_header", new Pair[0])));
        Pair[] pairArray = new Pair[]{TuplesKt.to("value", (int)(config.getClampedSleepPercentage() * (double)100))};
        context.sendMessage(Message.raw((String)lang.get("command.current_percentage", pairArray)));
        pairArray = new Pair[]{TuplesKt.to("value", config.getSkipDelayMs())};
        context.sendMessage(Message.raw((String)lang.get("command.current_delay", pairArray)));
        pairArray = new Pair[]{TuplesKt.to("value", config.getBroadcastMessages())};
        context.sendMessage(Message.raw((String)lang.get("command.broadcast_status", pairArray)));
        pairArray = new Pair[]{TuplesKt.to("value", config.getLanguage())};
        context.sendMessage(Message.raw((String)lang.get("command.current_language", pairArray)));
        context.sendMessage(Message.raw((String)""));
        context.sendMessage(Message.raw((String)lang.get("command.commands_header", new Pair[0])));
        context.sendMessage(Message.raw((String)lang.get("command.help_percentage", new Pair[0])));
        context.sendMessage(Message.raw((String)lang.get("command.help_delay", new Pair[0])));
        context.sendMessage(Message.raw((String)lang.get("command.help_language", new Pair[0])));
        context.sendMessage(Message.raw((String)lang.get("command.help_languages", new Pair[0])));
        context.sendMessage(Message.raw((String)lang.get("command.help_reload", new Pair[0])));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/rootapp/quicksleep/commands/QuickSleepCommand$DelayCommand;", "Lcom/hypixel/hytale/server/core/command/system/basecommands/CommandBase;", "plugin", "Lcom/rootapp/quicksleep/QuickSleepPlugin;", "<init>", "(Lcom/rootapp/quicksleep/QuickSleepPlugin;)V", "valueArg", "Lcom/hypixel/hytale/server/core/command/system/arguments/system/RequiredArg;", "", "executeSync", "", "context", "Lcom/hypixel/hytale/server/core/command/system/CommandContext;", "SleepVote-Hytale"})
    public static final class DelayCommand
    extends CommandBase {
        @NotNull
        private final QuickSleepPlugin plugin;
        @NotNull
        private final RequiredArg<Integer> valueArg;

        public DelayCommand(@NotNull QuickSleepPlugin plugin) {
            Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
            super("delay", "Set the delay before skipping night");
            this.plugin = plugin;
            this.valueArg = this.withRequiredArg("ms", "Delay in milliseconds (0 = instant)", (ArgumentType)ArgTypes.INTEGER);
        }

        protected void executeSync(@NotNull CommandContext context) {
            Intrinsics.checkNotNullParameter(context, "context");
            Object object = this.valueArg.get(context);
            Intrinsics.checkNotNullExpressionValue(object, "get(...)");
            int value = RangesKt.coerceAtLeast(((Number)object).intValue(), 0);
            LanguageManager lang = this.plugin.getLanguageManager();
            this.plugin.setPluginConfig(PluginConfig.copy$default(this.plugin.getPluginConfig(), 0.0, value, false, false, null, 0, 0, 125, null));
            this.plugin.getPluginConfig().save(this.plugin);
            if (value == 0) {
                context.sendMessage(Message.raw((String)lang.get("command.delay_instant", new Pair[0])));
            } else {
                Pair[] pairArray = new Pair[]{TuplesKt.to("value", value), TuplesKt.to("seconds", (double)value / 1000.0)};
                context.sendMessage(Message.raw((String)lang.get("command.delay_set", pairArray)));
            }
            this.plugin.getLogger().at(Level.INFO).log("Skip delay changed to %dms by %s", value, (Object)context.sender().getDisplayName());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/rootapp/quicksleep/commands/QuickSleepCommand$LanguageCommand;", "Lcom/hypixel/hytale/server/core/command/system/basecommands/CommandBase;", "plugin", "Lcom/rootapp/quicksleep/QuickSleepPlugin;", "<init>", "(Lcom/rootapp/quicksleep/QuickSleepPlugin;)V", "langArg", "Lcom/hypixel/hytale/server/core/command/system/arguments/system/RequiredArg;", "", "executeSync", "", "context", "Lcom/hypixel/hytale/server/core/command/system/CommandContext;", "SleepVote-Hytale"})
    public static final class LanguageCommand
    extends CommandBase {
        @NotNull
        private final QuickSleepPlugin plugin;
        @NotNull
        private final RequiredArg<String> langArg;

        public LanguageCommand(@NotNull QuickSleepPlugin plugin) {
            Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
            super("language", "Set the plugin language");
            this.plugin = plugin;
            this.langArg = this.withRequiredArg("lang", "Language code (e.g., en, es)", (ArgumentType)ArgTypes.STRING);
        }

        protected void executeSync(@NotNull CommandContext context) {
            Intrinsics.checkNotNullParameter(context, "context");
            Object object = this.langArg.get(context);
            Intrinsics.checkNotNullExpressionValue(object, "get(...)");
            String string = ((String)object).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String langCode = string;
            LanguageManager langManager = this.plugin.getLanguageManager();
            if (langManager.isLanguageAvailable(langCode)) {
                this.plugin.setPluginConfig(PluginConfig.copy$default(this.plugin.getPluginConfig(), 0.0, 0L, false, false, langCode, 0, 0, 111, null));
                this.plugin.getPluginConfig().save(this.plugin);
                Pair[] pairArray = new Pair[]{TuplesKt.to("value", langCode)};
                String message = langManager.get("command.language_set", pairArray);
                context.sendMessage(Message.raw((String)message));
                this.plugin.getLogger().at(Level.INFO).log("Language changed to %s by %s", (Object)langCode, (Object)context.sender().getDisplayName());
            } else {
                String available = CollectionsKt.joinToString$default(langManager.getAvailableLanguages(), ", ", null, null, 0, null, null, 62, null);
                Pair[] pairArray = new Pair[]{TuplesKt.to("value", langCode), TuplesKt.to("available", available)};
                String message = langManager.get("command.language_invalid", pairArray);
                context.sendMessage(Message.raw((String)message));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/rootapp/quicksleep/commands/QuickSleepCommand$LanguagesCommand;", "Lcom/hypixel/hytale/server/core/command/system/basecommands/CommandBase;", "plugin", "Lcom/rootapp/quicksleep/QuickSleepPlugin;", "<init>", "(Lcom/rootapp/quicksleep/QuickSleepPlugin;)V", "executeSync", "", "context", "Lcom/hypixel/hytale/server/core/command/system/CommandContext;", "SleepVote-Hytale"})
    public static final class LanguagesCommand
    extends CommandBase {
        @NotNull
        private final QuickSleepPlugin plugin;

        public LanguagesCommand(@NotNull QuickSleepPlugin plugin) {
            Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
            super("languages", "List available languages");
            this.plugin = plugin;
        }

        protected void executeSync(@NotNull CommandContext context) {
            Intrinsics.checkNotNullParameter(context, "context");
            LanguageManager langManager = this.plugin.getLanguageManager();
            String currentLang = this.plugin.getPluginConfig().getLanguage();
            List available = CollectionsKt.sorted((Iterable)langManager.getAvailableLanguages());
            context.sendMessage(Message.raw((String)langManager.get("command.languages_header", new Pair[0])));
            Pair[] pairArray = new Pair[]{TuplesKt.to("value", currentLang)};
            context.sendMessage(Message.raw((String)langManager.get("command.languages_current", pairArray)));
            pairArray = new Pair[]{TuplesKt.to("list", CollectionsKt.joinToString$default(available, ", ", null, null, 0, null, null, 62, null))};
            context.sendMessage(Message.raw((String)langManager.get("command.languages_available", pairArray)));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/rootapp/quicksleep/commands/QuickSleepCommand$PercentageCommand;", "Lcom/hypixel/hytale/server/core/command/system/basecommands/CommandBase;", "plugin", "Lcom/rootapp/quicksleep/QuickSleepPlugin;", "<init>", "(Lcom/rootapp/quicksleep/QuickSleepPlugin;)V", "valueArg", "Lcom/hypixel/hytale/server/core/command/system/arguments/system/RequiredArg;", "", "executeSync", "", "context", "Lcom/hypixel/hytale/server/core/command/system/CommandContext;", "SleepVote-Hytale"})
    public static final class PercentageCommand
    extends CommandBase {
        @NotNull
        private final QuickSleepPlugin plugin;
        @NotNull
        private final RequiredArg<Integer> valueArg;

        public PercentageCommand(@NotNull QuickSleepPlugin plugin) {
            Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
            super("percentage", "Set the required sleep percentage");
            this.plugin = plugin;
            this.valueArg = this.withRequiredArg("value", "Percentage (0-100)", (ArgumentType)ArgTypes.INTEGER);
        }

        protected void executeSync(@NotNull CommandContext context) {
            Intrinsics.checkNotNullParameter(context, "context");
            Object object = this.valueArg.get(context);
            Intrinsics.checkNotNullExpressionValue(object, "get(...)");
            int value = RangesKt.coerceIn(((Number)object).intValue(), 0, 100);
            double percentage = (double)value / 100.0;
            LanguageManager lang = this.plugin.getLanguageManager();
            this.plugin.setPluginConfig(PluginConfig.copy$default(this.plugin.getPluginConfig(), percentage, 0L, false, false, null, 0, 0, 126, null));
            this.plugin.getPluginConfig().save(this.plugin);
            Pair[] pairArray = new Pair[]{TuplesKt.to("value", value)};
            context.sendMessage(Message.raw((String)lang.get("command.percentage_set", pairArray)));
            this.plugin.getLogger().at(Level.INFO).log("Sleep percentage changed to " + value + "%% by %s", (Object)context.sender().getDisplayName());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/rootapp/quicksleep/commands/QuickSleepCommand$ReloadCommand;", "Lcom/hypixel/hytale/server/core/command/system/basecommands/CommandBase;", "plugin", "Lcom/rootapp/quicksleep/QuickSleepPlugin;", "<init>", "(Lcom/rootapp/quicksleep/QuickSleepPlugin;)V", "executeSync", "", "context", "Lcom/hypixel/hytale/server/core/command/system/CommandContext;", "SleepVote-Hytale"})
    public static final class ReloadCommand
    extends CommandBase {
        @NotNull
        private final QuickSleepPlugin plugin;

        public ReloadCommand(@NotNull QuickSleepPlugin plugin) {
            Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
            super("reload", "Reload configuration from file");
            this.plugin = plugin;
        }

        protected void executeSync(@NotNull CommandContext context) {
            Intrinsics.checkNotNullParameter(context, "context");
            this.plugin.reloadConfig();
            PluginConfig config = this.plugin.getPluginConfig();
            LanguageManager lang = this.plugin.getLanguageManager();
            context.sendMessage(Message.raw((String)lang.get("command.config_reloaded", new Pair[0])));
            Pair[] pairArray = new Pair[]{TuplesKt.to("value", (int)(config.getClampedSleepPercentage() * (double)100))};
            context.sendMessage(Message.raw((String)lang.get("command.reload_percentage", pairArray)));
            pairArray = new Pair[]{TuplesKt.to("value", config.getSkipDelayMs())};
            context.sendMessage(Message.raw((String)lang.get("command.reload_delay", pairArray)));
            pairArray = new Pair[]{TuplesKt.to("value", config.getLanguage())};
            context.sendMessage(Message.raw((String)lang.get("command.reload_language", pairArray)));
        }
    }
}

