/*
 * Decompiled with CFR 0.152.
 */
package com.rootapp.quicksleep;

import com.hypixel.hytale.builtin.beds.sleep.components.PlayerSleep;
import com.hypixel.hytale.builtin.beds.sleep.components.PlayerSomnolence;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Resource;
import com.hypixel.hytale.component.ResourceType;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.modules.time.WorldTimeResource;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.rootapp.quicksleep.QuickSleepPlugin;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 02\u00020\u0001:\u00010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0016\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001dH\u0002J\b\u0010\"\u001a\u00020\u0016H\u0002J \u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020\u0016H\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020%H\u0002J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020%H\u0002J\b\u0010.\u001a\u00020\nH\u0002J\u0006\u0010/\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\u0006\u001aB\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n \t* \u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b0\rj\b\u0012\u0004\u0012\u00020\b`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/rootapp/quicksleep/SleepManager;", "", "plugin", "Lcom/rootapp/quicksleep/QuickSleepPlugin;", "<init>", "(Lcom/rootapp/quicksleep/QuickSleepPlugin;)V", "currentlySleepingPlayers", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "tempUuidSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "thresholdReachedTime", "", "thresholdAnnounced", "nightAlreadySkipped", "checkInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "scheduleCheck", "", "checkSleepingPlayers", "updateSleepingPlayersIfChanged", "newUuids", "", "getEligiblePlayers", "", "Lcom/hypixel/hytale/server/core/universe/PlayerRef;", "allPlayers", "getPlayersInBed", "isPlayerInBed", "player", "skipNight", "broadcastSleepMessage", "playerName", "", "sleepingCount", "", "requiredPlayers", "broadcastNightSkipped", "broadcastMessage", "messageText", "stripColorCodes", "message", "isNightTime", "shutdown", "Companion", "SleepVote-Hytale"})
@SourceDebugExtension(value={"SMAP\nSleepManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SleepManager.kt\ncom/rootapp/quicksleep/SleepManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,428:1\n1557#2:429\n1628#2,3:430\n774#2:433\n865#2,2:434\n1863#2,2:436\n774#2:438\n865#2,2:439\n774#2:441\n865#2,2:442\n1755#2,3:444\n1863#2,2:447\n*S KotlinDebug\n*F\n+ 1 SleepManager.kt\ncom/rootapp/quicksleep/SleepManager\n*L\n101#1:429\n101#1:430,3\n145#1:433\n145#1:434,2\n230#1:436,2\n232#1:438\n232#1:439,2\n246#1:441\n246#1:442,2\n274#1:444,3\n348#1:447,2\n*E\n"})
public final class SleepManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QuickSleepPlugin plugin;
    private final ConcurrentHashMap.KeySetView<UUID, Boolean> currentlySleepingPlayers;
    @NotNull
    private final HashSet<UUID> tempUuidSet;
    private long thresholdReachedTime;
    private boolean thresholdAnnounced;
    private boolean nightAlreadySkipped;
    @NotNull
    private final AtomicBoolean checkInProgress;
    public static final int NIGHT_END_HOUR = 4;
    public static final int NIGHT_END_MINUTE = 45;
    @NotNull
    private static final Lazy<ComponentType<EntityStore, PlayerSomnolence>> SOMNOLENCE_TYPE$delegate = LazyKt.lazy(SleepManager::SOMNOLENCE_TYPE_delegate$lambda$8);
    @NotNull
    private static final Lazy<ResourceType<EntityStore, WorldTimeResource>> TIME_RESOURCE_TYPE$delegate = LazyKt.lazy(SleepManager::TIME_RESOURCE_TYPE_delegate$lambda$9);
    @NotNull
    private static final Regex COLOR_CODE_REGEX = new Regex("&[0-9a-fk-or]");

    public SleepManager(@NotNull QuickSleepPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.currentlySleepingPlayers = ConcurrentHashMap.newKeySet();
        this.tempUuidSet = new HashSet();
        this.checkInProgress = new AtomicBoolean(false);
    }

    public final void scheduleCheck() {
        if (!this.checkInProgress.compareAndSet(false, true)) {
            return;
        }
        try {
            Universe universe = Universe.get();
            World defaultWorld = universe.getDefaultWorld();
            if (defaultWorld != null) {
                defaultWorld.execute(() -> SleepManager.scheduleCheck$lambda$0(this));
            } else {
                this.checkInProgress.set(false);
            }
        }
        catch (Exception e) {
            this.checkInProgress.set(false);
            this.plugin.getLogger().at(Level.WARNING).log("Error scheduling sleep check: %s", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSleepingPlayers() {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Universe universe = Universe.get();
        World defaultWorld = universe.getDefaultWorld();
        List list = universe.getPlayers();
        Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
        List allPlayers = list;
        if (allPlayers.isEmpty() || defaultWorld == null) {
            return;
        }
        List<PlayerRef> eligiblePlayers = this.getEligiblePlayers(allPlayers);
        List<PlayerRef> playersInBed = this.getPlayersInBed(allPlayers);
        Iterable $this$map$iv = playersInBed;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PlayerRef playerRef = (PlayerRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUuid());
        }
        Set<UUID> playersInBedUuids = CollectionsKt.toSet((List)destination$iv$iv);
        int inBedCount = playersInBed.size();
        int totalCount = eligiblePlayers.size();
        if (totalCount == 0) {
            return;
        }
        if (inBedCount == 0) {
            this.nightAlreadySkipped = false;
            this.thresholdReachedTime = 0L;
            this.thresholdAnnounced = false;
            this.currentlySleepingPlayers.clear();
            return;
        }
        if (this.nightAlreadySkipped) {
            this.updateSleepingPlayersIfChanged(playersInBedUuids);
            return;
        }
        if (!this.isNightTime()) {
            ConcurrentHashMap.KeySetView<UUID, Boolean> keySetView = this.currentlySleepingPlayers;
            Intrinsics.checkNotNullExpressionValue(keySetView, "currentlySleepingPlayers");
            if (!((Collection)keySetView).isEmpty()) {
                this.plugin.getLogger().at(Level.FINE).log("Not nighttime - clearing bed tracking");
                this.currentlySleepingPlayers.clear();
                this.thresholdReachedTime = 0L;
                this.thresholdAnnounced = false;
            }
            return;
        }
        double requiredPercentage = this.plugin.getPluginConfig().getClampedSleepPercentage();
        int requiredPlayers = RangesKt.coerceAtLeast((int)Math.ceil((double)totalCount * requiredPercentage), 1);
        Iterable $this$filter$iv = playersInBedUuids;
        boolean $i$f$filter = false;
        Iterable bl = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UUID uuid = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (!(!this.currentlySleepingPlayers.contains(uuid))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List newInBed = (List)destination$iv$iv2;
        long now = System.currentTimeMillis();
        boolean thresholdMet = inBedCount >= requiredPlayers;
        if (!((Collection)newInBed).isEmpty() && !thresholdMet) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("sleeping", inBedCount), TuplesKt.to("total", totalCount), TuplesKt.to("required", requiredPlayers)};
            String message = this.plugin.getLanguageManager().get("sleep.progress", pairArray);
            this.plugin.executeCommand("say " + message);
        }
        this.updateSleepingPlayersIfChanged(playersInBedUuids);
        if (thresholdMet) {
            long elapsed;
            long skipDelay = RangesKt.coerceAtLeast(this.plugin.getPluginConfig().getSkipDelayMs(), 0L);
            if (this.thresholdReachedTime == 0L) {
                this.thresholdReachedTime = now;
                if (!this.thresholdAnnounced) {
                    if (skipDelay > 0L) {
                        Object element$iv$iv;
                        element$iv$iv = "%.1f";
                        Object[] objectArray = new Object[]{(double)skipDelay / 1000.0};
                        String string = String.format(element$iv$iv, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
                        String delaySeconds = string;
                        objectArray = new Pair[]{TuplesKt.to("delay", delaySeconds)};
                        String message = this.plugin.getLanguageManager().get("sleep.skipping_countdown", (Pair<String, ? extends Object>[])objectArray);
                        this.plugin.executeCommand("say " + message);
                    } else {
                        String message = this.plugin.getLanguageManager().get("sleep.skipping", new Pair[0]);
                        this.plugin.executeCommand("say " + message);
                    }
                    this.thresholdAnnounced = true;
                }
            }
            if ((elapsed = now - this.thresholdReachedTime) >= skipDelay) {
                this.skipNight();
                this.nightAlreadySkipped = true;
                this.thresholdReachedTime = 0L;
                this.thresholdAnnounced = false;
            }
        } else if (this.thresholdReachedTime != 0L) {
            this.thresholdReachedTime = 0L;
            this.thresholdAnnounced = false;
        }
    }

    private final void updateSleepingPlayersIfChanged(Set<UUID> newUuids) {
        if (this.currentlySleepingPlayers.size() != newUuids.size() || !this.currentlySleepingPlayers.containsAll((Collection)newUuids)) {
            this.currentlySleepingPlayers.clear();
            this.currentlySleepingPlayers.addAll((Collection<UUID>)newUuids);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PlayerRef> getEligiblePlayers(List<? extends PlayerRef> allPlayers) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        Universe universe = Universe.get();
        World world = universe.getDefaultWorld();
        if (world == null) {
            return CollectionsKt.emptyList();
        }
        World defaultWorld = world;
        Collection collection = defaultWorld.getPlayerRefs();
        Intrinsics.checkNotNullExpressionValue(collection, "getPlayerRefs(...)");
        Collection worldPlayerRefs = collection;
        this.tempUuidSet.clear();
        Iterable $this$forEach$iv = worldPlayerRefs;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            PlayerRef it = (PlayerRef)element$iv2;
            boolean bl = false;
            this.tempUuidSet.add(it.getUuid());
        }
        Iterable $this$filter$iv = allPlayers;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerRef it = (PlayerRef)element$iv$iv;
            boolean bl = false;
            if (!this.tempUuidSet.contains(it.getUuid())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playersInWorld = (List)destination$iv$iv;
        return this.plugin.getPluginConfig().getExcludeSpectators() ? playersInWorld : playersInWorld;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PlayerRef> getPlayersInBed(List<? extends PlayerRef> allPlayers) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = allPlayers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerRef player = (PlayerRef)element$iv$iv;
            boolean bl = false;
            if (!this.isPlayerInBed(player)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isPlayerInBed(PlayerRef player) {
        try {
            PlayerSomnolence holderSomnolence;
            boolean isInDefaultWorld;
            block9: {
                Universe universe = Universe.get();
                World defaultWorld = universe.getDefaultWorld();
                if (defaultWorld == null) {
                    return false;
                }
                Collection collection = defaultWorld.getPlayerRefs();
                Intrinsics.checkNotNullExpressionValue(collection, "getPlayerRefs(...)");
                Collection worldPlayerRefs = collection;
                Iterable $this$any$iv = worldPlayerRefs;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PlayerRef it = (PlayerRef)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getUuid(), player.getUuid())) continue;
                        v1 = true;
                        break block9;
                    }
                    v1 = isInDefaultWorld = false;
                }
            }
            if (!isInDefaultWorld) {
                return false;
            }
            PlayerSomnolence somnolence = (PlayerSomnolence)player.getComponent(SleepManager.Companion.getSOMNOLENCE_TYPE());
            if (somnolence != null) {
                PlayerSleep sleepState = somnolence.getSleepState();
                return sleepState != null && !(sleepState instanceof PlayerSleep.FullyAwake);
            }
            Holder holder = player.getHolder();
            if (holder != null && (holderSomnolence = (PlayerSomnolence)holder.getComponent(SleepManager.Companion.getSOMNOLENCE_TYPE())) != null) {
                PlayerSleep sleepState = holderSomnolence.getSleepState();
                return sleepState != null && !(sleepState instanceof PlayerSleep.FullyAwake);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().at(Level.FINE).log("Could not check bed state for %s: %s", (Object)player.getUsername(), (Object)e.getMessage());
        }
        return false;
    }

    private final void skipNight() {
        String message = this.plugin.getLanguageManager().get("sleep.good_morning", new Pair[0]);
        this.plugin.executeCommand("say " + message);
        this.plugin.executeCommand("time day");
    }

    private final void broadcastSleepMessage(String playerName, int sleepingCount, int requiredPlayers) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", playerName), TuplesKt.to("sleeping", sleepingCount), TuplesKt.to("required", requiredPlayers)};
        String message = this.plugin.getLanguageManager().get("sleep.progress", pairArray);
        this.broadcastMessage(message);
    }

    private final void broadcastNightSkipped() {
        this.broadcastMessage(this.plugin.getLanguageManager().get("sleep.good_morning", new Pair[0]));
    }

    private final void broadcastMessage(String messageText) {
        String cleanText = this.stripColorCodes(messageText);
        try {
            Universe universe = Universe.get();
            Message message = Message.raw((String)cleanText);
            Intrinsics.checkNotNullExpressionValue(message, "raw(...)");
            Message message2 = message;
            List list = universe.getPlayers();
            Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PlayerRef player = (PlayerRef)element$iv;
                boolean bl = false;
                player.sendMessage(message2);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().at(Level.WARNING).log("Failed to broadcast message: %s", (Object)e.getMessage());
        }
    }

    private final String stripColorCodes(String message) {
        CharSequence charSequence = message;
        Regex regex = COLOR_CODE_REGEX;
        String string = "";
        return regex.replace(charSequence, string);
    }

    private final boolean isNightTime() {
        try {
            Universe universe = Universe.get();
            World world = universe.getDefaultWorld();
            if (world == null) {
                return false;
            }
            World defaultWorld = world;
            EntityStore entityStore = defaultWorld.getEntityStore();
            Intrinsics.checkNotNullExpressionValue(entityStore, "getEntityStore(...)");
            EntityStore entityStore2 = entityStore;
            Store store = entityStore2.getStore();
            Resource resource = store.getResource(SleepManager.Companion.getTIME_RESOURCE_TYPE());
            Intrinsics.checkNotNullExpressionValue(resource, "getResource(...)");
            WorldTimeResource timeResource = (WorldTimeResource)resource;
            LocalDateTime gameDateTime = timeResource.getGameDateTime();
            int currentHour = gameDateTime.getHour();
            int currentMinute = gameDateTime.getMinute();
            int nightStartHour = this.plugin.getPluginConfig().getNightStartHour();
            int nightStartMinute = this.plugin.getPluginConfig().getNightStartMinute();
            int currentTimeMinutes = currentHour * 60 + currentMinute;
            int nightStartMinutes = nightStartHour * 60 + nightStartMinute;
            int nightEndMinutes = 285;
            boolean isNight = nightStartMinutes > nightEndMinutes ? currentTimeMinutes >= nightStartMinutes || currentTimeMinutes < nightEndMinutes : currentTimeMinutes >= nightStartMinutes && currentTimeMinutes < nightEndMinutes;
            this.plugin.getLogger().at(Level.FINE).log("Time check: %d:%02d, isNight=%s (night is %d:%02d-%d:%02d)", (Object)currentHour, (Object)currentMinute, (Object)isNight, (Object)nightStartHour, (Object)nightStartMinute, (Object)4, (Object)45);
            return isNight;
        }
        catch (Exception e) {
            this.plugin.getLogger().at(Level.WARNING).log("Error checking time: %s", (Object)e.getMessage());
            return false;
        }
    }

    public final void shutdown() {
        this.currentlySleepingPlayers.clear();
        this.nightAlreadySkipped = false;
        this.thresholdReachedTime = 0L;
        this.thresholdAnnounced = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void scheduleCheck$lambda$0(SleepManager this$0) {
        try {
            this$0.checkSleepingPlayers();
        }
        finally {
            this$0.checkInProgress.set(false);
        }
    }

    private static final ComponentType SOMNOLENCE_TYPE_delegate$lambda$8() {
        return PlayerSomnolence.getComponentType();
    }

    private static final ResourceType TIME_RESOURCE_TYPE_delegate$lambda$9() {
        return WorldTimeResource.getResourceType();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R[\u0010\u0007\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR7\u0010\u0010\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00120\u00120\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000f\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/rootapp/quicksleep/SleepManager$Companion;", "", "<init>", "()V", "NIGHT_END_HOUR", "", "NIGHT_END_MINUTE", "SOMNOLENCE_TYPE", "Lcom/hypixel/hytale/component/ComponentType;", "Lcom/hypixel/hytale/server/core/universe/world/storage/EntityStore;", "kotlin.jvm.PlatformType", "Lcom/hypixel/hytale/builtin/beds/sleep/components/PlayerSomnolence;", "getSOMNOLENCE_TYPE", "()Lcom/hypixel/hytale/component/ComponentType;", "SOMNOLENCE_TYPE$delegate", "Lkotlin/Lazy;", "TIME_RESOURCE_TYPE", "Lcom/hypixel/hytale/component/ResourceType;", "Lcom/hypixel/hytale/server/core/modules/time/WorldTimeResource;", "getTIME_RESOURCE_TYPE", "()Lcom/hypixel/hytale/component/ResourceType;", "TIME_RESOURCE_TYPE$delegate", "COLOR_CODE_REGEX", "Lkotlin/text/Regex;", "SleepVote-Hytale"})
    public static final class Companion {
        private Companion() {
        }

        private final ComponentType<EntityStore, PlayerSomnolence> getSOMNOLENCE_TYPE() {
            Lazy lazy = SOMNOLENCE_TYPE$delegate;
            return (ComponentType)lazy.getValue();
        }

        private final ResourceType<EntityStore, WorldTimeResource> getTIME_RESOURCE_TYPE() {
            Lazy lazy = TIME_RESOURCE_TYPE$delegate;
            return (ResourceType)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

