/*
 * Decompiled with CFR 0.152.
 */
package com.rootapp.quicksleep;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandManager;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.event.events.player.PlayerDisconnectEvent;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.rootapp.quicksleep.SleepManager;
import com.rootapp.quicksleep.commands.QuickSleepCommand;
import com.rootapp.quicksleep.config.PluginConfig;
import com.rootapp.quicksleep.i18n.LanguageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0014J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0002J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0018J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180#2\u0006\u0010!\u001a\u00020\u0018J\u0006\u0010$\u001a\u00020\u001cR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0011@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/rootapp/quicksleep/QuickSleepPlugin;", "Lcom/hypixel/hytale/server/core/plugin/JavaPlugin;", "init", "Lcom/hypixel/hytale/server/core/plugin/JavaPluginInit;", "<init>", "(Lcom/hypixel/hytale/server/core/plugin/JavaPluginInit;)V", "pluginConfig", "Lcom/rootapp/quicksleep/config/PluginConfig;", "getPluginConfig", "()Lcom/rootapp/quicksleep/config/PluginConfig;", "setPluginConfig", "(Lcom/rootapp/quicksleep/config/PluginConfig;)V", "value", "Lcom/rootapp/quicksleep/i18n/LanguageManager;", "languageManager", "getLanguageManager", "()Lcom/rootapp/quicksleep/i18n/LanguageManager;", "Lcom/rootapp/quicksleep/SleepManager;", "sleepManager", "getSleepManager", "()Lcom/rootapp/quicksleep/SleepManager;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "pluginVersion", "", "getPluginVersion", "()Ljava/lang/String;", "start", "", "shutdown", "registerListeners", "registerCommands", "executeCommand", "command", "executeCommandWithOutput", "", "reloadConfig", "Companion", "SleepVote-Hytale"})
public final class QuickSleepPlugin
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public PluginConfig pluginConfig;
    private LanguageManager languageManager;
    private SleepManager sleepManager;
    private ScheduledExecutorService scheduler;
    private static QuickSleepPlugin instance;

    public QuickSleepPlugin(@NotNull JavaPluginInit init) {
        Intrinsics.checkNotNullParameter(init, "init");
        super(init);
        instance = this;
    }

    @NotNull
    public final PluginConfig getPluginConfig() {
        PluginConfig pluginConfig = this.pluginConfig;
        if (pluginConfig != null) {
            return pluginConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException("pluginConfig");
        return null;
    }

    public final void setPluginConfig(@NotNull PluginConfig pluginConfig) {
        Intrinsics.checkNotNullParameter(pluginConfig, "<set-?>");
        this.pluginConfig = pluginConfig;
    }

    @NotNull
    public final LanguageManager getLanguageManager() {
        LanguageManager languageManager = this.languageManager;
        if (languageManager != null) {
            return languageManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("languageManager");
        return null;
    }

    @NotNull
    public final SleepManager getSleepManager() {
        SleepManager sleepManager = this.sleepManager;
        if (sleepManager != null) {
            return sleepManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("sleepManager");
        return null;
    }

    @NotNull
    public final String getPluginVersion() {
        Object object = this.getManifest();
        if (object == null || (object = object.getVersion()) == null || (object = object.toString()) == null) {
            object = "1.0.0";
        }
        return object;
    }

    protected void start() {
        this.getLogger().at(Level.INFO).log("Enabling QuickSleep Plugin...");
        this.setPluginConfig(PluginConfig.Companion.load(this));
        this.getLogger().at(Level.INFO).log("Sleep percentage set to %.0f%%", (Object)(this.getPluginConfig().getClampedSleepPercentage() * (double)100));
        this.languageManager = new LanguageManager(this);
        this.getLogger().at(Level.INFO).log("Language set to: %s", (Object)this.getPluginConfig().getLanguage());
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.sleepManager = new SleepManager(this);
        this.registerListeners();
        this.registerCommands();
        ScheduledExecutorService scheduledExecutorService = this.scheduler;
        if (scheduledExecutorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("scheduler");
            scheduledExecutorService = null;
        }
        scheduledExecutorService.scheduleAtFixedRate(() -> QuickSleepPlugin.start$lambda$0(this), 1L, 1L, TimeUnit.SECONDS);
        this.getLogger().at(Level.INFO).log("QuickSleep Plugin enabled!");
    }

    protected void shutdown() {
        this.getLogger().at(Level.INFO).log("Disabling QuickSleep Plugin...");
        ScheduledExecutorService scheduledExecutorService = this.scheduler;
        if (scheduledExecutorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("scheduler");
            scheduledExecutorService = null;
        }
        scheduledExecutorService.shutdown();
        try {
            ScheduledExecutorService scheduledExecutorService2 = this.scheduler;
            if (scheduledExecutorService2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("scheduler");
                scheduledExecutorService2 = null;
            }
            if (!scheduledExecutorService2.awaitTermination(1L, TimeUnit.SECONDS)) {
                ScheduledExecutorService scheduledExecutorService3 = this.scheduler;
                if (scheduledExecutorService3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("scheduler");
                    scheduledExecutorService3 = null;
                }
                scheduledExecutorService3.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            ScheduledExecutorService scheduledExecutorService4 = this.scheduler;
            if (scheduledExecutorService4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("scheduler");
                scheduledExecutorService4 = null;
            }
            scheduledExecutorService4.shutdownNow();
        }
        this.getSleepManager().shutdown();
        this.getLogger().at(Level.INFO).log("QuickSleep Plugin disabled!");
    }

    private final void registerListeners() {
        this.getEventRegistry().register(PlayerDisconnectEvent.class, arg_0 -> QuickSleepPlugin.registerListeners$lambda$1(this, arg_0));
        this.getLogger().at(Level.INFO).log("Event listeners registered");
    }

    private final void registerCommands() {
        this.getCommandRegistry().registerCommand((AbstractCommand)new QuickSleepCommand(this));
        this.getLogger().at(Level.INFO).log("Commands registered");
    }

    public final void executeCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter(command, "command");
        try {
            CommandManager commandManager = CommandManager.get();
            CommandSender consoleSender2 = new CommandSender(this){
                final /* synthetic */ QuickSleepPlugin this$0;
                {
                    this.this$0 = $receiver;
                }

                public String getDisplayName() {
                    return "QuickSleep";
                }

                public UUID getUuid() {
                    UUID uUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
                    Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
                    return uUID;
                }

                public void sendMessage(Message message) {
                    Intrinsics.checkNotNullParameter(message, "message");
                    this.this$0.getLogger().at(Level.INFO).log("[Command] %s", (Object)message.getRawText());
                }

                public boolean hasPermission(String permission) {
                    Intrinsics.checkNotNullParameter(permission, "permission");
                    return true;
                }

                public boolean hasPermission(String permission, boolean defaultValue) {
                    Intrinsics.checkNotNullParameter(permission, "permission");
                    return true;
                }
            };
            commandManager.handleCommand(consoleSender2, command);
            this.getLogger().at(Level.INFO).log("Executed command: %s", (Object)command);
        }
        catch (Exception e) {
            this.getLogger().at(Level.SEVERE).log("Failed to execute command '%s': %s", (Object)command, (Object)e.getMessage());
        }
    }

    @NotNull
    public final List<String> executeCommandWithOutput(@NotNull String command) {
        Intrinsics.checkNotNullParameter(command, "command");
        List outputs = new ArrayList();
        try {
            CommandManager commandManager = CommandManager.get();
            CommandSender consoleSender2 = new CommandSender(outputs, this){
                final /* synthetic */ List<String> $outputs;
                final /* synthetic */ QuickSleepPlugin this$0;
                {
                    this.$outputs = $outputs;
                    this.this$0 = $receiver;
                }

                public String getDisplayName() {
                    return "QuickSleep";
                }

                public UUID getUuid() {
                    UUID uUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
                    Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
                    return uUID;
                }

                public void sendMessage(Message message) {
                    Intrinsics.checkNotNullParameter(message, "message");
                    String text = message.getRawText();
                    if (text != null) {
                        this.$outputs.add(text);
                        this.this$0.getLogger().at(Level.INFO).log("[CommandOutput] %s", (Object)text);
                    }
                }

                public boolean hasPermission(String permission) {
                    Intrinsics.checkNotNullParameter(permission, "permission");
                    return true;
                }

                public boolean hasPermission(String permission, boolean defaultValue) {
                    Intrinsics.checkNotNullParameter(permission, "permission");
                    return true;
                }
            };
            commandManager.handleCommand(consoleSender2, command);
        }
        catch (Exception e) {
            this.getLogger().at(Level.WARNING).log("Failed to execute command '%s': %s", (Object)command, (Object)e.getMessage());
        }
        return outputs;
    }

    public final void reloadConfig() {
        this.setPluginConfig(PluginConfig.Companion.load(this));
        this.getLanguageManager().reload();
        this.getLogger().at(Level.INFO).log("Configuration reloaded. Sleep percentage: %.0f%%, Language: %s", this.getPluginConfig().getClampedSleepPercentage() * (double)100, (Object)this.getPluginConfig().getLanguage());
    }

    private static final void start$lambda$0(QuickSleepPlugin this$0) {
        try {
            this$0.getSleepManager().scheduleCheck();
        }
        catch (Exception e) {
            this$0.getLogger().at(Level.WARNING).log("Error scheduling sleep check: %s", (Object)e.getMessage());
        }
    }

    private static final void registerListeners$lambda$1(QuickSleepPlugin this$0, PlayerDisconnectEvent event) {
        PlayerRef playerRef = event.getPlayerRef();
        Intrinsics.checkNotNullExpressionValue(playerRef, "getPlayerRef(...)");
        PlayerRef playerRef2 = playerRef;
        this$0.getLogger().at(Level.FINE).log("Player %s disconnected", (Object)playerRef2.getUsername());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/rootapp/quicksleep/QuickSleepPlugin$Companion;", "", "<init>", "()V", "value", "Lcom/rootapp/quicksleep/QuickSleepPlugin;", "instance", "getInstance", "()Lcom/rootapp/quicksleep/QuickSleepPlugin;", "SleepVote-Hytale"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QuickSleepPlugin getInstance() {
            QuickSleepPlugin quickSleepPlugin = instance;
            if (quickSleepPlugin != null) {
                return quickSleepPlugin;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

