/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class TypeConversion {
    private static final ConcurrentHashMap<String, Function<String, Object>> REGISTRY = new ConcurrentHashMap();

    private TypeConversion() {
    }

    public static void register(String typeName, Function<String, Object> parser) {
        if (typeName == null || parser == null) {
            return;
        }
        REGISTRY.put(TypeConversion.normalize(typeName), parser);
    }

    public static void unregister(String typeName) {
        if (typeName == null) {
            return;
        }
        REGISTRY.remove(TypeConversion.normalize(typeName));
    }

    public static Map<String, Function<String, Object>> getRegistryView() {
        return Collections.unmodifiableMap(REGISTRY);
    }

    public static Object convert(String typeName, String value) {
        return TypeConversion.tryConvert(typeName, value).orElseThrow(() -> new IllegalArgumentException("Unsupported type or invalid value: type=" + typeName + ", value='" + value + "'"));
    }

    public static Optional<Object> tryConvert(String typeName, String value) {
        if (typeName == null) {
            return Optional.empty();
        }
        String key = TypeConversion.normalize(typeName);
        Function<String, Object> parser = REGISTRY.get(key);
        if (parser == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(parser.apply(value));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private static String normalize(String typeName) {
        return typeName.trim().toLowerCase(Locale.ROOT);
    }

    private static boolean parseBooleanFlexible(String value) {
        String v;
        if (value == null) {
            return false;
        }
        return switch (v = value.trim().toLowerCase(Locale.ROOT)) {
            case "true", "t", "yes", "y", "1" -> true;
            case "false", "f", "no", "n", "0" -> false;
            default -> Boolean.parseBoolean(v);
        };
    }

    static {
        Function<String, Object> intParser = Integer::parseInt;
        TypeConversion.register("int", intParser);
        TypeConversion.register("integer", intParser);
        TypeConversion.register("java.lang.integer", intParser);
        Function<String, Object> longParser = Long::parseLong;
        TypeConversion.register("long", longParser);
        TypeConversion.register("java.lang.long", longParser);
        Function<String, Object> shortParser = Short::parseShort;
        TypeConversion.register("short", shortParser);
        TypeConversion.register("java.lang.short", shortParser);
        Function<String, Object> byteParser = Byte::parseByte;
        TypeConversion.register("byte", byteParser);
        TypeConversion.register("java.lang.byte", byteParser);
        Function<String, Object> doubleParser = Double::parseDouble;
        TypeConversion.register("double", doubleParser);
        TypeConversion.register("java.lang.double", doubleParser);
        Function<String, Object> floatParser = Float::parseFloat;
        TypeConversion.register("float", floatParser);
        TypeConversion.register("java.lang.float", floatParser);
        Function<String, Object> booleanParser = TypeConversion::parseBooleanFlexible;
        TypeConversion.register("bool", booleanParser);
        TypeConversion.register("boolean", booleanParser);
        TypeConversion.register("java.lang.boolean", booleanParser);
        Function<String, Object> stringParser = s -> s;
        TypeConversion.register("string", stringParser);
        TypeConversion.register("java.lang.string", stringParser);
        Function<String, Object> uuidParser = UUID::fromString;
        TypeConversion.register("uuid", uuidParser);
        TypeConversion.register("java.util.uuid", uuidParser);
        Function<String, Object> bigIntegerParser = BigInteger::new;
        TypeConversion.register("biginteger", bigIntegerParser);
        TypeConversion.register("java.math.biginteger", bigIntegerParser);
        Function<String, Object> bigDecimalParser = BigDecimal::new;
        TypeConversion.register("bigdecimal", bigDecimalParser);
        TypeConversion.register("java.math.bigdecimal", bigDecimalParser);
    }
}

