/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.systems.tick;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.chunk.ChunkInfo;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.EventTitleUtil;
import java.awt.Color;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class TitleTickingSystem
extends EntityTickingSystem<EntityStore> {
    private static final Message WILDERNESS_MESSAGE = Message.raw((String)"Wilderness").color(Color.GREEN);
    private final Message simpleClaimsMessage;
    private static final String WILDERNESS_TEXT = "Wilderness";
    private final Map<UUID, String> playerLastTitle = new ConcurrentHashMap<UUID, String>();

    public TitleTickingSystem(String topLine) {
        this.simpleClaimsMessage = Message.raw((String)topLine);
    }

    public void tick(float v, int index, @NonNullDecl ArchetypeChunk<EntityStore> archetypeChunk, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer) {
        String previousTitle;
        PartyInfo party;
        Ref ref = archetypeChunk.getReferenceTo(index);
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        Message titleMessage = WILDERNESS_MESSAGE;
        String titleText = WILDERNESS_TEXT;
        ChunkInfo chunkInfo = ClaimManager.getInstance().getChunkRawCoords(player.getWorld().getName(), (int)playerRef.getTransform().getPosition().getX(), (int)playerRef.getTransform().getPosition().getZ());
        if (chunkInfo != null && (party = ClaimManager.getInstance().getPartyById(chunkInfo.getPartyOwner())) != null) {
            titleText = party.getName();
            titleMessage = Message.raw((String)titleText).color(Color.WHITE);
        }
        if (!titleText.equals(previousTitle = this.playerLastTitle.get(playerRef.getUuid()))) {
            this.playerLastTitle.put(playerRef.getUuid(), titleText);
            EventTitleUtil.showEventTitleToPlayer((PlayerRef)playerRef, (Message)titleMessage, (Message)this.simpleClaimsMessage, (boolean)false, null, (float)2.0f, (float)0.5f, (float)0.5f);
        }
    }

    public void removePlayer(UUID playerId) {
        this.playerLastTitle.remove(playerId);
    }

    @NullableDecl
    public Query<EntityStore> getQuery() {
        return PlayerRef.getComponentType();
    }
}

