/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.systems.tick;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.chunk.ChunkInfo;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.math.vector.Transform;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.teleport.Teleport;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class EntryTickingSystem
extends EntityTickingSystem<EntityStore> {
    private static final Message TELEPORT_MESSAGE = Message.raw((String)"You are not allowed to enter this claim!").color(Color.RED);
    private final Map<UUID, List<Transform>> playerLastSafePositions = new ConcurrentHashMap<UUID, List<Transform>>();

    public void tick(float v, int index, @NonNullDecl ArchetypeChunk<EntityStore> archetypeChunk, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer) {
        List<Transform> safePositions;
        Ref ref = archetypeChunk.getReferenceTo(index);
        if (!ref.isValid()) {
            return;
        }
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        ChunkInfo chunkInfo = ClaimManager.getInstance().getChunkRawCoords(player.getWorld().getName(), (int)playerRef.getTransform().getPosition().getX(), (int)playerRef.getTransform().getPosition().getZ());
        if (chunkInfo != null && !ClaimManager.getInstance().isAllowedToInteract(playerRef.getUuid(), player.getWorld().getName(), (int)playerRef.getTransform().getPosition().getX(), (int)playerRef.getTransform().getPosition().getZ(), PartyInfo::isAllowEntryEnabled) && this.playerLastSafePositions.containsKey(playerRef.getUuid()) && (safePositions = this.playerLastSafePositions.get(playerRef.getUuid())).size() > 2) {
            Transform lastSafePosition = safePositions.get(0);
            player.getWorld().execute(() -> {
                Vector3d lastSafePos = lastSafePosition.getPosition();
                store.putComponent(ref, Teleport.getComponentType(), (Component)new Teleport(player.getWorld(), new Vector3d(lastSafePos.getX(), lastSafePos.getY(), lastSafePos.getZ()), lastSafePosition.getRotation()));
                playerRef.sendMessage(TELEPORT_MESSAGE);
            });
            return;
        }
        safePositions = this.playerLastSafePositions.computeIfAbsent(playerRef.getUuid(), uuid -> new LinkedList());
        Transform currentTransform = playerRef.getTransform();
        if (safePositions.isEmpty()) {
            safePositions.add(currentTransform.clone());
        } else {
            double dz;
            double dy;
            Vector3d lastPos = ((Transform)safePositions.getLast()).getPosition();
            Vector3d currentPos = currentTransform.getPosition();
            double dx = lastPos.getX() - currentPos.getX();
            if (Math.sqrt(dx * dx + (dy = lastPos.getY() - currentPos.getY()) * dy + (dz = lastPos.getZ() - currentPos.getZ()) * dz) > 1.5) {
                safePositions.add(currentTransform.clone());
                if (safePositions.size() > 3) {
                    safePositions.remove(0);
                }
            }
        }
    }

    @NullableDecl
    public Query<EntityStore> getQuery() {
        return PlayerRef.getComponentType();
    }
}

