/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.systems.tick;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.chunk.ChunkInfo;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.spatial.SpatialResource;
import com.hypixel.hytale.component.system.tick.DelayedEntitySystem;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.protocol.Color;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.EntityModule;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.ParticleUtil;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.Random;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class ChunkBordersTickingSystem
extends DelayedEntitySystem<EntityStore> {
    private final Random random = new Random();

    public ChunkBordersTickingSystem() {
        super(0.5f);
    }

    public void tick(float v, int index, @NonNullDecl ArchetypeChunk<EntityStore> archetypeChunk, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer) {
        Ref ref = archetypeChunk.getReferenceTo(index);
        if (!ref.isValid()) {
            return;
        }
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        Vector3d pos = playerRef.getTransform().getPosition();
        int chunkX = ChunkUtil.chunkCoordinate((int)((int)pos.getX()));
        int chunkZ = ChunkUtil.chunkCoordinate((int)((int)pos.getZ()));
        String dimension = player.getWorld().getName();
        for (int x = chunkX - 1; x <= chunkX + 1; ++x) {
            for (int z = chunkZ - 1; z <= chunkZ + 1; ++z) {
                PartyInfo partyInfo;
                ChunkInfo chunkInfo = ClaimManager.getInstance().getChunk(dimension, x, z);
                if (chunkInfo == null || (partyInfo = ClaimManager.getInstance().getPartyById(chunkInfo.getPartyOwner())) == null || !this.isNearBorder(pos, x, z)) continue;
                this.spawnChunkBorderParticles(x, z, partyInfo, store, pos, dimension);
            }
        }
    }

    private boolean isNearBorder(Vector3d pos, int chunkX, int chunkZ) {
        int minX = ChunkUtil.minBlock((int)chunkX);
        int minZ = ChunkUtil.minBlock((int)chunkZ);
        int maxX = ChunkUtil.maxBlock((int)chunkX) + 1;
        int maxZ = ChunkUtil.maxBlock((int)chunkZ) + 1;
        double distMinX = Math.abs(pos.getX() - (double)minX);
        double distMaxX = Math.abs(pos.getX() - (double)maxX);
        double distMinZ = Math.abs(pos.getZ() - (double)minZ);
        double distMaxZ = Math.abs(pos.getZ() - (double)maxZ);
        double threshold = 5.0;
        return distMinX < threshold || distMaxX < threshold || distMinZ < threshold || distMaxZ < threshold;
    }

    private void spawnChunkBorderParticles(int chunkX, int chunkZ, PartyInfo partyInfo, Store<EntityStore> store, Vector3d playerPos, String dimension) {
        double x;
        ObjectList playerRefs;
        Vector3d pos;
        double z;
        ChunkInfo adjacent;
        int minX = ChunkUtil.minBlock((int)chunkX);
        int minZ = ChunkUtil.minBlock((int)chunkZ);
        int maxX = ChunkUtil.maxBlock((int)chunkX) + 1;
        int maxZ = ChunkUtil.maxBlock((int)chunkZ) + 1;
        double threshold = 5.0;
        double playerY = playerPos.getY();
        String particleName = "Buuz135_SimpleClaims_Spawn";
        SpatialResource playerSpatialResource = (SpatialResource)store.getResource(EntityModule.get().getPlayerSpatialResourceType());
        int colorInt = partyInfo.getColor();
        Color particleColor = new Color((byte)(colorInt >> 16 & 0xFF), (byte)(colorInt >> 8 & 0xFF), (byte)(colorInt & 0xFF));
        if (Math.abs(playerPos.getX() - (double)minX) < threshold && ((adjacent = ClaimManager.getInstance().getChunk(dimension, chunkX - 1, chunkZ)) == null || !adjacent.getPartyOwner().equals(partyInfo.getId()))) {
            for (z = (double)minZ; z <= (double)maxZ; z += 0.5) {
                if (!(Math.abs(playerPos.getZ() - z) < threshold) || !this.random.nextBoolean()) continue;
                pos = new Vector3d((double)minX, playerY, z + this.randomOffset());
                playerRefs = SpatialResource.getThreadLocalReferenceList();
                playerSpatialResource.getSpatialStructure().collect(playerPos, 75.0, (List)playerRefs);
                ParticleUtil.spawnParticleEffect((String)particleName, (Vector3d)pos, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (Color)particleColor, (List)playerRefs, store);
            }
        }
        if (Math.abs(playerPos.getX() - (double)maxX) < threshold && ((adjacent = ClaimManager.getInstance().getChunk(dimension, chunkX + 1, chunkZ)) == null || !adjacent.getPartyOwner().equals(partyInfo.getId()))) {
            for (z = (double)minZ; z <= (double)maxZ; z += 0.5) {
                if (!(Math.abs(playerPos.getZ() - z) < threshold) || !this.random.nextBoolean()) continue;
                pos = new Vector3d((double)maxX, playerY, z + this.randomOffset());
                playerRefs = SpatialResource.getThreadLocalReferenceList();
                playerSpatialResource.getSpatialStructure().collect(playerPos, 75.0, (List)playerRefs);
                ParticleUtil.spawnParticleEffect((String)particleName, (Vector3d)pos, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (Color)particleColor, (List)playerRefs, store);
            }
        }
        if (Math.abs(playerPos.getZ() - (double)minZ) < threshold && ((adjacent = ClaimManager.getInstance().getChunk(dimension, chunkX, chunkZ - 1)) == null || !adjacent.getPartyOwner().equals(partyInfo.getId()))) {
            for (x = (double)minX; x <= (double)maxX; x += 0.5) {
                if (!(Math.abs(playerPos.getX() - x) < threshold) || !this.random.nextBoolean()) continue;
                pos = new Vector3d(x + this.randomOffset(), playerY, (double)minZ);
                playerRefs = SpatialResource.getThreadLocalReferenceList();
                playerSpatialResource.getSpatialStructure().collect(playerPos, 75.0, (List)playerRefs);
                ParticleUtil.spawnParticleEffect((String)particleName, (Vector3d)pos, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (Color)particleColor, (List)playerRefs, store);
            }
        }
        if (Math.abs(playerPos.getZ() - (double)maxZ) < threshold && ((adjacent = ClaimManager.getInstance().getChunk(dimension, chunkX, chunkZ + 1)) == null || !adjacent.getPartyOwner().equals(partyInfo.getId()))) {
            for (x = (double)minX; x <= (double)maxX; x += 0.5) {
                if (!(Math.abs(playerPos.getX() - x) < threshold) || !this.random.nextBoolean()) continue;
                pos = new Vector3d(x + this.randomOffset(), playerY, (double)maxZ);
                playerRefs = SpatialResource.getThreadLocalReferenceList();
                playerSpatialResource.getSpatialStructure().collect(playerPos, 75.0, (List)playerRefs);
                ParticleUtil.spawnParticleEffect((String)particleName, (Vector3d)pos, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (Color)particleColor, (List)playerRefs, store);
            }
        }
    }

    private double randomOffset() {
        return this.random.nextDouble() - 0.5;
    }

    @NullableDecl
    public Query<EntityStore> getQuery() {
        return PlayerRef.getComponentType();
    }
}

