/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.systems.events;

import com.buuz135.simpleclaims.Main;
import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.config.SimpleClaimsConfig;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.dependency.Dependency;
import com.hypixel.hytale.component.dependency.RootDependency;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.EntityEventSystem;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.ecs.UseBlockEvent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class InteractEventSystem
extends EntityEventSystem<EntityStore, UseBlockEvent.Pre> {
    public InteractEventSystem() {
        super(UseBlockEvent.Pre.class);
    }

    public void handle(int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer, @Nonnull UseBlockEvent.Pre event) {
        Ref ref = archetypeChunk.getReferenceTo(index);
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        Predicate<PartyInfo> defaultInteract = PartyInfo::isBlockInteractEnabled;
        String blockName = event.getBlockType().getId().toLowerCase(Locale.ROOT);
        for (String blocksThatIgnoreInteractRestriction : ((SimpleClaimsConfig)Main.CONFIG.get()).getBlocksThatIgnoreInteractRestrictions()) {
            if (!blockName.contains(blocksThatIgnoreInteractRestriction.toLowerCase(Locale.ROOT))) continue;
            return;
        }
        if (blockName.contains("chest")) {
            defaultInteract = PartyInfo::isChestInteractEnabled;
        } else if (blockName.contains("bench") && !blockName.contains("furniture")) {
            defaultInteract = PartyInfo::isBenchInteractEnabled;
        } else if (blockName.contains("door")) {
            defaultInteract = PartyInfo::isDoorInteractEnabled;
        } else if (blockName.contains("chair") || blockName.contains("stool") || blockName.contains("bench") && blockName.contains("furniture")) {
            defaultInteract = PartyInfo::isChairInteractEnabled;
        } else if (blockName.contains("portal") || blockName.contains("teleporter")) {
            defaultInteract = PartyInfo::isPortalInteractEnabled;
        }
        if (playerRef != null && !ClaimManager.getInstance().isAllowedToInteract(playerRef.getUuid(), player.getWorld().getName(), event.getTargetBlock().getX(), event.getTargetBlock().getZ(), defaultInteract)) {
            event.setCancelled(true);
        }
    }

    @Nullable
    public Query<EntityStore> getQuery() {
        return PlayerRef.getComponentType();
    }

    @NonNullDecl
    public Set<Dependency<EntityStore>> getDependencies() {
        return Collections.singleton(RootDependency.first());
    }
}

