/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.systems.events;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.chunk.ChunkInfo;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.dependency.Dependency;
import com.hypixel.hytale.component.dependency.RootDependency;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.modules.entity.damage.Damage;
import com.hypixel.hytale.server.core.modules.entity.damage.DamageEventSystem;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class CustomDamageEventSystem
extends DamageEventSystem {
    public void handle(int index, @NonNullDecl ArchetypeChunk<EntityStore> archetypeChunk, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer, @NonNullDecl Damage damage) {
        Player attackerPlayerComponent;
        Damage.EntitySource damageEntitySource;
        Ref attackerRef;
        Damage.Source source;
        Ref ref = archetypeChunk.getReferenceTo(index);
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        Vector3d transform = ((TransformComponent)store.getComponent(ref, TransformComponent.getComponentType())).getPosition();
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        if (playerRef != null && (source = damage.getSource()) instanceof Damage.EntitySource && (attackerRef = (damageEntitySource = (Damage.EntitySource)source).getRef()).isValid() && (attackerPlayerComponent = (Player)commandBuffer.getComponent(attackerRef, Player.getComponentType())) != null) {
            PlayerRef attackerPlayerRef;
            PartyInfo partyInfo;
            ChunkInfo chunk = ClaimManager.getInstance().getChunkRawCoords(player.getWorld().getName(), (int)transform.getX(), (int)transform.getZ());
            if (chunk != null && (partyInfo = ClaimManager.getInstance().getPartyById(chunk.getPartyOwner())) != null && !partyInfo.isPVPEnabled()) {
                damage.setCancelled(true);
            }
            if (!damage.isCancelled() && (attackerPlayerRef = (PlayerRef)commandBuffer.getComponent(attackerRef, PlayerRef.getComponentType())) != null) {
                PartyInfo attackerParty = ClaimManager.getInstance().getPartyFromPlayer(attackerPlayerRef.getUuid());
                PartyInfo victimParty = ClaimManager.getInstance().getPartyFromPlayer(playerRef.getUuid());
                if (attackerParty != null && victimParty != null && attackerParty.getId().equals(victimParty.getId()) && !attackerParty.isFriendlyFireEnabled()) {
                    damage.setCancelled(true);
                }
            }
        }
    }

    @Nullable
    public Query<EntityStore> getQuery() {
        return PlayerRef.getComponentType();
    }

    @NonNullDecl
    public Set<Dependency<EntityStore>> getDependencies() {
        return Collections.singleton(RootDependency.first());
    }
}

