/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.map;

import com.buuz135.simpleclaims.Main;
import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.chunk.ChunkInfo;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.config.SimpleClaimsConfig;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.protocol.packets.worldmap.MapImage;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.asset.type.environment.config.Environment;
import com.hypixel.hytale.server.core.asset.type.fluid.Fluid;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.chunk.ChunkColumn;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.hypixel.hytale.server.core.universe.world.chunk.section.FluidSection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomImageBuilder {
    private final long index;
    private final World world;
    @Nonnull
    private final MapImage image;
    private final int sampleWidth;
    private final int sampleHeight;
    private final int blockStepX;
    private final int blockStepZ;
    @Nonnull
    private final short[] heightSamples;
    @Nonnull
    private final int[] tintSamples;
    @Nonnull
    private final int[] blockSamples;
    @Nonnull
    private final short[] neighborHeightSamples;
    @Nonnull
    private final short[] fluidDepthSamples;
    @Nonnull
    private final int[] environmentSamples;
    @Nonnull
    private final int[] fluidSamples;
    private final Color outColor = new Color();
    @Nullable
    private WorldChunk worldChunk;
    private FluidSection[] fluidSections;

    public CustomImageBuilder(long index, int imageWidth, int imageHeight, World world) {
        this.index = index;
        this.world = world;
        this.image = new MapImage(imageWidth, imageHeight, new int[imageWidth * imageHeight]);
        this.sampleWidth = Math.min(32, this.image.width);
        this.sampleHeight = Math.min(32, this.image.height);
        this.blockStepX = Math.max(1, 32 / this.image.width);
        this.blockStepZ = Math.max(1, 32 / this.image.height);
        this.heightSamples = new short[this.sampleWidth * this.sampleHeight];
        this.tintSamples = new int[this.sampleWidth * this.sampleHeight];
        this.blockSamples = new int[this.sampleWidth * this.sampleHeight];
        this.neighborHeightSamples = new short[(this.sampleWidth + 2) * (this.sampleHeight + 2)];
        this.fluidDepthSamples = new short[this.sampleWidth * this.sampleHeight];
        this.environmentSamples = new int[this.sampleWidth * this.sampleHeight];
        this.fluidSamples = new int[this.sampleWidth * this.sampleHeight];
    }

    public long getIndex() {
        return this.index;
    }

    @Nonnull
    public MapImage getImage() {
        return this.image;
    }

    @Nonnull
    private CompletableFuture<CustomImageBuilder> fetchChunk() {
        return this.world.getChunkStore().getChunkReferenceAsync(this.index).thenApplyAsync(ref -> {
            if (ref != null && ref.isValid()) {
                this.worldChunk = (WorldChunk)ref.getStore().getComponent(ref, WorldChunk.getComponentType());
                ChunkColumn chunkColumn = (ChunkColumn)ref.getStore().getComponent(ref, ChunkColumn.getComponentType());
                this.fluidSections = new FluidSection[10];
                for (int y = 0; y < 10; ++y) {
                    Ref sectionRef = chunkColumn.getSection(y);
                    this.fluidSections[y] = (FluidSection)this.world.getChunkStore().getStore().getComponent(sectionRef, FluidSection.getComponentType());
                }
                return this;
            }
            return null;
        }, (Executor)this.world);
    }

    @Nonnull
    private CompletableFuture<CustomImageBuilder> sampleNeighborsSync() {
        CompletionStage north = this.world.getChunkStore().getChunkReferenceAsync(ChunkUtil.indexChunk((int)this.worldChunk.getX(), (int)(this.worldChunk.getZ() - 1))).thenAcceptAsync(ref -> {
            if (ref != null && ref.isValid()) {
                WorldChunk worldChunk = (WorldChunk)ref.getStore().getComponent(ref, WorldChunk.getComponentType());
                int z = (this.sampleHeight - 1) * this.blockStepZ;
                for (int ix = 0; ix < this.sampleWidth; ++ix) {
                    int x = ix * this.blockStepX;
                    this.neighborHeightSamples[1 + ix] = worldChunk.getHeight(x, z);
                }
            }
        }, (Executor)this.world);
        CompletionStage south = this.world.getChunkStore().getChunkReferenceAsync(ChunkUtil.indexChunk((int)this.worldChunk.getX(), (int)(this.worldChunk.getZ() + 1))).thenAcceptAsync(ref -> {
            if (ref != null && ref.isValid()) {
                WorldChunk worldChunk = (WorldChunk)ref.getStore().getComponent(ref, WorldChunk.getComponentType());
                int z = 0;
                int neighbourStartIndex = (this.sampleHeight + 1) * (this.sampleWidth + 2) + 1;
                for (int ix = 0; ix < this.sampleWidth; ++ix) {
                    int x = ix * this.blockStepX;
                    this.neighborHeightSamples[neighbourStartIndex + ix] = worldChunk.getHeight(x, z);
                }
            }
        }, (Executor)this.world);
        CompletionStage west = this.world.getChunkStore().getChunkReferenceAsync(ChunkUtil.indexChunk((int)(this.worldChunk.getX() - 1), (int)this.worldChunk.getZ())).thenAcceptAsync(ref -> {
            if (ref != null && ref.isValid()) {
                WorldChunk worldChunk = (WorldChunk)ref.getStore().getComponent(ref, WorldChunk.getComponentType());
                int x = (this.sampleWidth - 1) * this.blockStepX;
                for (int iz = 0; iz < this.sampleHeight; ++iz) {
                    int z = iz * this.blockStepZ;
                    this.neighborHeightSamples[(iz + 1) * (this.sampleWidth + 2)] = worldChunk.getHeight(x, z);
                }
            }
        }, (Executor)this.world);
        CompletionStage east = this.world.getChunkStore().getChunkReferenceAsync(ChunkUtil.indexChunk((int)(this.worldChunk.getX() + 1), (int)this.worldChunk.getZ())).thenAcceptAsync(ref -> {
            if (ref != null && ref.isValid()) {
                WorldChunk worldChunk = (WorldChunk)ref.getStore().getComponent(ref, WorldChunk.getComponentType());
                int x = 0;
                for (int iz = 0; iz < this.sampleHeight; ++iz) {
                    int z = iz * this.blockStepZ;
                    this.neighborHeightSamples[(iz + 1) * (this.sampleWidth + 2) + this.sampleWidth + 1] = worldChunk.getHeight(x, z);
                }
            }
        }, (Executor)this.world);
        CompletionStage northeast = this.world.getChunkStore().getChunkReferenceAsync(ChunkUtil.indexChunk((int)(this.worldChunk.getX() + 1), (int)(this.worldChunk.getZ() - 1))).thenAcceptAsync(ref -> {
            if (ref != null && ref.isValid()) {
                WorldChunk worldChunk = (WorldChunk)ref.getStore().getComponent(ref, WorldChunk.getComponentType());
                int x = 0;
                int z = (this.sampleHeight - 1) * this.blockStepZ;
                this.neighborHeightSamples[0] = worldChunk.getHeight(x, z);
            }
        }, (Executor)this.world);
        CompletionStage northwest = this.world.getChunkStore().getChunkReferenceAsync(ChunkUtil.indexChunk((int)(this.worldChunk.getX() - 1), (int)(this.worldChunk.getZ() - 1))).thenAcceptAsync(ref -> {
            if (ref != null && ref.isValid()) {
                WorldChunk worldChunk = (WorldChunk)ref.getStore().getComponent(ref, WorldChunk.getComponentType());
                int x = (this.sampleWidth - 1) * this.blockStepX;
                int z = (this.sampleHeight - 1) * this.blockStepZ;
                this.neighborHeightSamples[this.sampleWidth + 1] = worldChunk.getHeight(x, z);
            }
        }, (Executor)this.world);
        CompletionStage southeast = this.world.getChunkStore().getChunkReferenceAsync(ChunkUtil.indexChunk((int)(this.worldChunk.getX() + 1), (int)(this.worldChunk.getZ() + 1))).thenAcceptAsync(ref -> {
            if (ref != null && ref.isValid()) {
                WorldChunk worldChunk = (WorldChunk)ref.getStore().getComponent(ref, WorldChunk.getComponentType());
                int x = 0;
                int z = 0;
                this.neighborHeightSamples[(this.sampleHeight + 1) * (this.sampleWidth + 2) + this.sampleWidth + 1] = worldChunk.getHeight(x, z);
            }
        }, (Executor)this.world);
        CompletionStage southwest = this.world.getChunkStore().getChunkReferenceAsync(ChunkUtil.indexChunk((int)(this.worldChunk.getX() - 1), (int)(this.worldChunk.getZ() + 1))).thenAcceptAsync(ref -> {
            if (ref != null && ref.isValid()) {
                WorldChunk worldChunk = (WorldChunk)ref.getStore().getComponent(ref, WorldChunk.getComponentType());
                int x = (this.sampleWidth - 1) * this.blockStepX;
                int z = 0;
                this.neighborHeightSamples[(this.sampleHeight + 1) * (this.sampleWidth + 2)] = worldChunk.getHeight(x, z);
            }
        }, (Executor)this.world);
        return CompletableFuture.allOf(new CompletableFuture[]{north, south, west, east, northeast, northwest, southeast, southwest}).thenApply(v -> this);
    }

    private CustomImageBuilder generateImageAsync() {
        for (int ix = 0; ix < this.sampleWidth; ++ix) {
            for (int iz = 0; iz < this.sampleHeight; ++iz) {
                int blockId;
                int sampleIndex = iz * this.sampleWidth + ix;
                int x = ix * this.blockStepX;
                int z = iz * this.blockStepZ;
                int height = this.worldChunk.getHeight(x, z);
                int tint = this.worldChunk.getTint(x, z);
                this.heightSamples[sampleIndex] = height;
                this.tintSamples[sampleIndex] = tint;
                this.blockSamples[sampleIndex] = blockId = this.worldChunk.getBlock(x, height, z);
                int fluidId = 0;
                int fluidTop = 320;
                Fluid fluid = null;
                int chunkYGround = ChunkUtil.chunkCoordinate((int)height);
                int chunkY = 9;
                block2: while (chunkY >= 0 && chunkY >= chunkYGround) {
                    FluidSection fluidSection = this.fluidSections[chunkY];
                    if (fluidSection != null && !fluidSection.isEmpty()) {
                        int maxBlockY;
                        int minBlockY = Math.max(ChunkUtil.minBlock((int)chunkY), height);
                        for (int blockY = maxBlockY = ChunkUtil.maxBlock((int)chunkY); blockY >= minBlockY; --blockY) {
                            fluidId = fluidSection.getFluidId(x, blockY, z);
                            if (fluidId == 0) continue;
                            fluid = (Fluid)Fluid.getAssetMap().getAsset(fluidId);
                            fluidTop = blockY;
                            break block2;
                        }
                        --chunkY;
                        continue;
                    }
                    --chunkY;
                }
                int fluidBottom = height;
                block4: while (chunkY >= 0 && chunkY >= chunkYGround) {
                    int maxBlockY;
                    FluidSection fluidSection = this.fluidSections[chunkY];
                    if (fluidSection == null || fluidSection.isEmpty()) {
                        fluidBottom = Math.min(ChunkUtil.maxBlock((int)chunkY) + 1, fluidTop);
                        break;
                    }
                    int minBlockY = Math.max(ChunkUtil.minBlock((int)chunkY), height);
                    for (int blockY = maxBlockY = Math.min(ChunkUtil.maxBlock((int)chunkY), fluidTop - 1); blockY >= minBlockY; --blockY) {
                        int nextFluidId = fluidSection.getFluidId(x, blockY, z);
                        if (nextFluidId == fluidId) continue;
                        Fluid nextFluid = (Fluid)Fluid.getAssetMap().getAsset(nextFluidId);
                        if (Objects.equals(fluid.getParticleColor(), nextFluid.getParticleColor())) continue;
                        fluidBottom = blockY + 1;
                        break block4;
                    }
                    --chunkY;
                }
                short fluidDepth = fluidId != 0 ? (short)(fluidTop - fluidBottom + 1) : (short)0;
                int environmentId = this.worldChunk.getBlockChunk().getEnvironment(x, fluidTop, z);
                this.fluidDepthSamples[sampleIndex] = fluidDepth;
                this.environmentSamples[sampleIndex] = environmentId;
                this.fluidSamples[sampleIndex] = fluidId;
            }
        }
        float imageToSampleRatioWidth = (float)this.sampleWidth / (float)this.image.width;
        float imageToSampleRatioHeight = (float)this.sampleHeight / (float)this.image.height;
        int blockPixelWidth = Math.max(1, this.image.width / this.sampleWidth);
        int blockPixelHeight = Math.max(1, this.image.height / this.sampleHeight);
        for (int iz = 0; iz < this.sampleHeight; ++iz) {
            System.arraycopy(this.heightSamples, iz * this.sampleWidth, this.neighborHeightSamples, (iz + 1) * (this.sampleWidth + 2) + 1, this.sampleWidth);
        }
        int chunkX = ChunkUtil.xOfChunkIndex((long)this.index);
        int chunkZ = ChunkUtil.zOfChunkIndex((long)this.index);
        int minBlockX = ChunkUtil.minBlock((int)chunkX);
        int minBlockZ = ChunkUtil.minBlock((int)chunkZ);
        ChunkInfo claimedChunk = ClaimManager.getInstance().getChunk(this.worldChunk.getWorld().getName(), this.worldChunk.getX(), this.worldChunk.getZ());
        PartyInfo partyInfo = null;
        if (claimedChunk != null) {
            partyInfo = ClaimManager.getInstance().getPartyById(claimedChunk.getPartyOwner());
        }
        ChunkInfo[] nearbyChunks = new ChunkInfo[]{ClaimManager.getInstance().getChunk(this.worldChunk.getWorld().getName(), this.worldChunk.getX(), this.worldChunk.getZ() + 1), ClaimManager.getInstance().getChunk(this.worldChunk.getWorld().getName(), this.worldChunk.getX(), this.worldChunk.getZ() - 1), ClaimManager.getInstance().getChunk(this.worldChunk.getWorld().getName(), this.worldChunk.getX() + 1, this.worldChunk.getZ()), ClaimManager.getInstance().getChunk(this.worldChunk.getWorld().getName(), this.worldChunk.getX() - 1, this.worldChunk.getZ())};
        for (int ix = 0; ix < this.image.width; ++ix) {
            for (int iz = 0; iz < this.image.height; ++iz) {
                int fluidId;
                int sampleX = Math.min((int)((float)ix * imageToSampleRatioWidth), this.sampleWidth - 1);
                int sampleZ = Math.min((int)((float)iz * imageToSampleRatioHeight), this.sampleHeight - 1);
                int sampleIndex = sampleZ * this.sampleWidth + sampleX;
                int blockPixelX = ix % blockPixelWidth;
                int blockPixelZ = iz % blockPixelHeight;
                short height = this.heightSamples[sampleIndex];
                int tint = this.tintSamples[sampleIndex];
                int blockId = this.blockSamples[sampleIndex];
                CustomImageBuilder.getBlockColor(blockId, tint, this.outColor);
                short north = this.neighborHeightSamples[sampleZ * (this.sampleWidth + 2) + sampleX + 1];
                short south = this.neighborHeightSamples[(sampleZ + 2) * (this.sampleWidth + 2) + sampleX + 1];
                short west = this.neighborHeightSamples[(sampleZ + 1) * (this.sampleWidth + 2) + sampleX];
                short east = this.neighborHeightSamples[(sampleZ + 1) * (this.sampleWidth + 2) + sampleX + 2];
                short northWest = this.neighborHeightSamples[sampleZ * (this.sampleWidth + 2) + sampleX];
                short northEast = this.neighborHeightSamples[sampleZ * (this.sampleWidth + 2) + sampleX + 2];
                short southWest = this.neighborHeightSamples[(sampleZ + 2) * (this.sampleWidth + 2) + sampleX];
                short southEast = this.neighborHeightSamples[(sampleZ + 2) * (this.sampleWidth + 2) + sampleX + 2];
                float shade = CustomImageBuilder.shadeFromHeights(blockPixelX, blockPixelZ, blockPixelWidth, blockPixelHeight, height, north, south, west, east, northWest, northEast, southWest, southEast);
                this.outColor.multiply(shade);
                if (height < 320 && (fluidId = this.fluidSamples[sampleIndex]) != 0) {
                    short fluidDepth = this.fluidDepthSamples[sampleIndex];
                    int environmentId = this.environmentSamples[sampleIndex];
                    CustomImageBuilder.getFluidColor(fluidId, environmentId, fluidDepth, this.outColor);
                }
                if (partyInfo != null) {
                    boolean isBorder = false;
                    int borderSize = 2;
                    if (!((ix > borderSize || nearbyChunks[3] != null && nearbyChunks[3].getPartyOwner().equals(partyInfo.getId())) && (ix < this.image.width - borderSize - 1 || nearbyChunks[2] != null && nearbyChunks[2].getPartyOwner().equals(partyInfo.getId())) && (iz > borderSize || nearbyChunks[1] != null && nearbyChunks[1].getPartyOwner().equals(partyInfo.getId())) && (iz < this.image.height - borderSize - 1 || nearbyChunks[0] != null && nearbyChunks[0].getPartyOwner().equals(partyInfo.getId())))) {
                        isBorder = true;
                    }
                    CustomImageBuilder.getForceBlockColor(blockId, partyInfo.getColor(), this.outColor, isBorder);
                }
                this.populateImageData(iz * this.image.width + ix, sampleX, sampleZ, minBlockX, minBlockZ);
            }
        }
        if (partyInfo != null && ((SimpleClaimsConfig)Main.CONFIG.get()).isRenderClaimNamesOnWorldMap()) {
            String name = partyInfo.getName().toUpperCase();
            this.drawText(this.image, 1, 1, name, new Color(0, 0, 0, 255).pack());
            this.drawText(this.image, 1, 2, name, new Color(0, 0, 0, 255).pack());
            this.drawText(this.image, 1, 3, name, new Color(0, 0, 0, 255).pack());
            this.drawText(this.image, 2, 1, name, new Color(0, 0, 0, 255).pack());
            this.drawText(this.image, 2, 3, name, new Color(0, 0, 0, 255).pack());
            this.drawText(this.image, 3, 1, name, new Color(0, 0, 0, 255).pack());
            this.drawText(this.image, 3, 2, name, new Color(0, 0, 0, 255).pack());
            this.drawText(this.image, 3, 3, name, new Color(0, 0, 0, 255).pack());
            this.drawText(this.image, 2, 2, name, new Color(255, 255, 255, 255).pack());
        }
        return this;
    }

    private static float shadeFromHeights(int blockPixelX, int blockPixelZ, int blockPixelWidth, int blockPixelHeight, short height, short north, short south, short west, short east, short northWest, short northEast, short southWest, short southEast) {
        float u = ((float)blockPixelX + 0.5f) / (float)blockPixelWidth;
        float v = ((float)blockPixelZ + 0.5f) / (float)blockPixelHeight;
        float ud = (u + v) / 2.0f;
        float vd = (1.0f - u + v) / 2.0f;
        float dhdx1 = (float)(height - west) * (1.0f - u) + (float)(east - height) * u;
        float dhdz1 = (float)(height - north) * (1.0f - v) + (float)(south - height) * v;
        float dhdx2 = (float)(height - northWest) * (1.0f - ud) + (float)(southEast - height) * ud;
        float dhdz2 = (float)(height - northEast) * (1.0f - vd) + (float)(southWest - height) * vd;
        float dhdx = dhdx1 * 2.0f + dhdx2;
        float dhdz = dhdz1 * 2.0f + dhdz2;
        float dy = 3.0f;
        float invS = 1.0f / (float)Math.sqrt(dhdx * dhdx + dy * dy + dhdz * dhdz);
        float nx = dhdx * invS;
        float ny = dy * invS;
        float nz = dhdz * invS;
        float lx = -0.2f;
        float ly = 0.8f;
        float lz = 0.5f;
        float invL = 1.0f / (float)Math.sqrt(lx * lx + ly * ly + lz * lz);
        float lambert = Math.max(0.0f, nx * (lx *= invL) + ny * (ly *= invL) + nz * (lz *= invL));
        float ambient = 0.4f;
        float diffuse = 0.6f;
        return ambient + diffuse * lambert;
    }

    private static void getBlockColor(int blockId, int biomeTintColor, @Nonnull Color outColor) {
        BlockType block = (BlockType)BlockType.getAssetMap().getAsset(blockId);
        int biomeTintR = biomeTintColor >> 16 & 0xFF;
        int biomeTintG = biomeTintColor >> 8 & 0xFF;
        int biomeTintB = biomeTintColor >> 0 & 0xFF;
        com.hypixel.hytale.protocol.Color[] tintUp = block.getTintUp();
        boolean hasTint = tintUp != null && tintUp.length > 0;
        int selfTintR = hasTint ? tintUp[0].red & 0xFF : 255;
        int selfTintG = hasTint ? tintUp[0].green & 0xFF : 255;
        int selfTintB = hasTint ? tintUp[0].blue & 0xFF : 255;
        float biomeTintMultiplier = (float)block.getBiomeTintUp() / 100.0f;
        int tintColorR = (int)((float)selfTintR + (float)(biomeTintR - selfTintR) * biomeTintMultiplier);
        int tintColorG = (int)((float)selfTintG + (float)(biomeTintG - selfTintG) * biomeTintMultiplier);
        int tintColorB = (int)((float)selfTintB + (float)(biomeTintB - selfTintB) * biomeTintMultiplier);
        com.hypixel.hytale.protocol.Color particleColor = block.getParticleColor();
        if (particleColor != null && biomeTintMultiplier < 1.0f) {
            tintColorR = tintColorR * (particleColor.red & 0xFF) / 255;
            tintColorG = tintColorG * (particleColor.green & 0xFF) / 255;
            tintColorB = tintColorB * (particleColor.blue & 0xFF) / 255;
        }
        outColor.r = tintColorR & 0xFF;
        outColor.g = tintColorG & 0xFF;
        outColor.b = tintColorB & 0xFF;
        outColor.a = 255;
    }

    private static void getForceBlockColor(int blockId, int partyColor, @Nonnull Color outColor, boolean isBorder) {
        int biomeTintR = partyColor >> 16 & 0xFF;
        int biomeTintG = partyColor >> 8 & 0xFF;
        int biomeTintB = partyColor >> 0 & 0xFF;
        float overlayAlpha = isBorder ? 0.75f : 0.4f;
        outColor.r = (int)((float)outColor.r * (1.0f - overlayAlpha) + (float)biomeTintR * overlayAlpha);
        outColor.g = (int)((float)outColor.g * (1.0f - overlayAlpha) + (float)biomeTintG * overlayAlpha);
        outColor.b = (int)((float)outColor.b * (1.0f - overlayAlpha) + (float)biomeTintB * overlayAlpha);
        outColor.a = 255;
    }

    private static void getFluidColor(int fluidId, int environmentId, int fluidDepth, @Nonnull Color outColor) {
        Fluid fluid;
        com.hypixel.hytale.protocol.Color partcileColor;
        int tintColorR = 255;
        int tintColorG = 255;
        int tintColorB = 255;
        Environment environment = (Environment)Environment.getAssetMap().getAsset(environmentId);
        com.hypixel.hytale.protocol.Color waterTint = environment.getWaterTint();
        if (waterTint != null) {
            tintColorR = tintColorR * (waterTint.red & 0xFF) / 255;
            tintColorG = tintColorG * (waterTint.green & 0xFF) / 255;
            tintColorB = tintColorB * (waterTint.blue & 0xFF) / 255;
        }
        if ((partcileColor = (fluid = (Fluid)Fluid.getAssetMap().getAsset(fluidId)).getParticleColor()) != null) {
            tintColorR = tintColorR * (partcileColor.red & 0xFF) / 255;
            tintColorG = tintColorG * (partcileColor.green & 0xFF) / 255;
            tintColorB = tintColorB * (partcileColor.blue & 0xFF) / 255;
        }
        float depthMultiplier = Math.min(1.0f, 1.0f / (float)fluidDepth);
        outColor.r = (int)((float)tintColorR + (float)((outColor.r & 0xFF) - tintColorR) * depthMultiplier) & 0xFF;
        outColor.g = (int)((float)tintColorG + (float)((outColor.g & 0xFF) - tintColorG) * depthMultiplier) & 0xFF;
        outColor.b = (int)((float)tintColorB + (float)((outColor.b & 0xFF) - tintColorB) * depthMultiplier) & 0xFF;
    }

    private void populateImageData(int pixelIndex, int sampleX, int sampleZ, int minBlockX, int minBlockZ) {
        this.image.data[pixelIndex] = this.outColor.pack();
    }

    private void drawText(MapImage image, int x, int y, String text, int color) {
        for (int i = 0; i < text.length(); ++i) {
            this.drawChar(image, x + i * 4 + 4, y + 4, text.charAt(i), color);
        }
    }

    private void drawChar(MapImage image, int x, int y, char c, int color) {
        if (c == ' ') {
            return;
        }
        byte[] glyph = this.getGlyph(c);
        for (int gy = 0; gy < 5; ++gy) {
            for (int gx = 0; gx < 3; ++gx) {
                if ((glyph[gy] >> 2 - gx & 1) != 1) continue;
                int px = x + gx;
                int py = y + gy;
                if (px < 0 || px >= image.width || py < 0 || py >= image.height) continue;
                image.data[py * image.width + px] = color;
            }
        }
    }

    private byte[] getGlyph(char c) {
        switch (Character.toUpperCase(c)) {
            case 'A': {
                return new byte[]{2, 5, 7, 5, 5};
            }
            case 'B': {
                return new byte[]{6, 5, 6, 5, 6};
            }
            case 'C': {
                return new byte[]{3, 4, 4, 4, 3};
            }
            case 'D': {
                return new byte[]{6, 5, 5, 5, 6};
            }
            case 'E': {
                return new byte[]{7, 4, 6, 4, 7};
            }
            case 'F': {
                return new byte[]{7, 4, 6, 4, 4};
            }
            case 'G': {
                return new byte[]{3, 4, 5, 5, 3};
            }
            case 'H': {
                return new byte[]{5, 5, 7, 5, 5};
            }
            case 'I': {
                return new byte[]{7, 2, 2, 2, 7};
            }
            case 'J': {
                return new byte[]{1, 1, 1, 5, 2};
            }
            case 'K': {
                return new byte[]{5, 5, 6, 5, 5};
            }
            case 'L': {
                return new byte[]{4, 4, 4, 4, 7};
            }
            case 'M': {
                return new byte[]{5, 7, 5, 5, 5};
            }
            case 'N': {
                return new byte[]{5, 7, 7, 5, 5};
            }
            case 'O': {
                return new byte[]{2, 5, 5, 5, 2};
            }
            case 'P': {
                return new byte[]{6, 5, 6, 4, 4};
            }
            case 'Q': {
                return new byte[]{2, 5, 5, 3, 1};
            }
            case 'R': {
                return new byte[]{6, 5, 6, 5, 5};
            }
            case 'S': {
                return new byte[]{3, 4, 2, 1, 6};
            }
            case 'T': {
                return new byte[]{7, 2, 2, 2, 2};
            }
            case 'U': {
                return new byte[]{5, 5, 5, 5, 7};
            }
            case 'V': {
                return new byte[]{5, 5, 5, 5, 2};
            }
            case 'W': {
                return new byte[]{5, 5, 5, 7, 5};
            }
            case 'X': {
                return new byte[]{5, 5, 2, 5, 5};
            }
            case 'Y': {
                return new byte[]{5, 5, 2, 2, 2};
            }
            case 'Z': {
                return new byte[]{7, 1, 2, 4, 7};
            }
            case ' ': {
                return new byte[]{0, 0, 0, 0, 0};
            }
            case '0': {
                return new byte[]{7, 5, 5, 5, 7};
            }
            case '1': {
                return new byte[]{2, 6, 2, 2, 7};
            }
            case '2': {
                return new byte[]{7, 1, 7, 4, 7};
            }
            case '3': {
                return new byte[]{7, 1, 7, 1, 7};
            }
            case '4': {
                return new byte[]{5, 5, 7, 1, 1};
            }
            case '5': {
                return new byte[]{7, 4, 7, 1, 7};
            }
            case '6': {
                return new byte[]{7, 4, 7, 5, 7};
            }
            case '7': {
                return new byte[]{7, 1, 1, 1, 1};
            }
            case '8': {
                return new byte[]{7, 5, 7, 5, 7};
            }
            case '9': {
                return new byte[]{7, 5, 7, 1, 1};
            }
        }
        return new byte[]{0, 0, 0, 0, 0};
    }

    @Nonnull
    public static CompletableFuture<CustomImageBuilder> build(long index, int imageWidth, int imageHeight, World world) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(new CustomImageBuilder(index, imageWidth, imageHeight, world)).thenCompose(CustomImageBuilder::fetchChunk)).thenCompose(builder -> builder != null ? builder.sampleNeighborsSync() : CompletableFuture.completedFuture(null))).thenApplyAsync(builder -> builder != null ? builder.generateImageAsync() : null);
    }

    private static class Color {
        public int r;
        public int g;
        public int b;
        public int a;

        public Color(int r, int g, int b, int a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public Color() {
        }

        public int pack() {
            return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.a & 0xFF;
        }

        public void multiply(float value) {
            this.r = Math.min(255, Math.max(0, (int)((float)this.r * value)));
            this.g = Math.min(255, Math.max(0, (int)((float)this.g * value)));
            this.b = Math.min(255, Math.max(0, (int)((float)this.b * value)));
        }
    }
}

