/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.gui;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.buuz135.simpleclaims.gui.ChunkInfoGui;
import com.buuz135.simpleclaims.gui.PartyInfoEditGui;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class PartyListGui
extends InteractiveCustomUIPage<PartyListCodec> {
    private String searchQuery = "";
    private String requestingConfirmation = "-1";

    public PartyListGui(@NonNullDecl PlayerRef playerRef) {
        super(playerRef, CustomPageLifetime.CanDismiss, PartyListCodec.CODEC);
    }

    public void handleDataEvent(@NonNullDecl Ref<EntityStore> ref, @NonNullDecl Store<EntityStore> store, @NonNullDecl PartyListCodec data) {
        String[] split;
        super.handleDataEvent(ref, store, (Object)data);
        if (data.searchQuery != null) {
            this.searchQuery = data.searchQuery;
            UICommandBuilder commandBuilder = new UICommandBuilder();
            UIEventBuilder eventBuilder = new UIEventBuilder();
            this.buildList(ref, commandBuilder, eventBuilder, (ComponentAccessor<EntityStore>)store);
            this.sendUpdate(commandBuilder, eventBuilder, false);
            return;
        }
        if (data.action != null) {
            PartyInfo party;
            split = data.action.split(":");
            if (split[0].equals("Edit")) {
                PartyInfo party2 = ClaimManager.getInstance().getPartyById(UUID.fromString(split[1]));
                if (party2 != null) {
                    Player player = (Player)store.getComponent(ref, Player.getComponentType());
                    player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new PartyInfoEditGui(this.playerRef, party2, true));
                }
                return;
            }
            if (split[0].equals("Use") && (party = ClaimManager.getInstance().getPartyById(UUID.fromString(split[1]))) != null) {
                ClaimManager.getInstance().getAdminUsageParty().put(this.playerRef.getUuid(), UUID.fromString(split[1]));
                this.playerRef.sendMessage(Message.join((Message[])new Message[]{CommandMessages.NOW_USING_PARTY, Message.raw((String)party.getName())}));
                return;
            }
            if (split[0].equals("Claim") && (party = ClaimManager.getInstance().getPartyById(UUID.fromString(split[1]))) != null) {
                ClaimManager.getInstance().getAdminUsageParty().put(this.playerRef.getUuid(), UUID.fromString(split[1]));
                this.playerRef.sendMessage(Message.join((Message[])new Message[]{CommandMessages.NOW_USING_PARTY, Message.raw((String)party.getName())}));
                Player player = (Player)store.getComponent(ref, Player.getComponentType());
                TransformComponent position = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new ChunkInfoGui(this.playerRef, player.getWorld().getName(), ChunkUtil.chunkCoordinate((double)position.getPosition().getX()), ChunkUtil.chunkCoordinate((double)position.getPosition().getZ()), true));
                return;
            }
        }
        if (data.removeButtonAction != null) {
            PartyInfo party;
            split = data.removeButtonAction.split(":");
            String action = split[0];
            String index = split[1];
            if (action.equals("Click")) {
                this.requestingConfirmation = index;
            }
            if (action.equals("Delete") && (party = ClaimManager.getInstance().getPartyById(UUID.fromString(index))) != null) {
                ClaimManager.getInstance().disbandParty(party);
                ClaimManager.getInstance().markDirty();
                this.playerRef.sendMessage(CommandMessages.PARTY_DISBANDED);
            }
            UICommandBuilder commandBuilder = new UICommandBuilder();
            UIEventBuilder eventBuilder = new UIEventBuilder();
            this.build(ref, commandBuilder, eventBuilder, store);
            this.sendUpdate(commandBuilder, eventBuilder, true);
            return;
        }
        this.sendUpdate();
    }

    public void build(@NonNullDecl Ref<EntityStore> ref, @NonNullDecl UICommandBuilder uiCommandBuilder, @NonNullDecl UIEventBuilder uiEventBuilder, @NonNullDecl Store<EntityStore> store) {
        uiCommandBuilder.append("Pages/Buuz135_SimpleClaims_OpPartyList.ui");
        uiCommandBuilder.set("#SearchInput.Value", this.searchQuery);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#SearchInput", EventData.of((String)"@SearchQuery", (String)"#SearchInput.Value"), false);
        this.buildList(ref, uiCommandBuilder, uiEventBuilder, (ComponentAccessor<EntityStore>)store);
    }

    private void buildList(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder uiCommandBuilder, @Nonnull UIEventBuilder uiEventBuilder, @Nonnull ComponentAccessor<EntityStore> store) {
        uiCommandBuilder.clear("#PartyCards");
        uiCommandBuilder.appendInline("#Main #PartyList", "Group #PartyCards { LayoutMode: Left; }");
        int i = 0;
        for (PartyInfo value : ClaimManager.getInstance().getParties().values()) {
            if (!value.getName().toLowerCase().contains(this.searchQuery.toLowerCase())) continue;
            uiCommandBuilder.append("#PartyCards", "Pages/Buuz135_SimpleClaims_OpPartyListEntry.ui");
            uiCommandBuilder.set("#PartyCards[" + i + "] #PartyName.Text", value.getName());
            uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PartyCards[" + i + "] #EditPartyButton", EventData.of((String)"Action", (String)("Edit:" + value.getId().toString())), false);
            uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PartyCards[" + i + "] #ClaimButton", EventData.of((String)"Action", (String)("Claim:" + value.getId().toString())), false);
            uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PartyCards[" + i + "] #UsePartyButton", EventData.of((String)"Action", (String)("Use:" + value.getId().toString())), false);
            if (this.requestingConfirmation.equals(value.getId().toString())) {
                uiCommandBuilder.set("#PartyCards[" + i + "] #RemovePartyButton.Text", "Are you sure?");
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PartyCards[" + i + "] #RemovePartyButton", EventData.of((String)"RemoveButtonAction", (String)("Delete:" + value.getId().toString())), false);
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.MouseExited, "#PartyCards[" + i + "] #RemovePartyButton", EventData.of((String)"RemoveButtonAction", (String)"Click:-1"), false);
            } else {
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PartyCards[" + i + "] #RemovePartyButton", EventData.of((String)"RemoveButtonAction", (String)("Click:" + value.getId().toString())), false);
            }
            ++i;
        }
    }

    public static class PartyListCodec {
        static final String KEY_ACTION = "Action";
        static final String KEY_SEARCH_QUERY = "@SearchQuery";
        static final String KEY_REMOVE_BUTTON_ACTION = "RemoveButtonAction";
        public static final BuilderCodec<PartyListCodec> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(PartyListCodec.class, PartyListCodec::new).addField(new KeyedCodec("@SearchQuery", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.searchQuery = s;
        }, searchGuiData -> searchGuiData.searchQuery)).addField(new KeyedCodec("Action", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.action = s;
        }, searchGuiData -> searchGuiData.action)).addField(new KeyedCodec("RemoveButtonAction", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.removeButtonAction = s;
        }, searchGuiData -> searchGuiData.removeButtonAction)).build();
        private String action;
        private String searchQuery;
        private String removeButtonAction;
    }
}

