/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.gui;

import com.buuz135.simpleclaims.Main;
import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.claim.party.PartyInvite;
import com.buuz135.simpleclaims.claim.party.PartyOverride;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.buuz135.simpleclaims.config.SimpleClaimsConfig;
import com.buuz135.simpleclaims.gui.subscreens.ChunkListGui;
import com.buuz135.simpleclaims.gui.subscreens.InteractGui;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.ui.DropdownEntryInfo;
import com.hypixel.hytale.server.core.ui.LocalizableString;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class PartyInfoEditGui
extends InteractiveCustomUIPage<PartyInfoData> {
    private final PartyInfo info;
    private String name;
    private String description;
    private int requestingConfirmation;
    private final boolean isOpEdit;
    private String inviteDropdown;
    private String alliesDropdown;

    public PartyInfoEditGui(@NonNullDecl PlayerRef playerRef, PartyInfo info, boolean isOpEdit) {
        super(playerRef, CustomPageLifetime.CanDismiss, PartyInfoData.CODEC);
        this.info = info;
        this.name = info.getName();
        this.description = info.getDescription();
        this.requestingConfirmation = -1;
        this.isOpEdit = isOpEdit;
    }

    public void handleDataEvent(@NonNullDecl Ref<EntityStore> ref, @NonNullDecl Store<EntityStore> store, @NonNullDecl PartyInfoData data) {
        boolean playerCanModify;
        super.handleDataEvent(ref, store, (Object)data);
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        boolean bl = playerCanModify = this.info.isOwner(this.playerRef.getUuid()) || this.isOpEdit;
        if (!playerCanModify) {
            UICommandBuilder commandBuilder = new UICommandBuilder();
            UIEventBuilder eventBuilder = new UIEventBuilder();
            this.build(ref, commandBuilder, eventBuilder, store);
            this.sendUpdate(commandBuilder, eventBuilder, true);
            return;
        }
        if (data.name != null) {
            this.name = data.name;
        }
        if (data.description != null) {
            this.description = data.description;
        }
        if (data.save != null) {
            this.info.setName(this.name);
            this.info.setDescription(this.description);
            ClaimManager.getInstance().queueMapUpdateForParty(this.info);
            ClaimManager.getInstance().markDirty();
        }
        if (data.cancel != null) {
            this.close();
        }
        if (data.removeButtonAction != null) {
            String[] split = data.removeButtonAction.split(":");
            String action = split[0];
            if (action.equals("DeleteInvite")) {
                ClaimManager.getInstance().getPartyInvites().remove(UUID.fromString(split[1]));
                ClaimManager.getInstance().markDirty();
                UICommandBuilder commandBuilder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.build(ref, commandBuilder, eventBuilder, store);
                this.sendUpdate(commandBuilder, eventBuilder, true);
                return;
            }
            if (action.equals("DeleteAllyPlayer")) {
                this.info.getPlayerAllies().remove(UUID.fromString(split[1]));
                ClaimManager.getInstance().markDirty();
                UICommandBuilder commandBuilder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.build(ref, commandBuilder, eventBuilder, store);
                this.sendUpdate(commandBuilder, eventBuilder, true);
                return;
            }
            if (action.equals("DeleteAllyParty")) {
                this.info.getPartyAllies().remove(UUID.fromString(split[1]));
                ClaimManager.getInstance().markDirty();
                UICommandBuilder commandBuilder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.build(ref, commandBuilder, eventBuilder, store);
                this.sendUpdate(commandBuilder, eventBuilder, true);
                return;
            }
            int index = Integer.parseInt(split[1]);
            if (action.equals("Click")) {
                this.requestingConfirmation = index;
            }
            if (action.equals("Delete")) {
                this.info.removeMember(this.info.getMembers()[index]);
                ClaimManager.getInstance().markDirty();
            }
            if (action.equals("PlaceBlocksSetting")) {
                this.info.setOverride(new PartyOverride("simpleclaims.party.protection.place_blocks", new PartyOverride.PartyOverrideValue("bool", !this.info.isBlockPlaceEnabled())));
            }
            if (action.equals("BreakBlocksSetting")) {
                this.info.setOverride(new PartyOverride("simpleclaims.party.protection.break_blocks", new PartyOverride.PartyOverrideValue("bool", !this.info.isBlockBreakEnabled())));
            }
            if (action.equals("InteractBlocksSetting")) {
                this.info.setOverride(new PartyOverride("simpleclaims.party.protection.interact", new PartyOverride.PartyOverrideValue("bool", !this.info.isBlockInteractEnabled())));
            }
            if (action.equals("PVPSetting")) {
                this.info.setOverride(new PartyOverride("simpleclaims.party.protection.pvp", new PartyOverride.PartyOverrideValue("bool", !this.info.isPVPEnabled())));
            }
            if (action.equals("AllowEntrySetting")) {
                this.info.setOverride(new PartyOverride("simpleclaims.party.protection.allow_entry", new PartyOverride.PartyOverrideValue("bool", !this.info.isAllowEntryEnabled())));
            }
            if (action.equals("FriendlyFireSetting")) {
                this.info.setOverride(new PartyOverride("simpleclaims.party.protection.friendly_fire", new PartyOverride.PartyOverrideValue("bool", !this.info.isFriendlyFireEnabled())));
            }
            UICommandBuilder commandBuilder = new UICommandBuilder();
            UIEventBuilder eventBuilder = new UIEventBuilder();
            this.build(ref, commandBuilder, eventBuilder, store);
            this.sendUpdate(commandBuilder, eventBuilder, true);
            return;
        }
        if (data.claimColor != null) {
            try {
                this.info.setColor(0xFF000000 | Integer.parseInt(data.claimColor.substring(1, 7), 16));
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid color");
            }
        }
        if (data.inviteDropdown != null) {
            this.inviteDropdown = data.inviteDropdown;
        }
        if (data.alliesDropdown != null) {
            this.alliesDropdown = data.alliesDropdown;
        }
        if (data.button != null) {
            PlayerRef invited;
            if (data.button.equals("Invite") && this.inviteDropdown != null) {
                if (player.hasPermission(CommandMessages.BASE_PERM + "create-invite")) {
                    if (((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyMembers() != -1 && (long)this.info.getMembers().length + ClaimManager.getInstance().getPartyInvites().values().stream().filter(partyInvite -> partyInvite.party().equals(this.info.getId())).count() >= (long)((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyMembers()) {
                        player.sendMessage(CommandMessages.PARTY_MEMBER_LIMIT_REACHED);
                        return;
                    }
                    if (!this.info.isMember(UUID.fromString(this.inviteDropdown)) && (invited = Universe.get().getPlayer(UUID.fromString(this.inviteDropdown))) != null) {
                        ClaimManager.getInstance().invitePlayerToParty(invited, this.info, this.playerRef);
                        ClaimManager.getInstance().markDirty();
                        invited.sendMessage(CommandMessages.PARTY_INVITE_RECEIVED.param("party_name", this.info.getName()).param("username", this.playerRef.getUsername()));
                        UICommandBuilder commandBuilder = new UICommandBuilder();
                        UIEventBuilder eventBuilder = new UIEventBuilder();
                        this.build(ref, commandBuilder, eventBuilder, store);
                        this.sendUpdate(commandBuilder, eventBuilder, true);
                        return;
                    }
                } else {
                    this.playerRef.sendMessage(Message.translation((String)"commands.parsing.error.noPermissionForCommand"));
                }
            }
            if (data.button.equals("Allies") && this.alliesDropdown != null) {
                if (((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyAllies() != -1 && this.info.getPartyAllies().size() + this.info.getPlayerAllies().size() >= ((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyAllies()) {
                    player.sendMessage(CommandMessages.PARTY_ALLY_LIMIT_REACHED);
                    return;
                }
                invited = Universe.get().getPlayer(UUID.fromString(this.alliesDropdown));
                if (invited != null) {
                    this.info.getPlayerAllies().add(invited.getUuid());
                    ClaimManager.getInstance().markDirty();
                    UICommandBuilder commandBuilder = new UICommandBuilder();
                    UIEventBuilder eventBuilder = new UIEventBuilder();
                    this.build(ref, commandBuilder, eventBuilder, store);
                    this.sendUpdate(commandBuilder, eventBuilder, true);
                    return;
                }
                PartyInfo party = ClaimManager.getInstance().getPartyById(UUID.fromString(this.alliesDropdown));
                if (party != null) {
                    this.info.getPartyAllies().add(party.getId());
                    ClaimManager.getInstance().markDirty();
                    UICommandBuilder commandBuilder = new UICommandBuilder();
                    UIEventBuilder eventBuilder = new UIEventBuilder();
                    this.build(ref, commandBuilder, eventBuilder, store);
                    this.sendUpdate(commandBuilder, eventBuilder, true);
                    return;
                }
            }
            if (data.button.equals("SeeClaimedChunks")) {
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new ChunkListGui(this.playerRef, this.info, this, this.isOpEdit));
                return;
            }
            if (data.button.equals("EditInteract")) {
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new InteractGui(this.playerRef, this.info, this, this.isOpEdit));
                return;
            }
        }
        this.sendUpdate();
    }

    public void build(@NonNullDecl Ref<EntityStore> ref, @NonNullDecl UICommandBuilder uiCommandBuilder, @NonNullDecl UIEventBuilder uiEventBuilder, @NonNullDecl Store<EntityStore> store) {
        int i;
        PlayerRef player = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        boolean playerCanModify = this.info.isOwner(player.getUuid()) || this.isOpEdit;
        uiCommandBuilder.append("Pages/Buuz135_SimpleClaims_EditParty.ui");
        uiCommandBuilder.set("#PartyInfo #PartyNameField.Value", this.info.getName());
        uiCommandBuilder.set("#PartyInfo #PartyNameField.IsReadOnly", !playerCanModify);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#PartyNameField", EventData.of((String)"@Name", (String)"#PartyNameField.Value"), false);
        uiCommandBuilder.set("#PartyInfo #PartyDescriptionField.Value", this.info.getDescription());
        uiCommandBuilder.set("#PartyInfo #PartyDescriptionField.IsReadOnly", !playerCanModify);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#PartyDescriptionField", EventData.of((String)"@Description", (String)"#PartyDescriptionField.Value"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#SeeClaimedChunksButton", EventData.of((String)"Button", (String)"SeeClaimedChunks"), false);
        for (i = 0; i < this.info.getMembers().length; ++i) {
            uiCommandBuilder.append("#MemberEntries", "Pages/Buuz135_SimpleClaims_PartyMemberListEntry.ui");
            boolean isOwner = this.info.isOwner(this.info.getMembers()[i]);
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberName.Text", ClaimManager.getInstance().getPlayerNameTracker().getPlayerName(this.info.getMembers()[i]));
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.Text", isOwner ? "Owner" : "Member");
            if (!isOwner) {
                uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.Background.Color", "#1a8dec83");
                uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.OutlineColor", "#1a8decde");
            }
            if (!playerCanModify || isOwner) {
                uiCommandBuilder.set("#MemberEntries[" + i + "] #RemoveMemberButton.Disabled", true);
                continue;
            }
            if (this.requestingConfirmation == i) {
                uiCommandBuilder.set("#MemberEntries[" + i + "] #RemoveMemberButton.Text", "Are you sure?");
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)("Delete:" + i)), false);
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.MouseExited, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)"Click:-1"), false);
                continue;
            }
            uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)("Click:" + i)), false);
        }
        for (PartyInvite value : ClaimManager.getInstance().getPartyInvites().values()) {
            uiCommandBuilder.append("#MemberEntries", "Pages/Buuz135_SimpleClaims_PartyMemberListEntry.ui");
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberName.Text", ClaimManager.getInstance().getPlayerNameTracker().getPlayerName(value.recipient()));
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.Text", "Pending Invite");
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.Background.Color", "#cac85383");
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.OutlineColor", "#cac853de");
            if (!playerCanModify) {
                uiCommandBuilder.set("#MemberEntries[" + i + "] #RemoveMemberButton.Disabled", true);
            } else if (this.requestingConfirmation == i) {
                uiCommandBuilder.set("#MemberEntries[" + i + "] #RemoveMemberButton.Text", "Are you sure?");
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)("DeleteInvite:" + value.recipient().toString())), false);
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.MouseExited, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)"Click:-1"), false);
            } else {
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)("Click:" + i)), false);
            }
            ++i;
        }
        for (UUID uuid : this.info.getPlayerAllies()) {
            uiCommandBuilder.append("#MemberEntries", "Pages/Buuz135_SimpleClaims_PartyMemberListEntry.ui");
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberName.Text", ClaimManager.getInstance().getPlayerNameTracker().getPlayerName(uuid));
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.Text", "  Ally  ");
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.Background.Color", "#5ab44e83");
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.OutlineColor", "#5ab44ede");
            if (!playerCanModify) {
                uiCommandBuilder.set("#MemberEntries[" + i + "] #RemoveMemberButton.Disabled", true);
            } else if (this.requestingConfirmation == i) {
                uiCommandBuilder.set("#MemberEntries[" + i + "] #RemoveMemberButton.Text", "Are you sure?");
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)("DeleteAllyPlayer:" + uuid.toString())), false);
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.MouseExited, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)"Click:-1"), false);
            } else {
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)("Click:" + i)), false);
            }
            ++i;
        }
        for (UUID uuid : this.info.getPartyAllies()) {
            uiCommandBuilder.append("#MemberEntries", "Pages/Buuz135_SimpleClaims_PartyMemberListEntry.ui");
            String name = "Unknown Party";
            if (ClaimManager.getInstance().getParties().containsKey(uuid.toString())) {
                name = ClaimManager.getInstance().getParties().get(uuid.toString()).getName();
            }
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberName.Text", name);
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.Text", "Party Ally");
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.Background.Color", "#5ab44e83");
            uiCommandBuilder.set("#MemberEntries[" + i + "] #MemberRole.OutlineColor", "#5ab44ede");
            if (!playerCanModify) {
                uiCommandBuilder.set("#MemberEntries[" + i + "] #RemoveMemberButton.Disabled", true);
            } else if (this.requestingConfirmation == i) {
                uiCommandBuilder.set("#MemberEntries[" + i + "] #RemoveMemberButton.Text", "Are you sure?");
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)("DeleteAllyParty:" + uuid.toString())), false);
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.MouseExited, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)"Click:-1"), false);
            } else {
                uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MemberEntries[" + i + "] #RemoveMemberButton", EventData.of((String)"RemoveButtonAction", (String)("Click:" + i)), false);
            }
            ++i;
        }
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#SaveChangesButton", EventData.of((String)"Save", (String)"true"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#CancelButton", EventData.of((String)"Cancel", (String)"true"), false);
        uiCommandBuilder.set("#PlaceBlocksSetting #CheckBox.Value", this.info.isBlockPlaceEnabled());
        if (!this.isOpEdit) {
            uiCommandBuilder.set("#PlaceBlocksSetting #CheckBox.Disabled", !playerCanModify || !((SimpleClaimsConfig)Main.CONFIG.get()).isAllowPartyBreakBlockSetting());
        }
        uiCommandBuilder.set("#BreakBlocksSetting #CheckBox.Value", this.info.isBlockBreakEnabled());
        if (!this.isOpEdit) {
            uiCommandBuilder.set("#BreakBlocksSetting #CheckBox.Disabled", !playerCanModify || !((SimpleClaimsConfig)Main.CONFIG.get()).isAllowPartyPlaceBlockSetting());
        }
        uiCommandBuilder.set("#InteractBlocksSetting #CheckBox.Value", this.info.isBlockInteractEnabled());
        if (!this.isOpEdit) {
            uiCommandBuilder.set("#InteractBlocksSetting #CheckBox.Disabled", !playerCanModify || !((SimpleClaimsConfig)Main.CONFIG.get()).isAllowPartyInteractBlockSetting());
            uiCommandBuilder.set("#EditInteractButton.Disabled", !playerCanModify || !((SimpleClaimsConfig)Main.CONFIG.get()).isAllowPartyInteractBlockSetting());
        }
        uiCommandBuilder.set("#PVPSetting #CheckBox.Value", this.info.isPVPEnabled());
        if (!this.isOpEdit) {
            uiCommandBuilder.set("#PVPSetting #CheckBox.Disabled", !playerCanModify || !((SimpleClaimsConfig)Main.CONFIG.get()).isAllowPartyPVPSetting());
        }
        uiCommandBuilder.set("#AllowEntrySetting #CheckBox.Value", this.info.isAllowEntryEnabled());
        uiCommandBuilder.set("#AllowEntrySetting.Visible", ((SimpleClaimsConfig)Main.CONFIG.get()).isEnableAlloyEntryTesting());
        if (!this.isOpEdit) {
            uiCommandBuilder.set("#AllowEntrySetting #CheckBox.Disabled", !playerCanModify || !((SimpleClaimsConfig)Main.CONFIG.get()).isAllowPartyAllowEntrySetting());
        }
        uiCommandBuilder.set("#FriendlyFireSetting #CheckBox.Value", this.info.isFriendlyFireEnabled());
        if (!this.isOpEdit) {
            uiCommandBuilder.set("#FriendlyFireSetting #CheckBox.Disabled", !playerCanModify || !((SimpleClaimsConfig)Main.CONFIG.get()).isAllowPartyFriendlyFireSetting());
        }
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#PlaceBlocksSetting #CheckBox", EventData.of((String)"RemoveButtonAction", (String)"PlaceBlocksSetting:0"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#BreakBlocksSetting #CheckBox", EventData.of((String)"RemoveButtonAction", (String)"BreakBlocksSetting:0"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#InteractBlocksSetting #CheckBox", EventData.of((String)"RemoveButtonAction", (String)"InteractBlocksSetting:0"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#PVPSetting #CheckBox", EventData.of((String)"RemoveButtonAction", (String)"PVPSetting:0"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#AllowEntrySetting #CheckBox", EventData.of((String)"RemoveButtonAction", (String)"AllowEntrySetting:0"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#FriendlyFireSetting #CheckBox", EventData.of((String)"RemoveButtonAction", (String)"FriendlyFireSetting:0"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#EditInteractButton", EventData.of((String)"Button", (String)"EditInteract"), false);
        uiCommandBuilder.set("#ClaimColorPickerGroup #ClaimColorPicker.Value", String.format("#%06X", 0xFFFFFF & this.info.getColor()));
        uiCommandBuilder.set("#ClaimedChunksInfo #ClaimedChunksCount.Text", "" + ClaimManager.getInstance().getAmountOfClaims(this.info));
        uiCommandBuilder.set("#ClaimedChunksInfo #MaxChunksCount.Text", "" + this.info.getMaxClaimAmount());
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#ClaimColorPicker", EventData.of((String)"@ClaimColor", (String)"#ClaimColorPicker.Value"), false);
        ArrayList<DropdownEntryInfo> players = new ArrayList<DropdownEntryInfo>(Universe.get().getPlayers().stream().filter(playerRef1 -> ClaimManager.getInstance().getPartyFromPlayer(playerRef1.getUuid()) == null).map(playerRef1 -> new DropdownEntryInfo(LocalizableString.fromString((String)playerRef1.getUsername()), playerRef1.getUuid().toString())).toList());
        uiCommandBuilder.set("#InviteDropdown.Entries", players);
        players = new ArrayList<DropdownEntryInfo>(Universe.get().getPlayers().stream().map(playerRef1 -> new DropdownEntryInfo(LocalizableString.fromString((String)playerRef1.getUsername()), playerRef1.getUuid().toString())).toList());
        List<DropdownEntryInfo> parties = ClaimManager.getInstance().getParties().values().stream().map(party -> new DropdownEntryInfo(LocalizableString.fromString((String)("[PAR] " + party.getName())), party.getId().toString())).toList();
        players.addAll(parties);
        uiCommandBuilder.set("#AlliesDropdown.Entries", players);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#InviteDropdown", EventData.of((String)"@InviteDropdown", (String)"#InviteDropdown.Value"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#AlliesDropdown", EventData.of((String)"@AlliesDropdown", (String)"#AlliesDropdown.Value"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#ConfirmInviteButton", EventData.of((String)"Button", (String)"Invite"), false);
        uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#ConfirmAlliesButton", EventData.of((String)"Button", (String)"Allies"), false);
        uiCommandBuilder.set("#ConfirmInviteButton.Disabled", !playerCanModify);
        uiCommandBuilder.set("#ConfirmAlliesButton.Disabled", !playerCanModify);
    }

    public static class PartyInfoData {
        static final String KEY_NAME = "@Name";
        static final String KEY_DESCRIPTION = "@Description";
        static final String KEY_SAVE = "Save";
        static final String KEY_CANCEL = "Cancel";
        static final String KEY_REMOVE_BUTTON_ACTION = "RemoveButtonAction";
        static final String KEY_CLAIM_COLOR = "@ClaimColor";
        static final String KEY_INVITE_DROPDOWN = "@InviteDropdown";
        static final String KEY_ALLIES_DROPDOWN = "@AlliesDropdown";
        static final String KEY_BUTTON = "Button";
        public static final BuilderCodec<PartyInfoData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(PartyInfoData.class, PartyInfoData::new).addField(new KeyedCodec("@Name", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.name = s;
        }, searchGuiData -> searchGuiData.name)).addField(new KeyedCodec("@Description", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.description = s;
        }, searchGuiData -> searchGuiData.description)).addField(new KeyedCodec("Save", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.save = s;
        }, searchGuiData -> searchGuiData.save)).addField(new KeyedCodec("Cancel", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.cancel = s;
        }, searchGuiData -> searchGuiData.cancel)).addField(new KeyedCodec("RemoveButtonAction", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.removeButtonAction = s;
        }, searchGuiData -> searchGuiData.removeButtonAction)).addField(new KeyedCodec("@ClaimColor", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.claimColor = s;
        }, searchGuiData -> searchGuiData.claimColor)).addField(new KeyedCodec("@InviteDropdown", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.inviteDropdown = s;
        }, searchGuiData -> searchGuiData.inviteDropdown)).addField(new KeyedCodec("@AlliesDropdown", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.alliesDropdown = s;
        }, searchGuiData -> searchGuiData.alliesDropdown)).addField(new KeyedCodec("Button", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.button = s;
        }, searchGuiData -> searchGuiData.button)).build();
        private String name;
        private String description;
        private String save;
        private String cancel;
        private String removeButtonAction;
        private String claimColor;
        private String inviteDropdown;
        private String alliesDropdown;
        private String button;

        public String toString() {
            return "PartyInfoData{name='" + this.name + "', description='" + this.description + "', save='" + this.save + "', cancel='" + this.cancel + "', removeButtonAction='" + this.removeButtonAction + "', claimColor='" + this.claimColor + "'}";
        }
    }
}

