/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.gui;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.chunk.ChunkInfo;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.buuz135.simpleclaims.util.MessageHelper;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.asset.util.ColorParseUtil;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.awt.Color;
import java.util.UUID;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class ChunkInfoGui
extends InteractiveCustomUIPage<ChunkInfoData> {
    private final int chunkX;
    private final int chunkZ;
    private final String dimension;
    private boolean isOp;

    public ChunkInfoGui(@NonNullDecl PlayerRef playerRef, String dimension, int chunkX, int chunkZ, boolean isOp) {
        super(playerRef, CustomPageLifetime.CanDismiss, ChunkInfoData.CODEC);
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.dimension = dimension;
        this.isOp = isOp;
    }

    public void handleDataEvent(@NonNullDecl Ref<EntityStore> ref, @NonNullDecl Store<EntityStore> store, @NonNullDecl ChunkInfoData data) {
        super.handleDataEvent(ref, store, (Object)data);
        if (data.action != null) {
            ChunkInfo chunk;
            PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
            Player playerInstance = (Player)store.getComponent(ref, Player.getComponentType());
            PartyInfo playerParty = ClaimManager.getInstance().getPartyFromPlayer(playerRef.getUuid());
            if (playerParty == null) {
                this.sendUpdate();
                return;
            }
            String[] actions = data.action.split(":");
            String button = actions[0];
            int x = Integer.parseInt(actions[1]);
            int z = Integer.parseInt(actions[2]);
            if (button.equals("LeftClicking")) {
                if (this.isOp) {
                    UUID selectedPartyID = ClaimManager.getInstance().getAdminUsageParty().get(playerRef.getUuid());
                    if (selectedPartyID == null) {
                        playerInstance.sendMessage(CommandMessages.ADMIN_PARTY_NOT_SELECTED);
                        this.sendUpdate();
                        return;
                    }
                    ChunkInfo chunk2 = ClaimManager.getInstance().getChunk(this.dimension, x, z);
                    PartyInfo selectedParty = ClaimManager.getInstance().getPartyById(selectedPartyID);
                    if (chunk2 == null && selectedParty != null && ClaimManager.getInstance().hasEnoughClaimsLeft(selectedParty)) {
                        ChunkInfo chunkInfo = ClaimManager.getInstance().claimChunkBy(this.dimension, x, z, selectedParty, playerInstance, playerRef);
                        ClaimManager.getInstance().queueMapUpdate(playerInstance.getWorld(), x, z);
                        ClaimManager.getInstance().markDirty();
                    }
                } else {
                    chunk = ClaimManager.getInstance().getChunk(this.dimension, x, z);
                    if (chunk == null && ClaimManager.getInstance().hasEnoughClaimsLeft(playerParty)) {
                        ChunkInfo chunkInfo = ClaimManager.getInstance().claimChunkBy(this.dimension, x, z, playerParty, playerInstance, playerRef);
                        ClaimManager.getInstance().queueMapUpdate(playerInstance.getWorld(), x, z);
                        ClaimManager.getInstance().markDirty();
                    }
                }
            }
            if (button.equals("RightClicking")) {
                if (this.isOp) {
                    chunk = ClaimManager.getInstance().getChunk(this.dimension, x, z);
                    UUID selectedPartyID = ClaimManager.getInstance().getAdminUsageParty().get(playerRef.getUuid());
                    if (selectedPartyID == null) {
                        playerInstance.sendMessage(CommandMessages.ADMIN_PARTY_NOT_SELECTED);
                        this.sendUpdate();
                        return;
                    }
                    if (chunk != null && selectedPartyID.equals(chunk.getPartyOwner())) {
                        ClaimManager.getInstance().unclaim(this.dimension, x, z);
                        ClaimManager.getInstance().queueMapUpdate(playerInstance.getWorld(), x, z);
                        ClaimManager.getInstance().markDirty();
                    }
                } else {
                    chunk = ClaimManager.getInstance().getChunk(this.dimension, x, z);
                    if (chunk != null && chunk.getPartyOwner().equals(playerParty.getId())) {
                        ClaimManager.getInstance().unclaim(this.dimension, x, z);
                        ClaimManager.getInstance().queueMapUpdate(playerInstance.getWorld(), x, z);
                        ClaimManager.getInstance().markDirty();
                    }
                }
            }
            UICommandBuilder commandBuilder = new UICommandBuilder();
            UIEventBuilder eventBuilder = new UIEventBuilder();
            this.build(ref, commandBuilder, eventBuilder, store);
            this.sendUpdate(commandBuilder, eventBuilder, true);
            return;
        }
        this.sendUpdate();
    }

    public void build(@NonNullDecl Ref<EntityStore> ref, @NonNullDecl UICommandBuilder uiCommandBuilder, @NonNullDecl UIEventBuilder uiEventBuilder, @NonNullDecl Store<EntityStore> store) {
        UUID selectedPartyID;
        uiCommandBuilder.append("Pages/Buuz135_SimpleClaims_ChunkVisualizer.ui");
        if (this.isOp) {
            uiCommandBuilder.set("#TitleText.Text", "Nearby Claimed Chunks - Admin Mode");
        }
        PlayerRef player = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        PartyInfo playerParty = ClaimManager.getInstance().getPartyFromPlayer(player.getUuid());
        if (this.isOp && (selectedPartyID = ClaimManager.getInstance().getAdminUsageParty().get(this.playerRef.getUuid())) != null) {
            playerParty = ClaimManager.getInstance().getPartyById(selectedPartyID);
        }
        uiCommandBuilder.set("#ClaimedChunksInfo #ClaimedChunksCount.Text", "" + ClaimManager.getInstance().getAmountOfClaims(playerParty));
        uiCommandBuilder.set("#ClaimedChunksInfo #MaxChunksCount.Text", "" + playerParty.getMaxClaimAmount());
        String hytaleGold = "#93844c";
        for (int z = 0; z <= 16; ++z) {
            uiCommandBuilder.appendInline("#ChunkCards", "Group { LayoutMode: Left; Anchor: (Bottom: 0); }");
            for (int x = 0; x <= 16; ++x) {
                uiCommandBuilder.append("#ChunkCards[" + z + "]", "Pages/Buuz135_SimpleClaims_ChunkEntry.ui");
                ChunkInfo chunk = ClaimManager.getInstance().getChunk(this.dimension, this.chunkX + x - 8, this.chunkZ + z - 8);
                if (z - 8 == 0 && x - 8 == 0) {
                    uiCommandBuilder.set("#ChunkCards[" + z + "][" + x + "].Text", "+");
                }
                if (chunk != null) {
                    PartyInfo partyInfo = ClaimManager.getInstance().getPartyById(chunk.getPartyOwner());
                    if (partyInfo == null) continue;
                    Color color = new Color(partyInfo.getColor());
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
                    uiCommandBuilder.set("#ChunkCards[" + z + "][" + x + "].Background.Color", ColorParseUtil.colorToHexAlpha((Color)color));
                    uiCommandBuilder.set("#ChunkCards[" + z + "][" + x + "].OutlineColor", ColorParseUtil.colorToHexAlpha((Color)color));
                    uiCommandBuilder.set("#ChunkCards[" + z + "][" + x + "].OutlineSize", 1);
                    MessageHelper.ML tooltip = MessageHelper.multiLine().append(Message.raw((String)"Owner: ").bold(true).color(hytaleGold)).append(Message.raw((String)partyInfo.getName())).nl().append(Message.raw((String)"Description: ").bold(true).color(hytaleGold)).append(Message.raw((String)partyInfo.getDescription()));
                    if (playerParty != null && playerParty.getId().equals(partyInfo.getId())) {
                        tooltip = tooltip.nl().nl().append(Message.raw((String)"*Right Click to Unclaim*").bold(true).color(Color.RED.darker().darker()));
                    }
                    uiCommandBuilder.set("#ChunkCards[" + z + "][" + x + "].TooltipTextSpans", tooltip.build());
                    uiEventBuilder.addEventBinding(CustomUIEventBindingType.RightClicking, "#ChunkCards[" + z + "][" + x + "]", EventData.of((String)"Action", (String)("RightClicking:" + (this.chunkX + x - 8) + ":" + (this.chunkZ + z - 8))));
                    continue;
                }
                MessageHelper.ML tooltip = MessageHelper.multiLine().append(Message.raw((String)"Wilderness").bold(true).color(Color.GREEN.darker()));
                if (playerParty != null) {
                    tooltip = tooltip.nl().nl().append(Message.raw((String)"*Left Click to claim*").bold(true).color(Color.GRAY));
                    uiEventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#ChunkCards[" + z + "][" + x + "]", EventData.of((String)"Action", (String)("LeftClicking:" + (this.chunkX + x - 8) + ":" + (this.chunkZ + z - 8))));
                } else {
                    tooltip = tooltip.nl().nl().append(Message.raw((String)"*Create a party to claim*").bold(true).color(Color.GRAY));
                }
                uiCommandBuilder.set("#ChunkCards[" + z + "][" + x + "].TooltipTextSpans", tooltip.build());
            }
        }
    }

    public static class ChunkInfoData {
        static final String KEY_ACTION = "Action";
        public static final BuilderCodec<ChunkInfoData> CODEC = ((BuilderCodec.Builder)BuilderCodec.builder(ChunkInfoData.class, ChunkInfoData::new).addField(new KeyedCodec("Action", (Codec)Codec.STRING), (searchGuiData, s) -> {
            searchGuiData.action = s;
        }, searchGuiData -> searchGuiData.action)).build();
        private String action;
    }
}

