/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.files;

import com.buuz135.simpleclaims.claim.player_name.PlayerNameTracker;
import com.buuz135.simpleclaims.util.FileUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hypixel.hytale.server.core.util.io.BlockingDiskFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.UUID;

public class PlayerNameTrackerBlockingFile
extends BlockingDiskFile {
    private PlayerNameTracker tracker = new PlayerNameTracker();

    public PlayerNameTrackerBlockingFile() {
        super(Path.of(FileUtils.NAMES_CACHE_PATH, new String[0]));
    }

    protected void read(BufferedReader bufferedReader) throws IOException {
        JsonElement rootElement = JsonParser.parseReader((Reader)bufferedReader);
        if (rootElement == null || !rootElement.isJsonObject()) {
            return;
        }
        JsonObject root = rootElement.getAsJsonObject();
        JsonArray valuesArray = root.getAsJsonArray("Values");
        if (valuesArray == null) {
            return;
        }
        this.tracker = new PlayerNameTracker();
        valuesArray.forEach(jsonElement -> {
            JsonObject playerObj = jsonElement.getAsJsonObject();
            this.tracker.setPlayerName(UUID.fromString(playerObj.get("UUID").getAsString()), playerObj.get("Name").getAsString());
        });
    }

    protected void write(BufferedWriter bufferedWriter) throws IOException {
        JsonObject root = new JsonObject();
        JsonArray valuesArray = new JsonArray();
        for (PlayerNameTracker.PlayerName name : this.tracker.getNames()) {
            JsonObject playerObj = new JsonObject();
            playerObj.addProperty("UUID", name.getUuid().toString());
            playerObj.addProperty("Name", name.getName());
            valuesArray.add((JsonElement)playerObj);
        }
        root.add("Values", (JsonElement)valuesArray);
        bufferedWriter.write(root.toString());
    }

    protected void create(BufferedWriter bufferedWriter) throws IOException {
        this.tracker = new PlayerNameTracker();
        this.write(bufferedWriter);
    }

    public PlayerNameTracker getTracker() {
        return this.tracker;
    }
}

