/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.files;

import com.buuz135.simpleclaims.claim.chunk.ChunkInfo;
import com.buuz135.simpleclaims.claim.tracking.ModifiedTracking;
import com.buuz135.simpleclaims.util.FileUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hypixel.hytale.server.core.util.io.BlockingDiskFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;

public class ClaimedChunkBlockingFile
extends BlockingDiskFile {
    private HashMap<String, HashMap<String, ChunkInfo>> chunks = new HashMap();

    public ClaimedChunkBlockingFile() {
        super(Path.of(FileUtils.CLAIM_PATH, new String[0]));
    }

    protected void read(BufferedReader bufferedReader) throws IOException {
        JsonElement rootElement = JsonParser.parseReader((Reader)bufferedReader);
        if (rootElement == null || !rootElement.isJsonObject()) {
            return;
        }
        JsonObject root = rootElement.getAsJsonObject();
        JsonArray dimensionsArray = root.getAsJsonArray("Dimensions");
        if (dimensionsArray == null) {
            return;
        }
        this.chunks = new HashMap();
        dimensionsArray.forEach(dimElement -> {
            JsonObject dimensionObj = dimElement.getAsJsonObject();
            String dimensionName = dimensionObj.get("Dimension").getAsString();
            HashMap chunkMap = new HashMap();
            JsonArray chunkInfoArray = dimensionObj.getAsJsonArray("ChunkInfo");
            if (chunkInfoArray != null) {
                chunkInfoArray.forEach(chunkElement -> {
                    JsonObject chunkObj = chunkElement.getAsJsonObject();
                    ChunkInfo chunkInfo = new ChunkInfo(UUID.fromString(chunkObj.get("UUID").getAsString()), chunkObj.get("ChunkX").getAsInt(), chunkObj.get("ChunkY").getAsInt());
                    if (chunkObj.has("CreatedTracker")) {
                        JsonObject trackerObj = chunkObj.getAsJsonObject("CreatedTracker");
                        chunkInfo.setCreatedTracked(new ModifiedTracking(UUID.fromString(trackerObj.get("UserUUID").getAsString()), trackerObj.get("UserName").getAsString(), trackerObj.get("Date").getAsString()));
                    }
                    chunkMap.put(ChunkInfo.formatCoordinates(chunkInfo.getChunkX(), chunkInfo.getChunkZ()), chunkInfo);
                });
            }
            this.chunks.put(dimensionName, chunkMap);
        });
    }

    protected void write(BufferedWriter bufferedWriter) throws IOException {
        JsonObject root = new JsonObject();
        JsonArray dimensionsArray = new JsonArray();
        this.chunks.forEach((dimensionName, chunkMap) -> {
            JsonObject dimensionObj = new JsonObject();
            dimensionObj.addProperty("Dimension", dimensionName);
            JsonArray chunkInfoArray = new JsonArray();
            chunkMap.values().forEach(chunkInfo -> {
                JsonObject chunkObj = new JsonObject();
                chunkObj.addProperty("UUID", chunkInfo.getPartyOwner().toString());
                chunkObj.addProperty("ChunkX", (Number)chunkInfo.getChunkX());
                chunkObj.addProperty("ChunkY", (Number)chunkInfo.getChunkZ());
                if (chunkInfo.getCreatedTracked() != null) {
                    JsonObject trackerObj = new JsonObject();
                    trackerObj.addProperty("UserUUID", chunkInfo.getCreatedTracked().getUserUUID().toString());
                    trackerObj.addProperty("UserName", chunkInfo.getCreatedTracked().getUserName());
                    trackerObj.addProperty("Date", chunkInfo.getCreatedTracked().getDate());
                    chunkObj.add("CreatedTracker", (JsonElement)trackerObj);
                }
                chunkInfoArray.add((JsonElement)chunkObj);
            });
            dimensionObj.add("ChunkInfo", (JsonElement)chunkInfoArray);
            dimensionsArray.add((JsonElement)dimensionObj);
        });
        root.add("Dimensions", (JsonElement)dimensionsArray);
        bufferedWriter.write(root.toString());
    }

    protected void create(BufferedWriter bufferedWriter) throws IOException {
        this.chunks = new HashMap();
        this.write(bufferedWriter);
    }

    public HashMap<String, HashMap<String, ChunkInfo>> getChunks() {
        return this.chunks;
    }
}

