/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.files;

import com.buuz135.simpleclaims.util.FileUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hypixel.hytale.server.core.util.io.BlockingDiskFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class AdminOverridesBlockingFile
extends BlockingDiskFile {
    private Set<UUID> adminOverrides = new HashSet<UUID>();

    public AdminOverridesBlockingFile() {
        super(Path.of(FileUtils.ADMIN_OVERRIDES_PATH, new String[0]));
    }

    protected void read(BufferedReader bufferedReader) throws IOException {
        JsonObject root = JsonParser.parseReader((Reader)bufferedReader).getAsJsonObject();
        if (root == null) {
            return;
        }
        JsonArray overridesArray = root.getAsJsonArray("AdminOverrides");
        if (overridesArray == null) {
            return;
        }
        this.adminOverrides = new HashSet<UUID>();
        overridesArray.forEach(jsonElement -> this.adminOverrides.add(UUID.fromString(jsonElement.getAsString())));
    }

    protected void write(BufferedWriter bufferedWriter) throws IOException {
        JsonObject root = new JsonObject();
        JsonArray overridesArray = new JsonArray();
        this.adminOverrides.forEach(uuid -> overridesArray.add(uuid.toString()));
        root.add("AdminOverrides", (JsonElement)overridesArray);
        bufferedWriter.write(root.toString());
    }

    protected void create(BufferedWriter bufferedWriter) throws IOException {
        JsonObject root = new JsonObject();
        JsonArray overrides = new JsonArray();
        root.add("AdminOverrides", (JsonElement)overrides);
        bufferedWriter.write(root.toString());
    }

    public Set<UUID> getAdminOverrides() {
        return this.adminOverrides;
    }
}

