/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.commands.subcommand.party.op;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.claim.party.PartyOverride;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractAsyncCommand;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class OpAddChunkAmountCommand
extends AbstractAsyncCommand {
    private final RequiredArg<Integer> amount;
    private final RequiredArg<String> name = this.withRequiredArg("player-name", "The player name", (ArgumentType)ArgTypes.STRING);

    public OpAddChunkAmountCommand() {
        super("add-chunk-amount", "Add the specified amount of chunks to the party of the specified player name");
        this.amount = this.withRequiredArg("amount", "The amount of chunks the party can claim", (ArgumentType)ArgTypes.INTEGER);
        this.requirePermission(CommandMessages.ADMIN_PERM + "add-chunk-amount");
    }

    @NonNullDecl
    protected CompletableFuture<Void> executeAsync(CommandContext commandContext) {
        CommandSender sender = commandContext.sender();
        String selectedPlayer = (String)commandContext.get(this.name);
        Integer selectedAmount = (Integer)this.amount.get(commandContext);
        UUID uuidSelectedPlayer = ClaimManager.getInstance().getPlayerNameTracker().getPlayerUUID(selectedPlayer);
        if (uuidSelectedPlayer == null) {
            sender.sendMessage(CommandMessages.PLAYER_NOT_FOUND);
            return CompletableFuture.completedFuture(null);
        }
        PartyInfo party = ClaimManager.getInstance().getPartyFromPlayer(uuidSelectedPlayer);
        if (party == null) {
            sender.sendMessage(CommandMessages.PARTY_NOT_FOUND);
            return CompletableFuture.completedFuture(null);
        }
        party.setOverride(new PartyOverride("simpleclaims.claim.amount", new PartyOverride.PartyOverrideValue("integer", party.getMaxClaimAmount() + selectedAmount)));
        ClaimManager.getInstance().markDirty();
        sender.sendMessage(CommandMessages.MODIFIED_MAX_CHUNK_AMOUNT.param("party_name", party.getName()).param("amount", party.getMaxClaimAmount()));
        return CompletableFuture.completedFuture(null);
    }
}

