/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.commands.subcommand.party;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.claim.party.PartyInvite;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.commands.player.inventory.InventorySeeCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractAsyncCommand;
import com.hypixel.hytale.server.core.entity.Entity;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class PartyAcceptCommand
extends AbstractAsyncCommand {
    public PartyAcceptCommand() {
        super("invite-accept", "Accepts your most recent party invite");
        this.requirePermission(CommandMessages.BASE_PERM + "accept-invite");
    }

    @NonNullDecl
    protected CompletableFuture<Void> executeAsync(CommandContext commandContext) {
        CommandSender sender = commandContext.sender();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Ref ref = player.getReference();
            if (ref != null && ref.isValid()) {
                Store store = ref.getStore();
                World world = ((EntityStore)store.getExternalData()).getWorld();
                return CompletableFuture.runAsync(() -> {
                    PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
                    if (playerRef != null) {
                        PartyInfo party = ClaimManager.getInstance().getPartyFromPlayer(playerRef.getUuid());
                        if (party != null) {
                            player.sendMessage(CommandMessages.IN_A_PARTY);
                            return;
                        }
                        if (ClaimManager.getInstance().getPartyInvites().containsKey(playerRef.getUuid())) {
                            PartyInvite invite = ClaimManager.getInstance().acceptInvite(playerRef);
                            if (invite != null) {
                                PartyInfo partyInvite = ClaimManager.getInstance().getPartyById(invite.party());
                                if (partyInvite != null) {
                                    player.sendMessage(CommandMessages.PARTY_INVITE_JOIN.param("party_name", partyInvite.getName()).param("username", player.getDisplayName()));
                                    Entity playerSender = player.getWorld().getEntity(invite.sender());
                                    if (playerSender instanceof Player) {
                                        Player playerSenderPlayer = (Player)playerSender;
                                        playerSenderPlayer.sendMessage(CommandMessages.PARTY_INVITE_JOIN.param("party_name", partyInvite.getName()).param("username", player.getDisplayName()));
                                    }
                                }
                            } else {
                                player.sendMessage(CommandMessages.PARTY_MEMBER_LIMIT_REACHED);
                            }
                        } else {
                            player.sendMessage(Message.raw((String)"You don't have any pending invites").bold(true).color(Color.RED));
                        }
                    }
                }, (Executor)world);
            }
            commandContext.sendMessage(InventorySeeCommand.MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

