/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.commands.subcommand.party;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.buuz135.simpleclaims.gui.PartyInfoEditGui;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.command.commands.player.inventory.InventorySeeCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractAsyncCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class CreatePartyCommand
extends AbstractAsyncCommand {
    public CreatePartyCommand() {
        super("create", "Creates a new party");
        this.requirePermission(CommandMessages.BASE_PERM + "create-party");
    }

    @NonNullDecl
    protected CompletableFuture<Void> executeAsync(CommandContext commandContext) {
        CommandSender sender = commandContext.sender();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Ref ref = player.getReference();
            if (ref != null && ref.isValid()) {
                Store store = ref.getStore();
                World world = ((EntityStore)store.getExternalData()).getWorld();
                return CompletableFuture.runAsync(() -> {
                    PlayerRef playerRef = (PlayerRef)ref.getStore().getComponent(ref, PlayerRef.getComponentType());
                    if (playerRef == null) {
                        return;
                    }
                    PartyInfo party = ClaimManager.getInstance().getPartyFromPlayer(playerRef.getUuid());
                    if (party != null) {
                        commandContext.sendMessage(CommandMessages.IN_A_PARTY);
                        return;
                    }
                    party = ClaimManager.getInstance().createParty(player, playerRef, false);
                    player.sendMessage(CommandMessages.PARTY_CREATED);
                    player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new PartyInfoEditGui(playerRef, party, false));
                }, (Executor)world);
            }
            commandContext.sendMessage(InventorySeeCommand.MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

