/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.commands.subcommand.chunk.op;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.chunk.ChunkInfo;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.command.commands.player.inventory.InventorySeeCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractAsyncCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class OpClaimChunkCommand
extends AbstractAsyncCommand {
    public OpClaimChunkCommand() {
        super("admin-claim", "Claims the chunk where you are, must have selected a party first using the /scp admin-party-list command");
        this.requirePermission(CommandMessages.ADMIN_PERM + "admin-claim");
    }

    @NonNullDecl
    protected CompletableFuture<Void> executeAsync(CommandContext commandContext) {
        CommandSender sender = commandContext.sender();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Ref ref = player.getReference();
            if (ref != null && ref.isValid()) {
                Store store = ref.getStore();
                World world = ((EntityStore)store.getExternalData()).getWorld();
                return CompletableFuture.runAsync(() -> {
                    PlayerRef playerRef = (PlayerRef)ref.getStore().getComponent(ref, PlayerRef.getComponentType());
                    if (playerRef == null) {
                        return;
                    }
                    UUID selectedPartyID = ClaimManager.getInstance().getAdminUsageParty().get(playerRef.getUuid());
                    if (selectedPartyID == null) {
                        player.sendMessage(CommandMessages.ADMIN_PARTY_NOT_SELECTED);
                        return;
                    }
                    PartyInfo party = ClaimManager.getInstance().getPartyById(selectedPartyID);
                    if (party == null) {
                        player.sendMessage(CommandMessages.PARTY_NOT_FOUND);
                        return;
                    }
                    ChunkInfo chunk = ClaimManager.getInstance().getChunkRawCoords(player.getWorld().getName(), (int)playerRef.getTransform().getPosition().getX(), (int)playerRef.getTransform().getPosition().getZ());
                    if (chunk != null) {
                        player.sendMessage(chunk.getPartyOwner().equals(party.getId()) ? CommandMessages.ALREADY_CLAIMED_BY_YOU : CommandMessages.ALREADY_CLAIMED_BY_ANOTHER_PLAYER);
                        return;
                    }
                    if (!ClaimManager.getInstance().hasEnoughClaimsLeft(party)) {
                        player.sendMessage(CommandMessages.NOT_ENOUGH_CHUNKS);
                        return;
                    }
                    ChunkInfo chunkInfo = ClaimManager.getInstance().claimChunkByRawCoords(player.getWorld().getName(), (int)playerRef.getTransform().getPosition().getX(), (int)playerRef.getTransform().getPosition().getZ(), party, player, playerRef);
                    ClaimManager.getInstance().queueMapUpdate(player.getWorld(), chunkInfo.getChunkX(), chunkInfo.getChunkZ());
                    player.sendMessage(CommandMessages.CLAIMED);
                }, (Executor)world);
            }
            commandContext.sendMessage(InventorySeeCommand.MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

