/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.commands.subcommand.chunk.op;

import com.buuz135.simpleclaims.commands.CommandMessages;
import com.buuz135.simpleclaims.gui.ChunkInfoGui;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.server.core.command.commands.player.inventory.InventorySeeCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractAsyncCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class OpChunkGuiCommand
extends AbstractAsyncCommand {
    public OpChunkGuiCommand() {
        super("admin-chunk", "Opens the chunk claim gui in op mode to claim chunks using the selected admin party");
        this.requirePermission(CommandMessages.ADMIN_PERM + "admin-chunk");
    }

    @NonNullDecl
    protected CompletableFuture<Void> executeAsync(CommandContext commandContext) {
        CommandSender sender = commandContext.sender();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Ref ref = player.getReference();
            if (ref != null && ref.isValid()) {
                Store store = ref.getStore();
                World world = ((EntityStore)store.getExternalData()).getWorld();
                return CompletableFuture.runAsync(() -> {
                    PlayerRef playerRef = (PlayerRef)ref.getStore().getComponent(ref, PlayerRef.getComponentType());
                    if (playerRef == null) {
                        return;
                    }
                    TransformComponent position = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
                    player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new ChunkInfoGui(playerRef, player.getWorld().getName(), ChunkUtil.chunkCoordinate((double)position.getPosition().getX()), ChunkUtil.chunkCoordinate((double)position.getPosition().getZ()), true));
                }, (Executor)world);
            }
            commandContext.sendMessage(InventorySeeCommand.MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

