/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.commands.subcommand.chunk;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.chunk.ChunkInfo;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.command.commands.player.inventory.InventorySeeCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractAsyncCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class ClaimChunkCommand
extends AbstractAsyncCommand {
    public ClaimChunkCommand() {
        super("claim", "Claims the chunk where you are");
        this.requirePermission(CommandMessages.BASE_PERM + "claim");
    }

    @NonNullDecl
    protected CompletableFuture<Void> executeAsync(CommandContext commandContext) {
        CommandSender sender = commandContext.sender();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Ref ref = player.getReference();
            if (ref != null && ref.isValid()) {
                Store store = ref.getStore();
                World world = ((EntityStore)store.getExternalData()).getWorld();
                return CompletableFuture.runAsync(() -> {
                    ChunkInfo chunk;
                    PlayerRef playerRef = (PlayerRef)ref.getStore().getComponent(ref, PlayerRef.getComponentType());
                    if (playerRef == null) {
                        return;
                    }
                    if (!ClaimManager.getInstance().canClaimInDimension(world)) {
                        player.sendMessage(CommandMessages.CANT_CLAIM_IN_THIS_DIMENSION);
                        return;
                    }
                    PartyInfo party = ClaimManager.getInstance().getPartyFromPlayer(playerRef.getUuid());
                    if (party == null) {
                        party = ClaimManager.getInstance().createParty(player, playerRef, false);
                        player.sendMessage(CommandMessages.PARTY_CREATED);
                    }
                    if ((chunk = ClaimManager.getInstance().getChunkRawCoords(player.getWorld().getName(), (int)playerRef.getTransform().getPosition().getX(), (int)playerRef.getTransform().getPosition().getZ())) != null) {
                        player.sendMessage(chunk.getPartyOwner().equals(party.getId()) ? CommandMessages.ALREADY_CLAIMED_BY_YOU : CommandMessages.ALREADY_CLAIMED_BY_ANOTHER_PLAYER);
                        return;
                    }
                    if (!ClaimManager.getInstance().hasEnoughClaimsLeft(party)) {
                        player.sendMessage(CommandMessages.NOT_ENOUGH_CHUNKS);
                        return;
                    }
                    ChunkInfo chunkInfo = ClaimManager.getInstance().claimChunkByRawCoords(player.getWorld().getName(), (int)playerRef.getTransform().getPosition().getX(), (int)playerRef.getTransform().getPosition().getZ(), party, player, playerRef);
                    ClaimManager.getInstance().queueMapUpdate(player.getWorld(), chunkInfo.getChunkX(), chunkInfo.getChunkZ());
                    player.sendMessage(CommandMessages.CLAIMED);
                }, (Executor)world);
            }
            commandContext.sendMessage(InventorySeeCommand.MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

