/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.commands;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.buuz135.simpleclaims.commands.subcommand.party.CreatePartyCommand;
import com.buuz135.simpleclaims.commands.subcommand.party.PartyAcceptCommand;
import com.buuz135.simpleclaims.commands.subcommand.party.PartyInviteCommand;
import com.buuz135.simpleclaims.commands.subcommand.party.PartyLeaveCommand;
import com.buuz135.simpleclaims.commands.subcommand.party.op.OpAddChunkAmountCommand;
import com.buuz135.simpleclaims.commands.subcommand.party.op.OpAllModifyChunkAmountCommand;
import com.buuz135.simpleclaims.commands.subcommand.party.op.OpCreatePartyCommand;
import com.buuz135.simpleclaims.commands.subcommand.party.op.OpModifyChunkAmountCommand;
import com.buuz135.simpleclaims.commands.subcommand.party.op.OpOverrideCommand;
import com.buuz135.simpleclaims.commands.subcommand.party.op.OpPartyListCommand;
import com.buuz135.simpleclaims.gui.PartyInfoEditGui;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.command.commands.player.inventory.InventorySeeCommand;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractAsyncCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class SimpleClaimsPartyCommand
extends AbstractAsyncCommand {
    public SimpleClaimsPartyCommand() {
        super("simpleclaimsparty", "Simple Claims Party Commands");
        this.addAliases(new String[]{"scp", "sc-party"});
        this.requirePermission(CommandMessages.BASE_PERM + "edit-party");
        this.addSubCommand((AbstractCommand)new CreatePartyCommand());
        this.addSubCommand((AbstractCommand)new PartyInviteCommand());
        this.addSubCommand((AbstractCommand)new PartyAcceptCommand());
        this.addSubCommand((AbstractCommand)new PartyLeaveCommand());
        this.addSubCommand((AbstractCommand)new OpCreatePartyCommand());
        this.addSubCommand((AbstractCommand)new OpPartyListCommand());
        this.addSubCommand((AbstractCommand)new OpModifyChunkAmountCommand());
        this.addSubCommand((AbstractCommand)new OpAllModifyChunkAmountCommand());
        this.addSubCommand((AbstractCommand)new OpOverrideCommand());
        this.addSubCommand((AbstractCommand)new OpAddChunkAmountCommand());
    }

    @NonNullDecl
    protected CompletableFuture<Void> executeAsync(CommandContext commandContext) {
        CommandSender sender = commandContext.sender();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Ref ref = player.getReference();
            if (ref != null && ref.isValid()) {
                Store store = ref.getStore();
                World world = ((EntityStore)store.getExternalData()).getWorld();
                return CompletableFuture.runAsync(() -> {
                    PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
                    if (playerRef != null) {
                        PartyInfo party = ClaimManager.getInstance().getPartyFromPlayer(playerRef.getUuid());
                        if (party == null) {
                            commandContext.sendMessage(CommandMessages.NOT_IN_A_PARTY);
                            return;
                        }
                        player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new PartyInfoEditGui(playerRef, party, false));
                    }
                }, (Executor)world);
            }
            commandContext.sendMessage(InventorySeeCommand.MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

