/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.commands;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.buuz135.simpleclaims.commands.subcommand.chunk.ClaimChunkCommand;
import com.buuz135.simpleclaims.commands.subcommand.chunk.UnclaimChunkCommand;
import com.buuz135.simpleclaims.commands.subcommand.chunk.op.OpChunkGuiCommand;
import com.buuz135.simpleclaims.commands.subcommand.chunk.op.OpClaimChunkCommand;
import com.buuz135.simpleclaims.commands.subcommand.chunk.op.OpUnclaimChunkCommand;
import com.buuz135.simpleclaims.gui.ChunkInfoGui;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.server.core.command.commands.player.inventory.InventorySeeCommand;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractAsyncCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class SimpleClaimProtectCommand
extends AbstractAsyncCommand {
    public SimpleClaimProtectCommand() {
        super("simpleclaims", "Opens the chunk claim gui");
        this.addAliases(new String[]{"sc", "sc-chunks", "scc"});
        this.requirePermission(CommandMessages.BASE_PERM + "claim-gui");
        this.addSubCommand((AbstractCommand)new ClaimChunkCommand());
        this.addSubCommand((AbstractCommand)new UnclaimChunkCommand());
        this.addSubCommand((AbstractCommand)new OpClaimChunkCommand());
        this.addSubCommand((AbstractCommand)new OpUnclaimChunkCommand());
        this.addSubCommand((AbstractCommand)new OpChunkGuiCommand());
    }

    @NonNullDecl
    protected CompletableFuture<Void> executeAsync(CommandContext commandContext) {
        CommandSender sender = commandContext.sender();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Ref ref = player.getReference();
            if (ref != null && ref.isValid()) {
                Store store = ref.getStore();
                World world = ((EntityStore)store.getExternalData()).getWorld();
                return CompletableFuture.runAsync(() -> {
                    PlayerRef playerRef = (PlayerRef)ref.getStore().getComponent(ref, PlayerRef.getComponentType());
                    if (playerRef == null) {
                        return;
                    }
                    if (!ClaimManager.getInstance().canClaimInDimension(world)) {
                        player.sendMessage(CommandMessages.CANT_CLAIM_IN_THIS_DIMENSION);
                        return;
                    }
                    PartyInfo party = ClaimManager.getInstance().getPartyFromPlayer(playerRef.getUuid());
                    if (party == null) {
                        party = ClaimManager.getInstance().createParty(player, playerRef, false);
                        player.sendMessage(CommandMessages.PARTY_CREATED);
                    }
                    TransformComponent position = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
                    player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new ChunkInfoGui(playerRef, player.getWorld().getName(), ChunkUtil.chunkCoordinate((double)position.getPosition().getX()), ChunkUtil.chunkCoordinate((double)position.getPosition().getZ()), false));
                }, (Executor)world);
            }
            commandContext.sendMessage(InventorySeeCommand.MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

