/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.claim.party;

import com.buuz135.simpleclaims.Main;
import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.claim.party.PartyOverride;
import com.buuz135.simpleclaims.claim.tracking.ModifiedTracking;
import com.buuz135.simpleclaims.config.SimpleClaimsConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public class PartyInfo {
    private UUID id;
    private UUID owner;
    private String name;
    private String description;
    private final Set<UUID> memberSet;
    private int color;
    private final Map<String, PartyOverride> overrideMap;
    private ModifiedTracking createdTracked;
    private ModifiedTracking modifiedTracked;
    private final Set<UUID> partyAllies;
    private final Set<UUID> playerAllies;

    public PartyInfo(UUID id, UUID owner, String name, String description, UUID[] members, int color) {
        this.id = id;
        this.owner = owner;
        this.name = name;
        this.description = description;
        this.memberSet = new HashSet<UUID>();
        this.memberSet.addAll(Arrays.asList(members));
        this.color = color;
        this.overrideMap = new HashMap<String, PartyOverride>();
        this.setOverride(new PartyOverride("simpleclaims.claim.amount", new PartyOverride.PartyOverrideValue("integer", ((SimpleClaimsConfig)Main.CONFIG.get()).getDefaultPartyClaimsAmount())));
        this.setOverride(new PartyOverride("simpleclaims.party.protection.place_blocks", new PartyOverride.PartyOverrideValue("bool", ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyBlockPlaceEnabled())));
        this.setOverride(new PartyOverride("simpleclaims.party.protection.break_blocks", new PartyOverride.PartyOverrideValue("bool", ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyBlockBreakEnabled())));
        this.setOverride(new PartyOverride("simpleclaims.party.protection.interact", new PartyOverride.PartyOverrideValue("bool", ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyBlockInteractEnabled())));
        this.setOverride(new PartyOverride("simpleclaims.party.protection.allow_entry", new PartyOverride.PartyOverrideValue("bool", ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyAllowEntry())));
        this.setOverride(new PartyOverride("simpleclaims.party.protection.interact.portal", new PartyOverride.PartyOverrideValue("bool", ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyInteractPortal())));
        this.createdTracked = new ModifiedTracking();
        this.modifiedTracked = new ModifiedTracking();
        this.partyAllies = new HashSet<UUID>();
        this.playerAllies = new HashSet<UUID>();
    }

    public PartyInfo() {
        this(UUID.randomUUID(), UUID.randomUUID(), "", "", new UUID[0], 0);
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public UUID[] getMembers() {
        return this.memberSet.toArray(new UUID[0]);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMembers(UUID[] members) {
        this.memberSet.clear();
        this.memberSet.addAll(Arrays.asList(members));
    }

    public boolean isOwner(UUID uuid) {
        return this.owner.equals(uuid);
    }

    public boolean isMember(UUID uuid) {
        return this.memberSet.contains(uuid);
    }

    public boolean isOwnerOrMember(UUID uuid) {
        return this.isOwner(uuid) || this.isMember(uuid);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public List<PartyOverride> getOverrides() {
        return new ArrayList<PartyOverride>(this.overrideMap.values());
    }

    public void addMember(UUID uuid) {
        if (((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyMembers() != -1 && this.memberSet.size() >= ((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyMembers()) {
            return;
        }
        this.memberSet.add(uuid);
    }

    public void removeMember(UUID uuid) {
        this.memberSet.remove(uuid);
        ClaimManager.getInstance().getPlayerToParty().remove(uuid);
    }

    public int getMaxClaimAmount() {
        PartyOverride override = this.getOverride("simpleclaims.claim.amount");
        if (override != null) {
            return (Integer)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).getDefaultPartyClaimsAmount();
    }

    public boolean isBlockPlaceEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.place_blocks");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyBlockPlaceEnabled();
    }

    public boolean isBlockBreakEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.break_blocks");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyBlockBreakEnabled();
    }

    public boolean isBlockInteractEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.interact");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyBlockInteractEnabled();
    }

    public boolean isPVPEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.pvp");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyPVPEnabled();
    }

    public boolean isFriendlyFireEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.friendly_fire");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyFriendlyFireEnabled();
    }

    public boolean isAllowEntryEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.allow_entry");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyAllowEntry();
    }

    public boolean isChestInteractEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.interact.chest");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyInteractChest();
    }

    public boolean isDoorInteractEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.interact.door");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyInteractDoor();
    }

    public boolean isBenchInteractEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.interact.bench");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyInteractBench();
    }

    public boolean isChairInteractEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.interact.chair");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyInteractChair();
    }

    public boolean isPortalInteractEnabled() {
        PartyOverride override = this.getOverride("simpleclaims.party.protection.interact.portal");
        if (override != null) {
            return (Boolean)override.getValue().getTypedValue();
        }
        return ((SimpleClaimsConfig)Main.CONFIG.get()).isDefaultPartyInteractPortal();
    }

    public void setOverride(PartyOverride override) {
        if (override.getType().equals("simpleclaims.claim.amount") && ((Integer)override.getValue().tryGetTypedValue().orElse(0)).intValue() == ((SimpleClaimsConfig)Main.CONFIG.get()).getDefaultPartyClaimsAmount()) {
            this.overrideMap.remove(override.getType());
            return;
        }
        this.overrideMap.put(override.getType(), override);
    }

    @Nullable
    public PartyOverride getOverride(String type) {
        return this.overrideMap.get(type);
    }

    public ModifiedTracking getCreatedTracked() {
        return this.createdTracked;
    }

    public void setCreatedTracked(ModifiedTracking createdTracked) {
        this.createdTracked = createdTracked;
    }

    public ModifiedTracking getModifiedTracked() {
        return this.modifiedTracked;
    }

    public void setModifiedTracked(ModifiedTracking modifiedTracked) {
        this.modifiedTracked = modifiedTracked;
    }

    public Set<UUID> getPartyAllies() {
        return this.partyAllies;
    }

    public Set<UUID> getPlayerAllies() {
        return this.playerAllies;
    }

    public void addPartyAllies(UUID uuid) {
        if (((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyAllies() != -1 && this.partyAllies.size() + this.playerAllies.size() >= ((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyAllies()) {
            return;
        }
        this.partyAllies.add(uuid);
    }

    public void removePartyAllies(UUID uuid) {
        this.partyAllies.remove(uuid);
    }

    public void addPlayerAllies(UUID uuid) {
        if (((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyAllies() != -1 && this.partyAllies.size() + this.playerAllies.size() >= ((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyAllies()) {
            return;
        }
        this.playerAllies.add(uuid);
    }

    public void removePlayerAllies(UUID uuid) {
        this.playerAllies.remove(uuid);
    }

    public String toString() {
        return "PartyInfo{id=" + String.valueOf(this.id) + ", owner=" + String.valueOf(this.owner) + ", name='" + this.name + "', description='" + this.description + "', members=" + String.valueOf(this.memberSet) + ", color=" + this.color + ", overrides=" + String.valueOf(this.overrideMap.values()) + ", createdTracked=" + String.valueOf(this.createdTracked) + ", modifiedTracked=" + String.valueOf(this.modifiedTracked) + "}";
    }
}

