/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.claim.chunk;

import com.buuz135.simpleclaims.claim.tracking.ModifiedTracking;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.codec.codecs.array.ArrayCodec;
import java.time.LocalDateTime;
import java.util.UUID;

public class ChunkInfo {
    public static final BuilderCodec<ChunkInfo> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(ChunkInfo.class, ChunkInfo::new).append(new KeyedCodec("UUID", (Codec)Codec.UUID_STRING), (chunkInfo, uuid, extraInfo) -> chunkInfo.setPartyOwner((UUID)uuid), (chunkInfo, extraInfo) -> chunkInfo.getPartyOwner()).add()).append(new KeyedCodec("ChunkX", (Codec)Codec.INTEGER), (chunkInfo, value, extraInfo) -> chunkInfo.setChunkX((int)value), (chunkInfo, extraInfo) -> chunkInfo.getChunkX()).add()).append(new KeyedCodec("ChunkY", (Codec)Codec.INTEGER), (chunkInfo, value, extraInfo) -> chunkInfo.setChunkZ((int)value), (chunkInfo, extraInfo) -> chunkInfo.getChunkZ()).add()).append(new KeyedCodec("CreatedTracker", ModifiedTracking.CODEC), (partyInfo, partyOverrides, extraInfo) -> partyInfo.setCreatedTracked((ModifiedTracking)partyOverrides), (partyInfo, extraInfo) -> partyInfo.getCreatedTracked()).add()).build();
    public static ArrayCodec<ChunkInfo> CODEC_ARRAY = new ArrayCodec(CODEC, ChunkInfo[]::new);
    private UUID partyOwner;
    private int chunkX;
    private int chunkZ;
    private ModifiedTracking createdTracked;

    public static String formatCoordinates(int chunkX, int chunkZ) {
        return chunkX + ":" + chunkZ;
    }

    public ChunkInfo(UUID partyOwner, int chunkX, int chunkZ) {
        this.partyOwner = partyOwner;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.createdTracked = new ModifiedTracking(UUID.randomUUID(), "-", LocalDateTime.now().toString());
    }

    public ChunkInfo() {
        this(UUID.randomUUID(), 0, 0);
    }

    public UUID getPartyOwner() {
        return this.partyOwner;
    }

    public void setPartyOwner(UUID partyOwner) {
        this.partyOwner = partyOwner;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public void setChunkX(int chunkX) {
        this.chunkX = chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public void setChunkZ(int chunkZ) {
        this.chunkZ = chunkZ;
    }

    public ModifiedTracking getCreatedTracked() {
        return this.createdTracked;
    }

    public void setCreatedTracked(ModifiedTracking createdTracked) {
        this.createdTracked = createdTracked;
    }

    public String getCoordinates() {
        return ChunkInfo.formatCoordinates(this.chunkX, this.chunkZ);
    }

    public static class ChunkInfoStorage {
        public static final BuilderCodec<ChunkInfoStorage> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(ChunkInfoStorage.class, ChunkInfoStorage::new).append(new KeyedCodec("Dimension", (Codec)Codec.STRING), (chunkInfoStorage, string, extraInfo) -> chunkInfoStorage.setDimension((String)string), (chunkInfoStorage, extraInfo) -> chunkInfoStorage.getDimension()).add()).append(new KeyedCodec("ChunkInfo", CODEC_ARRAY), (chunkInfoStorage, chunkInfos, extraInfo) -> chunkInfoStorage.setChunkInfos((ChunkInfo[])chunkInfos), (chunkInfoStorage, extraInfo) -> chunkInfoStorage.getChunkInfos()).add()).build();
        public static ArrayCodec<ChunkInfoStorage> CODEC_ARRAY = new ArrayCodec(CODEC, ChunkInfoStorage[]::new);
        public String dimension;
        private ChunkInfo[] chunkInfos;

        public ChunkInfoStorage() {
            this("", new ChunkInfo[0]);
        }

        public ChunkInfoStorage(String dimension, ChunkInfo[] infos) {
            this.dimension = dimension;
            this.chunkInfos = infos;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public ChunkInfo[] getChunkInfos() {
            return this.chunkInfos;
        }

        public void setChunkInfos(ChunkInfo[] chunkInfos) {
            this.chunkInfos = chunkInfos;
        }
    }

    public static final class DimensionStorage {
        public static final BuilderCodec<DimensionStorage> CODEC = ((BuilderCodec.Builder)BuilderCodec.builder(DimensionStorage.class, DimensionStorage::new).append(new KeyedCodec("Dimensions", ChunkInfoStorage.CODEC_ARRAY), (dimensionStorage, infoStorages, extraInfo) -> dimensionStorage.setChunkInfoStorages((ChunkInfoStorage[])infoStorages), (dimensionStorage, extraInfo) -> dimensionStorage.getChunkInfoStorages()).add()).build();
        private ChunkInfoStorage[] chunkInfoStorages;

        public DimensionStorage(ChunkInfoStorage[] chunkInfoStorages) {
            this.chunkInfoStorages = chunkInfoStorages;
        }

        public DimensionStorage() {
            this(new ChunkInfoStorage[0]);
        }

        public ChunkInfoStorage[] getChunkInfoStorages() {
            return this.chunkInfoStorages;
        }

        public void setChunkInfoStorages(ChunkInfoStorage[] chunkInfoStorages) {
            this.chunkInfoStorages = chunkInfoStorages;
        }
    }
}

