/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims.claim;

import com.buuz135.simpleclaims.Main;
import com.buuz135.simpleclaims.claim.chunk.ChunkInfo;
import com.buuz135.simpleclaims.claim.party.PartyInfo;
import com.buuz135.simpleclaims.claim.party.PartyInvite;
import com.buuz135.simpleclaims.claim.player_name.PlayerNameTracker;
import com.buuz135.simpleclaims.claim.tracking.ModifiedTracking;
import com.buuz135.simpleclaims.commands.CommandMessages;
import com.buuz135.simpleclaims.config.SimpleClaimsConfig;
import com.buuz135.simpleclaims.files.AdminOverridesBlockingFile;
import com.buuz135.simpleclaims.files.ClaimedChunkBlockingFile;
import com.buuz135.simpleclaims.files.PartyBlockingFile;
import com.buuz135.simpleclaims.files.PlayerNameTrackerBlockingFile;
import com.buuz135.simpleclaims.util.FileUtils;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.awt.Color;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class ClaimManager {
    private static final ClaimManager INSTANCE = new ClaimManager();
    private final Map<UUID, UUID> adminUsageParty;
    private final Map<UUID, PartyInvite> partyInvites;
    private final Map<UUID, UUID> playerToParty;
    private final Map<UUID, Integer> partyClaimCounts;
    private Set<String> worldsNeedingUpdates;
    private boolean isDirty = false;
    private Thread savingThread;
    private HytaleLogger logger = HytaleLogger.getLogger().getSubLogger("SimpleClaims");
    private PlayerNameTrackerBlockingFile playerNameTrackerBlockingFile;
    private PartyBlockingFile partyBlockingFile;
    private ClaimedChunkBlockingFile claimedChunkBlockingFile;
    private AdminOverridesBlockingFile adminOverridesBlockingFile;
    private HashMap<String, LongSet> mapUpdateQueue;

    public static ClaimManager getInstance() {
        return INSTANCE;
    }

    private ClaimManager() {
        this.adminUsageParty = new ConcurrentHashMap<UUID, UUID>();
        this.worldsNeedingUpdates = new HashSet<String>();
        this.partyInvites = new ConcurrentHashMap<UUID, PartyInvite>();
        this.playerToParty = new ConcurrentHashMap<UUID, UUID>();
        this.partyClaimCounts = new ConcurrentHashMap<UUID, Integer>();
        this.partyBlockingFile = new PartyBlockingFile();
        this.claimedChunkBlockingFile = new ClaimedChunkBlockingFile();
        this.playerNameTrackerBlockingFile = new PlayerNameTrackerBlockingFile();
        this.adminOverridesBlockingFile = new AdminOverridesBlockingFile();
        this.mapUpdateQueue = new HashMap();
        FileUtils.ensureMainDirectory();
        this.logger.at(Level.INFO).log("Loading simple claims data...");
        FileUtils.ensureFile(FileUtils.PARTY_PATH, "{}");
        this.logger.at(Level.INFO).log("Loading party data...");
        FileUtils.loadWithBackup(() -> ((PartyBlockingFile)this.partyBlockingFile).syncLoad(), FileUtils.PARTY_PATH, this.logger);
        for (PartyInfo partyInfo : this.partyBlockingFile.getParties().values()) {
            for (UUID member : partyInfo.getMembers()) {
                this.playerToParty.put(member, partyInfo.getId());
            }
        }
        FileUtils.ensureFile(FileUtils.CLAIM_PATH, "{}");
        FileUtils.loadWithBackup(() -> ((ClaimedChunkBlockingFile)this.claimedChunkBlockingFile).syncLoad(), FileUtils.CLAIM_PATH, this.logger);
        for (HashMap hashMap : this.claimedChunkBlockingFile.getChunks().values()) {
            for (ChunkInfo chunk : hashMap.values()) {
                this.partyClaimCounts.merge(chunk.getPartyOwner(), 1, Integer::sum);
            }
        }
        FileUtils.ensureFile(FileUtils.NAMES_CACHE_PATH, "{}");
        FileUtils.loadWithBackup(() -> ((PlayerNameTrackerBlockingFile)this.playerNameTrackerBlockingFile).syncLoad(), FileUtils.NAMES_CACHE_PATH, this.logger);
        FileUtils.ensureFile(FileUtils.ADMIN_OVERRIDES_PATH, "{}");
        FileUtils.loadWithBackup(() -> ((AdminOverridesBlockingFile)this.adminOverridesBlockingFile).syncLoad(), FileUtils.ADMIN_OVERRIDES_PATH, this.logger);
        this.savingThread = new Thread(() -> {
            while (true) {
                if (this.isDirty) {
                    this.isDirty = false;
                    this.logger.at(Level.INFO).log("Saving data...");
                    FileUtils.ensureMainDirectory();
                    try {
                        FileUtils.ensureFile(FileUtils.PARTY_PATH, "{}");
                        FileUtils.backupFile(FileUtils.PARTY_PATH);
                        this.partyBlockingFile.syncSave();
                    }
                    catch (Exception e) {
                        this.logger.at(Level.SEVERE).log(e.getMessage());
                    }
                    try {
                        FileUtils.ensureFile(FileUtils.CLAIM_PATH, "{}");
                        FileUtils.backupFile(FileUtils.CLAIM_PATH);
                        this.claimedChunkBlockingFile.syncSave();
                    }
                    catch (Exception e) {
                        this.logger.at(Level.SEVERE).log(e.getMessage());
                    }
                    try {
                        FileUtils.ensureFile(FileUtils.NAMES_CACHE_PATH, "{}");
                        FileUtils.backupFile(FileUtils.NAMES_CACHE_PATH);
                        this.playerNameTrackerBlockingFile.syncSave();
                    }
                    catch (Exception e) {
                        this.logger.at(Level.SEVERE).log(e.getMessage());
                    }
                    try {
                        FileUtils.ensureFile(FileUtils.ADMIN_OVERRIDES_PATH, "{}");
                        FileUtils.backupFile(FileUtils.ADMIN_OVERRIDES_PATH);
                        this.adminOverridesBlockingFile.syncSave();
                    }
                    catch (Exception e) {
                        this.logger.at(Level.SEVERE).log(e.getMessage());
                    }
                    this.logger.at(Level.INFO).log("Finished saving data... Eepy time...");
                }
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.at(Level.SEVERE).log("SAVING THREAD ERROR");
                    this.logger.at(Level.SEVERE).log(e.getMessage());
                    continue;
                }
                break;
            }
        });
        this.savingThread.start();
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void addParty(PartyInfo partyInfo) {
        this.partyBlockingFile.getParties().put(partyInfo.getId().toString(), partyInfo);
    }

    public boolean isAllowedToInteract(UUID playerUUID, String dimension, int chunkX, int chunkZ, Predicate<PartyInfo> interactMethod) {
        if (this.adminOverridesBlockingFile.getAdminOverrides().contains(playerUUID)) {
            return true;
        }
        ChunkInfo chunkInfo = this.getChunkRawCoords(dimension, chunkX, chunkZ);
        if (chunkInfo == null) {
            return !Arrays.asList(((SimpleClaimsConfig)Main.CONFIG.get()).getFullWorldProtection()).contains(dimension);
        }
        PartyInfo chunkParty = this.getPartyById(chunkInfo.getPartyOwner());
        if (chunkParty == null || interactMethod.test(chunkParty)) {
            return true;
        }
        if (chunkParty.getPlayerAllies().contains(playerUUID)) {
            return true;
        }
        UUID partyId = this.playerToParty.get(playerUUID);
        if (partyId == null) {
            return false;
        }
        return chunkInfo.getPartyOwner().equals(partyId) || chunkParty.getPartyAllies().contains(partyId);
    }

    @Nullable
    public PartyInfo getPartyFromPlayer(UUID player) {
        UUID partyId = this.playerToParty.get(player);
        if (partyId == null) {
            return null;
        }
        return this.getPartyById(partyId);
    }

    @Nullable
    public PartyInfo getPartyById(UUID partyId) {
        return this.partyBlockingFile.getParties().get(partyId.toString());
    }

    public PartyInfo createParty(Player owner, PlayerRef playerRef, boolean isAdmin) {
        PartyInfo party = new PartyInfo(UUID.randomUUID(), playerRef.getUuid(), owner.getDisplayName() + "'s Party", owner.getDisplayName() + "'s Party Description", new UUID[0], Color.getHSBColor(new Random().nextFloat(), 1.0f, 1.0f).getRGB());
        party.addMember(playerRef.getUuid());
        party.setCreatedTracked(new ModifiedTracking(playerRef.getUuid(), owner.getDisplayName(), LocalDateTime.now().toString()));
        party.setModifiedTracked(new ModifiedTracking(playerRef.getUuid(), owner.getDisplayName(), LocalDateTime.now().toString()));
        this.partyBlockingFile.getParties().put(party.getId().toString(), party);
        if (!isAdmin) {
            this.playerToParty.put(playerRef.getUuid(), party.getId());
        }
        this.markDirty();
        return party;
    }

    public boolean canClaimInDimension(World world) {
        if (world.getWorldConfig().isDeleteOnRemove()) {
            return false;
        }
        if (world.getName().contains("Gaia_Temple")) {
            return false;
        }
        return !Arrays.asList(((SimpleClaimsConfig)Main.CONFIG.get()).getWorldNameBlacklistForClaiming()).contains(world.getName());
    }

    @Nullable
    public ChunkInfo getChunk(String dimension, int chunkX, int chunkZ) {
        HashMap chunkInfo = this.getChunks().computeIfAbsent(dimension, k -> new HashMap());
        String formattedChunk = ChunkInfo.formatCoordinates(chunkX, chunkZ);
        return chunkInfo.getOrDefault(formattedChunk, null);
    }

    @Nullable
    public ChunkInfo getChunkRawCoords(String dimension, int blockX, int blockZ) {
        return this.getChunk(dimension, ChunkUtil.chunkCoordinate((int)blockX), ChunkUtil.chunkCoordinate((int)blockZ));
    }

    public ChunkInfo claimChunkBy(String dimension, int chunkX, int chunkZ, PartyInfo partyInfo, Player owner, PlayerRef playerRef) {
        ChunkInfo chunkInfo = new ChunkInfo(partyInfo.getId(), chunkX, chunkZ);
        HashMap chunkDimension = this.getChunks().computeIfAbsent(dimension, k -> new HashMap());
        chunkDimension.put(ChunkInfo.formatCoordinates(chunkX, chunkZ), chunkInfo);
        chunkInfo.setCreatedTracked(new ModifiedTracking(playerRef.getUuid(), owner.getDisplayName(), LocalDateTime.now().toString()));
        this.partyClaimCounts.merge(partyInfo.getId(), 1, Integer::sum);
        this.markDirty();
        return chunkInfo;
    }

    public ChunkInfo claimChunkByRawCoords(String dimension, int blockX, int blockZ, PartyInfo partyInfo, Player owner, PlayerRef playerRef) {
        return this.claimChunkBy(dimension, ChunkUtil.chunkCoordinate((int)blockX), ChunkUtil.chunkCoordinate((int)blockZ), partyInfo, owner, playerRef);
    }

    public boolean hasEnoughClaimsLeft(PartyInfo partyInfo) {
        int maxAmount = partyInfo.getMaxClaimAmount();
        int currentAmount = this.partyClaimCounts.getOrDefault(partyInfo.getId(), 0);
        return currentAmount < maxAmount;
    }

    public int getAmountOfClaims(PartyInfo partyInfo) {
        return this.partyClaimCounts.getOrDefault(partyInfo.getId(), 0);
    }

    public void unclaim(String dimension, int chunkX, int chunkZ) {
        ChunkInfo removed;
        HashMap<String, ChunkInfo> chunkMap = this.getChunks().get(dimension);
        if (chunkMap != null && (removed = chunkMap.remove(ChunkInfo.formatCoordinates(chunkX, chunkZ))) != null) {
            this.partyClaimCounts.computeIfPresent(removed.getPartyOwner(), (k, v) -> v > 1 ? Integer.valueOf(v - 1) : null);
        }
        this.markDirty();
    }

    public void unclaimRawCoords(String dimension, int blockX, int blockZ) {
        this.unclaim(dimension, ChunkUtil.chunkCoordinate((int)blockX), ChunkUtil.chunkCoordinate((int)blockZ));
    }

    public Set<String> getWorldsNeedingUpdates() {
        return this.worldsNeedingUpdates;
    }

    public void setNeedsMapUpdate(String world) {
        this.worldsNeedingUpdates.add(world);
    }

    public PlayerNameTracker getPlayerNameTracker() {
        return this.playerNameTrackerBlockingFile.getTracker();
    }

    public HashMap<String, PartyInfo> getParties() {
        return this.partyBlockingFile.getParties();
    }

    public HashMap<String, HashMap<String, ChunkInfo>> getChunks() {
        return this.claimedChunkBlockingFile.getChunks();
    }

    public Map<UUID, UUID> getAdminUsageParty() {
        return this.adminUsageParty;
    }

    public void invitePlayerToParty(PlayerRef recipient, PartyInfo partyInfo, PlayerRef sender) {
        this.partyInvites.put(recipient.getUuid(), new PartyInvite(recipient.getUuid(), sender.getUuid(), partyInfo.getId()));
    }

    public PartyInvite acceptInvite(PlayerRef player) {
        PartyInvite invite = this.partyInvites.get(player.getUuid());
        if (invite == null) {
            return null;
        }
        PartyInfo party = this.getPartyById(invite.party());
        if (party == null) {
            return null;
        }
        if (((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyMembers() != -1 && party.getMembers().length >= ((SimpleClaimsConfig)Main.CONFIG.get()).getMaxPartyMembers()) {
            this.partyInvites.remove(player.getUuid());
            return null;
        }
        party.addMember(player.getUuid());
        this.playerToParty.put(player.getUuid(), party.getId());
        this.partyInvites.remove(player.getUuid());
        return invite;
    }

    public Map<UUID, PartyInvite> getPartyInvites() {
        return this.partyInvites;
    }

    public void leaveParty(PlayerRef player, PartyInfo partyInfo) {
        this.playerToParty.remove(player.getUuid());
        if (partyInfo.isOwner(player.getUuid())) {
            partyInfo.removeMember(player.getUuid());
            if (partyInfo.getMembers().length > 0) {
                partyInfo.setOwner(partyInfo.getMembers()[0]);
                player.sendMessage(CommandMessages.PARTY_OWNER_TRANSFERRED.param("username", this.getPlayerNameTracker().getPlayerName(partyInfo.getMembers()[0])));
            } else {
                this.disbandParty(partyInfo);
                player.sendMessage(CommandMessages.PARTY_DISBANDED);
            }
        } else {
            partyInfo.removeMember(player.getUuid());
            player.sendMessage(CommandMessages.PARTY_LEFT);
        }
        this.markDirty();
    }

    public void disbandParty(PartyInfo partyInfo) {
        for (UUID member : partyInfo.getMembers()) {
            this.playerToParty.remove(member);
        }
        this.queueMapUpdateForParty(partyInfo);
        this.getChunks().forEach((dimension, chunkInfos) -> chunkInfos.values().removeIf(chunkInfo -> chunkInfo.getPartyOwner().equals(partyInfo.getId())));
        this.partyClaimCounts.remove(partyInfo.getId());
        this.partyBlockingFile.getParties().remove(partyInfo.getId().toString());
        this.markDirty();
    }

    public Set<UUID> getAdminClaimOverrides() {
        return this.adminOverridesBlockingFile.getAdminOverrides();
    }

    public void queueMapUpdateForParty(PartyInfo partyInfo) {
        this.getChunks().forEach((dimension, chunkInfos) -> {
            World world = (World)Universe.get().getWorlds().get(dimension);
            if (world != null) {
                for (ChunkInfo value : chunkInfos.values()) {
                    if (!value.getPartyOwner().equals(partyInfo.getId())) continue;
                    this.queueMapUpdate(world, value.getChunkX(), value.getChunkZ());
                }
            }
        });
    }

    public void queueMapUpdate(World world, int chunkX, int chunkZ) {
        if (!this.mapUpdateQueue.containsKey(world.getName())) {
            this.mapUpdateQueue.put(world.getName(), (LongSet)new LongOpenHashSet());
        }
        this.mapUpdateQueue.get(world.getName()).add(ChunkUtil.indexChunk((int)chunkX, (int)chunkZ));
        this.mapUpdateQueue.get(world.getName()).add(ChunkUtil.indexChunk((int)(chunkX + 1), (int)chunkZ));
        this.mapUpdateQueue.get(world.getName()).add(ChunkUtil.indexChunk((int)(chunkX - 1), (int)chunkZ));
        this.mapUpdateQueue.get(world.getName()).add(ChunkUtil.indexChunk((int)chunkX, (int)(chunkZ + 1)));
        this.mapUpdateQueue.get(world.getName()).add(ChunkUtil.indexChunk((int)chunkX, (int)(chunkZ - 1)));
        this.setNeedsMapUpdate(world.getName());
    }

    public HashMap<String, LongSet> getMapUpdateQueue() {
        return this.mapUpdateQueue;
    }

    public Map<UUID, UUID> getPlayerToParty() {
        return this.playerToParty;
    }
}

