/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.simpleclaims;

import com.buuz135.simpleclaims.claim.ClaimManager;
import com.buuz135.simpleclaims.commands.SimpleClaimProtectCommand;
import com.buuz135.simpleclaims.commands.SimpleClaimsPartyCommand;
import com.buuz135.simpleclaims.config.SimpleClaimsConfig;
import com.buuz135.simpleclaims.map.SimpleClaimsWorldMapProvider;
import com.buuz135.simpleclaims.systems.events.BreakBlockEventSystem;
import com.buuz135.simpleclaims.systems.events.CustomDamageEventSystem;
import com.buuz135.simpleclaims.systems.events.InteractEventSystem;
import com.buuz135.simpleclaims.systems.events.PickupInteractEventSystem;
import com.buuz135.simpleclaims.systems.events.PlaceBlockEventSystem;
import com.buuz135.simpleclaims.systems.tick.ChunkBordersTickingSystem;
import com.buuz135.simpleclaims.systems.tick.EntryTickingSystem;
import com.buuz135.simpleclaims.systems.tick.TitleTickingSystem;
import com.buuz135.simpleclaims.systems.tick.WorldMapUpdateTickingSystem;
import com.hypixel.hytale.component.system.ISystem;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.player.AddPlayerToWorldEvent;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.events.AddWorldEvent;
import com.hypixel.hytale.server.core.universe.world.worldmap.provider.IWorldMapProvider;
import com.hypixel.hytale.server.core.universe.world.worldmap.provider.chunk.WorldGenWorldMapProvider;
import com.hypixel.hytale.server.core.util.Config;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class Main
extends JavaPlugin {
    public static Config<SimpleClaimsConfig> CONFIG;

    public Main(@NonNullDecl JavaPluginInit init) {
        super(init);
        CONFIG = this.withConfig("SimpleClaims", SimpleClaimsConfig.CODEC);
    }

    protected void setup() {
        super.setup();
        CONFIG.save();
        this.getEntityStoreRegistry().registerSystem((ISystem)new BreakBlockEventSystem());
        this.getEntityStoreRegistry().registerSystem((ISystem)new PlaceBlockEventSystem());
        this.getEntityStoreRegistry().registerSystem((ISystem)new InteractEventSystem());
        this.getEntityStoreRegistry().registerSystem((ISystem)new PickupInteractEventSystem());
        this.getEntityStoreRegistry().registerSystem((ISystem)new TitleTickingSystem(((SimpleClaimsConfig)CONFIG.get()).getTitleTopClaimTitleText()));
        if (((SimpleClaimsConfig)CONFIG.get()).isEnableAlloyEntryTesting()) {
            this.getEntityStoreRegistry().registerSystem((ISystem)new EntryTickingSystem());
        }
        if (((SimpleClaimsConfig)CONFIG.get()).isEnableParticleBorders()) {
            this.getEntityStoreRegistry().registerSystem((ISystem)new ChunkBordersTickingSystem());
        }
        this.getEntityStoreRegistry().registerSystem((ISystem)new CustomDamageEventSystem());
        this.getChunkStoreRegistry().registerSystem((ISystem)new WorldMapUpdateTickingSystem());
        this.getCommandRegistry().registerCommand((AbstractCommand)new SimpleClaimProtectCommand());
        this.getCommandRegistry().registerCommand((AbstractCommand)new SimpleClaimsPartyCommand());
        IWorldMapProvider.CODEC.register((Object)"SimpleClaims", SimpleClaimsWorldMapProvider.class, SimpleClaimsWorldMapProvider.CODEC);
        ClaimManager.getInstance();
        this.getEventRegistry().registerGlobal(AddWorldEvent.class, event -> {
            this.getLogger().at(Level.INFO).log("Registered world: " + event.getWorld().getName());
            if (((SimpleClaimsConfig)CONFIG.get()).isForceSimpleClaimsChunkWorldMap() && !event.getWorld().getWorldConfig().isDeleteOnRemove()) {
                this.getLogger().at(Level.INFO).log("Registered map for world: " + event.getWorld().getName());
                event.getWorld().getWorldConfig().setWorldMapProvider((IWorldMapProvider)new SimpleClaimsWorldMapProvider());
            } else {
                event.getWorld().getWorldConfig().setWorldMapProvider((IWorldMapProvider)new WorldGenWorldMapProvider());
            }
        });
        this.getEventRegistry().registerGlobal(AddPlayerToWorldEvent.class, event -> {
            Player player = (Player)event.getHolder().getComponent(Player.getComponentType());
            PlayerRef playerRef = (PlayerRef)event.getHolder().getComponent(PlayerRef.getComponentType());
            ClaimManager.getInstance().getPlayerNameTracker().setPlayerName(playerRef.getUuid(), player.getDisplayName());
            ClaimManager.getInstance().markDirty();
        });
    }
}

