/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.oreharvester.event;

import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.universe.world.World;
import com.natamus.hybrid.event.callback.EntityBreakBlockCallback;
import com.natamus.hybrid.functions.BlockFunctions;
import com.natamus.hybrid.functions.PlayerFunctions;
import com.natamus.hybrid.functions.ToolFunctions;
import com.natamus.hybrid.functions.VectorFunctions;
import com.natamus.oreharvester.config.ConfigHandler;
import java.util.List;
import java.util.Objects;

public class EntityCallbacks {
    public static void init() {
        EntityBreakBlockCallback.ENTITY_BREAK_BLOCK.register(EntityCallbacks::blockBreakEvent);
    }

    private static boolean blockBreakEvent(Player player, BlockType blockType, Vector3i targetBlockPos, ItemStack handStack) {
        if (!ConfigHandler.getConfigHandler().enableOreHarvester) {
            return true;
        }
        World world = player.getWorld();
        if (world == null) {
            return true;
        }
        if (ConfigHandler.getConfigHandler().playerMustCrouch && !PlayerFunctions.isCrouching((Player)player)) {
            return true;
        }
        if (!BlockFunctions.isOre((BlockType)blockType)) {
            return true;
        }
        if (ConfigHandler.getConfigHandler().mustHoldPickaxe && !ToolFunctions.isPickaxe((ItemStack)handStack)) {
            return true;
        }
        List connectedOrePositions = VectorFunctions.getAllConnectedBlockPositions((World)world, (Vector3i)targetBlockPos, (boolean)false);
        if (connectedOrePositions.isEmpty()) {
            return true;
        }
        boolean dropOresAtFirstBrokenBlock = ConfigHandler.getConfigHandler().dropOresAtFirstBrokenBlock;
        boolean decreaseDurability = ConfigHandler.getConfigHandler().decreaseDurabilityPerHarvestedOre;
        for (Vector3i orePos : connectedOrePositions) {
            if (Objects.requireNonNull(player.getInventory().getItemInHand()).isBroken()) break;
            if (dropOresAtFirstBrokenBlock) {
                BlockFunctions.dropBlock((World)world, (Vector3i)orePos, (Vector3i)targetBlockPos, (boolean)true);
            } else {
                BlockFunctions.dropBlock((World)world, (Vector3i)orePos, (Vector3i)orePos, (boolean)true);
            }
            if (!decreaseDurability) continue;
            PlayerFunctions.decreaseHeldItemDurability((Player)player, (World)world, (double)ConfigHandler.getConfigHandler().durabilityPerHarvestedOre, (boolean)false);
        }
        return true;
    }
}

