/*
 * Decompiled with CFR 0.152.
 */
package games.player.home.commands;

import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.modules.entity.teleport.Teleport;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import games.player.home.HomeManager;
import java.util.UUID;
import javax.annotation.Nonnull;

public class HomeCommand
extends AbstractPlayerCommand {
    private final HomeManager homeManager;

    public HomeCommand(@Nonnull HomeManager homeManager) {
        super("home", "Teleport to your home location");
        this.homeManager = homeManager;
    }

    protected boolean canGeneratePermission() {
        return false;
    }

    protected void execute(@Nonnull CommandContext context, @Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull PlayerRef playerRef, @Nonnull World world) {
        UUID playerUuid = playerRef.getUuid();
        HomeManager.HomeLocation home = this.homeManager.getHome(playerUuid);
        if (home == null) {
            context.sendMessage(Message.raw((String)"You don't have a home set. Use /sethome first."));
            return;
        }
        World targetWorld = Universe.get().getWorld(home.worldName());
        if (targetWorld == null) {
            targetWorld = world;
        }
        World finalTargetWorld = targetWorld;
        world.execute(() -> {
            Teleport teleport = new Teleport(finalTargetWorld, home.toPosition(), home.toRotation());
            store.addComponent(ref, Teleport.getComponentType(), (Component)teleport);
            context.sendMessage(Message.raw((String)String.format("Teleporting to home at %.1f, %.1f, %.1f", home.x(), home.y(), home.z())));
        });
    }
}

