/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jet.registry;

import com.hypixel.hytale.server.core.asset.type.item.config.CraftingRecipe;
import com.hypixel.hytale.server.core.inventory.MaterialQuantity;
import dev.hytalemod.jet.JETPlugin;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class RecipeRegistry {
    private final Map<String, CraftingRecipe> recipes = new LinkedHashMap<String, CraftingRecipe>();
    private final Map<String, List<String>> craftingRecipes = new HashMap<String, List<String>>();
    private final Map<String, List<String>> usageRecipes = new HashMap<String, List<String>>();
    private Method getInputMethod = null;

    public void reload(Map<String, CraftingRecipe> newRecipes) {
        this.recipes.clear();
        this.craftingRecipes.clear();
        this.usageRecipes.clear();
        try {
            Method[] methods;
            Path logsDir = Paths.get(System.getProperty("user.home"), "AppData", "Roaming", "Hytale", "UserData", "Logs");
            Files.createDirectories(logsDir, new FileAttribute[0]);
            FileWriter methodsFile = new FileWriter(logsDir.resolve("JET_methods.txt").toFile());
            methodsFile.write("=== All CraftingRecipe Methods ===\n");
            for (Method m : methods = CraftingRecipe.class.getMethods()) {
                methodsFile.write(m.getName() + "(");
                Class<?>[] classArray = m.getParameterTypes();
                for (int i = 0; i < classArray.length; ++i) {
                    if (i > 0) {
                        methodsFile.write(", ");
                    }
                    methodsFile.write(classArray[i].getSimpleName());
                }
                methodsFile.write(") -> " + m.getReturnType().getSimpleName() + "\n");
            }
            methodsFile.close();
        }
        catch (Exception ex) {
            JETPlugin.getInstance().getLogger().at(Level.WARNING).log("[JET] Failed to write methods file: " + ex.getMessage());
        }
        try {
            this.getInputMethod = CraftingRecipe.class.getMethod("getInput", new Class[0]);
            JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] Found getInput method");
        }
        catch (Exception e) {
            this.getInputMethod = null;
            JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] No getInput method found, will try alternatives");
        }
        int outputCount = 0;
        int inputCount = 0;
        for (Map.Entry<String, CraftingRecipe> entry : newRecipes.entrySet()) {
            CraftingRecipe craftingRecipe = entry.getValue();
            String recipeId = craftingRecipe.getId();
            this.recipes.put(recipeId, craftingRecipe);
            MaterialQuantity[] outputs = craftingRecipe.getOutputs();
            if (outputs != null) {
                for (MaterialQuantity output : outputs) {
                    if (output == null || output.getItemId() == null) continue;
                    this.craftingRecipes.computeIfAbsent(output.getItemId(), k -> new ArrayList()).add(recipeId);
                    ++outputCount;
                }
            }
            int n = this.usageRecipes.size();
            this.indexInputs(craftingRecipe, recipeId);
            if (this.usageRecipes.size() <= n) continue;
            ++inputCount;
        }
        JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] Indexed " + outputCount + " recipe outputs across " + this.craftingRecipes.size() + " items");
        JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] Indexed " + inputCount + " recipes with inputs across " + this.usageRecipes.size() + " items");
        int debugCount = 0;
        for (Map.Entry<String, List<String>> entry : this.usageRecipes.entrySet()) {
            if (debugCount++ >= 5) continue;
            JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET]   - Item " + entry.getKey() + " used in " + entry.getValue().size() + " recipes");
        }
        try {
            FileWriter fileWriter;
            block25: {
                Path path = Paths.get(System.getProperty("user.home"), "AppData", "Roaming", "Hytale", "UserData", "Logs");
                Files.createDirectories(path, new FileAttribute[0]);
                fileWriter = new FileWriter(path.resolve("JET_debug.txt").toFile());
                fileWriter.write("=== JET Recipe Registry Debug ===\n");
                fileWriter.write("Total recipes: " + this.recipes.size() + "\n");
                fileWriter.write("Items with crafting recipes: " + this.craftingRecipes.size() + "\n");
                fileWriter.write("Items with usage recipes: " + this.usageRecipes.size() + "\n\n");
                fileWriter.write("First 10 items with usage recipes:\n");
                int count = 0;
                for (Map.Entry entry : this.usageRecipes.entrySet()) {
                    if (count++ >= 10) break;
                    fileWriter.write("  " + (String)entry.getKey() + ": " + ((List)entry.getValue()).size() + " recipes\n");
                }
                fileWriter.write("\nChecking gold/copper usage recipes:\n");
                for (String string : this.usageRecipes.keySet()) {
                    if (!string.contains("gold") && !string.contains("copper") && !string.contains("Gold") && !string.contains("Copper") && !string.contains("Ingot")) continue;
                    fileWriter.write("  " + string + ": " + this.usageRecipes.get(string).size() + " uses\n");
                }
                fileWriter.write("\nChecking gold/copper/ingot crafting recipes:\n");
                for (String string : this.craftingRecipes.keySet()) {
                    if (!string.contains("gold") && !string.contains("copper") && !string.contains("Gold") && !string.contains("Copper") && !string.contains("Ingot") && !string.contains("Ingredient")) continue;
                    fileWriter.write("  " + string + ": " + this.craftingRecipes.get(string).size() + " craft recipes\n");
                }
                fileWriter.write("\nAll items with 'Ingredient' in name:\n");
                for (String string : this.usageRecipes.keySet()) {
                    if (!string.contains("Ingredient")) continue;
                    fileWriter.write("  USAGE: " + string + ": " + this.usageRecipes.get(string).size() + " uses\n");
                }
                for (String string : this.craftingRecipes.keySet()) {
                    if (!string.contains("Ingredient")) continue;
                    fileWriter.write("  CRAFT: " + string + ": " + this.craftingRecipes.get(string).size() + " recipes\n");
                }
                fileWriter.write("\nDEBUG: Checking specific recipe inputs:\n");
                CraftingRecipe arcanebench = this.recipes.get("hytale:Arcanebench");
                if (arcanebench != null) {
                    fileWriter.write("Found Arcanebench recipe\n");
                    try {
                        Object object = this.getInputMethod.invoke((Object)arcanebench, new Object[0]);
                        if (object == null) {
                            fileWriter.write("  getInput() returned null\n");
                            break block25;
                        }
                        if (object instanceof MaterialQuantity[]) {
                            MaterialQuantity[] arr = (MaterialQuantity[])object;
                            fileWriter.write("  getInput() returned array of length: " + arr.length + "\n");
                            for (int i = 0; i < arr.length; ++i) {
                                MaterialQuantity mq = arr[i];
                                if (mq == null) continue;
                                fileWriter.write("    [" + i + "] " + mq.getItemId() + " x" + mq.getQuantity() + "\n");
                            }
                            break block25;
                        }
                        fileWriter.write("  getInput() returned unexpected type: " + object.getClass().getName() + "\n");
                    }
                    catch (Exception exception) {
                        fileWriter.write("  Error calling getInput(): " + exception.getMessage() + "\n");
                    }
                } else {
                    fileWriter.write("Arcanebench recipe not found\n");
                }
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            JETPlugin.getInstance().getLogger().at(Level.WARNING).log("[JET] Failed to write debug file: " + exception.getMessage());
        }
    }

    private void indexInputs(CraftingRecipe recipe, String recipeId) {
        block23: {
            Object inputsObj;
            block24: {
                inputsObj = null;
                Object successMethod = null;
                if (this.getInputMethod != null) {
                    try {
                        inputsObj = this.getInputMethod.invoke((Object)recipe, new Object[0]);
                        if (inputsObj != null) {
                            if (inputsObj instanceof MaterialQuantity[] && ((MaterialQuantity[])inputsObj).length > 0) {
                                successMethod = "getInput";
                            } else if (!(inputsObj instanceof MaterialQuantity[])) {
                                successMethod = "getInput";
                            } else {
                                inputsObj = null;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (inputsObj == null) {
                    String[] methodNames = new String[]{"getInputs", "getIngredients", "getMaterials", "getRecipeInputs", "getRequiredMaterials"};
                    for (String methodName : methodNames) {
                        try {
                            Method method = CraftingRecipe.class.getMethod(methodName, new Class[0]);
                            inputsObj = method.invoke((Object)recipe, new Object[0]);
                            if (inputsObj == null) continue;
                            successMethod = methodName;
                            break;
                        }
                        catch (Exception method) {
                            // empty catch block
                        }
                    }
                }
                if (inputsObj == null) {
                    return;
                }
                if (successMethod != null && this.recipes.size() < 10) {
                    JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] Recipe " + recipeId + " inputs detected via " + (String)successMethod);
                }
                if (inputsObj == null) break block23;
                if (!(inputsObj instanceof MaterialQuantity)) break block24;
                MaterialQuantity input = (MaterialQuantity)inputsObj;
                if (input == null || input.getItemId() == null) break block23;
                String itemId = input.getItemId();
                this.usageRecipes.computeIfAbsent(itemId, k -> new ArrayList()).add(recipeId);
                if (itemId.contains("gold") || itemId.contains("copper")) {
                    JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] Found usage (single): " + itemId + " in " + recipeId);
                }
                break block23;
            }
            if (inputsObj instanceof List) {
                inputs = (MaterialQuantity[])inputsObj;
                var6_7 = inputs.iterator();
                while (var6_7.hasNext()) {
                    MaterialQuantity input;
                    Object obj = var6_7.next();
                    if (!(obj instanceof MaterialQuantity) || (input = (MaterialQuantity)obj) == null || input.getItemId() == null) continue;
                    itemId = input.getItemId();
                    this.usageRecipes.computeIfAbsent(itemId, k -> new ArrayList()).add(recipeId);
                    if (!itemId.contains("gold") && !itemId.contains("copper")) continue;
                    JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] Found usage (list): " + itemId + " in " + recipeId);
                }
            } else if (inputsObj instanceof MaterialQuantity[]) {
                for (Object input : inputs = (MaterialQuantity[])inputsObj) {
                    if (input == null || input.getItemId() == null) continue;
                    String itemId = input.getItemId();
                    this.usageRecipes.computeIfAbsent(itemId, k -> new ArrayList()).add(recipeId);
                    if (!itemId.contains("gold") && !itemId.contains("copper")) continue;
                    JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] Found usage (array): " + itemId + " in " + recipeId);
                }
            } else if (inputsObj instanceof Collection) {
                inputs = (Collection)inputsObj;
                var6_7 = inputs.iterator();
                while (var6_7.hasNext()) {
                    MaterialQuantity input;
                    Object obj = var6_7.next();
                    if (!(obj instanceof MaterialQuantity) || (input = (MaterialQuantity)obj) == null || input.getItemId() == null) continue;
                    itemId = input.getItemId();
                    this.usageRecipes.computeIfAbsent(itemId, k -> new ArrayList()).add(recipeId);
                    if (!itemId.contains("gold") && !itemId.contains("copper")) continue;
                    JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] Found usage (collection): " + itemId + " in " + recipeId);
                }
            }
        }
    }

    public int size() {
        return this.recipes.size();
    }

    public CraftingRecipe get(String recipeId) {
        return this.recipes.get(recipeId);
    }

    public List<CraftingRecipe> getCraftingRecipes(String itemId) {
        List<String> recipeIds = this.craftingRecipes.get(itemId);
        if (recipeIds == null) {
            return Collections.emptyList();
        }
        ArrayList<CraftingRecipe> result = new ArrayList<CraftingRecipe>();
        for (String id : recipeIds) {
            CraftingRecipe r = this.recipes.get(id);
            if (r == null) continue;
            result.add(r);
        }
        return result;
    }

    public List<CraftingRecipe> getUsageRecipes(String itemId) {
        List<String> recipeIds = this.usageRecipes.get(itemId);
        if (recipeIds == null) {
            return Collections.emptyList();
        }
        ArrayList<CraftingRecipe> result = new ArrayList<CraftingRecipe>();
        for (String id : recipeIds) {
            CraftingRecipe r = this.recipes.get(id);
            if (r == null) continue;
            result.add(r);
        }
        return result;
    }

    public boolean hasCraftingRecipes(String itemId) {
        return this.craftingRecipes.containsKey(itemId) && !this.craftingRecipes.get(itemId).isEmpty();
    }

    public boolean hasUsageRecipes(String itemId) {
        return this.usageRecipes.containsKey(itemId) && !this.usageRecipes.get(itemId).isEmpty();
    }
}

