/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jet.registry;

import com.hypixel.hytale.server.core.asset.type.item.config.Item;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ItemRegistry {
    private final Map<String, Item> items = new LinkedHashMap<String, Item>();
    private final Map<Category, Set<String>> categoryIndex = new EnumMap<Category, Set<String>>(Category.class);
    private final Map<String, Set<String>> tagIndex = new HashMap<String, Set<String>>();

    public void reload(Map<String, Item> newItems) {
        this.items.clear();
        this.categoryIndex.clear();
        this.tagIndex.clear();
        for (Category cat : Category.values()) {
            this.categoryIndex.put(cat, new HashSet());
        }
        for (Map.Entry entry : newItems.entrySet()) {
            String idLower;
            String id = (String)entry.getKey();
            Item item = (Item)entry.getValue();
            this.items.put(id, item);
            this.categoryIndex.get((Object)Category.ALL).add(id);
            if (item.getTool() != null) {
                this.categoryIndex.get((Object)Category.TOOLS).add(id);
            }
            if (item.getWeapon() != null) {
                this.categoryIndex.get((Object)Category.WEAPONS).add(id);
            }
            if (item.getArmor() != null) {
                this.categoryIndex.get((Object)Category.ARMOR).add(id);
            }
            if (item.isConsumable()) {
                this.categoryIndex.get((Object)Category.FOOD).add(id);
            }
            if ((idLower = id.toLowerCase()).contains("block") || idLower.contains("brick") || idLower.contains("plank") || idLower.contains("stone") || idLower.contains("ore")) {
                this.categoryIndex.get((Object)Category.BLOCKS).add(id);
            }
            this.indexTags(id);
            boolean categorized = false;
            for (Category cat : Category.values()) {
                if (cat == Category.ALL || cat == Category.MISC || !this.categoryIndex.get((Object)cat).contains(id)) continue;
                categorized = true;
                break;
            }
            if (categorized) continue;
            this.categoryIndex.get((Object)Category.MISC).add(id);
        }
    }

    private void indexTags(String itemId) {
        String[] parts;
        for (String part : parts = itemId.split("[:_]")) {
            String tag = part.toLowerCase();
            if (tag.length() <= 2) continue;
            this.tagIndex.computeIfAbsent(tag, k -> new HashSet()).add(itemId);
        }
    }

    public int size() {
        return this.items.size();
    }

    public Item get(String id) {
        return this.items.get(id);
    }

    public Map<String, Item> getAll() {
        return Collections.unmodifiableMap(this.items);
    }

    public Set<String> getByCategory(Category category) {
        return Collections.unmodifiableSet(this.categoryIndex.getOrDefault((Object)category, Collections.emptySet()));
    }

    public Set<String> getByTag(String tag) {
        return Collections.unmodifiableSet(this.tagIndex.getOrDefault(tag.toLowerCase(), Collections.emptySet()));
    }

    public List<Map.Entry<String, Item>> search(String query) {
        if (query == null || query.isEmpty()) {
            return this.items.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        }
        query = query.trim();
        HashSet<String> matchingIds = new HashSet<String>(this.items.keySet());
        String[] terms = query.split("\\s+");
        String textSearch = "";
        for (String term : terms) {
            if (term.startsWith("@")) {
                String catName = term.substring(1).toLowerCase();
                HashSet catIds = new HashSet();
                for (Category cat : Category.values()) {
                    if (!cat.name().toLowerCase().contains(catName) && !cat.getDisplayName().toLowerCase().contains(catName)) continue;
                    catIds.addAll(this.categoryIndex.getOrDefault((Object)cat, Collections.emptySet()));
                }
                if (catIds.isEmpty()) continue;
                matchingIds.retainAll(catIds);
                continue;
            }
            if (term.startsWith("#")) {
                String tag = term.substring(1).toLowerCase();
                Set tagIds = this.tagIndex.getOrDefault(tag, Collections.emptySet());
                if (!tagIds.isEmpty()) {
                    matchingIds.retainAll(tagIds);
                    continue;
                }
                HashSet partialMatch = new HashSet();
                for (Map.Entry<String, Set<String>> e : this.tagIndex.entrySet()) {
                    if (!e.getKey().contains(tag)) continue;
                    partialMatch.addAll(e.getValue());
                }
                if (partialMatch.isEmpty()) continue;
                matchingIds.retainAll(partialMatch);
                continue;
            }
            textSearch = (textSearch + " " + term).trim();
        }
        if (!textSearch.isEmpty()) {
            String searchText = textSearch.toLowerCase();
            matchingIds.removeIf(id -> !id.toLowerCase().contains(searchText));
        }
        return matchingIds.stream().sorted().map(id -> Map.entry(id, this.items.get(id))).collect(Collectors.toList());
    }

    public List<Category> getCategories() {
        return Arrays.asList(Category.values());
    }

    public static enum Category {
        ALL("All"),
        TOOLS("Tools"),
        WEAPONS("Weapons"),
        ARMOR("Armor"),
        FOOD("Food"),
        BLOCKS("Blocks"),
        MATERIALS("Materials"),
        MISC("Misc");

        private final String displayName;

        private Category(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

