/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jet.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ItemInfo {
    private final String id;
    private final String name;
    private final String description;
    private final String category;
    private final Set<String> tags;
    private final int maxStackSize;

    public ItemInfo(String id, String name, String description, String category, Set<String> tags, int maxStackSize) {
        this.id = id;
        this.name = name;
        this.description = description != null ? description : "";
        this.category = category != null ? category : "misc";
        this.tags = tags != null ? new HashSet<String>(tags) : new HashSet();
        this.maxStackSize = maxStackSize > 0 ? maxStackSize : 64;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public boolean matchesSearch(String query) {
        if (query == null || query.isEmpty()) {
            return true;
        }
        String q = query.toLowerCase().trim();
        if (q.startsWith("@")) {
            String catQuery = q.substring(1);
            return this.category.toLowerCase().contains(catQuery);
        }
        if (q.startsWith("#")) {
            String tagQuery = q.substring(1);
            return this.tags.stream().anyMatch(t -> t.toLowerCase().contains(tagQuery));
        }
        return this.id.toLowerCase().contains(q) || this.name.toLowerCase().contains(q) || this.description.toLowerCase().contains(q);
    }

    public String toString() {
        return "ItemInfo{id='" + this.id + "', name='" + this.name + "', category='" + this.category + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemInfo itemInfo = (ItemInfo)o;
        return Objects.equals(this.id, itemInfo.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

