/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jet.input;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.MouseButtonEvent;
import com.hypixel.hytale.protocol.MouseButtonState;
import com.hypixel.hytale.protocol.MouseButtonType;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.event.events.player.PlayerMouseButtonEvent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.hytalemod.jet.JETPlugin;
import dev.hytalemod.jet.gui.JETGui;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class JETKeybindHandler {
    private final Map<UUID, Boolean> jetOpenState = new ConcurrentHashMap<UUID, Boolean>();
    private MouseButtonType toggleButton = MouseButtonType.X1;
    private static JETKeybindHandler instance;

    public static JETKeybindHandler getInstance() {
        if (instance == null) {
            instance = new JETKeybindHandler();
        }
        return instance;
    }

    public void onMouseButton(PlayerMouseButtonEvent event) {
        MouseButtonEvent mouseEvent = event.getMouseButton();
        if (mouseEvent.mouseButtonType != this.toggleButton) {
            return;
        }
        if (mouseEvent.state != MouseButtonState.Pressed) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        Ref ref = player.getReference();
        if (ref == null || !ref.isValid()) {
            return;
        }
        Store store = ref.getStore();
        PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        if (playerRef == null) {
            return;
        }
        UUID playerId = playerRef.getUuid();
        boolean isOpen = this.jetOpenState.getOrDefault(playerId, false);
        if (isOpen) {
            this.closeJETGui(player, playerRef);
        } else {
            this.openJETGui(player, playerRef);
        }
        event.setCancelled(true);
    }

    public void openJETGui(Player player, PlayerRef playerRef) {
        Ref ref = player.getReference();
        if (ref == null || !ref.isValid()) {
            return;
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        world.execute(() -> {
            JETGui gui = new JETGui(playerRef, CustomPageLifetime.CanDismiss, "");
            player.getPageManager().openCustomPage(ref, store, (CustomUIPage)gui);
            this.jetOpenState.put(playerRef.getUuid(), true);
            JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] Opened GUI for " + playerRef.getUsername());
        });
    }

    public void closeJETGui(Player player, PlayerRef playerRef) {
        Ref ref = player.getReference();
        if (ref == null || !ref.isValid()) {
            return;
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        this.jetOpenState.put(playerRef.getUuid(), false);
        JETPlugin.getInstance().getLogger().at(Level.INFO).log("[JET] GUI marked for close for " + playerRef.getUsername());
    }

    public void onPlayerDisconnect(UUID playerId) {
        this.jetOpenState.remove(playerId);
    }

    public void onGuiClosed(UUID playerId) {
        this.jetOpenState.put(playerId, false);
    }

    public boolean isJETOpen(UUID playerId) {
        return this.jetOpenState.getOrDefault(playerId, false);
    }

    public void setToggleButton(MouseButtonType button) {
        this.toggleButton = button;
    }

    public MouseButtonType getToggleButton() {
        return this.toggleButton;
    }
}

