/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jet.gui;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.BenchRequirement;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.asset.type.item.config.CraftingRecipe;
import com.hypixel.hytale.server.core.asset.type.item.config.Item;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.inventory.MaterialQuantity;
import com.hypixel.hytale.server.core.modules.i18n.I18nModule;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.hytalemod.jet.JETPlugin;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JETGui
extends InteractiveCustomUIPage<GuiData> {
    private static final int ITEMS_PER_ROW = 7;
    private static final int MAX_ROWS = 8;
    private static final int MAX_ITEMS = 56;
    private static final int RECIPES_PER_PAGE = 3;
    private String searchQuery;
    private String selectedItem;
    private String activeSection;
    private int craftPage;
    private int usagePage;

    public JETGui(PlayerRef playerRef, CustomPageLifetime lifetime, String initialSearch) {
        super(playerRef, lifetime, GuiData.CODEC);
        this.searchQuery = initialSearch != null ? initialSearch : "";
        this.selectedItem = null;
        this.activeSection = "craft";
        this.craftPage = 0;
        this.usagePage = 0;
    }

    public void build(Ref<EntityStore> ref, UICommandBuilder cmd, UIEventBuilder events, Store<EntityStore> store) {
        cmd.append("Pages/JET_Gui.ui");
        events.addEventBinding(CustomUIEventBindingType.ValueChanged, "#SearchInput", EventData.of((String)"@SearchQuery", (String)"#SearchInput.Value"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#RecipePanel #ToggleModeButton", EventData.of((String)"ToggleMode", (String)"toggle"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#PrevRecipe", EventData.of((String)"PageChange", (String)"prev"), false);
        events.addEventBinding(CustomUIEventBindingType.Activating, "#NextRecipe", EventData.of((String)"PageChange", (String)"next"), false);
        this.buildItemList(ref, cmd, events, store);
        this.buildRecipePanel(ref, cmd, events, store);
    }

    public void handleDataEvent(Ref<EntityStore> ref, Store<EntityStore> store, GuiData data) {
        super.handleDataEvent(ref, store, (Object)data);
        boolean needsItemUpdate = false;
        boolean needsRecipeUpdate = false;
        if (data.searchQuery != null && !data.searchQuery.equals(this.searchQuery)) {
            this.searchQuery = data.searchQuery.trim();
            needsItemUpdate = true;
            this.selectedItem = null;
            needsRecipeUpdate = true;
        }
        if (data.selectedItem != null && !data.selectedItem.isEmpty()) {
            this.selectedItem = data.selectedItem;
            this.craftPage = 0;
            this.usagePage = 0;
            this.activeSection = "craft";
            needsRecipeUpdate = true;
        }
        if (data.toggleMode != null && "toggle".equals(data.toggleMode)) {
            this.activeSection = "craft".equals(this.activeSection) ? "usage" : "craft";
            this.craftPage = 0;
            this.usagePage = 0;
            needsRecipeUpdate = true;
        }
        if (data.activeSection != null && !data.activeSection.isEmpty() && !data.activeSection.equals(this.activeSection)) {
            this.activeSection = data.activeSection;
            this.craftPage = 0;
            this.usagePage = 0;
            needsRecipeUpdate = true;
        }
        if (data.pageChange != null) {
            List recipeIds = "craft".equals(this.activeSection) ? JETPlugin.ITEM_TO_RECIPES.getOrDefault(this.selectedItem, Collections.emptyList()) : JETPlugin.ITEM_FROM_RECIPES.getOrDefault(this.selectedItem, Collections.emptyList());
            int totalPages = (int)Math.ceil((double)recipeIds.size() / 3.0);
            if ("prev".equals(data.pageChange)) {
                if ("craft".equals(this.activeSection) && this.craftPage > 0) {
                    --this.craftPage;
                    needsRecipeUpdate = true;
                } else if ("usage".equals(this.activeSection) && this.usagePage > 0) {
                    --this.usagePage;
                    needsRecipeUpdate = true;
                }
            } else if ("next".equals(data.pageChange)) {
                if ("craft".equals(this.activeSection) && this.craftPage < totalPages - 1) {
                    ++this.craftPage;
                    needsRecipeUpdate = true;
                } else if ("usage".equals(this.activeSection) && this.usagePage < totalPages - 1) {
                    ++this.usagePage;
                    needsRecipeUpdate = true;
                }
            }
        }
        if (needsItemUpdate || needsRecipeUpdate) {
            UICommandBuilder cmd = new UICommandBuilder();
            UIEventBuilder events = new UIEventBuilder();
            if (needsItemUpdate) {
                this.buildItemList(ref, cmd, events, store);
            }
            if (needsRecipeUpdate) {
                this.buildRecipePanel(ref, cmd, events, store);
            }
            this.sendUpdate(cmd, events, false);
        }
    }

    private void buildItemList(Ref<EntityStore> ref, UICommandBuilder cmd, UIEventBuilder events, Store<EntityStore> store) {
        ArrayList<Map.Entry<String, Item>> results = new ArrayList<Map.Entry<String, Item>>();
        for (Map.Entry<String, Item> entry : JETPlugin.ITEMS.entrySet()) {
            if (!this.searchQuery.isEmpty() && !this.matchesSearch(entry.getKey(), entry.getValue())) continue;
            results.add(entry);
        }
        cmd.clear("#ItemCards");
        String language = this.playerRef.getLanguage();
        int row = 0;
        int col = 0;
        int count = 0;
        for (Map.Entry entry : results) {
            if (count >= 56) break;
            String key = (String)entry.getKey();
            Item item = (Item)entry.getValue();
            if (col == 0) {
                cmd.appendInline("#ItemCards", "Group { LayoutMode: Left; Anchor: (Bottom: 0); }");
            }
            cmd.append("#ItemCards[" + row + "]", "Pages/JET_ItemIcon.ui");
            String sel = "#ItemCards[" + row + "][" + col + "]";
            cmd.set(sel + " #ItemIcon.ItemId", key);
            Object displayName = this.getDisplayName(item, language);
            if (((String)displayName).length() > 14) {
                displayName = ((String)displayName).substring(0, 12) + "...";
            }
            cmd.set(sel + " #ItemName.TextSpans", Message.raw((String)displayName));
            cmd.set(sel + ".TooltipTextSpans", this.buildTooltip(key, item, language));
            events.addEventBinding(CustomUIEventBindingType.Activating, sel, EventData.of((String)"SelectedItem", (String)key), false);
            if (++col >= 7) {
                col = 0;
                ++row;
            }
            ++count;
        }
    }

    private boolean matchesSearch(String itemId, Item item) {
        String query = this.searchQuery.toLowerCase().trim();
        String language = this.playerRef.getLanguage();
        if (query.startsWith("#")) {
            String componentTag = query.substring(1);
            return this.hasComponent(item, componentTag);
        }
        String translatedName = this.getDisplayName(item, language).toLowerCase();
        if (translatedName.contains(query)) {
            return true;
        }
        return itemId.toLowerCase().contains(query);
    }

    private boolean hasComponent(Item item, String componentTag) {
        if (item == null || componentTag == null || componentTag.isEmpty()) {
            return false;
        }
        try {
            String itemId;
            Method getIdMethod = Item.class.getMethod("getId", new Class[0]);
            Object idObj = getIdMethod.invoke((Object)item, new Object[0]);
            if (idObj != null && (itemId = idObj.toString().toLowerCase()).contains(componentTag.toLowerCase())) {
                return true;
            }
        }
        catch (Exception getIdMethod) {
            // empty catch block
        }
        try {
            String itemTypeStr;
            Method getItemTypeMethod = Item.class.getMethod("getItemType", new Class[0]);
            Object itemType = getItemTypeMethod.invoke((Object)item, new Object[0]);
            if (itemType != null && (itemTypeStr = itemType.toString().toLowerCase()).contains(componentTag.toLowerCase())) {
                return true;
            }
        }
        catch (Exception getItemTypeMethod) {
            // empty catch block
        }
        try {
            String componentsStr;
            Method getComponentsMethod = Item.class.getMethod("getComponents", new Class[0]);
            Object components = getComponentsMethod.invoke((Object)item, new Object[0]);
            if (components != null && (componentsStr = components.toString().toLowerCase()).contains(componentTag.toLowerCase())) {
                return true;
            }
        }
        catch (Exception getComponentsMethod) {
            // empty catch block
        }
        try {
            Method hasComponentMethod = Item.class.getMethod("hasComponent", String.class);
            Object result = hasComponentMethod.invoke((Object)item, componentTag);
            if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                return true;
            }
        }
        catch (Exception hasComponentMethod) {
            // empty catch block
        }
        try {
            Method getComponentMethod = Item.class.getMethod("getComponent", String.class);
            Object component = getComponentMethod.invoke((Object)item, componentTag);
            if (component != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void buildRecipePanel(Ref<EntityStore> ref, UICommandBuilder cmd, UIEventBuilder events, Store<EntityStore> store) {
        if (this.selectedItem == null || this.selectedItem.isEmpty()) {
            cmd.set("#RecipePanel.Visible", false);
            return;
        }
        cmd.set("#RecipePanel.Visible", true);
        Item item = JETPlugin.ITEMS.get(this.selectedItem);
        String language = this.playerRef.getLanguage();
        cmd.set("#RecipePanel #SelectedIcon.ItemId", this.selectedItem);
        cmd.set("#RecipePanel #SelectedName.TextSpans", Message.raw((String)this.getDisplayName(item, language)));
        List<String> craftRecipeIds = JETPlugin.ITEM_TO_RECIPES.getOrDefault(this.selectedItem, Collections.emptyList());
        List<String> usageRecipeIds = JETPlugin.ITEM_FROM_RECIPES.getOrDefault(this.selectedItem, Collections.emptyList());
        if ("craft".equals(this.activeSection)) {
            this.buildCraftSection(cmd, events, craftRecipeIds);
        } else {
            this.buildUsageSection(cmd, events, usageRecipeIds);
        }
    }

    private void buildCraftSection(UICommandBuilder cmd, UIEventBuilder events, List<String> recipeIds) {
        cmd.clear("#RecipePanel #RecipeListContainer #RecipeList");
        if (recipeIds.isEmpty()) {
            cmd.set("#RecipePanel #RecipeInfo.TextSpans", Message.raw((String)"No crafting recipes"));
            cmd.set("#RecipePanel #PageInfo.TextSpans", Message.raw((String)""));
            return;
        }
        int totalPages = (int)Math.ceil((double)recipeIds.size() / 3.0);
        if (this.craftPage >= totalPages) {
            this.craftPage = totalPages - 1;
        }
        if (this.craftPage < 0) {
            this.craftPage = 0;
        }
        int start = this.craftPage * 3;
        int end = Math.min(start + 3, recipeIds.size());
        cmd.set("#RecipePanel #RecipeInfo.TextSpans", Message.raw((String)("Craft (" + recipeIds.size() + "):")));
        cmd.set("#RecipePanel #PageInfo.TextSpans", Message.raw((String)(this.craftPage + 1 + " / " + totalPages)));
        for (int i = start; i < end; ++i) {
            String recipeId = recipeIds.get(i);
            CraftingRecipe recipe = JETPlugin.RECIPES.get(recipeId);
            if (recipe == null) continue;
            int idx = i - start;
            cmd.append("#RecipePanel #RecipeListContainer #RecipeList", "Pages/JET_RecipeEntry.ui");
            String rSel = "#RecipePanel #RecipeListContainer #RecipeList[" + idx + "]";
            this.buildRecipeDisplay(cmd, recipe, rSel);
        }
    }

    private void buildUsageSection(UICommandBuilder cmd, UIEventBuilder events, List<String> recipeIds) {
        cmd.clear("#RecipePanel #RecipeListContainer #RecipeList");
        if (recipeIds.isEmpty()) {
            cmd.set("#RecipePanel #RecipeInfo.TextSpans", Message.raw((String)"Not used in recipes"));
            cmd.set("#RecipePanel #PageInfo.TextSpans", Message.raw((String)""));
            return;
        }
        int totalPages = (int)Math.ceil((double)recipeIds.size() / 3.0);
        if (this.usagePage >= totalPages) {
            this.usagePage = totalPages - 1;
        }
        if (this.usagePage < 0) {
            this.usagePage = 0;
        }
        int start = this.usagePage * 3;
        int end = Math.min(start + 3, recipeIds.size());
        cmd.set("#RecipePanel #RecipeInfo.TextSpans", Message.raw((String)("Uses (" + recipeIds.size() + "):")));
        cmd.set("#RecipePanel #PageInfo.TextSpans", Message.raw((String)(this.usagePage + 1 + " / " + totalPages)));
        for (int i = start; i < end; ++i) {
            String recipeId = recipeIds.get(i);
            CraftingRecipe recipe = JETPlugin.RECIPES.get(recipeId);
            if (recipe == null) continue;
            int idx = i - start;
            cmd.append("#RecipePanel #RecipeListContainer #RecipeList", "Pages/JET_RecipeEntry.ui");
            String rSel = "#RecipePanel #RecipeListContainer #RecipeList[" + idx + "]";
            this.buildRecipeDisplay(cmd, recipe, rSel);
        }
    }

    private void buildRecipeDisplay(UICommandBuilder cmd, CraftingRecipe recipe, String rSel) {
        String recipeId = recipe.getId();
        if (recipeId.contains(":")) {
            recipeId = recipeId.substring(recipeId.indexOf(":") + 1);
        }
        Object benchInfo = "";
        if (recipe.getBenchRequirement() != null && recipe.getBenchRequirement().length > 0) {
            BenchRequirement bench = recipe.getBenchRequirement()[0];
            benchInfo = " [" + this.formatBenchName(bench.id) + " T" + bench.requiredTierLevel + "]";
        }
        cmd.set(rSel + " #RecipeTitle.TextSpans", Message.raw((String)(recipeId + (String)benchInfo)));
        List<MaterialQuantity> inputs = this.getRecipeInputs(recipe);
        cmd.clear(rSel + " #InputItems");
        for (int j = 0; j < inputs.size(); ++j) {
            MaterialQuantity input = inputs.get(j);
            cmd.appendInline(rSel + " #InputItems", "Group { LayoutMode: Top; Padding: (Right: 6); ItemIcon { Anchor: (Width: 32, Height: 32); Visible: true; } Label { Style: (FontSize: 10, TextColor: #ffffff, HorizontalAlignment: Center); Padding: (Top: 2); } }");
            cmd.set(rSel + " #InputItems[" + j + "][0].ItemId", input.getItemId());
            cmd.set(rSel + " #InputItems[" + j + "][1].Text", "x" + input.getQuantity());
        }
        MaterialQuantity[] outputs = recipe.getOutputs();
        cmd.clear(rSel + " #OutputItems");
        if (outputs != null && outputs.length > 0) {
            for (int j = 0; j < outputs.length; ++j) {
                MaterialQuantity output = outputs[j];
                if (output == null || output.getItemId() == null) continue;
                cmd.appendInline(rSel + " #OutputItems", "Group { LayoutMode: Top; Padding: (Right: 6); ItemIcon { Anchor: (Width: 32, Height: 32); Visible: true; } Label { Style: (FontSize: 10, TextColor: #ffffff, HorizontalAlignment: Center); Padding: (Top: 2); } }");
                cmd.set(rSel + " #OutputItems[" + j + "][0].ItemId", output.getItemId());
                cmd.set(rSel + " #OutputItems[" + j + "][1].Text", "x" + output.getQuantity());
            }
        }
    }

    private String formatBenchName(String benchId) {
        if (benchId == null) {
            return "";
        }
        if (benchId.contains(":")) {
            benchId = benchId.substring(benchId.indexOf(":") + 1);
        }
        if (benchId.startsWith("hytale_")) {
            benchId = benchId.substring(7);
        }
        String[] parts = benchId.split("_");
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
        }
        return result.toString();
    }

    private String getDisplayName(Item item, String language) {
        int underscore;
        if (item == null) {
            return "Unknown";
        }
        try {
            String translated;
            String key = item.getTranslationKey();
            if (key != null && (translated = I18nModule.get().getMessage(language, key)) != null && !translated.isEmpty()) {
                return translated;
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        String id = item.getId();
        if (id == null) {
            return "Unknown";
        }
        if (id.contains(":")) {
            id = id.substring(id.indexOf(":") + 1);
        }
        if ((underscore = id.indexOf("_")) > 0) {
            id = id.substring(underscore + 1);
        }
        return id.replace("_", " ");
    }

    private Message buildTooltip(String itemId, Item item, String language) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDisplayName(item, language)).append("\n");
        sb.append("-------------------\n");
        sb.append("ID: ").append(itemId).append("\n");
        sb.append("Stack: ").append(item.getMaxStack());
        if (item.getMaxDurability() > 0.0) {
            sb.append("\nDurability: ").append((int)item.getMaxDurability());
        }
        sb.append("\n-------------------");
        sb.append("\nClick to view recipes");
        return Message.raw((String)sb.toString());
    }

    private List<MaterialQuantity> getRecipeInputs(CraftingRecipe recipe) {
        ArrayList<MaterialQuantity> result;
        block13: {
            Object inputsObj;
            block14: {
                result = new ArrayList<MaterialQuantity>();
                inputsObj = null;
                try {
                    Method getInputMethod = CraftingRecipe.class.getMethod("getInput", new Class[0]);
                    inputsObj = getInputMethod.invoke((Object)recipe, new Object[0]);
                }
                catch (Exception e) {
                    String[] methodNames;
                    for (String methodName : methodNames = new String[]{"getInputs", "getIngredients", "getMaterials", "getRecipeInputs", "getRequiredMaterials"}) {
                        try {
                            Method method = CraftingRecipe.class.getMethod(methodName, new Class[0]);
                            inputsObj = method.invoke((Object)recipe, new Object[0]);
                            if (inputsObj == null) continue;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (inputsObj == null) break block13;
                if (!(inputsObj instanceof MaterialQuantity)) break block14;
                MaterialQuantity input = (MaterialQuantity)inputsObj;
                if (input == null || input.getItemId() == null) break block13;
                result.add(input);
                break block13;
            }
            if (inputsObj instanceof List) {
                inputs = (MaterialQuantity[])inputsObj;
                var5_6 = inputs.iterator();
                while (var5_6.hasNext()) {
                    MaterialQuantity input;
                    obj = var5_6.next();
                    if (!(obj instanceof MaterialQuantity) || (input = (MaterialQuantity)obj) == null || input.getItemId() == null) continue;
                    result.add(input);
                }
            } else if (inputsObj instanceof MaterialQuantity[]) {
                for (Object input : inputs = (MaterialQuantity[])inputsObj) {
                    if (input == null || input.getItemId() == null) continue;
                    result.add((MaterialQuantity)input);
                }
            } else if (inputsObj instanceof Collection) {
                inputs = (Collection)inputsObj;
                var5_6 = inputs.iterator();
                while (var5_6.hasNext()) {
                    MaterialQuantity input;
                    obj = var5_6.next();
                    if (!(obj instanceof MaterialQuantity) || (input = (MaterialQuantity)obj) == null || input.getItemId() == null) continue;
                    result.add(input);
                }
            }
        }
        return result;
    }

    public static class GuiData {
        public static final BuilderCodec<GuiData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(GuiData.class, GuiData::new).addField(new KeyedCodec("@SearchQuery", (Codec)Codec.STRING), (d, v) -> {
            d.searchQuery = v;
        }, d -> d.searchQuery)).addField(new KeyedCodec("SelectedItem", (Codec)Codec.STRING), (d, v) -> {
            d.selectedItem = v;
        }, d -> d.selectedItem)).addField(new KeyedCodec("ActiveSection", (Codec)Codec.STRING), (d, v) -> {
            d.activeSection = v;
        }, d -> d.activeSection)).addField(new KeyedCodec("PageChange", (Codec)Codec.STRING), (d, v) -> {
            d.pageChange = v;
        }, d -> d.pageChange)).addField(new KeyedCodec("ToggleMode", (Codec)Codec.STRING), (d, v) -> {
            d.toggleMode = v;
        }, d -> d.toggleMode)).build();
        private String searchQuery;
        private String selectedItem;
        private String activeSection;
        private String pageChange;
        private String toggleMode;
    }
}

