/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jet.command;

import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import dev.hytalemod.jet.JETPlugin;
import dev.hytalemod.jet.registry.ItemRegistry;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class JETListCommand
extends AbstractCommand {
    public JETListCommand() {
        super("jetlist", "List item categories", false);
        this.addAliases(new String[]{"jl"});
        this.setPermissionGroup(GameMode.Adventure);
    }

    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        ItemRegistry registry = JETPlugin.getInstance().getItemRegistry();
        context.sendMessage(Message.raw((String)"========= JET Categories =========").color("#FFAA00"));
        for (ItemRegistry.Category cat : registry.getCategories()) {
            int count = registry.getByCategory(cat).size();
            context.sendMessage(Message.raw((String)(cat.getDisplayName() + ": " + count + " items")));
        }
        context.sendMessage(Message.raw((String)"==================================").color("#FFAA00"));
        context.sendMessage(Message.raw((String)"Use /jet to open the browser").color("#AAAAAA"));
        context.sendMessage(Message.raw((String)"Search with @category or #tag").color("#AAAAAA"));
        return CompletableFuture.completedFuture(null);
    }
}

