/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jet.command;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.hytalemod.jet.gui.JETGui;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public class JETCommand
extends AbstractCommand {
    public JETCommand() {
        super("jet", "Opens the JET item browser", false);
        this.addAliases(new String[]{"jei", "items"});
        this.setPermissionGroup(GameMode.Adventure);
    }

    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        CommandSender sender = context.sender();
        if (!(sender instanceof Player)) {
            return CompletableFuture.completedFuture(null);
        }
        Player player = (Player)sender;
        Ref ref = player.getReference();
        if (ref == null || !ref.isValid()) {
            return CompletableFuture.completedFuture(null);
        }
        Store store = ref.getStore();
        World world = ((EntityStore)store.getExternalData()).getWorld();
        return CompletableFuture.runAsync(() -> {
            PlayerRef playerRef = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
            if (playerRef != null) {
                JETGui gui = new JETGui(playerRef, CustomPageLifetime.CanDismiss, "");
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)gui);
            }
        }, (Executor)world);
    }
}

