/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jet;

import com.hypixel.hytale.assetstore.event.LoadedAssetsEvent;
import com.hypixel.hytale.assetstore.map.DefaultAssetMap;
import com.hypixel.hytale.server.core.asset.type.item.config.CraftingRecipe;
import com.hypixel.hytale.server.core.asset.type.item.config.Item;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.event.events.player.PlayerDisconnectEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerMouseButtonEvent;
import com.hypixel.hytale.server.core.inventory.MaterialQuantity;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import dev.hytalemod.jet.command.JETCommand;
import dev.hytalemod.jet.command.JETInfoCommand;
import dev.hytalemod.jet.command.JETListCommand;
import dev.hytalemod.jet.input.JETKeybindHandler;
import dev.hytalemod.jet.registry.ItemRegistry;
import dev.hytalemod.jet.registry.RecipeRegistry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class JETPlugin
extends JavaPlugin {
    public static final String VERSION = "1.0.0-beta.10";
    private static JETPlugin instance;
    private ItemRegistry itemRegistry;
    private RecipeRegistry recipeRegistry;
    public static Map<String, Item> ITEMS;
    public static Map<String, CraftingRecipe> RECIPES;
    public static Map<String, List<String>> ITEM_TO_RECIPES;
    public static Map<String, List<String>> ITEM_FROM_RECIPES;

    public JETPlugin(JavaPluginInit init) {
        super(init);
    }

    protected void setup() {
        super.setup();
        instance = this;
        this.itemRegistry = new ItemRegistry();
        this.recipeRegistry = new RecipeRegistry();
        this.getCommandRegistry().registerCommand((AbstractCommand)new JETCommand());
        this.getCommandRegistry().registerCommand((AbstractCommand)new JETInfoCommand());
        this.getCommandRegistry().registerCommand((AbstractCommand)new JETListCommand());
        this.getEventRegistry().registerGlobal(PlayerMouseButtonEvent.class, event -> JETKeybindHandler.getInstance().onMouseButton((PlayerMouseButtonEvent)event));
        this.getEventRegistry().registerGlobal(PlayerDisconnectEvent.class, event -> JETKeybindHandler.getInstance().onPlayerDisconnect(event.getPlayerRef().getUuid()));
        this.getEventRegistry().register(LoadedAssetsEvent.class, Item.class, JETPlugin::onItemsLoaded);
        this.getEventRegistry().register(LoadedAssetsEvent.class, CraftingRecipe.class, JETPlugin::onRecipesLoaded);
        this.getLogger().at(Level.INFO).log("[JET] Plugin enabled - v1.0.0-beta.10");
        this.getLogger().at(Level.INFO).log("[JET] Press Mouse Side Button (X1) to toggle item browser");
        this.getLogger().at(Level.INFO).log("[JET] Or use /jet command");
    }

    private static void onItemsLoaded(LoadedAssetsEvent<String, Item, DefaultAssetMap<String, Item>> event) {
        ITEMS = ((DefaultAssetMap)event.getAssetMap()).getAssetMap();
        JETPlugin.instance.itemRegistry.reload(ITEMS);
        instance.getLogger().at(Level.INFO).log("[JET] Loaded " + JETPlugin.instance.itemRegistry.size() + " items");
    }

    private static void onRecipesLoaded(LoadedAssetsEvent<String, CraftingRecipe, DefaultAssetMap<String, CraftingRecipe>> event) {
        Map recipes = event.getLoadedAssets();
        if (recipes == null || recipes.isEmpty()) {
            instance.getLogger().at(Level.WARNING).log("[JET] No recipes in LoadedAssetsEvent");
            return;
        }
        Method getInputMethod = null;
        try {
            getInputMethod = CraftingRecipe.class.getMethod("getInput", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        block6: for (CraftingRecipe recipe : recipes.values()) {
            String[] methodNames;
            RECIPES.put(recipe.getId(), recipe);
            for (MaterialQuantity output : recipe.getOutputs()) {
                ITEM_TO_RECIPES.computeIfAbsent(output.getItemId(), k -> new ArrayList()).add(recipe.getId());
            }
            if (getInputMethod != null) {
                try {
                    Object inputsObj = getInputMethod.invoke((Object)recipe, new Object[0]);
                    if (inputsObj == null) continue;
                    JETPlugin.processRecipeInputs(inputsObj, recipe.getId());
                }
                catch (Exception inputsObj) {}
                continue;
            }
            for (String methodName : methodNames = new String[]{"getInputs", "getIngredients", "getMaterials", "getRecipeInputs", "getRequiredMaterials"}) {
                try {
                    Method fallbackMethod = CraftingRecipe.class.getMethod(methodName, new Class[0]);
                    Object inputsObj = fallbackMethod.invoke((Object)recipe, new Object[0]);
                    if (inputsObj == null) continue;
                    JETPlugin.processRecipeInputs(inputsObj, recipe.getId());
                    continue block6;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        JETPlugin.instance.recipeRegistry.reload(recipes);
        instance.getLogger().at(Level.INFO).log("[JET] Loaded " + JETPlugin.instance.recipeRegistry.size() + " recipes");
        instance.getLogger().at(Level.INFO).log("[JET] Built recipe maps - ITEM_TO_RECIPES: " + ITEM_TO_RECIPES.size() + " items, ITEM_FROM_RECIPES: " + ITEM_FROM_RECIPES.size() + " items");
    }

    private static void processRecipeInputs(Object inputsObj, String recipeId) {
        block5: {
            Collection inputs;
            block7: {
                block6: {
                    block4: {
                        if (!(inputsObj instanceof MaterialQuantity)) break block4;
                        MaterialQuantity input = (MaterialQuantity)inputsObj;
                        if (input == null || input.getItemId() == null) break block5;
                        ITEM_FROM_RECIPES.computeIfAbsent(input.getItemId(), k -> new ArrayList()).add(recipeId);
                        break block5;
                    }
                    if (!(inputsObj instanceof List)) break block6;
                    List inputs2 = (List)inputsObj;
                    if (inputs2 == null || inputs2.isEmpty()) break block5;
                    for (MaterialQuantity input : inputs2) {
                        if (input == null || input.getItemId() == null) continue;
                        ITEM_FROM_RECIPES.computeIfAbsent(input.getItemId(), k -> new ArrayList()).add(recipeId);
                    }
                    break block5;
                }
                if (!(inputsObj instanceof MaterialQuantity[])) break block7;
                MaterialQuantity[] inputs3 = (MaterialQuantity[])inputsObj;
                if (inputs3 == null || inputs3.length <= 0) break block5;
                for (MaterialQuantity input : inputs3) {
                    if (input == null || input.getItemId() == null) continue;
                    ITEM_FROM_RECIPES.computeIfAbsent(input.getItemId(), k -> new ArrayList()).add(recipeId);
                }
                break block5;
            }
            if (inputsObj instanceof Collection && (inputs = (Collection)inputsObj) != null && !inputs.isEmpty()) {
                for (MaterialQuantity input : inputs) {
                    if (input == null || input.getItemId() == null) continue;
                    ITEM_FROM_RECIPES.computeIfAbsent(input.getItemId(), k -> new ArrayList()).add(recipeId);
                }
            }
        }
    }

    public static JETPlugin getInstance() {
        return instance;
    }

    public ItemRegistry getItemRegistry() {
        return this.itemRegistry;
    }

    public RecipeRegistry getRecipeRegistry() {
        return this.recipeRegistry;
    }

    static {
        ITEMS = new HashMap<String, Item>();
        RECIPES = new HashMap<String, CraftingRecipe>();
        ITEM_TO_RECIPES = new HashMap<String, List<String>>();
        ITEM_FROM_RECIPES = new HashMap<String, List<String>>();
    }
}

