/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jei.ui;

import dev.hytalemod.jei.registry.ItemInfo;
import dev.hytalemod.jei.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JEIScreen {
    private final ItemRegistry registry;
    private final Map<Object, PlayerUIState> playerStates;
    private static final int ITEMS_PER_ROW = 9;
    private static final int ROWS_VISIBLE = 6;
    private static final int ITEMS_PER_PAGE = 54;

    public JEIScreen(ItemRegistry registry) {
        this.registry = registry;
        this.playerStates = new HashMap<Object, PlayerUIState>();
    }

    public void open(Object player) {
        this.open(player, "");
    }

    public void open(Object player, String searchQuery) {
        PlayerUIState state = this.playerStates.computeIfAbsent(this.getPlayerId(player), k -> new PlayerUIState());
        state.searchQuery = searchQuery != null ? searchQuery : "";
        state.currentPage = 0;
        state.selectedCategory = null;
        state.filteredItems = this.registry.search(state.searchQuery);
        this.showScreen(player, state);
    }

    public void close(Object player) {
        this.playerStates.remove(this.getPlayerId(player));
        this.hideScreen(player);
    }

    public void onSearchChanged(Object player, String newQuery) {
        PlayerUIState state = this.getState(player);
        if (state == null) {
            return;
        }
        state.searchQuery = newQuery;
        state.currentPage = 0;
        state.filteredItems = this.registry.search(newQuery);
        this.updateDisplay(player, state);
    }

    public void onPageChange(Object player, int direction) {
        PlayerUIState state = this.getState(player);
        if (state == null) {
            return;
        }
        int maxPage = this.getMaxPage(state);
        state.currentPage = Math.max(0, Math.min(state.currentPage + direction, maxPage));
        this.updateDisplay(player, state);
    }

    public void onCategorySelected(Object player, String category) {
        PlayerUIState state = this.getState(player);
        if (state == null) {
            return;
        }
        if (category == null || category.equals(state.selectedCategory)) {
            state.selectedCategory = null;
            state.filteredItems = this.registry.search(state.searchQuery);
        } else {
            state.selectedCategory = category;
            state.filteredItems = this.registry.search("@" + category + " " + state.searchQuery);
        }
        state.currentPage = 0;
        this.updateDisplay(player, state);
    }

    public void onItemClicked(Object player, String itemId, int button) {
        PlayerUIState state = this.getState(player);
        if (state == null) {
            return;
        }
        ItemInfo item = this.registry.getItem(itemId);
        if (item == null) {
            return;
        }
        state.selectedItem = item;
        if (button == 0) {
            this.showItemRecipes(player, item);
        } else if (button == 1) {
            this.showItemUsages(player, item);
        }
    }

    public List<ItemInfo> getCurrentPageItems(Object player) {
        PlayerUIState state = this.getState(player);
        if (state == null) {
            return Collections.emptyList();
        }
        return this.registry.getPage(state.filteredItems, state.currentPage, 54);
    }

    public String getPageInfo(Object player) {
        PlayerUIState state = this.getState(player);
        if (state == null) {
            return "";
        }
        int totalPages = Math.max(1, this.getMaxPage(state) + 1);
        return "Page " + (state.currentPage + 1) + "/" + totalPages + " (" + state.filteredItems.size() + " items)";
    }

    public boolean canGoPrevious(Object player) {
        PlayerUIState state = this.getState(player);
        return state != null && state.currentPage > 0;
    }

    public boolean canGoNext(Object player) {
        PlayerUIState state = this.getState(player);
        return state != null && state.currentPage < this.getMaxPage(state);
    }

    private void showScreen(Object player, PlayerUIState state) {
        System.out.println("[HytaleJEI] Opening screen for player");
        System.out.println("  Search: '" + state.searchQuery + "'");
        System.out.println("  Items: " + state.filteredItems.size());
        System.out.println("  " + this.getPageInfo(player));
        List<ItemInfo> pageItems = this.getCurrentPageItems(player);
        System.out.println("  Showing " + pageItems.size() + " items:");
        for (ItemInfo item : pageItems) {
            System.out.println("    - " + item.getName() + " (" + item.getId() + ")");
        }
    }

    private void hideScreen(Object player) {
        System.out.println("[HytaleJEI] Closing screen");
    }

    private void updateDisplay(Object player, PlayerUIState state) {
        System.out.println("[HytaleJEI] Updating display: " + this.getPageInfo(player));
    }

    private void showItemRecipes(Object player, ItemInfo item) {
        System.out.println("[HytaleJEI] Showing recipes for: " + item.getName());
    }

    private void showItemUsages(Object player, ItemInfo item) {
        System.out.println("[HytaleJEI] Showing usages for: " + item.getName());
    }

    private PlayerUIState getState(Object player) {
        return this.playerStates.get(this.getPlayerId(player));
    }

    private Object getPlayerId(Object player) {
        return player.hashCode();
    }

    private int getMaxPage(PlayerUIState state) {
        return Math.max(0, (state.filteredItems.size() - 1) / 54);
    }

    private static class PlayerUIState {
        String searchQuery = "";
        int currentPage = 0;
        String selectedCategory = null;
        ItemInfo selectedItem = null;
        List<ItemInfo> filteredItems = new ArrayList<ItemInfo>();

        private PlayerUIState() {
        }
    }
}

